/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.text.parcel;

import com.mapinfo.mapmarker.CAN.dp.merge.IMergeOutputRecordOutputer;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeOutputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.StreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.utils.IRandomDataInputOutputStream;
import java.io.DataOutput;
import java.io.IOException;

public class ParcelOutputRecordOutputer
implements IMergeOutputRecordOutputer {
    private IRandomDataInputOutputStream m_stream;
    private int m_outputRecordCount = 0;

    public void open(IRandomDataInputOutputStream stream) throws DataSourceException {
        this.m_stream = stream;
        try {
            this.m_stream.writeInt(this.m_outputRecordCount);
        }
        catch (IOException IOEx) {
            throw new DataSourceException(10, (Throwable)IOEx);
        }
    }

    public void close() throws DataSourceException {
        try {
            this.m_stream.seek(0L);
            this.m_stream.writeInt(this.m_outputRecordCount);
        }
        catch (IOException IOEx) {
            throw new DataSourceException(12, (Throwable)IOEx);
        }
    }

    @Override
    public void output(MergeOutputRecord record) throws DataSourceException {
        if (record.getMergedRecords() != null || record.getUnMergedRecords() != null) {
            throw new IllegalArgumentException("There should be no merged or unmerged records");
        }
        if (record.getNoMatchRecords() != null && !record.getNoMatchRecords().isEmpty()) {
            this.m_outputRecordCount += record.getNoMatchRecords().size();
            try {
                for (StreetDataSourceRecord street : record.getNoMatchRecords()) {
                    street.write((DataOutput)this.m_stream);
                }
            }
            catch (IOException IOEx) {
                throw new DataSourceException(13, (Throwable)IOEx);
            }
        }
    }

    IRandomDataInputOutputStream getStream() {
        return this.m_stream;
    }
}

