/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.text.parcel;

import com.mapinfo.mapmarker.CAN.dp.merge.IMergeOutputRecordOutputer;
import com.mapinfo.mapmarker.CAN.dp.merge.MergeOutputRecord;
import com.mapinfo.mapmarker.CAN.dp.merge.text.MergedDataSource;
import com.mapinfo.mapmarker.CAN.dp.merge.text.StreetDataSourceRecord;
import com.mapinfo.mapmarker.CAN.dp.text.parcel.ParcelOutputRecordOutputer;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IUnitDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.utils.IRandomDataInputOutputStream;
import com.mapinfo.mapmarker.utils.RandomAccessDataStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ProvinceLevelOutputRecordOutputer
implements IMergeOutputRecordOutputer {
    private String m_outputPath;
    private Map<String, ParcelOutputRecordOutputer> m_outputers;
    private File m_recordsWithUnitsFile;
    private ParcelOutputRecordOutputer m_recordsWithUnitsOutputer;

    public ProvinceLevelOutputRecordOutputer(String outputPath) {
        this.m_outputPath = outputPath;
        this.m_outputers = new HashMap<String, ParcelOutputRecordOutputer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws DataSourceException {
        DataSourceException exception = null;
        try {
            this.outputRecordsWithUnits();
        }
        catch (DataSourceException DSEx) {
            exception = DSEx;
        }
        for (ParcelOutputRecordOutputer outputer : this.m_outputers.values()) {
            try {
                outputer.close();
            }
            catch (DataSourceException DSEx) {
                DataCreationLogger.getLogger().logInternalError(DSEx.getMessage());
                DataCreationLogger.getLogger().logStackTrace((Throwable)DSEx);
                if (exception != null) continue;
                exception = DSEx;
            }
            finally {
                try {
                    outputer.getStream().close();
                }
                catch (IOException IOEx) {
                    if (exception != null) continue;
                    exception = new DataSourceException(12, (Throwable)IOEx);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void output(MergeOutputRecord record) throws DataSourceException {
        if (this.hasUnits(record)) {
            this.outputRecordsWithUnits(record);
        } else {
            IMergeOutputRecordOutputer outputer = this.getOutputer(record);
            if (outputer != null) {
                outputer.output(record);
            }
        }
    }

    private IMergeOutputRecordOutputer getOutputer(MergeOutputRecord record) throws DataSourceException {
        Iterator iterator;
        if (record.getNoMatchRecords() != null && !record.getNoMatchRecords().isEmpty() && (iterator = record.getNoMatchRecords().iterator()).hasNext()) {
            RandomAccessDataStream stream;
            StreetDataSourceRecord street = (StreetDataSourceRecord)iterator.next();
            String province = street.getSegment().getLeftAreaName1();
            ParcelOutputRecordOutputer outputer = this.m_outputers.get(province);
            if (outputer != null) {
                return outputer;
            }
            try {
                stream = new RandomAccessDataStream(new File(StringUtilities.appendToPath((String)this.m_outputPath, (String)province, (String)"src")));
            }
            catch (IOException IOEx) {
                throw new DataSourceException(10, (Throwable)IOEx);
            }
            outputer = new ParcelOutputRecordOutputer();
            outputer.open((IRandomDataInputOutputStream)stream);
            this.m_outputers.put(province, outputer);
            return outputer;
        }
        DataCreationLogger.getLogger().logError("MergeOutputRecord contains to no match records");
        return null;
    }

    private boolean hasUnits(MergeOutputRecord record) throws DataSourceException {
        for (StreetDataSourceRecord street : record.getNoMatchRecords()) {
            IRangeDataSourceRecord range = (IRangeDataSourceRecord)street.getSegment().getRanges().get(0);
            if (range.getUnits() == null || range.getUnits().size() <= 0) continue;
            IUnitDataSourceRecord unit = (IUnitDataSourceRecord)range.getUnits().get(0);
            return unit.hasLowUnit() && !StringUtilities.isEmpty((String)unit.getLowUnit()) || unit.hasHighUnit() && !StringUtilities.isEmpty((String)unit.getHighUnit()) || unit.hasUnitType() && !StringUtilities.isEmpty((String)unit.getUnitType());
        }
        return false;
    }

    private void outputRecordsWithUnits(MergeOutputRecord record) throws DataSourceException {
        if (this.m_recordsWithUnitsFile == null) {
            RandomAccessDataStream stream;
            try {
                this.m_recordsWithUnitsFile = File.createTempFile("units", "tmp", new File(this.m_outputPath));
                this.m_recordsWithUnitsFile.deleteOnExit();
            }
            catch (IOException IOEx) {
                throw new DataSourceException(10, (Throwable)IOEx);
            }
            try {
                stream = new RandomAccessDataStream(this.m_recordsWithUnitsFile);
            }
            catch (IOException IOEx) {
                this.m_recordsWithUnitsFile = null;
                throw new DataSourceException(10, (Throwable)IOEx);
            }
            this.m_recordsWithUnitsOutputer = new ParcelOutputRecordOutputer();
            try {
                this.m_recordsWithUnitsOutputer.open((IRandomDataInputOutputStream)stream);
            }
            catch (DataSourceException DSEx) {
                this.m_recordsWithUnitsFile = null;
                throw DSEx;
            }
        }
        this.m_recordsWithUnitsOutputer.output(record);
    }

    private void outputRecordsWithUnits() throws DataSourceException {
        if (this.m_recordsWithUnitsFile != null) {
            IStreetDataSourceRecord record;
            if (this.m_recordsWithUnitsOutputer == null) {
                return;
            }
            this.m_recordsWithUnitsOutputer.close();
            try {
                this.m_recordsWithUnitsOutputer.getStream().close();
            }
            catch (IOException IOEx) {
                throw new DataSourceException(12, (Throwable)IOEx);
            }
            MergedDataSource dataSource = new MergedDataSource();
            String[] args = new String[]{this.m_recordsWithUnitsFile.getAbsolutePath()};
            dataSource.open(args);
            while ((record = (IStreetDataSourceRecord)dataSource.getNextDataSourceRecordObjects()) != null) {
                MergeOutputRecord output = MergeOutputRecord.makeNoMatchRecord(Collections.singletonList(record));
                this.getOutputer(output).output(output);
            }
            dataSource.close();
            this.m_recordsWithUnitsFile.delete();
        }
    }
}

