/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.ud.tab;

import com.mapinfo.mapmarker.CAN.CAN_GeoSoundexKey;
import com.mapinfo.mapmarker.CAN.dp.CAN_IntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_GenericStreetBuilder;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_UDPostInfoFetcher;
import com.mapinfo.mapmarker.CAN.dp.binary.index.CAN_GeoInfoMiSoundexIndexFile;
import com.mapinfo.mapmarker.CAN.dp.ud.CAN_UDGeoInfoDataHandler;
import com.mapinfo.mapmarker.CAN.dp.ud.CAN_UDStreetDataSourceRecordConvertor;
import com.mapinfo.mapmarker.CAN.dp.ud.tab.CAN_UDTabStreetDataHandler;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.IUDNonStreetDataHandler;
import com.mapinfo.mapmarker.common.dp.UDGeo2SacDataHandler;
import com.mapinfo.mapmarker.common.dp.UDPost2SacDataHandler;
import com.mapinfo.mapmarker.common.dp.binary.AbstractUDDataProvider;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.DataFileMasks;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.DuplicateKeyException;
import com.mapinfo.mapmarker.common.dp.binary.index.IFileInnerIndexConvertor;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexFileConvertor;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexMultiValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexFileConvertor;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ListFileTempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.tab.TabFileDataSource;
import com.mapinfo.mapmarker.utils.MiVersion;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class CAN_TabUDDataProvider
extends AbstractUDDataProvider {
    private MMJComplexDataFileMetadata m_geoinfoMetadata;
    private MMJComplexDataFileMetadata m_streetMetadata;
    private MiStringIndexFile m_geoInfoIndex;
    private CAN_UDPostInfoFetcher m_postInfoFetcher;
    private static final int DATATYPE_USER_DICTIONARY = 10;

    public void initialize(Properties dataProperties) throws DataCreationException {
        super.initialize(dataProperties);
        this.m_post2sacDataHandler = new UDPost2SacDataHandler();
        this.m_geo2sacDataHandler = new UDGeo2SacDataHandler();
        this.m_geoInfoDataHandler = new CAN_UDGeoInfoDataHandler();
        try {
            this.m_postInfoFetcher = new CAN_UDPostInfoFetcher(dataProperties.getProperty("dataSetPath"));
        }
        catch (DataDictionaryIntializationException DDIEx) {
            throw new DataCreationException((Throwable)DDIEx);
        }
        this.m_streetDataHandler = new CAN_UDTabStreetDataHandler((IDataSource)new TabFileDataSource(dataProperties), (IDataSourceRecordConvertor)new CAN_UDStreetDataSourceRecordConvertor(dataProperties, (IUDNonStreetDataHandler)this.m_post2sacDataHandler, (IUDNonStreetDataHandler)this.m_geo2sacDataHandler, (IUDNonStreetDataHandler)this.m_geoInfoDataHandler, this.m_postInfoFetcher), (IIntermediateDataHandler)new CAN_IntermediateStreetDataFileFormatHandler(StringUtilities.appendToPath((String)dataProperties.getProperty("street_outputFilePath"), (String)"street.tmp")), (ITempDataRecordHandler)new ListFileTempDataRecordHandler(dataProperties.getProperty("street_outputFilePath")));
        this.m_dataBuilder = new CAN_GenericStreetBuilder();
    }

    public MMJComplexDataFileMetadata getStreetMetadata() {
        if (this.m_streetMetadata == null) {
            this.m_streetMetadata = new MMJComplexDataFileMetadata();
            this.m_streetMetadata.setCountry("CAN");
            this.m_streetMetadata.setDataFileMasks(new DataFileMasks());
            this.m_streetMetadata.setFrequentStrings(this.m_streetFrequentStrings);
            this.m_streetMetadata.setVersion(new MiVersion(4, 0, 0));
            this.m_streetMetadata.setXPow10((byte)5);
            this.m_streetMetadata.setYPow10((byte)5);
            this.m_streetMetadata.setVendorCode(10);
        }
        return this.m_streetMetadata;
    }

    @Override
    public MMJComplexDataFileMetadata getPostInfoMetadata() {
        return null;
    }

    @Override
    public MMJComplexDataFileMetadata getGeoInfoMetadata() {
        if (this.m_geoinfoMetadata == null) {
            this.m_geoinfoMetadata = new MMJComplexDataFileMetadata();
            this.m_geoinfoMetadata.setCountry("CAN");
            this.m_geoinfoMetadata.setDataFileMasks(new DataFileMasks());
            this.m_geoinfoMetadata.setFrequentStrings(this.m_geoinfoFrequentStrings);
            this.m_geoinfoMetadata.setVersion(new MiVersion(4, 0, 0));
            this.m_geoinfoMetadata.setVendorCode(10);
        }
        return this.m_geoinfoMetadata;
    }

    public void processStreets(boolean bCreateStats) throws DataCreationException {
        super.processStreets(bCreateStats);
        try {
            if (this.m_geoInfoIndex != null) {
                this.m_geoInfoIndex.close();
            }
        }
        catch (IOException IOEx) {
            throw new DataCreationException(400, (Throwable)IOEx);
        }
        try {
            if (this.m_postInfoFetcher != null) {
                this.m_postInfoFetcher.close();
            }
        }
        catch (DataAccessException DAEx) {
            throw new DataCreationException((Throwable)DAEx);
        }
        this.m_geoInfoIndex = null;
        this.m_postInfoFetcher = null;
    }

    @Override
    protected void createOtherFiles() throws DataCreationException {
        super.createOtherFiles();
        this.createGeoInfoFiles();
    }

    private void createGeoInfoFiles() throws DataCreationException {
        ((CAN_UDGeoInfoDataHandler)this.m_geoInfoDataHandler).checkForEmpty();
        this.processGeoInfo(false);
        String geoInfoBase = StringUtilities.appendToPath((String)this.m_processProperties.getProperty("geoInfo_outputFilePath"), (String)this.m_processProperties.getProperty("geoInfo_outputFile"));
        MiStringIndexFileConvertor convertor = new MiStringIndexFileConvertor(geoInfoBase + ".tdx", geoInfoBase + ".jdx");
        convertor.convert();
        CAN_GeoInfoMiSoundexIndexFile soundexIndex = new CAN_GeoInfoMiSoundexIndexFile();
        try {
            soundexIndex.create(geoInfoBase + ".sdx", new MapMarkerIndexFileMetadata());
            MiSoundexKey fakeSoundex = new MiSoundexKey();
            fakeSoundex.setFirstChar('\u0000');
            fakeSoundex.setNumericValue(-1);
            CAN_GeoSoundexKey fakeKey = new CAN_GeoSoundexKey("\u0000", fakeSoundex);
            MapMarkerIndexMultiValue fakeValue = new MapMarkerIndexMultiValue();
            fakeValue.addOffset(-1L);
            soundexIndex.addIndexEntry(fakeKey, (MapMarkerIndexValue)fakeValue);
            soundexIndex.write();
            soundexIndex.close();
        }
        catch (IOException IOEx) {
            throw new DataCreationException(400, (Throwable)IOEx);
        }
        catch (DuplicateKeyException DKEx) {
            throw new DataCreationException(400, (Throwable)DKEx);
        }
        this.m_geoInfoIndex = new MiStringIndexFile();
        try {
            this.m_geoInfoIndex.open(geoInfoBase + ".jdx");
        }
        catch (IOException IOEx) {
            throw new DataCreationException(400, (Throwable)IOEx);
        }
        ((CAN_GenericStreetBuilder)this.m_dataBuilder).setGeoInfoIndex(this.m_geoInfoIndex);
    }

    public IndexFileConvertor getSoundexGeoInfoIndexConvertor(String tempIndex, String newIndex) {
        return null;
    }

    public IndexFileConvertor getExactMatchGeoInfoIndexConvertor(String tempIndex, String newIndex) {
        return null;
    }

    @Override
    protected List getTempFileNames() {
        List files = super.getTempFileNames();
        String geoInfoBase = StringUtilities.appendToPath((String)this.getGeoInfoFilePath(), (String)this.getGeoInfoFileBaseName());
        files.add(geoInfoBase + ".tdx");
        files.add(geoInfoBase + ".jdx");
        String postInfoBase = StringUtilities.appendToPath((String)this.getPostInfoFilePath(), (String)this.getPostInfoFileBaseName());
        String postInfoTempIndex = postInfoBase + ".tzx";
        if (files.contains(postInfoTempIndex)) {
            files.remove(postInfoTempIndex);
        }
        if (files.contains(postInfoTempIndex = postInfoBase + ".tdx")) {
            files.remove(postInfoTempIndex);
        }
        return files;
    }

    @Override
    protected List getFinalFileNames() {
        String postInfoIndexFileName;
        String postInfoBase;
        String postInfoDataFileName;
        List files = super.getFinalFileNames();
        if (files.contains(postInfoDataFileName = (postInfoBase = StringUtilities.appendToPath((String)this.getPostInfoFilePath(), (String)this.getPostInfoFileBaseName())) + ".jdr")) {
            files.remove(postInfoDataFileName);
        }
        if (files.contains(postInfoIndexFileName = postInfoBase + ".jdx")) {
            files.remove(postInfoIndexFileName);
        }
        String geoInfoBase = StringUtilities.appendToPath((String)this.getGeoInfoFilePath(), (String)this.getGeoInfoFileBaseName());
        files.add(geoInfoBase + ".jdr");
        files.add(geoInfoBase + ".sdx");
        String altFile = StringUtilities.appendToPath((String)this.getStreetFilePath(), (String)"alt.mmj");
        if (files.contains(altFile)) {
            files.remove(altFile);
        }
        return files;
    }

    public byte[] getAlternateStreetSearchSupportedTypes() {
        return null;
    }

    public byte[] getAlternateStreetBrowseSupportedTypes() {
        return null;
    }

    public IFileInnerIndexConvertor getStreetAlternateSearchTypeIndexFileConvertor(byte alternateType) {
        return null;
    }

    public IFileInnerIndexConvertor getStreetAlternateBrowseTypeIndexFileConvertor(byte alternateType) {
        return null;
    }
}

