/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.ud.tab;

import com.mapinfo.mapmarker.CAN.dp.ud.ICAN_UDLDUDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.tab.TabDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.tab.TabDataSourceRecordObjects;

public class CAN_UDTabLDUDataSourceRecord
extends TabDataSourceRecord
implements ICAN_UDLDUDataSourceRecord {
    private String m_LDUKey;

    public CAN_UDTabLDUDataSourceRecord(TabDataSourceRecordObjects objects, String LDUKey) {
        super(objects);
        this.m_LDUKey = LDUKey;
    }

    @Override
    public boolean hasLDU() throws DataSourceException {
        return this.hasField(this.m_LDUKey);
    }

    @Override
    public String getLDU() throws DataSourceException {
        if (this.hasLDU()) {
            String LDU = this.emptyToNull(this.getFieldStringValue(this.getFieldName(this.m_LDUKey)));
            if (LDU == null || this.isValidLDU(LDU)) {
                return LDU;
            }
            DataCreationLogger.getLogger().logInternalError("Invalid LDU value: " + LDU);
            return null;
        }
        return null;
    }

    private boolean isValidLDU(String LDU) {
        if (LDU != null && LDU.length() == 3) {
            return Character.isDigit(LDU.charAt(0)) && Character.isLetter(LDU.charAt(1)) && Character.isDigit(LDU.charAt(2));
        }
        return false;
    }

    private String emptyToNull(String str) {
        if (str == null) {
            return null;
        }
        String temp = str.trim();
        if (temp.length() == 0) {
            return null;
        }
        return temp;
    }
}

