/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.dp.ud.tab;

import com.mapinfo.mapmarker.CAN.dp.CAN_TabSegmentDataSourceRecordImpl;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.tab.TabDataSourceRecordObjects;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;

public class CAN_UDTabSegmentDataSourceRecord
extends CAN_TabSegmentDataSourceRecordImpl {
    private static Set m_provinces = new TreeSet();

    public CAN_UDTabSegmentDataSourceRecord(TabDataSourceRecordObjects objects, String leftAreaName1FieldKey, String leftAreaName2FieldKey, String leftAreaName3FieldKey, String leftAreaName4FieldKey, String leftPostCode1FieldKey, String leftPostCode2FieldKey, String rightAreaName1FieldKey, String rightAreaName2FieldKey, String rightAreaName3FieldKey, String rightAreaName4FieldKey, String rightPostCode1FieldKey, String rightPostCode2FieldKey, String leftDAFieldKey, String leftCMAFieldKey, String leftCSDFieldKey, String leftCTFieldKey, String rightDAFieldKey, String rightCMAFieldKey, String rightCSDFieldKey, String rightCTFieldKey, String leftCDFieldKey, String rightCDFieldKey, ArrayList rangeRecords) {
        super(objects, leftAreaName1FieldKey, leftAreaName2FieldKey, leftAreaName3FieldKey, leftAreaName4FieldKey, leftPostCode1FieldKey, leftPostCode2FieldKey, rightAreaName1FieldKey, rightAreaName2FieldKey, rightAreaName3FieldKey, rightAreaName4FieldKey, rightPostCode1FieldKey, rightPostCode2FieldKey, leftDAFieldKey, leftCMAFieldKey, leftCSDFieldKey, leftCTFieldKey, rightDAFieldKey, rightCMAFieldKey, rightCSDFieldKey, rightCTFieldKey, leftCDFieldKey, rightCDFieldKey, "NONE", rangeRecords);
    }

    public String getLeftAreaName1() throws DataSourceException {
        String leftProv = super.getLeftAreaName1();
        if (leftProv == null || this.isValidProvince(leftProv)) {
            return leftProv;
        }
        DataCreationLogger.getLogger().logInternalError("Invalid leftProv: " + leftProv);
        return null;
    }

    public String getRightAreaName1() throws DataSourceException {
        String rightProv = super.getRightAreaName1();
        if (rightProv == null || this.isValidProvince(rightProv)) {
            return rightProv;
        }
        DataCreationLogger.getLogger().logInternalError("Invalid rightProv: " + rightProv);
        return null;
    }

    public String getLeftPostCode1() throws DataSourceException {
        String leftFSA = super.getLeftPostCode1();
        if (leftFSA == null || this.isValidFSA(leftFSA)) {
            return leftFSA;
        }
        DataCreationLogger.getLogger().logInternalError("Invalid leftFSA: " + leftFSA);
        return null;
    }

    public String getRightPostCode1() throws DataSourceException {
        String rightFSA = super.getRightPostCode1();
        if (rightFSA == null || this.isValidFSA(rightFSA)) {
            return rightFSA;
        }
        DataCreationLogger.getLogger().logInternalError("Invalid rightFSA: " + rightFSA);
        return null;
    }

    private boolean isValidFSA(String test) {
        if (test == null || test.length() != 3) {
            return false;
        }
        return Character.isLetter(test.charAt(0)) && Character.isDigit(test.charAt(1)) && Character.isLetter(test.charAt(2));
    }

    private boolean isValidProvince(String province) {
        if (province == null || province.length() != 2) {
            return false;
        }
        return m_provinces.contains(province.toUpperCase());
    }

    static {
        String[] prAbbr = new String[]{"AB", "BC", "MB", "NB", "NL", "NT", "NS", "NU", "ON", "PE", "QC", "SK", "YT", "PQ"};
        for (int i = 0; i < prAbbr.length; ++i) {
            m_provinces.add(prAbbr[i]);
        }
    }
}

