/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.filters;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;

public class BetterDirectionalRule
implements ICloseMatchFilterRule {
    public boolean demoteOther(Address[] inputAddresses, ICandidate bestCandidate, ICandidate otherCandidate) {
        InternalCandidateAddress best = (InternalCandidateAddress)bestCandidate;
        InternalCandidateAddress other = (InternalCandidateAddress)otherCandidate;
        if (best.getMainAddressScore() != other.getMainAddressScore() || best.getPreThoroughfareTypeScore() != other.getPreThoroughfareTypeScore() || best.getPostThoroughfareTypeScore() != other.getPostThoroughfareTypeScore() || best.getCombinedAdditionalFieldScore() != other.getCombinedAdditionalFieldScore()) {
            return false;
        }
        String inputPreDir = inputAddresses[0].getPreDirectional();
        String inputPostDir = inputAddresses[0].getPostDirectional();
        if (inputPreDir == null && inputPostDir == null) {
            return best.getPreDirectional() == null && best.getPostDirectional() == null && (other.getPreDirectional() != null || other.getPostDirectional() != null);
        }
        if (inputPreDir == null) {
            if (best.getPostDirectionalScore() == 1.0 && other.getPostDirectionalScore() != 1.0) {
                return true;
            }
            if (best.getPostDirectionalScore() != 1.0 && other.getPostDirectionalScore() == 1.0) {
                return false;
            }
            if (this.acceptDirectional(inputPostDir, best.getPostDirectional()) && !this.acceptDirectional(inputPostDir, other.getPostDirectional())) {
                return true;
            }
        } else {
            if (best.getPreDirectionalScore() == 1.0 && other.getPreDirectionalScore() != 1.0) {
                return true;
            }
            if (best.getPreDirectionalScore() != 1.0 && other.getPreDirectionalScore() == 1.0) {
                return false;
            }
            if (this.acceptDirectional(inputPreDir, best.getPreDirectional()) && !this.acceptDirectional(inputPreDir, other.getPreDirectional())) {
                return true;
            }
        }
        return false;
    }

    private boolean acceptDirectional(String target, String test) {
        int testValue;
        if (target == null && test == null) {
            return true;
        }
        if (target == null || test == null) {
            return false;
        }
        int targetValue = this.assignDirectionalValue(target);
        if (targetValue < (testValue = this.assignDirectionalValue(test))) {
            return testValue - targetValue <= 1;
        }
        return targetValue - testValue <= 1;
    }

    private int assignDirectionalValue(String directional) {
        int length = directional.length();
        switch (directional.charAt(0)) {
            case 'N': {
                if (length == 1) {
                    return 0;
                }
                if (length != 2) break;
                switch (directional.charAt(1)) {
                    case 'E': {
                        return 1;
                    }
                    case 'W': {
                        return 7;
                    }
                }
                break;
            }
            case 'E': {
                if (length != 1) break;
                return 2;
            }
            case 'S': {
                if (length == 1) {
                    return 4;
                }
                if (length != 2) break;
                switch (directional.charAt(1)) {
                    case 'E': {
                        return 3;
                    }
                    case 'W': {
                        return 5;
                    }
                }
                break;
            }
            case 'W': {
                if (length != 1) break;
                return 6;
            }
        }
        return 99;
    }
}

