/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.filters;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;

public class BetterStreetFilter
implements ICloseMatchFilterRule {
    public boolean demoteOther(Address[] inputAddresses, ICandidate bestCandidate, ICandidate otherCandidate) {
        InternalCandidateAddress best = (InternalCandidateAddress)bestCandidate;
        InternalCandidateAddress other = (InternalCandidateAddress)otherCandidate;
        if (best.getCombinedAddressScore() == other.getCombinedAddressScore() || best.getAddressNumberScore() != other.getAddressNumberScore()) {
            return false;
        }
        if (best.getCombinedAdditionalFieldScore() == other.getCombinedAdditionalFieldScore()) {
            Address inputAddress = inputAddresses[0];
            if (best.getMainAddressScore() > other.getMainAddressScore()) {
                return true;
            }
            if (best.getPreThoroughfareTypeScore() > other.getPreThoroughfareTypeScore()) {
                return true;
            }
            if (best.getPostThoroughfareTypeScore() > other.getPostThoroughfareTypeScore()) {
                return true;
            }
            if (inputAddress.getPreDirectional() != null && best.getPreDirectionalScore() > other.getPreDirectionalScore()) {
                return true;
            }
            if (inputAddress.getPostDirectional() != null && best.getPostDirectionalScore() > other.getPostDirectionalScore()) {
                return true;
            }
        } else if (best.getCombinedAddressScore() > other.getCombinedAddressScore() && best.getPostCode1Score() != 1.0 && other.getPostCode1Score() != 1.0 && best.getAreaName3Score() >= other.getAreaName3Score()) {
            return true;
        }
        return false;
    }
}

