/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.filters;

import com.mapinfo.mapmarker.CAN.CAN_InternalCandidateAddress;
import com.mapinfo.mapmarker.CAN.CAN_Range;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;

public class HouseNumberFilterRule
implements ICloseMatchFilterRule {
    public boolean demoteOther(Address[] inputAddresses, ICandidate bestCandidate, ICandidate otherCandidate) {
        CAN_InternalCandidateAddress best = (CAN_InternalCandidateAddress)bestCandidate;
        CAN_InternalCandidateAddress other = (CAN_InternalCandidateAddress)otherCandidate;
        ParsedNumber inputNumber = inputAddresses[0].getParsedAddressNumber();
        if (inputNumber == null || inputNumber.isEmpty()) {
            return (best.getAddressNumber() == null || best.getAddressNumber() != null && best.getAddressNumber().isEmpty()) && other.getAddressNumber() != null && !other.getAddressNumber().isEmpty();
        }
        if (best.hasMatchingRange() && other.hasMatchingRange()) {
            if (best.getCntAddressNumberFieldsMatched() > other.getCntAddressNumberFieldsMatched()) {
                return other.getPostCode1Score() != 1.0 || other.getPostCode2Score() != 1.0 || best.getPostCode1Score() == 1.0 && best.getPostCode2Score() == 1.0;
            }
            CAN_Range bestRange = (CAN_Range)best.getSegment().getRangeAt(best.getMatchedRangeNumber(), best.getSegmentSide());
            CAN_Range otherRange = (CAN_Range)other.getSegment().getRangeAt(other.getMatchedRangeNumber(), other.getSegmentSide());
            if (bestRange != null && otherRange != null) {
                int parityForOther;
                int inputParity = inputNumber.isRangeOddEvenBoth();
                int parityForBest = bestRange.getOddEven();
                if (parityForBest != (parityForOther = otherRange.getOddEven()) && inputParity != parityForOther && parityForOther != 0 && (parityForBest == inputParity || parityForBest == 0)) {
                    return true;
                }
            }
            return false;
        }
        if (best.hasMatchingRange() && !other.hasMatchingRange()) {
            if (other.getPostCode1Score() < 1.0 || best.getPostCode2Score() >= other.getPostCode2Score()) {
                return true;
            }
        } else {
            ParsedNumber bestNumber = best.getParsedAddressNumber();
            if (bestNumber != null && !bestNumber.isEmpty()) {
                long otherOffset;
                ParsedNumber otherNumber = other.getParsedAddressNumber();
                if (otherNumber == null || otherNumber.isEmpty()) {
                    return true;
                }
                long bestOffset = inputNumber.computeDifference(bestNumber, 1);
                if (bestOffset < (otherOffset = inputNumber.computeDifference(otherNumber, 1)) && best.getPostCode1Score() >= other.getPostCode1Score() && best.getPostCode2Score() >= other.getPostCode2Score()) {
                    return true;
                }
            }
        }
        return false;
    }
}

