/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.filters;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;

public class PreferPostalMatchWithSlighStreetErrorFilter
implements ICloseMatchFilterRule {
    public boolean demoteOther(Address[] inputAddresses, ICandidate bestCandidate, ICandidate otherCandidate) {
        InternalCandidateAddress best = (InternalCandidateAddress)bestCandidate;
        InternalCandidateAddress other = (InternalCandidateAddress)otherCandidate;
        if (best.getPostCode1Score() != 1.0 || best.getPostCode2Score() != 1.0) {
            return false;
        }
        if (other.getPostCode1Score() == 1.0 && other.getPostCode2Score() == 1.0) {
            return false;
        }
        if (best.getCombinedAddressScore() < other.getCombinedAddressScore()) {
            if (other.getMainAddressScore() > best.getMainAddressScore()) {
                return false;
            }
            boolean bBetterPreDir = other.getPreDirectionalScore() > best.getPreDirectionalScore();
            boolean bBetterPreType = other.getPreThoroughfareTypeScore() > best.getPreThoroughfareTypeScore();
            boolean bBetterPostType = other.getPostThoroughfareTypeScore() > best.getPostThoroughfareTypeScore();
            boolean bBetterPostDir = other.getPostDirectionalScore() > best.getPostDirectionalScore();
            int totalDiffs = bBetterPreDir ? 1 : 0;
            totalDiffs += bBetterPreType ? 1 : 0;
            totalDiffs += bBetterPostType ? 1 : 0;
            return (totalDiffs += bBetterPostDir ? 1 : 0) <= 1;
        }
        return best.getCombinedAdditionalFieldScore() >= other.getCombinedAdditionalFieldScore();
    }
}

