/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.gui;

import com.mapinfo.mapmarker.CAN.dp.CANPost.ICombinedRecord;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class CANPostRecordTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"ID", "Postal code", "Street", "Dir", "Type", "From", "To", "Seq", "rec type", "municipality", "dir areaName"};
    private static final int COLUMNS = COLUMN_NAMES.length;
    private static final int COLUMN_WIDTH_FACTOR = 9;
    private static final int[] COLUMN_WIDTHS = new int[]{8, 6, 25, 3, 5, 6, 6, 3, 3, 25, 25};
    private ArrayList m_allRecords;
    private ArrayList m_leftOvers;
    private ArrayList m_records;
    private int m_rows;

    public void updataContents(ArrayList allRecords, ArrayList leftOvers) {
        this.m_allRecords = allRecords;
        this.m_leftOvers = leftOvers;
        this.selectAllRecords();
    }

    @Override
    public int getColumnCount() {
        return COLUMNS;
    }

    @Override
    public int getRowCount() {
        return this.m_rows;
    }

    public int getColumnWidth(int column) {
        return 9 * COLUMN_WIDTHS[column];
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public Class getColumnClass(int column) {
        return String.class;
    }

    @Override
    public Object getValueAt(int row, int column) {
        ICombinedRecord record = (ICombinedRecord)this.m_records.get(row);
        switch (column) {
            case 0: {
                return record.getUniqueIDElement().getUniqueID();
            }
            case 1: {
                return record.getStandardElements().getPostalCode();
            }
            case 2: {
                return record.getStreetElements().getStreetName();
            }
            case 3: {
                return record.getStreetElements().getStreetDirectionCode();
            }
            case 4: {
                return record.getStreetElements().getStreetTypeCode();
            }
            case 5: {
                return record.getStreetElements().getStreetAddressFromNumber();
            }
            case 6: {
                return record.getStreetElements().getStreetAddressToNumber();
            }
            case 7: {
                return String.valueOf(record.getStreetElements().getStreetAddressSequenceCode());
            }
            case 8: {
                return String.valueOf(record.getStandardElements().getRecordTypeCode());
            }
            case 9: {
                return record.getStandardElements().getMunicipalityName();
            }
            case 10: {
                return record.getStandardElements().getDirectoryAreaName();
            }
        }
        return null;
    }

    private void setCurrent(ArrayList records) {
        this.m_records = records;
        this.m_rows = this.m_records != null ? this.m_records.size() : 0;
        this.fireTableDataChanged();
    }

    public void selectAllRecords() {
        this.setCurrent(this.m_allRecords);
    }

    public void selectLeftOvers() {
        this.setCurrent(this.m_leftOvers);
    }
}

