/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.gui;

import com.mapinfo.mapmarker.CAN.CAN_ParsedAddress;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ParsePanel
extends JPanel {
    private boolean m_bDisplayHorizontal;
    private JTextField m_preDir;
    private JTextField m_preType;
    private JTextField m_main;
    private JTextField m_postType;
    private JTextField m_postDir;
    private JCheckBox m_numberedRoad;
    private JCheckBox m_numericStreet;
    private JCheckBox m_frenchOrdinal;
    private JCheckBox m_englishOrdinal;

    public ParsePanel(boolean bDisplayHorizontal) {
        this.m_bDisplayHorizontal = bDisplayHorizontal;
    }

    public void init() {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 35, 5, 35), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Parsed Output"), BorderFactory.createEmptyBorder(10, 5, 10, 5))));
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 10;
        constraints.fill = 0;
        JPanel hiddenPanel = this.makeHiddenPanel();
        constraints.gridheight = this.m_bDisplayHorizontal ? 2 : 6;
        constraints.gridwidth = this.m_bDisplayHorizontal ? 6 : 2;
        layout.setConstraints(hiddenPanel, constraints);
        this.add(hiddenPanel);
        JPanel checkPanel = this.makeCheckPanel();
        constraints.gridheight = 1;
        constraints.gridwidth /= 2;
        constraints.gridy = constraints.gridy + (this.m_bDisplayHorizontal ? 3 : 10);
        constraints.gridx = this.m_bDisplayHorizontal ? 3 : 1;
        constraints.anchor = 10;
        constraints.fill = 0;
        layout.setConstraints(checkPanel, constraints);
        this.add(checkPanel);
    }

    private JPanel makeHiddenPanel() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 0;
        constraints.anchor = 17;
        JLabel label = this.makeLabel("Pre Dir: ");
        constraints.gridx = 1;
        constraints.gridy = 1;
        layout.setConstraints(label, constraints);
        panel.add(label);
        this.m_preDir = this.makeField(2);
        ++constraints.gridx;
        layout.setConstraints(this.m_preDir, constraints);
        panel.add(this.m_preDir);
        label = this.makeLabel("Pre Type: ");
        if (this.m_bDisplayHorizontal) {
            ++constraints.gridx;
        } else {
            ++constraints.gridy;
            constraints.gridx = 1;
        }
        layout.setConstraints(label, constraints);
        panel.add(label);
        this.m_preType = this.makeField(4);
        ++constraints.gridx;
        layout.setConstraints(this.m_preType, constraints);
        panel.add(this.m_preType);
        label = this.makeLabel("Main: ");
        if (this.m_bDisplayHorizontal) {
            ++constraints.gridx;
        } else {
            ++constraints.gridy;
            constraints.gridx = 1;
        }
        layout.setConstraints(label, constraints);
        panel.add(label);
        this.m_main = this.makeField(25);
        ++constraints.gridx;
        layout.setConstraints(this.m_main, constraints);
        panel.add(this.m_main);
        label = this.makeLabel("Post Type: ");
        if (this.m_bDisplayHorizontal) {
            ++constraints.gridx;
        } else {
            ++constraints.gridy;
            constraints.gridx = 1;
        }
        layout.setConstraints(label, constraints);
        panel.add(label);
        this.m_postType = this.makeField(4);
        ++constraints.gridx;
        layout.setConstraints(this.m_postType, constraints);
        panel.add(this.m_postType);
        label = this.makeLabel("Post Dir: ");
        if (this.m_bDisplayHorizontal) {
            ++constraints.gridx;
        } else {
            ++constraints.gridy;
            constraints.gridx = 1;
        }
        layout.setConstraints(label, constraints);
        panel.add(label);
        this.m_postDir = this.makeField(2);
        ++constraints.gridx;
        layout.setConstraints(this.m_postDir, constraints);
        panel.add(this.m_postDir);
        return panel;
    }

    private JLabel makeLabel(String title) {
        JLabel label = new JLabel(title);
        this.addBorder(label);
        return label;
    }

    private JTextField makeField(int width) {
        JTextField field = new JTextField();
        field.setColumns(width + 1);
        field.setEditable(false);
        this.addBorder(field);
        return field;
    }

    private JPanel makeCheckPanel() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 0;
        constraints.anchor = 10;
        constraints.gridy = 1;
        this.m_numberedRoad = this.makeCheckBox("Numbered Road");
        constraints.gridx = 1;
        layout.setConstraints(this.m_numberedRoad, constraints);
        panel.add(this.m_numberedRoad);
        this.m_numericStreet = this.makeCheckBox("Numeric Street");
        ++constraints.gridx;
        layout.setConstraints(this.m_numericStreet, constraints);
        panel.add(this.m_numericStreet);
        this.m_frenchOrdinal = this.makeCheckBox("French Ordinal");
        ++constraints.gridx;
        layout.setConstraints(this.m_frenchOrdinal, constraints);
        panel.add(this.m_frenchOrdinal);
        this.m_englishOrdinal = this.makeCheckBox("English Ordinal");
        ++constraints.gridx;
        layout.setConstraints(this.m_englishOrdinal, constraints);
        panel.add(this.m_englishOrdinal);
        return panel;
    }

    private JCheckBox makeCheckBox(String title) {
        JCheckBox checkBox = new JCheckBox(title);
        checkBox.setEnabled(false);
        this.addBorder(checkBox);
        return checkBox;
    }

    private void addBorder(JComponent component) {
        component.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, this.m_bDisplayHorizontal && component instanceof JLabel ? 10 : 5, 5, 5), component.getBorder()));
    }

    public void clear() {
        this.m_preDir.setText(null);
        this.m_preType.setText(null);
        this.m_main.setText(null);
        this.m_postType.setText(null);
        this.m_postDir.setText(null);
        this.m_numberedRoad.setSelected(false);
        this.m_numericStreet.setSelected(false);
        this.m_frenchOrdinal.setSelected(false);
        this.m_englishOrdinal.setSelected(false);
    }

    public void update(CAN_ParsedAddress address) {
        this.m_preDir.setText(address.getPreDirectional());
        this.m_preType.setText(address.getPreThoroughfareType());
        this.m_main.setText(address.getMainAddress());
        this.m_postType.setText(address.getPostThoroughfareType());
        this.m_postDir.setText(address.getPostDirectional());
        this.m_numberedRoad.setSelected(address.isNumberedRoad());
        this.m_numericStreet.setSelected(address.isNumericStreetName());
        this.m_frenchOrdinal.setSelected(address.hasFrenchOrdinal());
        this.m_englishOrdinal.setSelected(address.hasEnglishOrdinal());
    }
}

