/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.parser;

import com.mapinfo.mapmarker.utils.FileUtilities;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.HashMap;
import java.util.Map;

public class CAN_Abbreviations {
    private static final String ABBR_FILE = "com.mapinfo.mapmarker.CAN.CAN_Abbreviations.properties";
    private static final String EXPANS_FILE = "com.mapinfo.mapmarker.CAN.CAN_Expansions.properties";
    private static final Map m_abbreviationMap = new HashMap();
    private static final Map m_expandedNameMap;

    private static Map load(String propFile) {
        try {
            return FileUtilities.loadProperties((String)propFile);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static void loadAbbreviations() {
        Map props = CAN_Abbreviations.load(ABBR_FILE);
        if (props != null) {
            for (Map.Entry entry : props.entrySet()) {
                m_abbreviationMap.put(entry.getKey(), new AbbreviationItem((String)entry.getValue()));
            }
        }
    }

    private static void loadExpansions() {
        Map props = CAN_Abbreviations.load(EXPANS_FILE);
        if (props != null) {
            for (Map.Entry entry : props.entrySet()) {
                m_expandedNameMap.put(entry.getKey(), new ExpansionItem((String)entry.getValue()));
            }
        }
    }

    private CAN_Abbreviations() {
    }

    public static String getExpandedName(String abbr) {
        return CAN_Abbreviations.getExpandedName(abbr, false);
    }

    public static String getExpandedName(String abbr, boolean bFrench) {
        ExpansionItem item = (ExpansionItem)m_expandedNameMap.get(abbr);
        if (item != null) {
            String expansion;
            if (bFrench && (expansion = item.getFrenchExpansion()) != null) {
                return expansion;
            }
            return item.getEnglishExpansion();
        }
        return null;
    }

    public static String getProperName(String abbr) {
        if (m_expandedNameMap.get(abbr) != null) {
            return abbr;
        }
        return null;
    }

    public static String getAbbrFromValue(String val) {
        AbbreviationItem item = (AbbreviationItem)m_abbreviationMap.get(val);
        if (item != null) {
            return item.gtAbbreviation();
        }
        return null;
    }

    public static void convertToNumeric(StringWithTokens tokens) {
        int i;
        boolean bProcessingNumber = false;
        String currentNumber = null;
        for (i = 0; i < tokens.size(); ++i) {
            StringWithTokens tempTokens;
            String token = tokens.getToken(i);
            String abbrev = CAN_Abbreviations.getAbbrFromValue(token);
            if (abbrev != null) {
                tokens.remove(i);
                --i;
                currentNumber = bProcessingNumber ? currentNumber.substring(0, currentNumber.length() - 1) + abbrev : abbrev;
                if (currentNumber.length() > 1 && StringUtilities.isNumeric((String)currentNumber) && currentNumber.charAt(currentNumber.length() - 1) == '0') {
                    bProcessingNumber = true;
                    continue;
                }
                tokens.insert(i + 1, currentNumber);
                ++i;
                bProcessingNumber = false;
                continue;
            }
            if (bProcessingNumber) {
                tokens.insert(i, currentNumber);
                ++i;
                bProcessingNumber = false;
            }
            if ((tempTokens = new StringWithTokens(token, "-")).size() != 2) continue;
            CAN_Abbreviations.convertToNumeric(tempTokens);
            if (tempTokens.size() != 1) continue;
            tokens.setToken(i, tempTokens.getToken(0));
        }
        if (bProcessingNumber) {
            tokens.insert(i, currentNumber);
        }
    }

    public static boolean expandNumber(StringWithTokens tokens, boolean bFrench) {
        boolean bAdjustedNumber = false;
        boolean bIs80 = false;
        for (int i = 0; i < tokens.size(); ++i) {
            String token = tokens.getToken(i);
            if (!StringUtilities.isNumeric((String)token)) continue;
            String expansion = CAN_Abbreviations.getExpandedName(token, bFrench);
            if (expansion != null) {
                bAdjustedNumber = true;
                tokens.setToken(i, expansion);
                continue;
            }
            long tokenValueLong = Long.parseLong(token);
            if (tokenValueLong >= 100L) continue;
            int tokenValue = (int)tokenValueLong;
            String replacement = null;
            String secondReplacement = null;
            int tensValue = tokenValue / 10;
            int unitValue = tokenValue % 10;
            if (bFrench && tensValue >= 7) {
                switch (tensValue) {
                    case 7: {
                        replacement = CAN_Abbreviations.getExpandedName("60", true);
                        secondReplacement = CAN_Abbreviations.getExpandedName(String.valueOf(unitValue + 10), true);
                        break;
                    }
                    case 8: {
                        replacement = CAN_Abbreviations.getExpandedName("80", true);
                        secondReplacement = CAN_Abbreviations.getExpandedName(String.valueOf(unitValue), true);
                        bIs80 = true;
                        break;
                    }
                    case 9: {
                        replacement = CAN_Abbreviations.getExpandedName("80", true);
                        secondReplacement = CAN_Abbreviations.getExpandedName(String.valueOf(unitValue + 10), true);
                        bIs80 = true;
                    }
                }
            } else {
                replacement = CAN_Abbreviations.getExpandedName(String.valueOf(tensValue * 10), bFrench);
                secondReplacement = CAN_Abbreviations.getExpandedName(String.valueOf(unitValue), bFrench);
            }
            if (replacement == null || secondReplacement == null) continue;
            if (bFrench) {
                StringBuilder builder;
                if (bIs80) {
                    replacement = replacement.substring(0, replacement.length() - 1);
                    builder = new StringBuilder(replacement);
                    builder.append('-');
                    builder.append(secondReplacement);
                    tokens.setToken(i, builder.toString());
                } else if (unitValue == 1) {
                    tokens.setToken(i, secondReplacement);
                    tokens.insert(i, "ET");
                    tokens.insert(i, replacement);
                    i += 2;
                } else {
                    builder = new StringBuilder(replacement);
                    builder.append('-');
                    builder.append(secondReplacement);
                    tokens.setToken(i, builder.toString());
                }
            } else {
                tokens.setToken(i, secondReplacement);
                tokens.insert(i, replacement);
                ++i;
            }
            bAdjustedNumber = true;
        }
        return bAdjustedNumber;
    }

    static {
        CAN_Abbreviations.loadAbbreviations();
        m_expandedNameMap = new HashMap();
        CAN_Abbreviations.loadExpansions();
    }

    private static class ExpansionItem {
        private String m_englishExpansion;
        private String m_frenchExpansion;

        private ExpansionItem(String expansion) {
            int index = expansion.indexOf(44);
            if (index == -1) {
                this.m_englishExpansion = expansion;
            } else {
                this.m_englishExpansion = expansion.substring(0, index);
                this.m_frenchExpansion = expansion.substring(index + 1);
            }
        }

        private String getEnglishExpansion() {
            return this.m_englishExpansion;
        }

        private String getFrenchExpansion() {
            return this.m_frenchExpansion;
        }
    }

    private static class AbbreviationItem {
        private String m_abbreviation;

        private AbbreviationItem(String abbreviation) {
            this.m_abbreviation = abbreviation;
        }

        private String gtAbbreviation() {
            return this.m_abbreviation;
        }
    }
}

