/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.parser;

import com.mapinfo.mapmarker.common.Address;
import java.util.HashMap;
import java.util.Map;

public class CAN_Directionals {
    private static final Map m_directionalMap;
    private static final Map m_directionalFullNameMap;

    private CAN_Directionals() {
    }

    public static String getAbbreviation(String directional) {
        String abbrev = (String)m_directionalMap.get(directional);
        if (abbrev != null) {
            return abbrev;
        }
        if (directional.charAt(directional.length() - 1) == '.') {
            return (String)m_directionalMap.get(directional.substring(0, directional.length() - 1));
        }
        return null;
    }

    public static String getFullName(String directional) {
        String fullName = (String)m_directionalFullNameMap.get(directional);
        if (fullName != null) {
            return fullName;
        }
        if (directional.charAt(directional.length() - 1) == '.') {
            return (String)m_directionalFullNameMap.get(directional.substring(0, directional.length() - 1));
        }
        return null;
    }

    public static boolean isDirectional(String directional) {
        if (directional == null) {
            return false;
        }
        if (m_directionalMap.containsKey(directional)) {
            return true;
        }
        if (directional.charAt(directional.length() - 1) == '.') {
            return m_directionalMap.containsKey(directional.substring(0, directional.length() - 1));
        }
        return false;
    }

    public static boolean removePreDirectional(Address address) {
        String tmp;
        String main = address.getMainAddress();
        boolean foundDir = false;
        if (main.startsWith("EAST")) {
            String tmp2 = main.substring(4);
            if (tmp2.length() != 0) {
                address.setPreDirectional("E");
                address.setMainAddress(tmp2);
                foundDir = true;
            }
        } else if (main.startsWith("WEST")) {
            String tmp3 = main.substring(4);
            if (tmp3.length() != 0) {
                address.setPreDirectional("W");
                address.setMainAddress(tmp3);
                foundDir = true;
            }
        } else if (main.startsWith("NORTH")) {
            String tmp4 = main.substring(5);
            if (tmp4.length() != 0) {
                address.setPreDirectional("N");
                address.setMainAddress(tmp4);
                foundDir = true;
            }
        } else if (main.startsWith("SOUTH") && (tmp = main.substring(5)).length() != 0) {
            address.setPreDirectional("S");
            address.setMainAddress(tmp);
            foundDir = true;
        }
        return foundDir;
    }

    static {
        int i;
        String[] directionals = new String[]{"N", "S", "E", "W", "O", "NO", "SO", "NE", "NW", "SE", "SW", "NORTH", "SOUTH", "EAST", "WEST", "NORD", "SUD", "EST", "OUEST", "NO", "SO", "NORDOUEST", "SUDOUEST", "NORD-OUEST", "SUD-OUEST", "NORTHEAST", "NORTHWEST", "SOUTHEAST", "SOUTHWEST", "N.E.", "N.W.", "S.E.", "S.W.", "N.O.", "S.O.", "N.", "S.", "E.", "W.", "O."};
        String[] directionalName = new String[]{"NORTH", "SOUTH", "EAST", "WEST", "OUEST", "NORDOUEST", "SUDOUEST", "NORTHEAST", "NORTHWEST", "SOUTHEAST", "SOUTHWEST", "NORTH", "SOUTH", "EAST", "WEST", "NORD", "SUD", "EST", "OUEST", "NORDOUEST", "SUDOEST", "NORDOUEST", "SUDOUEST", "NORDOUEST", "SUDOUEST", "NORTHEAST", "NORTHWEST", "SOUTHEAST", "SOUTHWEST", "NORTHEAST", "NORTHWEST", "SOUTHEAST", "SOUTHWEST", "NORDOUEST", "SUDOUEST", "NORTH", "SOUTH", "EAST", "WEST", "OUEST"};
        String[] abbreviation = new String[]{"N", "S", "E", "W", "O", "NO", "SO", "NE", "NW", "SE", "SW", "N", "S", "E", "W", "N", "S", "E", "O", "NO", "SO", "NO", "SO", "NO", "SO", "NE", "NW", "SE", "SW", "NE", "NW", "SE", "SW", "NO", "SO", "N", "S", "E", "W", "O"};
        m_directionalMap = new HashMap(directionals.length);
        for (i = 0; i < directionals.length; ++i) {
            m_directionalMap.put(directionals[i], abbreviation[i]);
        }
        m_directionalFullNameMap = new HashMap(directionals.length);
        for (i = 0; i < directionals.length; ++i) {
            m_directionalFullNameMap.put(directionals[i], directionalName[i]);
        }
    }
}

