/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.parser;

import com.mapinfo.mapmarker.CAN.AddressUtils;
import com.mapinfo.mapmarker.CAN.CAN_ParsedAddress;
import com.mapinfo.mapmarker.CAN.parser.CAN_Abbreviations;
import com.mapinfo.mapmarker.CAN.parser.CAN_Directionals;
import com.mapinfo.mapmarker.CAN.parser.CAN_NewThoroughfareTypes;
import com.mapinfo.mapmarker.CAN.parser.CAN_ThoroughfareType;
import com.mapinfo.mapmarker.CAN.parser.CAN_UnitType;
import com.mapinfo.mapmarker.CAN.parser.CAN_UnitTypes;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.EnglishVerbalNumber;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CAN_NewParseMainAddressRule
implements IParseRule {
    private static final CAN_NewThoroughfareTypes m_tfareTypes;
    private CAN_UnitType m_unitType = null;
    private boolean m_assignedHNToUnit = false;
    static HashSet m_winningPostThoroughfareTypeSet;
    static HashSet m_winningPreThoroughfareTypeSet;
    static HashSet m_losingPostThoroughfareTypeSet;
    static HashSet m_numericStreetCompanionTypeSet;
    static HashSet m_articleSet;
    private static String POSSIBLE_HOUSENUMBER_UNIT_SEPARATORS;
    private static String POBOX_PATTERN_STRING;
    private static Pattern POB_PATTERN;
    private static String FRENCH_POBOX_PATTERN_STRING;
    private static Pattern FRENCH_POB_PATTERN;

    public void parse(Address ura, Address inParsedAddress, IConstraints constraints) throws ParserException {
        String type;
        String token;
        ParsedNumber num;
        StringWithTokens newTokens;
        String token2;
        String testDir;
        boolean abbreviatedPostDir = false;
        boolean abbreviatedPreDir = false;
        CAN_ThoroughfareType postType = null;
        CAN_ThoroughfareType preType = null;
        CAN_ParsedAddress pa = (CAN_ParsedAddress)inParsedAddress;
        String upMainAddress = null;
        String upSecondLine = null;
        Object upFirmName = null;
        StringWithTokens secondLineTokens = null;
        Object firmTokens = null;
        StringWithTokens mainAddrTokens = null;
        String inputMainAddress = null;
        boolean bSwappedMainAndSecondLineTokens = false;
        boolean bPreferPreType = false;
        if (ura == null) {
            throw new ParserException(2000);
        }
        if (pa == null) {
            throw new ParserException(2001);
        }
        this.RemoveBadChars((Address)pa);
        this.RemoveBadChars(ura);
        if (constraints != null && pa.getMainAddress() == null && pa.getGenericField1() != null) {
            pa.setMainAddress(pa.getGenericField1());
            pa.setGenericField1("");
        }
        if (ura.getGenericField1() != null && ura.getGenericField1().length() != 0) {
            AddressImpl secondLineParse = new AddressImpl(ura);
            String buf = ura.getGenericField1().trim();
            upSecondLine = buf.toUpperCase();
            secondLineTokens = new StringWithTokens(upSecondLine, " ,");
            CAN_ThoroughfareType postTypesl = null;
            if (secondLineTokens != null && secondLineTokens.size() != 0) {
                String testDir2;
                this.getHouseNumber((Address)secondLineParse, secondLineTokens, constraints);
                postTypesl = m_tfareTypes.findStreetType(secondLineTokens, false);
                if (postTypesl == null && CAN_Directionals.isDirectional(testDir2 = secondLineTokens.getLastToken())) {
                    secondLineTokens.removeLast();
                    postTypesl = m_tfareTypes.findStreetType(secondLineTokens, false);
                }
                secondLineTokens = new StringWithTokens(upSecondLine, " ,");
            }
        }
        if (pa.getMainAddress() != null && pa.getMainAddress().length() != 0) {
            inputMainAddress = pa.getMainAddress().trim();
            upMainAddress = inputMainAddress.toUpperCase();
            String altMainAddress = this.getFullAddressString((Address)pa);
            if (altMainAddress != null) {
                upMainAddress = altMainAddress;
                pa.setAddressNumber("");
                pa.setPostThoroughfareType("");
                pa.setPreThoroughfareType("");
                pa.setPreDirectional("");
                pa.setPostDirectional("");
            }
            if (upSecondLine != null && upSecondLine.length() != 0) {
                if (!upMainAddress.equals("")) {
                    upMainAddress = upMainAddress + " ";
                }
                upMainAddress = upMainAddress + upSecondLine;
            }
            mainAddrTokens = new StringWithTokens(upMainAddress, " ,");
        }
        pa.setMainAddress("");
        if (upMainAddress == null && upSecondLine == null && (pa.getPlaceName() == null || pa.getPlaceName().length() == 0)) {
            return;
        }
        if (mainAddrTokens == null || mainAddrTokens.size() == 0) {
            return;
        }
        mainAddrTokens = this.separateOutPOBOX(mainAddrTokens, pa);
        if ((mainAddrTokens = this.findSpecialAddressFormats(pa, mainAddrTokens, upMainAddress)).size() == 0) {
            if (pa.getAdditionalFieldForKey(AddressImpl.POB_IN_MAIN_ADDRESS_FIELD) != null) {
                pa.getAdditionalFields().remove(AddressImpl.KEY_POBOX);
                pa.getAdditionalFields().remove(AddressImpl.KEY_POBOX_NUMBER);
            }
            return;
        }
        this.checkForStreetServedByRouteService(pa, mainAddrTokens);
        if (mainAddrTokens != null && mainAddrTokens.size() != 0 && !this.getHouseNumber((Address)pa, mainAddrTokens, constraints)) {
            this.getHouseNumberFromEnd((Address)pa, mainAddrTokens, constraints);
        }
        if (pa.getAddressNumber() == null && upSecondLine != null && secondLineTokens.size() > 1) {
            this.getHouseNumber((Address)pa, secondLineTokens, constraints);
            if (pa.getAddressNumber() != null) {
                StringWithTokens save = mainAddrTokens;
                mainAddrTokens = secondLineTokens;
                secondLineTokens = save;
                bSwappedMainAndSecondLineTokens = true;
            }
        }
        boolean bPostType = false;
        if (mainAddrTokens.size() != 0 && (postType = m_tfareTypes.findStreetType(mainAddrTokens, false)) != null && (!(bPreferPreType = this.pickStartOrEndType(preType = m_tfareTypes.findStreetType(mainAddrTokens, true), postType, mainAddrTokens)) && postType.foundAtEnd() || mainAddrTokens.size() == postType.getNumTokens() && postType.foundAtStart())) {
            pa.setPostThoroughfareType(postType.getPreferredTypeName());
            bPostType = true;
            for (int cnt = 0; cnt < postType.getNumTokens(); ++cnt) {
                mainAddrTokens.removeLast();
            }
        }
        if (mainAddrTokens.size() > 1) {
            mainAddrTokens = this.parseUnitInfo((Address)pa, mainAddrTokens, true, true, !bPostType);
        }
        if (mainAddrTokens.size() > 1 && "#".equals(pa.getUnitType()) && CAN_NewThoroughfareTypes.lookupByTypeName(mainAddrTokens.getLastToken()) == null) {
            mainAddrTokens = this.parseUnitInfo((Address)pa, mainAddrTokens, false, true, !bPostType);
        }
        if (pa.getAddressNumber() == null && pa.getUnitType() != null) {
            this.getHouseNumber((Address)pa, mainAddrTokens, constraints);
        }
        if (mainAddrTokens.size() != 0 && (postType == null || bPreferPreType) && CAN_Directionals.isDirectional(testDir = mainAddrTokens.getLastToken())) {
            pa.setPostDirectional(CAN_Directionals.getAbbreviation(testDir));
            if (!testDir.equals(CAN_Directionals.getAbbreviation(testDir))) {
                abbreviatedPostDir = true;
            }
            mainAddrTokens.removeLast();
        }
        if (!bPreferPreType && mainAddrTokens.size() != 0 && postType == null && (postType = m_tfareTypes.findStreetType(mainAddrTokens, false)) != null && !(bPreferPreType = this.pickStartOrEndType(preType = m_tfareTypes.findStreetType(mainAddrTokens, true), postType, mainAddrTokens)) && postType.foundAtEnd()) {
            pa.setPostThoroughfareType(postType.getPreferredTypeName());
            for (int cnt = 0; cnt < postType.getNumTokens(); ++cnt) {
                mainAddrTokens.removeLast();
            }
        }
        if (mainAddrTokens.size() != 0) {
            boolean bskip = false;
            String testDir3 = mainAddrTokens.getFirstToken();
            if (("SO".equals(testDir3) || "NO".equals(testDir3)) && pa.getPostDirectional() != null) {
                bskip = true;
            }
            if (CAN_Directionals.isDirectional(testDir3) && !bskip) {
                pa.setPreDirectional(CAN_Directionals.getAbbreviation(testDir3));
                if (!testDir3.equals(CAN_Directionals.getAbbreviation(testDir3))) {
                    abbreviatedPreDir = true;
                }
                mainAddrTokens.removeFirst();
            }
        }
        if (mainAddrTokens.size() != 0 && pa.getPostThoroughfareType() == null && pa.getPreThoroughfareType() == null && (preType = m_tfareTypes.findStreetType(mainAddrTokens, true)) != null) {
            for (int cnt = 0; cnt < preType.getNumTokens(); ++cnt) {
                mainAddrTokens.removeFirst();
            }
            if (preType.isSpecialCase()) {
                this.handleSpecialPreTypesWithAddrNum(pa, mainAddrTokens, preType);
            } else {
                pa.setPreThoroughfareType(preType.getPreferredTypeName());
            }
        }
        if (pa.isQC() && mainAddrTokens.size() == 1 && postType != null && m_articleSet.contains(token2 = mainAddrTokens.getFirstToken())) {
            StringBuffer sb = new StringBuffer(token2);
            sb.append(' ');
            sb.append(postType.getTypeName());
            mainAddrTokens = new StringWithTokens(sb.toString());
            pa.setPostThoroughfareType(null);
        }
        if (postType == null && preType == null && mainAddrTokens.size() == 1 && (token = mainAddrTokens.getFirstToken()).indexOf(45) > 0 && (preType = m_tfareTypes.findStreetType(newTokens = new StringWithTokens(token, "-"), true)) != null) {
            for (int cnt = 0; cnt < preType.getNumTokens(); ++cnt) {
                newTokens.removeFirst();
            }
            mainAddrTokens = newTokens;
            if (preType.isSpecialCase()) {
                this.handleSpecialPreTypesWithAddrNum(pa, mainAddrTokens, preType);
            } else {
                pa.setPreThoroughfareType(preType.getPreferredTypeName());
            }
        }
        if (mainAddrTokens.size() > 1 && pa.getAddressNumber() != null && pa.getUnitType() == null && pa.getUnitValue() == null && (num = pa.getParsedAddressNumber()).isPureNumeric() && (num = new ParsedNumber(token = mainAddrTokens.getFirstToken())) != null && num.isPureNumeric()) {
            pa.setUnitValue(pa.getAddressNumber());
            pa.setAddressNumber(token);
            pa.setUnitType("#");
            mainAddrTokens.removeFirst();
            this.m_assignedHNToUnit = true;
        }
        if (mainAddrTokens.size() == 1 && postType != null && postType.foundAtEnd() && "THE".equals(mainAddrTokens.getFirstToken())) {
            StringBuffer sb = new StringBuffer(mainAddrTokens.getFirstToken());
            sb.append(' ');
            sb.append(postType.getTypeName());
            pa.setPostThoroughfareType("");
            postType = null;
            mainAddrTokens = new StringWithTokens(sb.toString());
        }
        if (mainAddrTokens.size() != 0) {
            pa.setMainAddress(this.createMainAddressString(mainAddrTokens));
        } else {
            this.checkParsing((Address)pa, abbreviatedPreDir, abbreviatedPostDir, preType, postType, ura);
        }
        if (StringUtilities.isEmpty((String)pa.getMainAddress()) && pa.getAdditionalFieldForKey(AddressImpl.KEY_POBOX) != null && pa.getPostThoroughfareType() == null && pa.getPreThoroughfareType() == null) {
            pa.setAddressNumber(pa.getAdditionalFieldForKey(AddressImpl.KEY_POBOX_NUMBER).trim());
            pa.setMainAddress("PO BOX");
            return;
        }
        if (pa.getMainAddress() != null && StringUtilities.isNumeric((String)pa.getMainAddress())) {
            pa.setNumberedRoad(true);
        }
        this.handleNumericStreetNamesWithSpaces((Address)pa);
        this.handleNumericWithOrdinal(pa.getMainAddress(), pa);
        if (pa.hasFrenchOrdinal() && pa.getPostThoroughfareType() == null && (type = pa.getPreThoroughfareType()) != null) {
            pa.setPostThoroughfareType(type);
            pa.setPreThoroughfareType(null);
        }
    }

    protected void checkForStreetServedByRouteService(CAN_ParsedAddress pa, StringWithTokens mainAddrTokens) {
        if (mainAddrTokens.size() >= 4) {
            String thirdLast;
            String last = mainAddrTokens.getLastToken();
            String secondLast = mainAddrTokens.getToken(mainAddrTokens.size() - 2);
            if ("RR".equals(secondLast) || "SS".equals(secondLast)) {
                if (last.length() > 1 && last.charAt(0) == '#') {
                    last = last.substring(1);
                }
                if (StringUtilities.isNumeric((String)last)) {
                    pa.setAdditionalRouteServiceNumber(last);
                    pa.setAdditionalRouteServiceType(secondLast);
                    mainAddrTokens.removeLast();
                    mainAddrTokens.removeLast();
                    return;
                }
            } else if ("#".equals(secondLast) && StringUtilities.isNumeric((String)last) && ("RR".equals(thirdLast = mainAddrTokens.getToken(mainAddrTokens.size() - 3)) || "SS".equals(thirdLast))) {
                pa.setAdditionalRouteServiceNumber(last);
                pa.setAdditionalRouteServiceType(thirdLast);
                mainAddrTokens.removeLast();
                mainAddrTokens.removeLast();
                mainAddrTokens.removeLast();
                return;
            }
        }
        if (mainAddrTokens.size() >= 3 && "GD".equals(mainAddrTokens.getLastToken())) {
            pa.setAdditionalRouteServiceType("GD");
            mainAddrTokens.removeLast();
            return;
        }
    }

    protected StringWithTokens separateOutPOBOX(StringWithTokens tokens, CAN_ParsedAddress pa) {
        String mainAddtoksString = tokens.toString();
        if (!StringUtilities.isEmpty((String)mainAddtoksString)) {
            boolean foundFrenchPOBox;
            Matcher matcher = POB_PATTERN.matcher(mainAddtoksString);
            int len = mainAddtoksString.length();
            boolean possibleSTN = mainAddtoksString.toUpperCase().contains(" STN ") || mainAddtoksString.toUpperCase().contains(" RPO ") || mainAddtoksString.toUpperCase().contains(" STATION ") || mainAddtoksString.toUpperCase().contains(" SUCC ");
            boolean foundEnglishPOBox = matcher.find();
            if (!foundEnglishPOBox) {
                matcher = FRENCH_POB_PATTERN.matcher(mainAddtoksString);
            }
            boolean bl = foundFrenchPOBox = !foundEnglishPOBox && matcher.find();
            if (foundEnglishPOBox || foundFrenchPOBox) {
                int startPos = matcher.start();
                int endPos = matcher.end();
                if (!(startPos == 0 && endPos == len || possibleSTN)) {
                    String substr = mainAddtoksString.substring(startPos, endPos);
                    String street = mainAddtoksString.replace(substr, "");
                    StringWithTokens toks = new StringWithTokens(street.toUpperCase());
                    substr = this.checkForConnectedBoxNumber(substr);
                    String[] splits = substr.split(" ");
                    pa.getAdditionalFields().put(AddressImpl.KEY_POBOX, "PO BOX");
                    pa.getAdditionalFields().put(AddressImpl.KEY_POBOX_NUMBER, splits[splits.length - 1]);
                    if (foundFrenchPOBox) {
                        pa.getAdditionalFields().put("FRENCH_PO_BOX", "true");
                    } else {
                        pa.getAdditionalFields().put("ENGLISH_PO_BOX", "true");
                    }
                    return toks;
                }
                if (startPos != 0 || endPos != len) {
                    StringBuilder stnInfo = new StringBuilder();
                    String substr = mainAddtoksString.substring(startPos, endPos);
                    String street = mainAddtoksString.replace(substr, "");
                    StringWithTokens newTokens = new StringWithTokens(street);
                    StringWithTokens swt = new StringWithTokens(this.checkForConnectedBoxNumber(substr));
                    substr = swt.toString();
                    String[] splits = substr.split(" ");
                    pa.getAdditionalFields().put(AddressImpl.KEY_POBOX, "PO BOX");
                    pa.getAdditionalFields().put(AddressImpl.KEY_POBOX_NUMBER, splits[splits.length - 1]);
                    boolean lastTokenIsType = CAN_NewThoroughfareTypes.isStreetType(newTokens.getLastToken());
                    boolean lastTokenIsDir = CAN_Directionals.isDirectional(newTokens.getLastToken());
                    CAN_ThoroughfareType preType = m_tfareTypes.findStreetType(new StringWithTokens(substr), true);
                    if (preType != null && preType.getPreferredTypeName().equals("PXE")) {
                        pa.setEnglishPOBox(true);
                    } else {
                        pa.setFrenchPOBox(true);
                    }
                    StringWithTokens.TokenIterator itr = newTokens.iterator();
                    while (itr.hasNext()) {
                        String tok = itr.next().toUpperCase();
                        if (tok.equals("STATION")) {
                            tok = "STN";
                        }
                        if (!tok.equals("STN") && !tok.equals("RPO") && !tok.equals("SUCC")) continue;
                        stnInfo.append(tok);
                        stnInfo.append(' ');
                        if (!itr.hasNext()) continue;
                        itr.remove();
                        while (itr.hasNext()) {
                            stnInfo.append(itr.next().toUpperCase());
                            stnInfo.append(' ');
                            itr.remove();
                            if (!lastTokenIsType && !lastTokenIsDir) continue;
                        }
                        pa.setStationInformation(stnInfo.toString().trim());
                        if (newTokens.isEmpty()) {
                            return new StringWithTokens(substr);
                        }
                        return newTokens;
                    }
                    return new StringWithTokens(street.toUpperCase());
                }
                if (tokens.size() == 1 || !Character.isDigit(tokens.getLastToken().charAt(0))) {
                    return new StringWithTokens(this.checkForConnectedBoxNumber(mainAddtoksString).toUpperCase());
                }
            }
        }
        return tokens;
    }

    protected String checkForConnectedBoxNumber(String input) {
        StringBuilder stringBuilder = new StringBuilder(input);
        int idx = input.lastIndexOf(32);
        if (idx < 0) {
            idx = 0;
        }
        boolean previousSpace = true;
        for (int i = idx + 1; i < input.length(); ++i) {
            if (Character.isDigit(stringBuilder.charAt(i))) {
                if (previousSpace) break;
                stringBuilder.insert(i, ' ');
                break;
            }
            previousSpace = Character.isSpaceChar(stringBuilder.charAt(i));
        }
        return stringBuilder.toString();
    }

    private boolean getHouseNumberFromEnd(Address pa, StringWithTokens list, IConstraints constraints) {
        if (list == null || list.size() < 2) {
            return false;
        }
        String lastToken = list.getLastToken();
        if (StringUtilities.isNumeric((String)lastToken)) {
            String secondPreviousToken = null;
            String previousToken = list.getToken(list.size() - 2);
            if (CAN_NewThoroughfareTypes.isStreetType(previousToken)) {
                String str;
                CAN_NewThoroughfareTypes.KeyInfo key = CAN_NewThoroughfareTypes.lookupByTypeName(previousToken);
                CAN_NewThoroughfareTypes.KeyInfo key2 = null;
                if (list.size() > 2 && key.getProperTypeName().equals("RD") && (key2 = CAN_NewThoroughfareTypes.lookupByTypeName(str = (secondPreviousToken = list.getToken(list.size() - 3)) + " " + previousToken)) != null) {
                    key = key2;
                }
                if (!key.canEnd()) {
                    return false;
                }
                if (key.canStart() && key.getSpecialCase() != -1) {
                    return false;
                }
            } else if (CAN_UnitTypes.getUnitType(previousToken) != null) {
                return false;
            }
        } else {
            return false;
        }
        list.removeLast();
        pa.setAddressNumber(lastToken);
        return true;
    }

    private void adjustForDashedFL(StringWithTokens toklist) {
        int dashpos = -1;
        dashpos = toklist.toString().indexOf(45);
        if (dashpos > 0) {
            StringWithTokens.TokenIterator iter = toklist.iterator();
            int mainListpos = 0;
            while (iter.hasNext()) {
                StringWithTokens testToks;
                CAN_UnitType unitType;
                String tok = iter.next();
                int pos = tok.indexOf(45);
                if (pos > 0 && (unitType = CAN_UnitTypes.getUnitType((testToks = new StringWithTokens(tok, "-")).getFirstToken())) != null && unitType.getAbbreviation().equals("FL") && mainListpos > 0 && EnglishVerbalNumber.convertString((String)toklist.getToken(mainListpos - 1)) > 0) {
                    String str = toklist.getToken(mainListpos - 1);
                    toklist.insert(mainListpos, testToks.getLastToken());
                    toklist.remove(mainListpos + 1);
                    toklist.remove(mainListpos - 1);
                    toklist.insert(toklist.size(), str);
                    toklist.insert(toklist.size(), "FL");
                    break;
                }
                ++mainListpos;
            }
        }
    }

    private boolean getHouseNumber(Address pa, StringWithTokens list, IConstraints constraints) {
        StringBuffer houseNum = new StringBuffer();
        if (list == null || list.size() == 0) {
            return false;
        }
        boolean bFoundAtStart = true;
        boolean bAbbreviatedHouseNumber = false;
        String s = this.stripHouseNumberFromStart(list, constraints);
        if (s != null) {
            if (StringUtilities.isFractionalNumber((String)s)) {
                // empty if block
            }
            houseNum.append(s);
            if (!s.equals(list.getFirstToken())) {
                bAbbreviatedHouseNumber = true;
            }
            list.removeFirst();
        } else {
            bFoundAtStart = false;
        }
        if (!bFoundAtStart) {
            this.adjustForDashedFL(list);
        }
        if (list.size() != 0) {
            String s1;
            String token = list.getFirstToken();
            if ("1/2".equals(token) || "1/4".equals(token) || "3/4".equals(token)) {
                houseNum.append(" ");
                houseNum.append(token);
                list.removeFirst();
            } else if (bAbbreviatedHouseNumber && (s1 = this.stripHouseNumberFromStart(list, constraints)) != null && !s1.equals(token) && StringUtilities.isNumeric((String)s1)) {
                int firstNum = 0;
                int secondNum = 0;
                try {
                    firstNum = Integer.parseInt(houseNum.toString());
                    secondNum = Integer.parseInt(s1);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (firstNum >= 10 && firstNum % 10 == 0 && secondNum <= 9) {
                    houseNum = new StringBuffer(String.valueOf(firstNum + secondNum));
                    list.removeFirst();
                }
            }
        }
        if (bFoundAtStart) {
            pa.setAddressNumber(houseNum.toString());
            ParsedNumber test = pa.getParsedAddressNumber();
            if (test.getCombinedAddressNumber().startsWith("#")) {
                test = new ParsedNumber(test.getCombinedAddressNumber().substring(1));
            }
            if (!test.isPureNumeric() && test.hasSeparator() && ("-".equals(test.getNumberSeparator()) || "-".equals(test.getPrefixSeparator()) || "-".equals(test.getSuffixSeparator()))) {
                long unit;
                String alphaUnitVal = null;
                if ("-".equals(test.getPrefixSeparator()) && (alphaUnitVal = test.getAddressPrefix()).equalsIgnoreCase("house")) {
                    alphaUnitVal = null;
                }
                if ((unit = test.getAddressNumber()) != 0L || alphaUnitVal != null) {
                    String addrSuffix;
                    String abbr;
                    long house;
                    boolean moreUnitWork = true;
                    boolean moreHouseWork = true;
                    if ("-".equals(test.getNumberSeparator()) && test.getNumFields() == 3 && test.getSuffixNumberExists()) {
                        house = test.getSuffixNumber();
                        pa.setAddressNumber(String.valueOf(house));
                        pa.setUnitValue(String.valueOf(unit));
                        pa.setUnitType("#");
                        moreUnitWork = false;
                        moreHouseWork = false;
                        this.m_assignedHNToUnit = true;
                    } else if ("-".equals(test.getPrefixSeparator()) && test.getNumFields() == 3 && test.getAddressPrefix() != null) {
                        house = test.getAddressNumber();
                        pa.setAddressNumber(String.valueOf(house));
                        if (alphaUnitVal != null) {
                            CAN_UnitType unitType = CAN_UnitTypes.getUnitType(alphaUnitVal);
                            if (unitType != null) {
                                pa.setUnitType(unitType.getAbbreviation());
                            } else {
                                pa.setUnitType("#");
                                pa.setUnitValue(test.getAddressPrefix());
                            }
                        }
                        moreUnitWork = false;
                        moreHouseWork = false;
                        this.m_assignedHNToUnit = true;
                    }
                    if ("-".equals(test.getNumberSeparator()) && test.getNumFields() == 3 && test.isFractionalTrailer()) {
                        moreUnitWork = false;
                        moreHouseWork = false;
                        this.m_assignedHNToUnit = false;
                    }
                    if (moreUnitWork && ((abbr = CAN_Abbreviations.getAbbrFromValue(addrSuffix = test.getAddressSuffix())) == null || Character.isDigit(addrSuffix.charAt(0)))) {
                        StringBuffer str = new StringBuffer();
                        if (test.getAddressPrefix().length() > 0) {
                            str.append(test.getAddressPrefix());
                            test.setAddressPrefix(null);
                        }
                        str.append(String.valueOf(unit));
                        if (test.getAddressSuffix().length() > 0) {
                            str.append(test.getAddressSuffix());
                            test.setAddressSuffix(null);
                        }
                        pa.setUnitValue(str.toString());
                        pa.setUnitType("#");
                        moreUnitWork = false;
                        this.m_assignedHNToUnit = true;
                    }
                    if (moreHouseWork && test.getSuffixNumberExists()) {
                        String house2;
                        test.setAddressNumber(0L);
                        if ("-".equals(test.getNumberSeparator())) {
                            test.setNumberSeparator(null);
                        }
                        if ("-".equals(test.getSuffixSeparator())) {
                            test.setSuffixSeparator(null);
                        }
                        if ((house2 = test.getCombinedAddressNumber()) != null) {
                            if (house2.length() > 1 && house2.charAt(0) == '0') {
                                house2 = house2.substring(1);
                            }
                            pa.setAddressNumber(house2);
                            moreHouseWork = false;
                        }
                    }
                }
            }
        }
        return bFoundAtStart;
    }

    private void checkParsing(Address pa, boolean abbreviatedPreDir, boolean abbreviatedPostDir, CAN_ThoroughfareType preType, CAN_ThoroughfareType postType, Address inputAddress) {
        boolean bHavePreDir = false;
        boolean bHavePreType = false;
        boolean bHavePostType = false;
        boolean bHavePostDir = false;
        boolean bHaveUnitType = false;
        boolean bHaveUnitValue = false;
        boolean bHaveHouseNumber = false;
        CAN_ParsedAddress CAN_pa = (CAN_ParsedAddress)pa;
        if (CAN_pa.getMainAddress() != null && CAN_pa.getMainAddress().length() != 0) {
            return;
        }
        if (CAN_pa.getPreThoroughfareType() != null && CAN_pa.getPreThoroughfareType().length() != 0) {
            bHavePreType = true;
        }
        if (CAN_pa.getPostThoroughfareType() != null && CAN_pa.getPostThoroughfareType().length() != 0) {
            bHavePostType = true;
        }
        if (CAN_pa.getPostDirectional() != null && CAN_pa.getPostDirectional().length() != 0) {
            bHavePostDir = true;
        }
        if (CAN_pa.getPreDirectional() != null && CAN_pa.getPreDirectional().length() != 0) {
            bHavePreDir = true;
        }
        if (CAN_pa.getUnitType() != null && CAN_pa.getUnitType().length() != 0) {
            bHaveUnitType = true;
        }
        if (CAN_pa.getUnitValue() != null && CAN_pa.getUnitValue().length() != 0) {
            bHaveUnitValue = true;
        }
        if (CAN_pa.getAddressNumber() != null && CAN_pa.getAddressNumber().length() != 0) {
            bHaveHouseNumber = true;
        }
        if (!(bHavePreType || bHavePostType || bHavePreDir || bHavePostDir || !bHaveUnitType)) {
            if (CAN_pa.getUnitValue() != null && CAN_pa.getUnitValue().length() != 0) {
                bHaveUnitValue = true;
            }
            if (bHaveUnitType && !bHaveUnitValue) {
                CAN_pa.setMainAddress(this.getBestUnitTypeString(CAN_pa));
            } else {
                StringBuffer str = new StringBuffer();
                str.append(this.getBestUnitTypeString(CAN_pa));
                str.append(" ");
                str.append(CAN_pa.getUnitValue());
                CAN_pa.setMainAddress(str.toString());
                CAN_pa.setUnitValue("");
            }
            if (bHavePreDir) {
                CAN_pa.setPreDirectional(CAN_pa.getPostDirectional());
                CAN_pa.setPostDirectional("");
            }
            CAN_pa.setUnitType("");
        } else if (!bHavePreType && !bHavePostType && bHaveUnitType && bHaveUnitValue && !StringUtilities.hasNumeric((String)CAN_pa.getUnitValue()) && CAN_pa.getUnitValue().length() > 4) {
            StringBuffer str = new StringBuffer();
            if (bHavePostDir && !bHavePreDir) {
                String originalMainAddress = inputAddress.getMainAddress();
                StringBuffer tempPostDirString = new StringBuffer(" ");
                tempPostDirString.append(abbreviatedPostDir ? CAN_Directionals.getFullName(CAN_pa.getPostDirectional()) : CAN_pa.getPostDirectional());
                if (originalMainAddress != null && !originalMainAddress.toUpperCase().endsWith(tempPostDirString.toString())) {
                    CAN_pa.setPreDirectional(CAN_pa.getPostDirectional());
                    CAN_pa.setPostDirectional("");
                }
            } else if (bHavePostDir && bHavePreDir) {
                if (abbreviatedPostDir) {
                    str.append(CAN_Directionals.getFullName(CAN_pa.getPostDirectional()));
                } else {
                    str.append(CAN_pa.getPostDirectional());
                }
                str.append(" ");
                CAN_pa.setPostDirectional("");
            }
            str.append(this.getBestUnitTypeString(CAN_pa));
            str.append(" ");
            str.append(CAN_pa.getUnitValue());
            CAN_pa.setUnitValue(null);
            CAN_pa.setMainAddress(str.toString());
            CAN_pa.setUnitType(null);
        } else if (bHavePreType && bHavePostType) {
            CAN_pa.setMainAddress(preType.getTypeName());
            CAN_pa.setPreThoroughfareType("");
        } else if (bHavePostType && bHavePostDir && !bHavePreType && !bHavePreDir) {
            if (abbreviatedPostDir) {
                CAN_pa.setMainAddress(CAN_Directionals.getFullName(CAN_pa.getPostDirectional()));
                CAN_pa.setPreThoroughfareType(CAN_pa.getPostThoroughfareType());
                CAN_pa.setPostThoroughfareType("");
                CAN_pa.setPostDirectional("");
            } else if (CAN_pa.isQC()) {
                CAN_pa.setMainAddress(CAN_pa.getPostDirectional());
                CAN_pa.setPreThoroughfareType(CAN_pa.getPostThoroughfareType());
                CAN_pa.setPostThoroughfareType("");
                CAN_pa.setPostDirectional("");
            } else if ((bHaveHouseNumber && postType.getTypeName().equals("ST") || postType.getTypeName().equals("AVE") && CAN_pa.getParsedAddressNumber() != null && CAN_pa.getParsedAddressNumber().isPureNumeric()) && (this.m_assignedHNToUnit || StringUtilities.isEmpty((String)CAN_pa.getUnitType()) && StringUtilities.isEmpty((String)CAN_pa.getUnitValue()))) {
                CAN_pa.setMainAddress(CAN_pa.getAddressNumber());
                if (this.m_assignedHNToUnit) {
                    CAN_pa.setAddressNumber(CAN_pa.getUnitValue());
                    CAN_pa.setUnitValue(null);
                    CAN_pa.setUnitType(null);
                    this.m_assignedHNToUnit = false;
                } else {
                    CAN_pa.setAddressNumber("");
                }
            } else {
                CAN_pa.setMainAddress(postType.getExpandedTypeName());
                CAN_pa.setPostThoroughfareType("");
            }
        } else if (bHavePostType && bHavePreDir && !bHavePreType && !bHavePostDir) {
            if (abbreviatedPreDir) {
                CAN_pa.setMainAddress(CAN_Directionals.getFullName(CAN_pa.getPreDirectional()));
            } else {
                CAN_pa.setMainAddress(CAN_pa.getPreDirectional());
            }
            CAN_pa.setPreDirectional("");
        } else if (bHavePreType && bHavePostDir && !bHavePreDir && !bHavePostType) {
            CAN_pa.setMainAddress(preType.getTypeName());
            CAN_pa.setPreThoroughfareType("");
        } else if (bHavePreType && !bHavePostType && !bHavePreDir && !bHavePostDir && bHaveUnitType && bHaveUnitValue) {
            StringBuffer str = new StringBuffer(this.getBestUnitTypeString(CAN_pa));
            str.append(" ");
            str.append(CAN_pa.getUnitValue());
            CAN_pa.setUnitValue(null);
            CAN_pa.setUnitType(null);
            CAN_pa.setMainAddress(str.toString());
        } else if (bHavePreType && !bHavePostType && !bHavePreDir && !bHavePostDir) {
            CAN_pa.setMainAddress(preType.getTypeName());
            CAN_pa.setPreThoroughfareType("");
        } else if (bHaveHouseNumber && bHavePostType && !bHavePreDir && !bHavePreType && !bHavePostDir && bHaveUnitType && bHaveUnitValue) {
            CAN_pa.setMainAddress(postType.getTypeName());
            CAN_pa.setPostThoroughfareType("");
        } else if (bHaveHouseNumber && bHavePostType && !bHavePreType && !bHavePreDir && this.isNumericType(CAN_pa.getPostThoroughfareType())) {
            CAN_pa.setMainAddress(CAN_pa.getAddressNumber());
            if (this.m_assignedHNToUnit) {
                CAN_pa.setAddressNumber(CAN_pa.getUnitValue());
                CAN_pa.setUnitValue(null);
                CAN_pa.setUnitType(null);
                this.m_assignedHNToUnit = false;
            } else {
                CAN_pa.setAddressNumber("");
            }
        } else if (bHavePostDir && !bHavePostType && !bHavePreDir && !bHavePreType) {
            if (abbreviatedPostDir) {
                CAN_pa.setMainAddress(CAN_Directionals.getFullName(CAN_pa.getPostDirectional()));
            } else {
                CAN_pa.setMainAddress(CAN_pa.getPostDirectional());
            }
            CAN_pa.setPostDirectional("");
        } else if (!bHavePostDir && !bHavePostType && bHavePreDir && bHavePreType) {
            CAN_pa.setMainAddress(preType.getTypeName());
            CAN_pa.setPreThoroughfareType("");
        } else if (bHavePostDir && !bHavePostType && bHavePreDir && !bHavePreType) {
            if (!abbreviatedPostDir && abbreviatedPreDir) {
                CAN_pa.setMainAddress(CAN_pa.getPostDirectional());
                CAN_pa.setPostDirectional("");
            } else if (abbreviatedPostDir && !abbreviatedPreDir) {
                CAN_pa.setMainAddress(CAN_pa.getPreDirectional());
                CAN_pa.setPreDirectional("");
            } else if (abbreviatedPostDir && abbreviatedPreDir) {
                CAN_pa.setMainAddress(CAN_Directionals.getFullName(CAN_pa.getPostDirectional()));
                CAN_pa.setPostDirectional("");
            } else {
                CAN_pa.setMainAddress(CAN_pa.getPostDirectional());
                CAN_pa.setPostDirectional("");
            }
        } else if (!(!bHaveHouseNumber || bHavePreDir || bHavePreType || bHavePostDir || bHavePostType || bHaveUnitType || bHaveUnitValue)) {
            ParsedNumber number = CAN_pa.getParsedAddressNumber();
            if (number.getNumFields() == 1) {
                CAN_pa.setMainAddress(CAN_pa.getAddressNumber());
                if (this.m_assignedHNToUnit) {
                    CAN_pa.setAddressNumber(CAN_pa.getUnitValue());
                    CAN_pa.setUnitValue(null);
                    CAN_pa.setUnitType(null);
                    this.m_assignedHNToUnit = false;
                } else {
                    CAN_pa.setAddressNumber("");
                }
            }
        } else if (bHavePreDir && bHavePostType && bHavePostDir && !bHavePreType) {
            if (abbreviatedPreDir) {
                CAN_pa.setMainAddress(CAN_Directionals.getFullName(CAN_pa.getPreDirectional()));
            } else {
                CAN_pa.setMainAddress(CAN_pa.getPreDirectional());
            }
            CAN_pa.setPreDirectional("");
        } else if (!bHavePreType && bHavePostType && !bHavePreDir && !bHavePostDir) {
            boolean bHandled = false;
            if (bHaveHouseNumber) {
                this.handleNumericWithOrdinal(CAN_pa.getAddressNumber(), CAN_pa);
                if (CAN_pa.hasEnglishOrdinal() || CAN_pa.hasFrenchOrdinal()) {
                    if (this.m_assignedHNToUnit) {
                        CAN_pa.setAddressNumber(CAN_pa.getUnitValue());
                        CAN_pa.setUnitValue(null);
                        CAN_pa.setUnitType(null);
                        this.m_assignedHNToUnit = false;
                    } else {
                        CAN_pa.setAddressNumber("");
                    }
                    bHandled = true;
                }
            }
            if (!bHandled) {
                CAN_pa.setMainAddress(postType.getTypeName());
                CAN_pa.setPostThoroughfareType("");
            }
        }
    }

    private String getBestUnitTypeString(CAN_ParsedAddress pa) {
        if (this.m_unitType != null) {
            return this.m_unitType.getUnitTypeString();
        }
        return pa.getUnitType();
    }

    private String createMainAddressString(StringWithTokens listOfTokens) {
        CAN_Abbreviations.convertToNumeric(listOfTokens);
        StringBuffer buf = new StringBuffer();
        int sz = listOfTokens.size();
        for (int i = 0; i < sz; ++i) {
            if (i != 0) {
                buf.append(" ");
            }
            String token = listOfTokens.removeFirst();
            int len = token.length();
            if ("MT".equals(token) || "MT.".equals(token)) {
                buf.append("MOUNT");
                continue;
            }
            if ("SAINTE".equals(token)) {
                buf.append("STE");
                continue;
            }
            if ("SAINT".equals(token)) {
                buf.append("ST");
                continue;
            }
            if ("ST".equals(token) || "ST.".equals(token)) {
                buf.append("ST");
                continue;
            }
            if (len >= 7 && token.startsWith("SAINTE-")) {
                buf.append("STE-");
                if (len <= 7) continue;
                buf.append(token.substring(7));
                continue;
            }
            if (len >= 6 && token.startsWith("SAINT-")) {
                buf.append("ST-");
                if (len <= 6) continue;
                buf.append(token.substring(6));
                continue;
            }
            if (len > 8) {
                int idx = token.indexOf("-SAINTE-");
                if (idx >= 0) {
                    if (idx != 0) {
                        buf.append(token.substring(0, idx));
                    }
                    buf.append("-STE-");
                    if (idx + 8 >= len) continue;
                    buf.append(token.substring(idx + 8));
                    continue;
                }
                idx = token.indexOf("-SAINT-");
                if (idx >= 0) {
                    if (idx != 0) {
                        buf.append(token.substring(0, idx));
                    }
                    buf.append("-ST-");
                    if (idx + 7 >= len) continue;
                    buf.append(token.substring(idx + 7));
                    continue;
                }
            }
            buf.append(token);
        }
        return buf.toString();
    }

    private boolean isNumericType(String type) {
        return m_numericStreetCompanionTypeSet.contains(type);
    }

    private void handleNumericWithOrdinal(String str, CAN_ParsedAddress addr) {
        if (addr.hasEnglishOrdinal() || addr.hasFrenchOrdinal()) {
            return;
        }
        if (str != null) {
            int len = str.length();
            if (len == 1) {
                return;
            }
            int dashIndex = -1;
            char c = str.charAt(len - 1);
            if (c == 'R') {
                if (len > 2 && str.charAt(len - 2) == 'E') {
                    for (int i = 0; i < len - 2; ++i) {
                        if (Character.isDigit(str.charAt(i))) continue;
                        if (str.charAt(i) == '-' && dashIndex == -1) {
                            dashIndex = i;
                            continue;
                        }
                        return;
                    }
                    StringBuffer sb = new StringBuffer(str);
                    if (dashIndex > 0 && addr.getParsedAddressNumber() == null) {
                        addr.setAddressNumber(sb.substring(0, dashIndex));
                        int sblen = sb.length();
                        addr.setMainAddress(sb.substring(dashIndex + 1, sblen - 1));
                    }
                    if (sb.length() != 3 && sb.charAt(0) != '1') {
                        sb.setLength(sb.length() - 2);
                        sb.append('E');
                    }
                    addr.setMainAddress(sb.toString());
                    addr.setNumericStreetName(true);
                    addr.setHasFrenchOrdinal(true);
                    return;
                }
                return;
            }
            if (c == 'E') {
                char c2 = '\u0000';
                char c3 = '\u0000';
                char c4 = '\u0000';
                if (len > 4) {
                    c4 = str.charAt(len - 4);
                }
                if (len > 3) {
                    c3 = str.charAt(len - 3);
                }
                if (len > 2) {
                    c2 = str.charAt(len - 2);
                }
                if (!(c4 == '\u0000' || c4 != 'I' || c3 != 'E' && c3 != '\u00c8' || c2 != 'R' && c2 != 'M')) {
                    for (int i = 0; i < len - 4; ++i) {
                        if (Character.isDigit(str.charAt(i))) continue;
                        if (str.charAt(i) == '-' && dashIndex == -1) {
                            dashIndex = i;
                            continue;
                        }
                        return;
                    }
                    StringBuffer sb = new StringBuffer(str);
                    if (dashIndex > 0 && addr.getParsedAddressNumber() == null && len > 4) {
                        addr.setAddressNumber(sb.substring(0, dashIndex));
                        sb.delete(0, dashIndex);
                        len = sb.length();
                    }
                    if (dashIndex == 0 && len > 4) {
                        sb.deleteCharAt(0);
                        len = sb.length();
                    }
                    sb.setLength(len - 4);
                    if (sb.length() == 1 && sb.charAt(0) == '1') {
                        sb.append("I\u00c8RE");
                    } else {
                        sb.append('E');
                    }
                    addr.setMainAddress(sb.toString());
                    addr.setNumericStreetName(true);
                    addr.setHasFrenchOrdinal(true);
                    return;
                }
                if (c3 != '\u0000' && (c3 == '\u00c8' || c3 == 'E') && c2 == 'R') {
                    for (int i = 0; i < len - 3; ++i) {
                        if (Character.isDigit(str.charAt(i))) continue;
                        if (str.charAt(i) == '-' && dashIndex == -1) {
                            dashIndex = i;
                            if (str.charAt(i + 1) != ' ') continue;
                            ++i;
                            continue;
                        }
                        return;
                    }
                    StringBuffer sb = new StringBuffer(str);
                    if (dashIndex > 0 && addr.getAddressNumber() == null && len > 3) {
                        addr.setAddressNumber(sb.substring(0, dashIndex));
                        sb.delete(0, dashIndex + 1);
                        len = sb.length();
                    }
                    if (dashIndex == 0 && len > 3) {
                        sb.deleteCharAt(0);
                        --len;
                        if (sb.charAt(0) == ' ') {
                            sb.deleteCharAt(0);
                            --len;
                        }
                    }
                    sb.setLength(len - 3);
                    if (sb.length() == 1 && sb.charAt(0) == '1') {
                        sb.append("I\u00c8RE");
                    } else {
                        sb.append('E');
                    }
                    addr.setMainAddress(sb.toString());
                    addr.setNumericStreetName(true);
                    addr.setHasFrenchOrdinal(true);
                    return;
                }
                if (c2 != '\u0000' && c2 == 'R') {
                    for (int i = 0; i < len - 2; ++i) {
                        if (Character.isDigit(str.charAt(i))) continue;
                        if (str.charAt(i) == '-' && dashIndex == -1) {
                            dashIndex = i;
                            if (str.charAt(i + 1) != ' ') continue;
                            ++i;
                            continue;
                        }
                        return;
                    }
                    StringBuffer sb = new StringBuffer(str);
                    if (dashIndex > 0 && addr.getAddressNumber() == null && len > 3) {
                        addr.setAddressNumber(sb.substring(0, dashIndex));
                        sb.delete(0, dashIndex + 1);
                        len = sb.length();
                    }
                    if (dashIndex == 0 && len > 3) {
                        sb.deleteCharAt(0);
                        --len;
                        if (sb.charAt(0) == ' ') {
                            sb.deleteCharAt(0);
                            --len;
                        }
                    }
                    sb.setLength(len - 2);
                    if (sb.length() == 1 && sb.charAt(0) == '1') {
                        sb.append("I\u00c8RE");
                    } else {
                        sb.append('E');
                    }
                    addr.setMainAddress(sb.toString());
                    addr.setNumericStreetName(true);
                    addr.setHasFrenchOrdinal(true);
                    return;
                }
                for (int i = 0; i < len - 1; ++i) {
                    if (Character.isDigit(str.charAt(i))) continue;
                    if (str.charAt(i) == '-' && dashIndex == -1) {
                        dashIndex = i;
                        if (str.charAt(i + 1) != ' ') continue;
                        ++i;
                        continue;
                    }
                    if (str.charAt(i) == ' ') continue;
                    return;
                }
                StringBuffer sb = new StringBuffer(str);
                if (dashIndex > 0 && addr.getAddressNumber() == null && len > 2) {
                    addr.setAddressNumber(sb.substring(0, dashIndex));
                    sb.delete(0, dashIndex + 1);
                    len = sb.length();
                }
                if (dashIndex == 0 && len > 2) {
                    sb.deleteCharAt(0);
                    --len;
                    if (sb.charAt(0) == ' ') {
                        sb.deleteCharAt(0);
                        --len;
                    }
                } else if (dashIndex == -1) {
                    sb.deleteCharAt(len - 1);
                }
                if (sb.length() == 1 && sb.charAt(0) == '1') {
                    sb.append("I\u00c8RE");
                } else {
                    sb.append('E');
                }
                addr.setMainAddress(sb.toString());
                addr.setNumericStreetName(true);
                addr.setHasFrenchOrdinal(true);
                return;
            }
            if (len > 2) {
                for (int i = 0; i < len - 2; ++i) {
                    if (Character.isDigit(str.charAt(i))) continue;
                    return;
                }
                char c1 = str.charAt(len - 2);
                char c2 = str.charAt(len - 1);
                if (c1 == 'S' && c2 == 'T') {
                    addr.setNumericStreetName(true);
                    addr.setHasEnglishOrdinal(true);
                } else if (c1 == 'N' && c2 == 'D') {
                    addr.setNumericStreetName(true);
                    addr.setHasEnglishOrdinal(true);
                } else if (c1 == 'R' && c2 == 'D') {
                    addr.setNumericStreetName(true);
                    addr.setHasEnglishOrdinal(true);
                } else if (c1 == 'T' && c2 == 'H') {
                    addr.setNumericStreetName(true);
                    addr.setHasEnglishOrdinal(true);
                }
            }
        }
    }

    private StringWithTokens findSpecialAddressFormats(CAN_ParsedAddress pa, StringWithTokens mainAddrTokens, String upMainAddress) {
        Object subTokens = null;
        CAN_ThoroughfareType preType = null;
        preType = m_tfareTypes.findStreetType(mainAddrTokens, true);
        if (preType != null && preType.isSpecialCase()) {
            if (preType.getSpecialCase() == 1 || preType.getSpecialCase() == 7 || preType.getSpecialCase() == 8 || preType.getSpecialCase() == 2 || preType.getSpecialCase() == 6) {
                if (preType.getSpecialCase() == 1 && mainAddrTokens.size() > preType.getNumTokens()) {
                    CAN_NewThoroughfareTypes.KeyInfo key = CAN_NewThoroughfareTypes.lookupByTypeName(mainAddrTokens.getToken(preType.getNumTokens()));
                    if (key != null) {
                        return mainAddrTokens;
                    }
                    if (mainAddrTokens.size() > preType.getNumTokens() + 1) {
                        int sz = mainAddrTokens.size();
                        for (int i = preType.getNumTokens() + 1; i < sz; ++i) {
                            key = CAN_NewThoroughfareTypes.lookupByTypeName(mainAddrTokens.getToken(i));
                            if (key == null || key.getSpecialCase() == 3) continue;
                            return mainAddrTokens;
                        }
                    }
                }
                for (int idx = 0; idx < preType.getNumTokens(); ++idx) {
                    mainAddrTokens.removeFirst();
                }
                this.handleRR_SS_CR(pa, mainAddrTokens, preType);
                return mainAddrTokens;
            }
            if (preType.getSpecialCase() == 4) {
                for (int index = 0; index < preType.getNumTokens(); ++index) {
                    mainAddrTokens.removeFirst();
                }
                this.handleGD(pa, mainAddrTokens, preType);
                return mainAddrTokens;
            }
            if (preType.getSpecialCase() == 3) {
                for (int cnt = 0; cnt < preType.getNumTokens(); ++cnt) {
                    mainAddrTokens.removeFirst();
                }
                this.handlePOBox(pa, mainAddrTokens, preType);
                pa.getAdditionalFields().put(AddressImpl.POB_IN_MAIN_ADDRESS_FIELD, "true");
                return mainAddrTokens;
            }
        }
        this.findConnectedRRTypeNumber(pa, mainAddrTokens, upMainAddress);
        return mainAddrTokens;
    }

    private void findConnectedRRTypeNumber(CAN_ParsedAddress pa, StringWithTokens mainAddrTokens, String upMainAddress) {
        String token = mainAddrTokens.getFirstToken();
        int n = StringUtilities.findFirstNumeric((String)token);
        if (n > 0) {
            String typePortion;
            CAN_NewThoroughfareTypes.KeyInfo tKey;
            if (token.charAt(n - 1) == '#') {
                --n;
            }
            if ((tKey = CAN_NewThoroughfareTypes.lookupByTypeName(typePortion = token.substring(0, n))) != null && (tKey.getSpecialCase() == 1 || tKey.getSpecialCase() == 7 || tKey.getSpecialCase() == 8 || tKey.getSpecialCase() == 2 || tKey.getSpecialCase() == 6)) {
                String remaining = token.substring(n);
                mainAddrTokens.removeFirst();
                mainAddrTokens.insert(0, remaining);
                this.handleRR_SS_CR(pa, mainAddrTokens, new CAN_ThoroughfareType(typePortion, -1, tKey));
            }
        }
    }

    private void handleNumericStreetNamesWithSpaces(Address pa) {
        StringWithTokens tokens;
        String name = pa.getMainAddress();
        if (name != null && name.length() != 0 && Character.isDigit(name.charAt(0)) && (tokens = new StringWithTokens(name)).size() > 1) {
            String firstToken = tokens.getToken(0);
            String token = tokens.getToken(1);
            StringBuffer sb = new StringBuffer();
            StringWithTokens.TokenIterator i = tokens.iterator();
            char testDigit = firstToken.charAt(firstToken.length() - 1);
            if (Character.isDigit(testDigit) && (token.equals("ST") && testDigit == '1' || token.equals("ND") && testDigit == '2' || token.equals("RD") && testDigit == '3' || token.equals("TH") && (testDigit == '0' || Character.getNumericValue(testDigit) > 3 || firstToken.length() == 2 && firstToken.charAt(0) == '1'))) {
                sb.append(i.next());
                sb.append(i.next());
            }
            while (i.hasNext()) {
                if (sb.length() != 0) {
                    sb.append(' ');
                }
                sb.append(i.next());
            }
            pa.setMainAddress(sb.toString());
        }
    }

    private void handleGD(CAN_ParsedAddress pa, StringWithTokens listOfTokens, CAN_ThoroughfareType preType) {
        pa.setMainAddress(preType.getProperTypeName());
        pa.setFrenchGD(preType.getPreferredTypeName().equalsIgnoreCase("GDF"));
        pa.setStationInformation(listOfTokens.toString());
        listOfTokens.clear();
    }

    private void handlePOBox(CAN_ParsedAddress pa, StringWithTokens listOfTokens, CAN_ThoroughfareType preType) {
        if (preType.getTypeName().equals("BOX") && listOfTokens.size() >= 3) {
            String mxType = listOfTokens.getToken(1);
            if (mxType.equals("CMR") || mxType.equals("UNIT") || mxType.equals("PSC")) {
                StringBuffer buf = new StringBuffer(10);
                buf.append(mxType);
                buf.append(" ");
                pa.setAddressNumber(listOfTokens.removeFirst());
                listOfTokens.removeFirst();
                buf.append(listOfTokens.removeFirst());
                pa.setMainAddress(buf.toString());
                return;
            }
        } else {
            if ("BOX".equals(preType.getTypeName()) && "UNIT".equals(pa.getUnitType()) && pa.getUnitValue() != null && listOfTokens.size() != 0) {
                StringBuffer buf = new StringBuffer(10);
                buf.append("UNIT ");
                pa.setAddressNumber(listOfTokens.removeFirst());
                pa.setUnitType("");
                buf.append(pa.getUnitValue());
                pa.setMainAddress(buf.toString());
                pa.setUnitValue("");
                return;
            }
            if ("BOX".equals(preType.getTypeName())) {
                String tok;
                CAN_ThoroughfareType postType = m_tfareTypes.findStreetType(listOfTokens, false);
                if (postType != null) {
                    pa.setPostThoroughfareType(postType.getPreferredTypeName());
                    for (int i = 0; i < postType.getNumTokens(); ++i) {
                        listOfTokens.removeLast();
                    }
                }
                if (listOfTokens.size() == 0) {
                    pa.setMainAddress("BOX");
                    return;
                }
                if (listOfTokens.size() != 0 && !StringUtilities.hasNumeric((String)(tok = listOfTokens.getFirstToken()))) {
                    StringBuffer buf = new StringBuffer(10);
                    buf.append("BOX");
                    while (listOfTokens.size() != 0) {
                        buf.append(" ");
                        buf.append(listOfTokens.removeFirst());
                    }
                    pa.setMainAddress(buf.toString());
                    return;
                }
            }
        }
        pa.setPreThoroughfareType(preType.getPreferredTypeName());
        if (preType.getPreferredTypeName().equals("PXE")) {
            pa.setEnglishPOBox(true);
        } else {
            pa.setFrenchPOBox(true);
        }
        if (listOfTokens.size() == 0 && pa.getPreThoroughfareType() != null) {
            pa.setMainAddress("PO BOX");
            pa.setPreThoroughfareType(null);
        } else {
            pa.setMainAddress("PO BOX");
            pa.setPreThoroughfareType(null);
            if (StringUtilities.hasNumeric((String)listOfTokens.getFirstToken())) {
                String addressNumber = listOfTokens.removeFirst();
                if (addressNumber.length() > 1 && addressNumber.charAt(0) == '#') {
                    pa.setAddressNumber(addressNumber.substring(1));
                } else {
                    pa.setAddressNumber(addressNumber);
                }
            }
            if (StringUtilities.isEmpty((String)pa.getStationInformation())) {
                pa.setStationInformation(listOfTokens.toString());
            }
            listOfTokens.clear();
            pa.setUnitType(null);
            pa.setUnitValue(null);
            pa.setPostThoroughfareType(null);
        }
    }

    private void handleSpecialPreTypesWithAddrNum(CAN_ParsedAddress pa, StringWithTokens listOfTokens, CAN_ThoroughfareType preType) {
        int specialCase = preType.getSpecialCase();
        if (specialCase == 4) {
            this.handleGD(pa, listOfTokens, preType);
        } else if (specialCase == 3) {
            this.handlePOBox(pa, listOfTokens, preType);
        } else if (specialCase == 5) {
            if ((preType.getTypeName().equals("RTE") || preType.getTypeName().equals("RT")) && listOfTokens.size() >= 3 && listOfTokens.getToken(1).equals("BOX")) {
                pa.setPreThoroughfareType("RR");
                pa.setMainAddress(listOfTokens.removeFirst());
                listOfTokens.removeFirst();
                pa.setAddressNumber(listOfTokens.removeFirst());
            } else if (listOfTokens.size() != 0) {
                pa.setPreThoroughfareType(preType.getPreferredTypeName());
                pa.setMainAddress(this.createMainAddressString(listOfTokens));
                listOfTokens.clear();
            } else {
                pa.setMainAddress(preType.getTypeName());
            }
        } else if (specialCase == 9) {
            if (listOfTokens.size() == 0) {
                pa.setMainAddress("TRANS CANADA");
                pa.setPostThoroughfareType("HWY");
            } else {
                pa.setPreThoroughfareType(preType.getPreferredTypeName());
                pa.setMainAddress(this.createMainAddressString(listOfTokens));
                listOfTokens.clear();
            }
        } else if (specialCase == 1 || specialCase == 7 || specialCase == 8 || specialCase == 6) {
            this.handleRR_SS_CR(pa, listOfTokens, preType);
        }
    }

    private void handleRR_SS_CR(CAN_ParsedAddress pa, StringWithTokens listOfTokens, CAN_ThoroughfareType preType) {
        StringBuffer mainAddress = new StringBuffer();
        StringBuffer addressNumber = new StringBuffer();
        if (preType.getSpecialCase() == 1) {
            pa.setPreThoroughfareType("RR");
        } else if (preType.getSpecialCase() == 8) {
            pa.setPreThoroughfareType("MR");
        } else if (preType.getSpecialCase() == 7) {
            pa.setPreThoroughfareType("SS");
        } else if (preType.getSpecialCase() == 6) {
            pa.setPreThoroughfareType("CRD");
        }
        if (listOfTokens.size() > 0) {
            String roadNumber = listOfTokens.removeFirst();
            if (roadNumber.charAt(0) == '#') {
                pa.setMainAddress(roadNumber.substring(1));
            } else {
                pa.setMainAddress(roadNumber);
            }
            pa.setStationInformation(listOfTokens.toString());
            listOfTokens.clear();
        } else {
            pa.setMainAddress(pa.getPreThoroughfareType());
            pa.setPreThoroughfareType("");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StringWithTokens parseUnitInfo(Address pa, StringWithTokens tokens, boolean okayToPullFromFront, boolean checkForEmptyMainAddress, boolean bOkayToPullFromEnd) {
        String tok;
        boolean splitToken;
        boolean foundUnit;
        String unitValue;
        String unitType;
        String initialAddress;
        block37: {
            String lastToken;
            String secondToLastToken;
            block39: {
                block40: {
                    block38: {
                        initialAddress = tokens.toString();
                        unitType = null;
                        unitValue = null;
                        this.m_unitType = null;
                        foundUnit = false;
                        splitToken = false;
                        if (!bOkayToPullFromEnd) break block37;
                        secondToLastToken = null;
                        lastToken = tokens.getLastToken();
                        if (lastToken.length() <= 1 || lastToken.charAt(0) != '#') break block38;
                        secondToLastToken = lastToken.substring(0, 1);
                        lastToken = lastToken.substring(1);
                        splitToken = true;
                        String thirdToLastToken = tokens.getToken(tokens.size() - 2);
                        if (CAN_UnitTypes.getUnitType(thirdToLastToken) == null) break block39;
                        secondToLastToken = thirdToLastToken;
                        splitToken = false;
                        break block39;
                    }
                    if (lastToken.length() <= 4 || !lastToken.startsWith("SUITE/") && !lastToken.startsWith("SUITE-") && !lastToken.startsWith("STE/") && !lastToken.startsWith("STE-")) break block40;
                    int pos = lastToken.indexOf(47);
                    if (pos == -1) {
                        pos = lastToken.indexOf(45);
                    }
                    if (pos <= 2) break block39;
                    secondToLastToken = lastToken.substring(0, pos);
                    lastToken = lastToken.substring(pos + 1);
                    break block39;
                }
                if (lastToken.length() > 3) {
                    String[] validSeparators = new String[]{".#", "#", "."};
                    for (int i = 0; i < validSeparators.length; ++i) {
                        String tmp;
                        int sepPos = lastToken.indexOf(validSeparators[i]);
                        if (sepPos == -1 || CAN_UnitTypes.getUnitType(tmp = lastToken.substring(0, sepPos)) == null) continue;
                        secondToLastToken = tmp;
                        lastToken = lastToken.substring(sepPos + validSeparators[i].length());
                        splitToken = true;
                        break;
                    }
                }
            }
            if (secondToLastToken == null && tokens.size() > 1) {
                secondToLastToken = tokens.getToken(tokens.size() - 2);
            }
            if (secondToLastToken != null && tokens.size() > 2 && secondToLastToken.equalsIgnoreCase("number")) {
                boolean bFoundType = false;
                boolean bFoundUnitType = false;
                String thirdToLastToken = tokens.getToken(tokens.size() - 3);
                tokens.remove(tokens.size() - 2);
                if (thirdToLastToken != null) {
                    CAN_NewThoroughfareTypes.KeyInfo canSt = CAN_NewThoroughfareTypes.lookupByPreferredName(thirdToLastToken);
                    if (canSt == null) {
                        canSt = CAN_NewThoroughfareTypes.lookupByTypeName(thirdToLastToken);
                    }
                    if (canSt != null) {
                        bFoundType = true;
                    } else {
                        CAN_UnitType canType = CAN_UnitTypes.getUnitType(thirdToLastToken);
                        if (canType != null) {
                            bFoundUnitType = true;
                        }
                    }
                }
                if (bFoundType) {
                    tokens.insert(tokens.size() - 1, "#");
                }
                if (bFoundType || bFoundUnitType) {
                    secondToLastToken = tokens.getToken(tokens.size() - 2);
                }
            }
            if (secondToLastToken != null) {
                this.m_unitType = CAN_UnitTypes.getUnitType(secondToLastToken);
                if (this.m_unitType != null) {
                    if (tokens.size() == 3 && CAN_NewThoroughfareTypes.lookupByTypeName(tokens.getFirstToken()) != null && (lastToken == null || lastToken.length() > 2 && !Character.isDigit(lastToken.charAt(0)))) {
                        return tokens;
                    }
                    foundUnit = true;
                    unitType = this.m_unitType.getAbbreviation();
                    unitValue = lastToken;
                    tokens.removeLast();
                    if (!splitToken) {
                        tokens.removeLast();
                    }
                } else {
                    this.m_unitType = CAN_UnitTypes.getUnitType(lastToken);
                    if (this.m_unitType != null && !this.m_unitType.mustHaveUnitValue()) {
                        foundUnit = true;
                        unitType = this.m_unitType.getAbbreviation();
                        tokens.removeLast();
                    } else if (this.m_unitType != null && ("FL".equalsIgnoreCase(this.m_unitType.getAbbreviation()) || "\u00c9TAGE".equalsIgnoreCase(this.m_unitType.getAbbreviation()))) {
                        StringBuffer buf = new StringBuffer();
                        int len = secondToLastToken.length();
                        for (int i = 0; i < len && Character.isDigit(secondToLastToken.charAt(i)); ++i) {
                            buf.append(secondToLastToken.charAt(i));
                        }
                        foundUnit = true;
                        unitType = this.m_unitType.getAbbreviation();
                        unitValue = buf.length() > 0 ? buf.toString() : secondToLastToken;
                        tokens.removeLast();
                        tokens.removeLast();
                    }
                }
            } else {
                this.m_unitType = CAN_UnitTypes.getUnitType(lastToken);
                if (this.m_unitType != null && !this.m_unitType.mustHaveUnitValue()) {
                    foundUnit = true;
                    unitType = this.m_unitType.getAbbreviation();
                    tokens.removeLast();
                }
            }
        }
        if (!foundUnit && okayToPullFromFront) {
            splitToken = false;
            String secondToken = null;
            String firstToken = tokens.getFirstToken();
            if (firstToken.length() > 1 && firstToken.charAt(0) == '#') {
                secondToken = firstToken.substring(1);
                firstToken = firstToken.substring(0, 1);
                splitToken = true;
            } else if (tokens.size() > 1) {
                secondToken = tokens.getToken(1);
            }
            if (secondToken != null) {
                this.m_unitType = CAN_UnitTypes.getUnitType(firstToken);
                if (this.m_unitType != null && this.m_unitType.mustHaveUnitValue()) {
                    foundUnit = true;
                    unitType = this.m_unitType.getAbbreviation();
                    unitValue = secondToken;
                    tokens.removeFirst();
                    if (!splitToken) {
                        tokens.removeFirst();
                    }
                }
            } else {
                this.m_unitType = CAN_UnitTypes.getUnitType(firstToken);
                if (this.m_unitType != null && !this.m_unitType.mustHaveUnitValue()) {
                    foundUnit = true;
                    unitType = this.m_unitType.getAbbreviation();
                    tokens.removeFirst();
                }
            }
        }
        if (checkForEmptyMainAddress && foundUnit && tokens.size() <= 1 && (tokens.size() == 0 || !"#".equals(unitType) && AddressUtils.isValidHouseNumber(tokens.getFirstToken()))) {
            return new StringWithTokens(initialAddress, " ,");
        }
        if (foundUnit) {
            if (pa.getUnitType() != null && pa.getUnitValue() != null) {
                if (!pa.getUnitType().equals("#")) return new StringWithTokens(initialAddress, " ,");
                pa.setUnitValue(unitValue);
                pa.setUnitType(unitType);
            } else {
                pa.setUnitType(unitType);
                pa.setUnitValue(unitValue);
            }
        }
        if ((tok = tokens.getLastToken()) != null && tok.length() == 1 && this.testCharForPossibleNumberSeparator(tok.charAt(0))) {
            tokens.removeLast();
        }
        if (!okayToPullFromFront || (tok = tokens.getFirstToken()) == null || tok.length() != 1 || !this.testCharForPossibleNumberSeparator(tok.charAt(0))) return tokens;
        tokens.removeFirst();
        return tokens;
    }

    private String stripHouseNumberFromStart(StringWithTokens list, IConstraints constraints) {
        String possibleType;
        CAN_NewThoroughfareTypes.KeyInfo key;
        int dashPos;
        boolean bNextTokenStartsWithSep;
        this.checkForHouseDashedWithNumberedStreet(list);
        String addressNumber = null;
        if (list.size() < 2) {
            return null;
        }
        addressNumber = list.getFirstToken();
        String nextToken = null;
        nextToken = list.getToken(1);
        boolean bl = bNextTokenStartsWithSep = nextToken != null && this.testCharForPossibleNumberSeparator(nextToken.charAt(0));
        if (bNextTokenStartsWithSep || this.testCharForPossibleNumberSeparator(addressNumber.charAt(addressNumber.length() - 1))) {
            StringBuffer buf;
            if (bNextTokenStartsWithSep && nextToken.length() == 1 && list.size() > 2) {
                buf = new StringBuffer(addressNumber);
                buf.append('-');
                buf.append(list.getToken(2));
                list.setToken(0, buf.toString());
                list.remove(1);
                list.remove(1);
            } else if (nextToken != null && nextToken.length() > 1 && !this.testCharForPossibleNumberSeparator(nextToken.charAt(nextToken.length() - 1))) {
                buf = new StringBuffer(addressNumber);
                buf.append(nextToken);
                list.setToken(0, buf.toString());
                list.remove(1);
            }
            addressNumber = list.getFirstToken();
            if (list.size() > 1) {
                nextToken = list.getToken(1);
            }
        }
        if (!AddressUtils.isValidHouseNumber(addressNumber)) {
            return null;
        }
        if (CAN_Directionals.isDirectional(addressNumber)) {
            return null;
        }
        if (addressNumber.equals("I")) {
            if (StringUtilities.isNumeric((String)nextToken)) {
                return null;
            }
        } else {
            CAN_UnitType unitType;
            CAN_NewThoroughfareTypes.KeyInfo key2;
            if (nextToken.equals("AND")) {
                return null;
            }
            if (nextToken.length() == 2 && (nextToken.equals("TH") || addressNumber.charAt(addressNumber.length() - 1) == '2' && nextToken.equals("ND"))) {
                return null;
            }
            if (m_tfareTypes.findStreetType(list, true) != null) {
                return null;
            }
            if (AddressUtils.isValidHouseNumber(nextToken) && StringUtilities.isNumeric((String)nextToken) && list.size() > 2 && constraints != null && nextToken.indexOf(47) < 0 && (key2 = CAN_NewThoroughfareTypes.lookupByTypeName(list.getToken(2))) == null && (unitType = CAN_UnitTypes.getUnitType(list.getToken(list.size() - 2))) == null) {
                addressNumber = addressNumber + "-" + nextToken;
                list.removeFirst();
            }
        }
        if ((dashPos = addressNumber.indexOf(45)) > 1 && (key = CAN_NewThoroughfareTypes.lookupByTypeName(possibleType = addressNumber.substring(0, dashPos))) != null && key.getSpecialCase() == 9) {
            return null;
        }
        String abbr = CAN_Abbreviations.getAbbrFromValue(addressNumber);
        if (abbr != null && StringUtilities.isNumeric((String)abbr)) {
            return abbr;
        }
        return addressNumber;
    }

    private boolean testCharForPossibleNumberSeparator(char c) {
        return POSSIBLE_HOUSENUMBER_UNIT_SEPARATORS.indexOf(c) >= 0;
    }

    private void checkForHouseDashedWithNumberedStreet(StringWithTokens list) {
        String token = list.getFirstToken();
        if (token.indexOf(45) >= 0) {
            String[] splits;
            int letterCnt = 0;
            for (int i = 0; i < token.length(); ++i) {
                if (Character.isLetter(token.charAt(i))) {
                    if (++letterCnt <= 1) continue;
                    break;
                }
                letterCnt = 0;
            }
            if (letterCnt <= 1 && (splits = token.split("-")).length == 3) {
                list.removeFirst();
                list.insert(0, splits[2]);
                list.insert(0, splits[0] + '-' + splits[1]);
            }
        }
    }

    private boolean pickStartOrEndType(CAN_ThoroughfareType preType, CAN_ThoroughfareType postType, StringWithTokens mainAddrTokens) {
        if (preType == null) {
            return false;
        }
        if (postType.foundAtEnd() && preType != null && preType.foundAtStart() && mainAddrTokens.size() != postType.getNumTokens()) {
            if (mainAddrTokens.getToken(1).charAt(0) == 'D' && preType.getPreferredTypeName().equals("COTE")) {
                if (mainAddrTokens.size() == 3) {
                    return true;
                }
            } else {
                if (m_winningPostThoroughfareTypeSet.contains(postType.getPreferredTypeName())) {
                    return false;
                }
                if (m_winningPreThoroughfareTypeSet.contains(preType.getPreferredTypeName())) {
                    return true;
                }
                if (m_losingPostThoroughfareTypeSet.contains(postType.getPreferredTypeName())) {
                    return true;
                }
            }
        }
        return false;
    }

    private String getFullAddressString(Address addr) {
        String inStr;
        StringBuffer builtBuf = new StringBuffer();
        boolean bChanged = false;
        ParsedNumber inNum = addr.getParsedAddressNumber();
        if (inNum != null && !inNum.isEmpty()) {
            builtBuf.append(inNum.getCombinedAddressNumber());
            bChanged = true;
        }
        if ((inStr = addr.getPreDirectional()) != null) {
            builtBuf.append(' ');
            builtBuf.append(inStr);
            bChanged = true;
        }
        if ((inStr = addr.getPreThoroughfareType()) != null) {
            builtBuf.append(' ');
            builtBuf.append(inStr);
            bChanged = true;
        }
        if ((inStr = addr.getMainAddress()) != null) {
            builtBuf.append(' ');
            builtBuf.append(inStr);
        }
        if ((inStr = addr.getPostThoroughfareType()) != null) {
            builtBuf.append(' ');
            builtBuf.append(inStr);
            bChanged = true;
        }
        if ((inStr = addr.getPostDirectional()) != null) {
            builtBuf.append(' ');
            builtBuf.append(inStr);
            bChanged = true;
        }
        if (bChanged) {
            return builtBuf.toString().toUpperCase();
        }
        return null;
    }

    private void RemoveBadChars(Address pa) {
        String[] Addresses = new String[2];
        StringBuffer[] newAddrs = new StringBuffer[2];
        Addresses[0] = pa.getMainAddress();
        Addresses[1] = pa.getGenericField1();
        for (int i = 0; i < 2; ++i) {
            if (Addresses[i] == null) continue;
            block4: for (int j = 0; j < Addresses[i].length(); ++j) {
                char thischar = Addresses[i].charAt(j);
                int ttype = Character.getType(thischar);
                switch (ttype) {
                    case 0: 
                    case 12: 
                    case 15: 
                    case 26: {
                        if (newAddrs[i] != null) {
                            newAddrs[i].append(' ');
                            continue block4;
                        }
                        newAddrs[i] = new StringBuffer();
                        newAddrs[i].append(' ');
                        continue block4;
                    }
                    default: {
                        boolean isValidChar;
                        boolean bl = isValidChar = thischar != '\"';
                        if (newAddrs[i] == null) {
                            newAddrs[i] = new StringBuffer("");
                            if (isValidChar) {
                                newAddrs[i].append(thischar);
                                continue block4;
                            }
                            newAddrs[i].append(' ');
                            continue block4;
                        }
                        if (isValidChar) {
                            newAddrs[i].append(thischar);
                            continue block4;
                        }
                        newAddrs[i].append(' ');
                    }
                }
            }
            if (i == 0) {
                pa.setMainAddress(newAddrs[0].toString().trim());
                continue;
            }
            pa.setGenericField1(newAddrs[1].toString().trim());
        }
    }

    static {
        int i;
        m_tfareTypes = new CAN_NewThoroughfareTypes();
        m_winningPostThoroughfareTypeSet = null;
        m_winningPreThoroughfareTypeSet = null;
        m_losingPostThoroughfareTypeSet = null;
        m_numericStreetCompanionTypeSet = null;
        m_articleSet = null;
        POSSIBLE_HOUSENUMBER_UNIT_SEPARATORS = "-&:";
        POBOX_PATTERN_STRING = "\\b(P\\s*BOX|POST\\s*BOX|POST OFFICE BOX|POSTOFFICE BOX|POSTOFFICEBOX|PO\\s*DRAWER|PO\\s*DRAW|P\\.?\\s*O\\.?\\s* BXO?|P\\.?\\s*O\\.?\\s*BO?X+|P\\.?\\s*O\\.?\\s*BOC?|P\\.?\\s*O\\.?\\s*B\\.?|LOCK\\s*BOX|BOX\\s*PO|PO|PB|BIN|BOX|BX|PX|      )\\s*(\\d+)";
        POB_PATTERN = Pattern.compile(POBOX_PATTERN_STRING, 2);
        FRENCH_POBOX_PATTERN_STRING = "\\b(CASEPOSTAL|CASE POSTALE|CASE POSTAL|C\\s*P|C\\.?\\s*P\\.?)\\s*(\\d+)";
        FRENCH_POB_PATTERN = Pattern.compile(FRENCH_POBOX_PATTERN_STRING, 2);
        String[] winningPostTypes = new String[]{"ST", "RD", "AVE", "BD", "TER", "DR", "CH", "PVT", "WAY", "CIR"};
        String[] winningPreTypes = new String[]{"CH", "RUE", "PROM", "TSSE", "VO", "VIA", "RTE", "BD", "ALE", "AVE", "CER", "CROIS", "IMP", "MTE", "PL", "RD", "RR", "SE", "TCHWY"};
        String[] losingPostTypes = new String[]{"BD", "PR"};
        String[] numericStreetCompanionTypes = new String[]{"ST", "AVE", "BD", "BYP", "CH", "EXPY", "FRWY", "HWY"};
        String[] articles = new String[]{"DU", "DE", "DES", "D", "DEL", "L", "LA", "LE", "LES"};
        m_winningPostThoroughfareTypeSet = new HashSet(winningPostTypes.length);
        for (i = 0; i < winningPostTypes.length; ++i) {
            m_winningPostThoroughfareTypeSet.add(winningPostTypes[i]);
        }
        m_winningPreThoroughfareTypeSet = new HashSet(winningPostTypes.length);
        for (i = 0; i < winningPreTypes.length; ++i) {
            m_winningPreThoroughfareTypeSet.add(winningPreTypes[i]);
        }
        m_losingPostThoroughfareTypeSet = new HashSet(losingPostTypes.length);
        for (i = 0; i < losingPostTypes.length; ++i) {
            m_losingPostThoroughfareTypeSet.add(losingPostTypes[i]);
        }
        m_numericStreetCompanionTypeSet = new HashSet(numericStreetCompanionTypes.length);
        for (i = 0; i < numericStreetCompanionTypes.length; ++i) {
            m_numericStreetCompanionTypeSet.add(numericStreetCompanionTypes[i]);
        }
        m_articleSet = new HashSet(articles.length);
        for (i = 0; i < articles.length; ++i) {
            m_articleSet.add(articles[i]);
        }
    }
}

