/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.postal;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalPostalCandidate;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.core.matcher.MatcherException;
import com.mapinfo.mapmarker.core.postal.CorePostalMatcher;
import com.mapinfo.mapmarker.core.postal.IPostalMatcher;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CAN_PostalMatcher
implements IPostalMatcher {
    private IPostalMatcher m_coreMatcher = new CorePostalMatcher();

    public List matchPostal(IConstraints constraints, Address address, IRetrievedCandidates candidates) throws MatcherException {
        List results = this.m_coreMatcher.matchPostal(constraints, address, candidates);
        if (results == null || results.size() <= 1) {
            return results;
        }
        int closeCount = 0;
        for (InternalPostalCandidate candidate : results) {
            if (candidate.isCloseMatch()) {
                ++closeCount;
            }
            if (closeCount != 2) continue;
            break;
        }
        if (closeCount > 1) {
            this.filterCloseMatches(results);
        }
        return results;
    }

    private void filterCloseMatches(List<InternalPostalCandidate> results) {
        InternalPostalCandidate other;
        Iterator<InternalPostalCandidate> iterator = results.iterator();
        InternalPostalCandidate best = iterator.next();
        boolean bModified = false;
        while (iterator.hasNext() && (other = iterator.next()).isCloseMatch()) {
            if (best.getUserDictionaryPriority() >= other.getUserDictionaryPriority()) continue;
            other.setCloseMatchOff();
            bModified = true;
        }
        if (bModified) {
            Collections.sort(results);
            Collections.reverse(results);
        }
    }
}

