/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.singleline;

import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

class AvoidEndingWithArticleRule
implements Comparator<IAddressParsing> {
    private static final Set<String> ARTICLES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("LE", "LA", "LES", "UN", "UNE", "DES", "DU", "DE", "SUR")));
    private static final Set<String> ARTICLES_POST_START = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("UN", "UNE", "DES", "DU", "DE", "SUR")));

    AvoidEndingWithArticleRule() {
    }

    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        boolean splitsArticle1 = this.hasSplitArticle(o1);
        boolean splitsArticle2 = this.hasSplitArticle(o2);
        if (splitsArticle1 && !splitsArticle2) {
            return 1;
        }
        if (!splitsArticle1 && splitsArticle2) {
            return -1;
        }
        return 0;
    }

    private boolean hasSplitArticle(IAddressParsing parsing) {
        String lastWord;
        int lastIdx;
        String main = parsing.getSplit().getAddress().getMainAddress();
        if (!StringUtilities.isEmpty((String)main) && (lastIdx = (main = main.toUpperCase()).lastIndexOf(32)) >= 0 && ARTICLES.contains(lastWord = main.substring(lastIdx + 1))) {
            return true;
        }
        String post = parsing.getSplit().getAddress().getPostAddress();
        if (!StringUtilities.isEmpty((String)post)) {
            String firstWord;
            String lastWord2;
            int lastIdx2 = (post = post.toUpperCase()).lastIndexOf(32);
            if (lastIdx2 >= 0 && ARTICLES.contains(lastWord2 = post.substring(lastIdx2 + 1))) {
                return true;
            }
            int firstIdx = post.indexOf(32);
            if (firstIdx >= 0 && ARTICLES_POST_START.contains(firstWord = post.substring(0, firstIdx))) {
                return true;
            }
        }
        return false;
    }
}

