/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.singleline;

import com.mapinfo.mapmarker.CAN.AddressUtils;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Comparator;

class AvoidEndingWithSaintRule
implements Comparator<IAddressParsing> {
    AvoidEndingWithSaintRule() {
    }

    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        boolean hasType2;
        boolean hasType1 = !StringUtilities.isEmpty((String)o1.getParse()[0].getPostThoroughfareType());
        boolean bl = hasType2 = !StringUtilities.isEmpty((String)o2.getParse()[0].getPostThoroughfareType());
        if (hasType1 != hasType2) {
            return 0;
        }
        boolean endsInSaint1 = this.mainEndsInSaint(o1);
        boolean endsInSaint2 = this.mainEndsInSaint(o2);
        if (endsInSaint1 && !endsInSaint2) {
            return 1;
        }
        if (!endsInSaint1 && endsInSaint2) {
            return -1;
        }
        return 0;
    }

    private boolean mainEndsInSaint(IAddressParsing parsing) {
        String mainAddress = parsing.getSplit().getAddress().getMainAddress();
        if (StringUtilities.isEmpty((String)mainAddress)) {
            return false;
        }
        int lastIdx = mainAddress.lastIndexOf(32);
        String lastWord = (lastIdx > 0 ? mainAddress.substring(lastIdx + 1) : mainAddress).toUpperCase();
        Address[] parses = parsing.getParse();
        if (lastWord.equalsIgnoreCase("ST") && parses != null && parses.length > 0 && lastWord.equalsIgnoreCase(parses[0].getPostThoroughfareType())) {
            return false;
        }
        return AddressUtils.isSaintVariation(lastWord);
    }
}

