/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.singleline;

import com.mapinfo.mapmarker.CAN.CAN_ParsedAddress;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public class AvoidExtraWordInMainWithNumericForPreTypeHWYRule
implements Comparator<IAddressParsing> {
    private static Set<String> typesToChk = new HashSet<String>();

    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        CAN_ParsedAddress parsed1 = (CAN_ParsedAddress)o1.getParse()[0];
        CAN_ParsedAddress parsed2 = (CAN_ParsedAddress)o2.getParse()[0];
        String preType1 = parsed1.getPreThoroughfareType();
        String preType2 = parsed2.getPreThoroughfareType();
        if (preType1 != null && preType2 != null && preType1.equals(preType2) && typesToChk.contains(preType1) && typesToChk.contains(preType2) && parsed1.getMainAddress() != null && parsed2.getMainAddress() != null) {
            StringWithTokens toks1 = new StringWithTokens(parsed1.getMainAddress());
            StringWithTokens toks2 = new StringWithTokens(parsed2.getMainAddress());
            if (toks1.size() != toks2.size() && toks1.getFirstToken().equalsIgnoreCase(toks2.getFirstToken()) && StringUtilities.isNumeric((String)toks1.getFirstToken()) && toks2.size() > 1) {
                return -1;
            }
            if (toks1.size() != toks2.size() && toks1.getFirstToken().equalsIgnoreCase(toks2.getFirstToken()) && StringUtilities.isNumeric((String)toks1.getFirstToken()) && toks1.size() > 1) {
                return 1;
            }
        }
        return 0;
    }

    static {
        typesToChk.add("HWY");
        typesToChk.add("RTE");
        typesToChk = Collections.unmodifiableSet(typesToChk);
    }
}

