/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN.singleline;

import com.mapinfo.mapmarker.CAN.parser.CAN_Directionals;
import com.mapinfo.mapmarker.CAN.parser.CAN_UnitType;
import com.mapinfo.mapmarker.CAN.parser.CAN_UnitTypes;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Comparator;

class PreferDirectionalInCityOverUnitRule
implements Comparator<IAddressParsing> {
    PreferDirectionalInCityOverUnitRule() {
    }

    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        boolean unitValueEndInDir1 = this.unitValueEndInDir(o1);
        boolean unitValueEndInDir2 = this.unitValueEndInDir(o2);
        if (unitValueEndInDir1 && !unitValueEndInDir2) {
            return 1;
        }
        if (!unitValueEndInDir1 && unitValueEndInDir2) {
            return -1;
        }
        return 0;
    }

    private boolean unitValueEndInDir(IAddressParsing parsing) {
        String unitValue = parsing.getParse()[0].getUnitValue();
        if (StringUtilities.isEmpty((String)unitValue)) {
            return false;
        }
        String typeString = parsing.getParse()[0].getUnitType();
        if (StringUtilities.isEmpty((String)typeString)) {
            return false;
        }
        int lastIdx = unitValue.lastIndexOf(32);
        String lastWord = lastIdx > 0 ? unitValue.substring(lastIdx + 1) : unitValue;
        boolean isDirectional = CAN_Directionals.isDirectional(lastWord);
        boolean requiresValue = false;
        CAN_UnitType ut = CAN_UnitTypes.getUnitType(typeString);
        if (ut != null) {
            requiresValue = ut.mustHaveUnitValue();
        }
        if (lastIdx > 0 || !requiresValue) {
            return isDirectional;
        }
        return false;
    }
}

