/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE;

import com.mapinfo.mapmarker.CHE.parser.CHE_AddressTerm;
import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class CHE_AddressUtils {
    private static final double CLOSE_MATCH_SCORE = 1.0;

    private CHE_AddressUtils() {
    }

    public static String getFormattedStreetAddress(Address addr, boolean bAppendAddressNumber) {
        String postDir;
        HashMap fields = addr.getAdditionalFields();
        String postTTSeparator = (String)fields.get("POST_TT_SEPARATOR");
        postTTSeparator = postTTSeparator == null ? " " : postTTSeparator;
        String postMainSeparator = (String)fields.get("POST_MAIN_SEPARATOR");
        postMainSeparator = postMainSeparator == null ? "" : postMainSeparator;
        StringBuffer buf = new StringBuffer(100);
        String preDir = addr.getPreDirectional();
        if (preDir != null) {
            buf.append(preDir);
            buf.append(' ');
        }
        if (addr.getPreAddress() != null) {
            String preAddress = addr.getPreAddress();
            buf.append(preAddress);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        String newMainAddress = addr.getMainAddress();
        if (postMainSeparator != null) {
            newMainAddress = newMainAddress + postMainSeparator;
        }
        buf.append(newMainAddress);
        String postAddr = addr.getPostAddress();
        if (postAddr != null && postAddr.length() != 0) {
            if (!postTTSeparator.equals("-") && postAddr.charAt(0) != '-' && buf.length() > 0 && buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
            buf.append(postAddr);
        }
        if ((postDir = addr.getPostDirectional()) != null) {
            if (!postTTSeparator.equals("-") && postDir.charAt(0) != '-' && buf.length() > 0 && buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
            buf.append(postDir);
        }
        if (addr.getGenericField3() != null) {
            buf.append(' ');
            buf.append(addr.getGenericField3());
        }
        if (bAppendAddressNumber && addr.getAddressNumber() != null) {
            if (buf.length() > 0 && buf.charAt(buf.length() - 1) != ' ') {
                buf.append(' ');
                buf.append(addr.getAddressNumber());
            } else {
                buf.append(' ');
                buf.append(addr.getAddressNumber());
            }
        }
        return buf.toString().trim();
    }

    public static String getFormattedPreAddress(Address addr) {
        String preMainCommon;
        String preAddrCommon;
        String preTT;
        HashMap fields = addr.getAdditionalFields();
        StringBuffer buf = new StringBuffer(100);
        String preDir = addr.getPreDirectional();
        if (preDir != null) {
            buf.append(preDir);
            buf.append(' ');
        }
        if ((preTT = addr.getPreThoroughfareType()) != null) {
            buf.append(preTT);
            buf.append(' ');
        }
        if ((preAddrCommon = (String)fields.get("pre_addr_common")) != null) {
            buf.append(preAddrCommon);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if (addr.getPreAddress() != null) {
            String preAddress = addr.getPreAddress();
            buf.append(preAddress);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if ((preMainCommon = (String)fields.get("pre_main_address_common")) != null && preMainCommon.length() != 0) {
            buf.append(preMainCommon);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        return buf.toString().trim();
    }

    public static boolean isPrefixAndSuffixCloseMatch(Address input, InternalCandidateAddress addr) {
        boolean postMatch;
        boolean isCloseMatch = true;
        boolean preMatch = CHE_AddressUtils.isEmpty(input.getPreAddress()) || addr.getPreAddressScore() == 1.0;
        boolean bl = postMatch = CHE_AddressUtils.isEmpty(input.getPostAddress()) || addr.getPostAddressScore() == 1.0;
        if (!preMatch || !postMatch) {
            isCloseMatch = false;
        }
        return isCloseMatch;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getModifiedStreetAddress(String inputedStreetAddress) {
        String str = null;
        if (inputedStreetAddress == null) return str;
        StringTokenizer tokens = new StringTokenizer(inputedStreetAddress, CHE_AddressTerm.getDelimiters(), true);
        LinkedList listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
        String firstTerm = (String)listOfTokens.get(0);
        StringBuffer strBuf = new StringBuffer();
        if (StringUtilities.isNumeric((String)firstTerm)) return inputedStreetAddress;
        String term = (String)listOfTokens.get(listOfTokens.size() - 1);
        if (StringUtilities.isNumeric((String)term.trim())) {
            strBuf.append(term + " ");
            strBuf.append(inputedStreetAddress.substring(0, inputedStreetAddress.length() - term.length()));
            return strBuf.toString();
        } else {
            if (term.length() <= 1) return inputedStreetAddress;
            int housenumberLength = term.length() - 1;
            if (StringUtilities.isNumeric((String)term.substring(housenumberLength))) return inputedStreetAddress;
            if (!StringUtilities.isNumeric((String)term.substring(0, housenumberLength))) return inputedStreetAddress;
            strBuf.append(term + " ");
            strBuf.append(inputedStreetAddress.substring(0, inputedStreetAddress.length() - term.length()));
        }
        return strBuf.toString();
    }

    public static void converttoCamelCase(CandidateAddress address) {
        if (address != null) {
            address.setGenericField1(StringUtilities.toProperCase((String)address.getGenericField1()));
            address.setGenericField2(StringUtilities.toProperCase((String)address.getGenericField2()));
            address.setGenericField3(StringUtilities.toProperCase((String)address.getGenericField3()));
            address.setGenericField4(StringUtilities.toProperCase((String)address.getGenericField4()));
            address.setPreAddress(StringUtilities.toProperCase((String)address.getPreAddress()));
            address.setPlaceName(StringUtilities.toProperCase((String)address.getPlaceName()));
            address.setMainAddress(StringUtilities.toProperCase((String)address.getMainAddress()));
            address.setPreThoroughfareType(StringUtilities.toProperCase((String)address.getPreThoroughfareType()));
            address.setPostThoroughfareType(StringUtilities.toProperCase((String)address.getPostThoroughfareType()));
            address.setPostAddress(StringUtilities.toProperCase((String)address.getPostAddress()));
            address.setUnitType(StringUtilities.toProperCase((String)address.getUnitType()));
            address.setUnitValue(StringUtilities.toProperCase((String)address.getUnitValue()));
            address.setPreDirectional(StringUtilities.toProperCase((String)address.getPreDirectional()));
            address.setPostDirectional(StringUtilities.toProperCase((String)address.getPostDirectional()));
        }
    }

    public static void converttoCamelCaseRG(ReverseGeocodeCandidateAddress address) {
        if (address != null) {
            address.setGenericField1(StringUtilities.toProperCase((String)address.getGenericField1()));
            address.setGenericField2(StringUtilities.toProperCase((String)address.getGenericField2()));
            address.setGenericField3(StringUtilities.toProperCase((String)address.getGenericField3()));
            address.setGenericField4(StringUtilities.toProperCase((String)address.getGenericField4()));
            address.setPreAddress(StringUtilities.toProperCase((String)address.getPreAddress()));
            address.setPlaceName(StringUtilities.toProperCase((String)address.getPlaceName()));
            address.setMainAddress(StringUtilities.toProperCase((String)address.getMainAddress()));
            address.setPreThoroughfareType(StringUtilities.toProperCase((String)address.getPreThoroughfareType()));
            address.setPostThoroughfareType(StringUtilities.toProperCase((String)address.getPostThoroughfareType()));
            address.setPostAddress(StringUtilities.toProperCase((String)address.getPostAddress()));
            address.setUnitType(StringUtilities.toProperCase((String)address.getUnitType()));
            address.setUnitValue(StringUtilities.toProperCase((String)address.getUnitValue()));
            address.setPreDirectional(StringUtilities.toProperCase((String)address.getPreDirectional()));
            address.setPostDirectional(StringUtilities.toProperCase((String)address.getPostDirectional()));
        }
    }

    public static long computeOffsetDifference(ParsedNumber inputHouseNumber, Range range) {
        long offset = 0L;
        if (range.getParsedFrom() != null && inputHouseNumber != null) {
            long parsedFromNumber = range.getParsedFrom().getAddressNumber();
            String hnr = inputHouseNumber.getCombinedAddressNumber();
            long inputNumber = 0L;
            inputNumber = !StringUtilities.isEmpty((String)hnr) && (hnr.indexOf("-") > -1 || hnr.indexOf("/") > -1) ? range.getMatchedRangeNumber().getAddressNumber() : inputHouseNumber.getAddressNumber();
            offset = parsedFromNumber - inputNumber;
            if (offset < 0L) {
                offset *= -1L;
            }
        }
        return offset;
    }

    public static ParsedNumber prepareParsedHnrfromString(String inputString) {
        ParsedNumber parsedNumber = null;
        boolean isSlashTrailorSepretor = true;
        if (!(StringUtilities.isEmpty((String)inputString) || inputString.indexOf("/") <= -1 && inputString.indexOf("-") <= -1 || CHE_AddressUtils.isAlphaNumeric(inputString))) {
            String[] strArray = inputString.split("/");
            if (strArray.length <= 1) {
                strArray = inputString.split("-");
                isSlashTrailorSepretor = false;
            }
            if (strArray.length > 1) {
                parsedNumber = new ParsedNumber(strArray[0]);
                parsedNumber.setTrailerSeparator(isSlashTrailorSepretor ? "/" : "-");
                parsedNumber.setAddressTrailer(strArray[1]);
            }
        }
        return parsedNumber;
    }

    public static boolean isAlphaNumeric(String inputString) {
        boolean isAlpha = false;
        if (inputString != null) {
            char[] characters = inputString.toCharArray();
            for (int i = 0; i < characters.length; ++i) {
                if (!Character.isLetter(characters[i])) continue;
                isAlpha = true;
                break;
            }
        }
        return isAlpha;
    }
}

