/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE;

import com.mapinfo.mapmarker.CHE.CHE_AddressUtils;
import com.mapinfo.mapmarker.CHE.CHE_Handler;
import com.mapinfo.mapmarker.CHE.CHE_HandlerImpl;
import com.mapinfo.mapmarker.CHE.CHE_Range;
import com.mapinfo.mapmarker.CHE.CHE_StreetCandidateAddress;
import com.mapinfo.mapmarker.CHE.FRA.parser.FRA_Abbreviations;
import com.mapinfo.mapmarker.CHE.dp.binary.CHE_DataManager;
import com.mapinfo.mapmarker.CHE.parser.CHE_AddressTerm;
import com.mapinfo.mapmarker.CHE.parser.CHE_ParsePostAddressRule;
import com.mapinfo.mapmarker.CHE.parser.CHE_PreParseHandler;
import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.EMEA.EMEA_InternalCandidateAddress;
import com.mapinfo.mapmarker.EMEA.EMEA_ScoringAddress;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoRecord;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.core.interpolator.Interpolator;
import com.mapinfo.mapmarker.user.IResponseCandidate;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.Length;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CHE_InternalCandidateAddress
extends EMEA_InternalCandidateAddress {
    public static final String KEY_AREA_NAME_3_MATCHED_AREA_NAME_1 = "AREA_NAME_3_MATCHED_AREA_NAME_1";
    public static final String PRE_ADDR_COMMON = "pre_addr_common";
    public static final String POST_ADDR_COMMON = "post_addr_common";
    public static final String PRE_MAIN_ADDRESS_COMMON = "pre_main_address_common";
    public static final String NO_MATCH_TOWN_ON_PROVINCE = "no_match_town_on_province";
    public static final String PRE_MAIN_COMMON_ADDRESS = "address.common.pre.main";
    public static final String POST_STREET_COMMON_TYPE = "address.common.post.st_type";
    public static final String PRE_DIRECTIONAL_SEPARATOR = "PRE_DIRECTIONAL_SEPARATOR";
    public static final String POST_TT_SEPARATOR = "POST_TT_SEPARATOR";
    public static final String PRE_TT_SEPARATOR = "PRE_TT_SEPARATOR";
    public static final String POST_MAIN_SEPARATOR = "POST_MAIN_SEPARATOR";
    public static final String EXPANDED_AREANAME3 = "expanded_areaname3";
    public static final String EXPANDED_POSTADDRESS = "expanded_postaddress";
    public static final String EXPANDED_PREADDRESS = "expanded_preaddress";
    public static final String EXPANDED_PRE_MAIN_COMMON = "expanded_pre_main_common";
    public static final String PRE_STREET_TYPE_COMMON = "pre_street_type_common";
    public static final String POST_STREET_TYPE_COMMON = "post_st_type_common";
    public static final String CAND_FULL_TOWN = "cand_full_town";
    public static final String VIRTUAL_TOWN_NAME = "virtual_town_name";
    public static final String PRE_SEPARATOR_CHAR = "PRE_SEP";
    public static final String POST_SEPARATOR_CHAR = "POST_SEP";
    private static final String DEFAULT_STREET_TYPE = "Via";
    public static final String STREET_NUMBER = "STREET_NUMBER";
    public static final int MATCH_NONE = 0;
    public static final int MATCH_FIRST = 1;
    public static final int MATCH_SECOND = 2;
    public static final int MATCH_BOTH_DIFFERENT = 3;
    public static final int MATCH_BOTH = 4;
    private static final int MAX_SCORE_CACHE = 20;
    private static double minScoreConsidered = 0.85;
    private static ItemsCachedScore[] m_scoreCache;
    public static int CHE_RANGE;
    protected static StringScorer plainScorer;
    protected boolean areaName1Matched = true;
    protected boolean areaName3Matched = false;
    protected boolean postcode1Matched = true;
    protected boolean areaName2Matched = true;
    private int m_numAddrNumberFields = 0;
    private int m_numAddrNumberFieldsMatched = 0;
    private int m_matchType = 0;
    private String m_CHEAreaName4 = null;
    private String m_addressNumber = null;
    public static final String ORIGINAL_STREET_NAME = "original_street_name";

    public CHE_InternalCandidateAddress() {
    }

    public CHE_InternalCandidateAddress(Address addr) {
        super(addr);
    }

    public static String reconstructAddress(InternalCandidateAddress cand) {
        StringBuffer buff = new StringBuffer();
        HashMap additionalFielfs = cand.getAdditionalFields();
        if (additionalFielfs != null) {
            buff.append(additionalFielfs.get(ORIGINAL_STREET_NAME));
            buff.append(" ");
            buff.append(cand.getAddressNumber() == null ? "" : cand.getAddressNumber());
            return buff.toString().trim();
        }
        if (cand.getGenericField4() != null) {
            buff.append(cand.getGenericField4());
            buff.append(" ");
            buff.append(cand.getAddressNumber() == null ? "" : cand.getAddressNumber());
            return buff.toString().trim();
        }
        String tmp = CHE_InternalCandidateAddress.noNulls((String)cand.getAdditionalFields().get("address.start"));
        if (tmp.length() > 0) {
            buff.append(tmp + " ");
        }
        if ((tmp = CHE_InternalCandidateAddress.noNulls(CHE_InternalCandidateAddress.reconstructMainAddress((Address)cand))).length() > 0) {
            buff.append(tmp);
        }
        if ((tmp = CHE_InternalCandidateAddress.noNulls(CHE_InternalCandidateAddress.getFormattedPreAddress((Address)cand))).length() > 0) {
            buff.append(tmp);
            if (!tmp.endsWith(" ")) {
                buff.append(' ');
            }
        }
        if ((tmp = CHE_InternalCandidateAddress.noNulls(cand.getPreThoroughfareType())).length() > 0) {
            buff.append(tmp + " ");
        }
        if ((tmp = CHE_InternalCandidateAddress.noNulls(cand.getPostThoroughfareType())).length() > 0) {
            buff.append(tmp + " ");
        }
        if ((tmp = CHE_InternalCandidateAddress.noNulls(cand.getAddressNumber())).length() > 0) {
            buff.append(' ');
            buff.append(tmp);
        }
        return buff.toString();
    }

    public void scoreAreaNames(ScoringAddress parsedAddress) {
        double tmp;
        double highScore;
        EMEA_GeoInfoRecord geoRecord = (EMEA_GeoInfoRecord)this.getSegment().getGeoInfoRecord();
        char parsedArea3FirstCh = '\u0000';
        if (geoRecord == null) {
            geoRecord = new EMEA_GeoInfoRecord();
        }
        String candAreaName1 = this.getAreaName1();
        String parsedAreaName1 = parsedAddress.getAreaName1();
        String candTown = geoRecord.getAreaName3Short() == null ? this.getAreaName3() : geoRecord.getAreaName3Short();
        String parsedAreaName3 = null;
        String parsedAreaName4 = parsedAddress.getAreaName4();
        String candAreaName4 = geoRecord.getAreaName4();
        double score = 0.0;
        EMEA_ScoringAddress scorer = (EMEA_ScoringAddress)parsedAddress;
        if (parsedAreaName1 != null && candAreaName1 != null) {
            score = scorer.scoreItems(parsedAreaName1, candAreaName1);
        }
        if (score != 1.0 && CHE_AddressTerm.isStateAbbreviation(parsedAreaName1)) {
            highScore = score;
            String fullAreaName1 = CHE_AddressTerm.getStateAbbreviation(parsedAreaName1);
            StringTokenizer tokens = new StringTokenizer(fullAreaName1, ",");
            while (tokens.hasMoreTokens()) {
                String tempAreaName1 = tokens.nextToken();
                if (tempAreaName1 != null) {
                    score = scorer.scoreItems(fullAreaName1, candAreaName1);
                }
                if (!(score > highScore)) continue;
                highScore = score;
            }
            score = highScore;
        }
        this.setAreaName1Score(score);
        this.setAreaName2Score(0.0);
        parsedAreaName3 = parsedAddress.getAreaName3();
        highScore = 0.0;
        if (parsedAreaName3 != null) {
            parsedAreaName3 = parsedAreaName3.toUpperCase();
            if (candTown != null) {
                highScore = scorer.scoreItems(parsedAreaName3, candTown.toUpperCase());
            }
            if (highScore != 1.0 && parsedAreaName4 == null && this.getAreaName4() != null && (score = scorer.scoreItems(parsedAreaName3, this.getAreaName4().toUpperCase())) > 0.5) {
                double d = highScore = score > highScore ? score : highScore;
            }
            if (highScore != 1.0) {
                String candAltTownString = geoRecord.getAltLanguageNames();
                String candAltTownTemp = null;
                String candAltTown = null;
                if (candAltTownString != null) {
                    StringTokenizer tokens = new StringTokenizer(candAltTownString, "/");
                    while (tokens.hasMoreTokens()) {
                        candAltTown = tokens.nextToken();
                        if (candAltTown == null || !((score = scorer.scoreItems(candAltTownTemp = CHE_AddressTerm.removeCommonWords(candAltTown, false), parsedAreaName3)) > highScore) || (highScore = score) != 1.0) continue;
                        this.getSegment().setLeftAreaName3(candAltTown);
                        this.getSegment().setRightAreaName3(candAltTown);
                        candAltTownTemp = null;
                        break;
                    }
                }
            }
        }
        this.setAreaName3Score(highScore);
        boolean checkAlias = false;
        if (parsedAreaName3 != null && highScore < minScoreConsidered) {
            checkAlias = true;
        }
        if (checkAlias) {
            String postcode = this.getPostCode1();
            double geoInfoHighScore = 0.0;
            double totalHighScore = 0.0;
            String bestArea = null;
            ArrayList geoInfoRecordArray = CHE_DataManager.getGeoInfoAlias(this.getAreaName3(), postcode, 0);
            if (geoInfoRecordArray != null) {
                for (int n = 0; n < geoInfoRecordArray.size(); ++n) {
                    geoRecord = (EMEA_GeoInfoRecord)((Object)geoInfoRecordArray.get(n));
                    String recordTownAlias = null;
                    recordTownAlias = CHE_ParsePostAddressRule.removeCommonWords(geoRecord.getAreaName4());
                    if (recordTownAlias == null || recordTownAlias.length() == 0) {
                        recordTownAlias = geoRecord.getAreaName4();
                    }
                    double geoInfoScore = 0.0;
                    double totalScore = 0.0;
                    if (!this.areaName2Matched && !this.areaName3Matched && CHE_InternalCandidateAddress.toUpper(recordTownAlias.charAt(0)) != parsedArea3FirstCh) continue;
                    geoInfoScore = scorer.scoreItems(parsedAreaName3, FRA_Abbreviations.expandAbbreviations(recordTownAlias));
                    totalScore = geoInfoScore;
                    if (totalScore > totalHighScore) {
                        geoInfoHighScore = geoInfoScore;
                        totalHighScore = totalScore;
                        bestArea = recordTownAlias;
                    }
                    if (geoInfoHighScore == 1.0) break;
                }
            }
            if (geoInfoHighScore > this.getAreaName3Score() && geoInfoHighScore > minScoreConsidered) {
                this.setAreaName4(bestArea);
                this.setAreaName3Score(geoInfoHighScore);
                this.getAdditionalFields().remove(VIRTUAL_TOWN_NAME);
            }
        }
        if (parsedAreaName3 != null && highScore < minScoreConsidered && candAreaName1 != null && parsedAreaName1 == null && parsedAddress.getPostCode1() != null && this.getPostCode1Score() == 1.0 && (tmp = scorer.scoreItems(parsedAreaName3, candAreaName1)) == 1.0) {
            this.setAreaName3Score(0.8);
            this.getAdditionalFields().put(KEY_AREA_NAME_3_MATCHED_AREA_NAME_1, "true");
        }
        highScore = scorer.scoreStrings(parsedAreaName4, candAreaName4);
        this.setAreaName4Score(highScore);
    }

    public CandidateAddress toCandidateAddress(Address input, IConstraints constraints) throws MapMarkerInternalException {
        CandidateAddress candidateAddress = this.superToCandidateAddress(input, constraints);
        this.performCandidateFieldCleanUp((IResponseCandidate)candidateAddress);
        Segment segment = this.getSegment();
        if (this.isAPCandidate() && segment != null) {
            CHE_Range range = (CHE_Range)segment.getRangeAt(0, 0);
            segment.setSegmentId(Long.toString(range.getPointID()));
        }
        this.populateSegmentId((Address)candidateAddress);
        if (candidateAddress.getPrecisionCode().startsWith("S4") && StringUtilities.isEmpty((String)candidateAddress.getAddressNumber()) && this.getInputNumber() != null && !StringUtilities.isEmpty((String)this.getInputNumber().getCombinedAddressNumber())) {
            StringBuilder s4FSA = new StringBuilder(candidateAddress.getFormattedStreetAddress());
            s4FSA.append(" ");
            s4FSA.append(this.getInputNumber().getCombinedAddressNumber());
            candidateAddress.setFormattedStreetAddress(s4FSA.toString());
            candidateAddress.setAddressNumber(this.getInputNumber().getCombinedAddressNumber());
        }
        Address address = constraints.getHandler().getInputAddress();
        candidateAddress.setCountry(address.getCountry());
        candidateAddress.addKeyValueToAdditionalFields("StreetDataType", this.getVendorCode());
        return candidateAddress;
    }

    public String getFormattedLocationAddress() {
        StringBuffer str = new StringBuffer();
        String tmp = this.getPostCode1();
        if (tmp != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getPostCode2()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getAreaName3()) != null) {
            str.append(tmp);
        }
        return str.toString().trim();
    }

    @Override
    public String getPostCode1() {
        Segment segment;
        String postCode1 = super.getPostCode1();
        if (postCode1 == null && (segment = this.getSegment()) != null) {
            postCode1 = segment.getLeftPostCode1();
        }
        if (postCode1 != null && postCode1.length() > 4) {
            postCode1 = postCode1.substring(1);
        }
        return postCode1;
    }

    private String getFormatOutStreetforRG(IResponseCandidate addr) {
        AddressImpl locAddr = new AddressImpl();
        CHE_InternalCandidateAddress iCand = new CHE_InternalCandidateAddress((Address)addr);
        locAddr.setMainAddress(addr.getFormattedStreetAddress());
        locAddr.setAreaName3(addr.getAreaName3());
        locAddr.setPostCode1(addr.getPostCode1());
        CHE_HandlerImpl handler = new CHE_HandlerImpl();
        CHE_PreParseHandler ppHandler = new CHE_PreParseHandler();
        ppHandler.preParse((Address)locAddr, handler);
        String cCode = ((CHE_Handler)handler).getCountryCode();
        if (cCode.equalsIgnoreCase("FRA")) {
            return this.getFormattedFRAStreetAddress();
        }
        return this.getFormattedStreetAddress();
    }

    public CandidateAddress superToCandidateAddress(Address input, IConstraints constraints) throws MapMarkerInternalException {
        String preMainCommon;
        String preAddrCommon;
        String prefix;
        Segment segment;
        boolean bPostDirMatched;
        boolean bPreDirMatched;
        int debugLevel = DebugLevel.getDebugLevel((int)1);
        ResourceBundle errorBundle = this.loadResourceBundleForLocale(constraints.getClientLocale());
        CandidateAddress candidate = new CandidateAddress((Address)this);
        CHE_Handler localHandler = (CHE_Handler)constraints.getHandler();
        String cCode = localHandler.getCountryCode();
        if (cCode.equalsIgnoreCase("FRA")) {
            candidate.setFormattedStreetAddress(this.getFormattedFRAStreetAddress());
        } else {
            candidate.setFormattedStreetAddress(this.getFormattedStreetAddress());
        }
        candidate.setFormattedLocationAddress(this.getFormattedLocationAddress());
        candidate.setSourceStreetID(this.getStreetOffset());
        if (this.fromUserDictionary()) {
            candidate.setFromUserDictionary();
        }
        candidate.setConfiguredDictionaryNumber(this.getDictionaryPriority() + 1);
        if (this.isCloseMatch()) {
            candidate.setCloseMatch();
        }
        if (this.getCountryScore() == 1.0) {
            candidate.setCountryMatched();
        }
        if (!(this.fieldExists(input.getPostAddress()) && this.getPostAddressScore() != 1.0 || this.fieldExists(input.getPreAddress()) && this.getPreAddressScore() != 1.0)) {
            candidate.setStreetPrefixAndSuffixMatched();
        }
        if (this.fieldExists(input.getMainAddress()) && this.getMainAddressScore() == 1.0) {
            candidate.setStreetNameMatched();
        }
        boolean bl = this.fieldExists(input.getPreDirectional()) ? this.getAdditionalParserFieldsScore() == 2.0 : (bPreDirMatched = true);
        boolean bl2 = this.fieldExists(input.getPostDirectional()) ? this.getAdditionalParserFieldsScore() == 2.0 : (bPostDirMatched = true);
        if (bPreDirMatched) {
            candidate.setPreDirectionalMatched();
        }
        if (bPostDirMatched) {
            candidate.setPostDirectionalMatched();
        }
        if (this.getPreThoroughfareTypeScore() == 1.0 && this.getPostThoroughfareTypeScore() == 1.0) {
            candidate.setThoroughfareTypeMatched();
        }
        if (this.fieldExists(input.getPostCode1()) && this.getPostCode1Score() == 1.0) {
            candidate.setPostalCode1Matched();
        }
        if (this.fieldExists(input.getPostCode2()) && this.getPostCode2Score() == 1.0) {
            candidate.setPostalCode2Matched();
        }
        if (this.fieldExists(input.getAreaName1()) && this.getAreaName1Score() == 1.0) {
            candidate.setAreaName1Matched();
        }
        if (this.fieldExists(input.getAreaName2()) && this.getAreaName2Score() == 1.0) {
            candidate.setAreaName2Matched();
        }
        if (this.fieldExists(input.getAreaName3()) && this.getAreaName3Score() == 1.0) {
            candidate.setAreaName3Matched();
        }
        if (this.fieldExists(input.getAreaName4()) && this.getAreaName4Score() == 1.0) {
            candidate.setAreaName4Matched();
        }
        if (this.fieldExists(input.getPlaceName()) && this.getPlaceNameScore() == 1.0) {
            candidate.setPlaceNameMatched();
        }
        ParsedNumber num = new ParsedNumber(this.getAddressNumber());
        ParsedNumber unitNum = new ParsedNumber(input.getUnitValue());
        if (!num.isEmpty() && this.getAddressNumberScore() == 1.0) {
            candidate.setAddressNumberMatched();
            candidate.setAddressNumber(num);
        }
        int maxRanges = constraints.getMaxRanges();
        candidate.setNumberOfReturnableRanges(maxRanges);
        if (maxRanges != 0) {
            CandidateRange candidateRange;
            segment = this.getSegment();
            int numLeftRanges = segment.getRangeCount(0);
            int numRightRanges = segment.getRangeCount(1);
            ArrayList rangeList = new ArrayList();
            if (numLeftRanges > 0) {
                rangeList.addAll(segment.getRanges(0));
            }
            if (numRightRanges > 0) {
                rangeList.addAll(segment.getRanges(1));
            }
            Collections.sort(rangeList, new CHE_RangeComparator(num));
            for (Range range : rangeList) {
                CandidateRange candRange = range.toCandidateRange(num, 1, unitNum, constraints);
                candidate.addCandidateRange(candRange);
            }
            if (!num.isEmpty() && (candidateRange = candidate.getRangeAt(0)) != null && this.isAPCandidate()) {
                candidate.setAddressNumber(candidateRange.getLowAddress());
            }
        } else if (this.isAPCandidate()) {
            segment = this.getSegment();
            ArrayList rangeList = new ArrayList(segment.getRanges(0));
            Collections.sort(rangeList, new CHE_RangeComparator(num));
            if (rangeList.size() >= 1) {
                candidate.setAddressNumber(((Range)rangeList.get(0)).getParsedFrom());
            }
        }
        String string = prefix = input.getParsedAddressNumber() != null ? input.getParsedAddressNumber().getAddressPrefix() : "";
        if (input.getAddressNumber() == null || !StringUtilities.isEmpty((String)prefix) && input.getAddressNumber().equals(prefix)) {
            if (!this.isAPCandidate()) {
                candidate.setAddressNumberMatched();
            } else {
                CandidateRange range = candidate.getRangeAt(0);
                if (range != null) {
                    candidate.setAddressNumber(range.getLowAddress());
                    candidate.setPlaceName(range.getPlaceName());
                    if (this.getAddressNumberScore() == 1.0) {
                        candidate.setAddressNumberMatched();
                    } else if (this.fieldExists(input.getPlaceName()) && this.getPlaceNameScore() == 1.0) {
                        candidate.setAddressNumberMatched();
                    }
                }
            }
        }
        if (this.isAPCandidate()) {
            this.updateFormatStreetAddress(candidate, cCode);
        }
        this.setGeocodedPoint(candidate, debugLevel, constraints, errorBundle);
        String geores = this.buildPrecisionCode(candidate);
        candidate.addKeyValueToAdditionalFields("RESULT_CODE", geores);
        HashMap fields = candidate.getAdditionalFields();
        StringBuffer buf = new StringBuffer(100);
        String preDir = candidate.getPreDirectional();
        if (preDir != null) {
            buf.append(preDir);
            buf.append(' ');
        }
        if ((preAddrCommon = (String)fields.get(PRE_ADDR_COMMON)) != null) {
            buf.append(preAddrCommon);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if (candidate.getPreAddress() != null) {
            String preAddress = candidate.getPreAddress();
            buf.append(preAddress);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if ((preMainCommon = (String)fields.get(PRE_MAIN_ADDRESS_COMMON)) != null && preMainCommon.length() != 0) {
            buf.append(preMainCommon);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        candidate.setPreAddress(buf.toString().trim());
        CHE_AddressUtils.converttoCamelCase(candidate);
        return candidate;
    }

    private void updateFormatStreetAddress(CandidateAddress candidate, String cCode) {
        String addressNumber = candidate.getAddressNumber();
        String fsa = candidate.getFormattedStreetAddress();
        StringBuffer buf = new StringBuffer();
        if (!(StringUtilities.isEmpty((String)addressNumber) || StringUtilities.isEmpty((String)fsa) || fsa.contains(addressNumber))) {
            if (cCode.equalsIgnoreCase("FRA")) {
                buf.append(addressNumber).append(" ").append(fsa);
            } else {
                buf.append(fsa).append(" ").append(addressNumber);
            }
            candidate.setFormattedStreetAddress(buf.toString());
        }
    }

    public boolean isAPCandidate() {
        return ((CHE_StreetCandidateAddress)this.getStreetCandidateAddress()).isAPCandidate();
    }

    protected DirectPosition getAddressNumberHousePoint() {
        DirectPosition addresNumberPoint = super.getAddressNumberHousePoint();
        if (addresNumberPoint == null && this.isAPCandidate()) {
            Segment segment = this.getSegment();
            addresNumberPoint = segment.getHousePoint(segment.getRangeAt(0, 0).getRangeNumber());
        }
        return addresNumberPoint;
    }

    public void scoreAdditionalParserFields(ScoringAddress parsedAddress) {
        String cand_pre_street_type_common = (String)this.getAdditionalFields().get(PRE_STREET_TYPE_COMMON);
        String cand_post_street_type_common = (String)this.getAdditionalFields().get(POST_STREET_TYPE_COMMON);
        String cand_pre_addr_common = (String)this.getAdditionalFields().get(PRE_ADDR_COMMON);
        String cand_post_addr_common = (String)this.getAdditionalFields().get(POST_ADDR_COMMON);
        String candidatePreMainCommon = (String)this.getAdditionalFields().get(PRE_MAIN_ADDRESS_COMMON);
        String AddressPreMainCommon = (String)parsedAddress.getAdditionalFields().get(PRE_MAIN_ADDRESS_COMMON);
        EMEA_ScoringAddress input = (EMEA_ScoringAddress)parsedAddress;
        String input_pre_addr = (String)input.getAdditionalFields().get(PRE_ADDR_COMMON);
        String input_post_addr = (String)input.getAdditionalFields().get(POST_ADDR_COMMON);
        String input_pre_street_type_common = (String)input.getAdditionalFields().get(PRE_STREET_TYPE_COMMON);
        String input_post_street_type_common = (String)input.getAdditionalFields().get(POST_STREET_TYPE_COMMON);
        String parsedPreSep = (String)parsedAddress.getAdditionalFields().get(PRE_SEPARATOR_CHAR);
        String parsedPostSep = (String)parsedAddress.getAdditionalFields().get(POST_SEPARATOR_CHAR);
        String candidatePreSep = this.getAdditionalFieldForKey(PRE_SEPARATOR_CHAR);
        String candidatePostSep = this.getAdditionalFieldForKey(POST_SEPARATOR_CHAR);
        double pre_addr_score = input.scoreItems(cand_pre_addr_common, input_pre_addr);
        double post_addr_score = input.scoreItems(cand_post_addr_common, input_post_addr);
        double pre_street_type_common_score = input.scoreItems(cand_pre_street_type_common, input_pre_street_type_common);
        double post_street_type_common_score = input.scoreItems(cand_post_street_type_common, input_post_street_type_common);
        double score = pre_addr_score + post_addr_score + pre_street_type_common_score + post_street_type_common_score;
        double preSeperatorScore = input.scoreItems(parsedPreSep, candidatePreSep);
        double postSeperatorScore = input.scoreItems(parsedPostSep, candidatePostSep);
        if (0.5 < preSeperatorScore && preSeperatorScore < 1.0) {
            preSeperatorScore = 0.5;
        }
        if (0.5 < postSeperatorScore && postSeperatorScore < 1.0) {
            postSeperatorScore = 0.5;
        }
        score += input.scoreItems(candidatePreMainCommon, AddressPreMainCommon);
        this.setAdditionalParserFieldsScore(score += preSeperatorScore + postSeperatorScore);
    }

    public void computeScores(ScoringAddress parsedAddress, String charsToIgnore) {
        super.computeScores(parsedAddress, charsToIgnore);
        this.scoreAdditionalParserFields(parsedAddress);
    }

    @Override
    public String getFormattedStreetAddress() {
        return CHE_InternalCandidateAddress.reconstructAddress(this);
    }

    public int compare(Object o1, Object o2) {
        double score2;
        CHE_InternalCandidateAddress cand1 = (CHE_InternalCandidateAddress)((Object)o1);
        CHE_InternalCandidateAddress cand2 = (CHE_InternalCandidateAddress)((Object)o2);
        boolean bCand1Match = cand1.isCloseMatch();
        boolean bCand2Match = cand2.isCloseMatch();
        if (!bCand1Match && bCand2Match) {
            return -1;
        }
        if (bCand1Match && !bCand2Match) {
            return 1;
        }
        bCand1Match = cand1.isPerfectMatch();
        bCand2Match = cand2.isPerfectMatch();
        if (!bCand1Match && bCand2Match) {
            return -1;
        }
        if (bCand1Match && !bCand2Match) {
            return 1;
        }
        double score1 = cand1.getCombinedAddressScore();
        if (score1 == (score2 = cand2.getCombinedAddressScore())) {
            score1 = cand1.getCombinedAdditionalFieldScore();
            if (score1 < (score2 = cand2.getCombinedAdditionalFieldScore())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = cand1.getAreaName3Score();
            if (score1 < (score2 = cand2.getAreaName3Score())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = cand1.getAreaName4Score();
            if (score1 < (score2 = cand2.getAreaName4Score())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = cand1.getPostCode1Score();
            if (score1 < (score2 = cand2.getPostCode1Score())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = cand1.getMainAddressScore();
            if (score1 < (score2 = cand2.getMainAddressScore())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = cand1.getPlaceNameScore();
            if (score1 < (score2 = cand2.getPlaceNameScore())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = cand1.getAddressNumberScore();
            if (score1 < (score2 = cand2.getAddressNumberScore())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            if (score1 != 1.0 && score2 != 1.0) {
                if (cand1.hasClosestRange() && cand2.hasClosestRange()) {
                    long cand2Offset;
                    Range cand1Closest = cand1.getSegment().getRangeAt(cand1.getClosestRangeNumber(), cand1.getClosestSegmentSide());
                    Range cand2Closest = cand2.getSegment().getRangeAt(cand2.getClosestRangeNumber(), cand2.getClosestSegmentSide());
                    long cand1Offset = cand1Closest.getRangeOffset();
                    if (cand1Offset < (cand2Offset = cand2Closest.getRangeOffset())) {
                        return 1;
                    }
                    if (cand1Offset > cand2Offset) {
                        return -1;
                    }
                } else {
                    if (cand1.hasClosestRange()) {
                        return 1;
                    }
                    if (cand2.hasClosestRange()) {
                        return -1;
                    }
                }
            }
        } else {
            if (score1 < score2) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    private static char toUpper(char ch) {
        if (ch >= 'a' && ch <= 'z') {
            return (char)(ch - 32);
        }
        return ch;
    }

    public int compareTo(Object o1) {
        return this.compare((Object)this, o1);
    }

    @Override
    public String getAreaName2() {
        String areaName2 = null;
        int ctr = 0;
        while (areaName2 == null) {
            areaName2 = this.fetchAreaName2(ctr, this);
            ++ctr;
        }
        return areaName2;
    }

    private String getAreaNameFromSegmentSide(InternalCandidateAddress candiadte, Segment segment) {
        String value = null;
        switch (candiadte.getSegmentSide()) {
            case 0: {
                value = segment.getLeftAreaName2();
                break;
            }
            case 1: {
                value = segment.getRightAreaName2();
                break;
            }
            default: {
                value = this.getStreetCandidateAddress().getAreaName2();
            }
        }
        return value;
    }

    private String getAreaNameFromSegmentClosestSide(InternalCandidateAddress candiadte, Segment segment) {
        String value = null;
        switch (candiadte.getClosestSegmentSide()) {
            case 0: {
                value = segment.getLeftAreaName2();
                break;
            }
            case 1: {
                value = segment.getRightAreaName2();
                break;
            }
            default: {
                value = this.getStreetCandidateAddress().getAreaName2();
            }
        }
        return value;
    }

    private String fetchAreaName2(int scenario, InternalCandidateAddress candidate) {
        String areaName2 = null;
        Segment segment = candidate.getSegment();
        switch (scenario) {
            case 1: {
                areaName2 = this.getAreaNameFromSegmentSide(this, segment);
                break;
            }
            case 2: {
                areaName2 = this.getAreaNameFromSegmentClosestSide(this, segment);
                break;
            }
            case 3: {
                areaName2 = segment.getLeftAreaName2();
                break;
            }
            case 4: {
                areaName2 = segment.getGeoInfoRecord().getAreaName2();
            }
        }
        return areaName2;
    }

    public static String reconstructMainAddress(Address pa) {
        String unparsedAddress = pa.getGenericField1();
        if (unparsedAddress != null && unparsedAddress.length() > 0) {
            return unparsedAddress;
        }
        StringBuffer buff = new StringBuffer();
        String tmp = CHE_InternalCandidateAddress.noNulls(pa.getMainAddress());
        if (tmp.length() > 0) {
            buff.append(tmp);
            buff.append(' ');
        }
        if ((tmp = CHE_InternalCandidateAddress.noNulls((String)pa.getAdditionalFields().get(PRE_MAIN_ADDRESS_COMMON))).length() > 0) {
            buff.append(tmp);
            buff.append(' ');
        }
        if ((tmp = CHE_InternalCandidateAddress.noNulls(pa.getPostAddress())).length() > 0) {
            buff.append(' ');
            buff.append(tmp);
            buff.append(' ');
        }
        return buff.toString();
    }

    public static String reconstructFRAAddress(InternalCandidateAddress cand) {
        StringBuffer buff = new StringBuffer();
        HashMap additionalFielfs = cand.getAdditionalFields();
        if (additionalFielfs != null) {
            buff.append(cand.getAddressNumber() == null ? "" : cand.getAddressNumber());
            buff.append(" ");
            buff.append(additionalFielfs.get(ORIGINAL_STREET_NAME));
            return buff.toString().trim();
        }
        if (cand.getGenericField4() != null) {
            buff.append(cand.getAddressNumber() == null ? "" : cand.getAddressNumber());
            buff.append(" ");
            buff.append(cand.getGenericField4());
            return buff.toString().trim();
        }
        String tmp = CHE_InternalCandidateAddress.noNulls((String)cand.getAdditionalFields().get("address.start"));
        if (tmp.length() > 0) {
            buff.append(tmp + " ");
        }
        if ((tmp = CHE_InternalCandidateAddress.noNulls(cand.getPreThoroughfareType())).length() > 0) {
            buff.append(tmp + " ");
        }
        if ((tmp = CHE_InternalCandidateAddress.noNulls(CHE_InternalCandidateAddress.reconstructMainAddress((Address)cand))).length() > 0) {
            buff.append(tmp);
        }
        if ((tmp = CHE_InternalCandidateAddress.noNulls(CHE_InternalCandidateAddress.getFormattedPreAddress((Address)cand))).length() > 0) {
            buff.append(tmp);
            if (!tmp.endsWith(" ")) {
                buff.append(' ');
            }
        }
        if ((tmp = CHE_InternalCandidateAddress.noNulls(cand.getAddressNumber())).length() > 0) {
            buff.append(' ');
            buff.append(tmp);
        }
        return buff.toString();
    }

    public String getFormattedFRAStreetAddress() {
        return CHE_InternalCandidateAddress.reconstructFRAAddress(this);
    }

    private ItemsCachedScore findCachedScore(String item1, String item2) {
        for (int i = 0; i < 20; ++i) {
            ItemsCachedScore cachedScore = m_scoreCache[i];
            if (cachedScore == null) {
                return null;
            }
            if (!cachedScore.equalItems(item1, item2)) continue;
            return cachedScore;
        }
        return null;
    }

    private void addIntoScoreCache(String item1, String item2, double score) {
        ItemsCachedScore cachedScore = new ItemsCachedScore(item1, item2, score);
        for (int i = 18; i >= 0; --i) {
            CHE_InternalCandidateAddress.m_scoreCache[i + 1] = m_scoreCache[i];
        }
        CHE_InternalCandidateAddress.m_scoreCache[0] = cachedScore;
    }

    private double scoreItems(String item1, String item2, StringScorer scorer) {
        return this.scoreItems(item1, item2, this.getCharsToIgnore(), scorer);
    }

    private double scoreItems(String item1, String item2, String charsToIgnore, StringScorer scorer) {
        double score = 0.0;
        if (item1 != null && item2 != null) {
            ItemsCachedScore cachedScore = this.findCachedScore(item1, item2);
            if (cachedScore != null) {
                score = cachedScore.getScore();
            } else {
                score = scorer.scoreString(item1, item2, charsToIgnore);
                this.addIntoScoreCache(item1, item2, score);
            }
        } else {
            score = scorer.scoreString(item1, item2, charsToIgnore);
        }
        return score;
    }

    public void scorePostalInformation(Address address) {
        double score = this.scoreItems(address.getPostCode1(), this.getPostCode1(), plainScorer);
        this.setPostCode1Score(score);
        score = this.scoreItems(address.getPostCode2(), this.getPostCode2(), plainScorer);
        this.setPostCode2Score(score);
    }

    public void scoreAddressNumber(ScoringAddress parsedAddress) {
        String addressNumber;
        int secondMatchedRange = -1;
        int secondSegmentSide = -1;
        ParsedNumber secondNumber = null;
        String firstAddressNumber = addressNumber = parsedAddress.getAddressNumber();
        String secondAddressNumber = null;
        if (addressNumber != null) {
            StringTokenizer st = new StringTokenizer(addressNumber, "-/ ");
            if (st.countTokens() > 1) {
                firstAddressNumber = st.nextToken();
                ParsedNumber parsedNumber = new ParsedNumber(firstAddressNumber);
                if (parsedNumber.getAddressNumberExists()) {
                    firstAddressNumber = Long.toString(parsedNumber.getAddressNumber());
                }
                while (st.hasMoreTokens() && (secondAddressNumber = st.nextToken()) != null) {
                    parsedNumber = new ParsedNumber(secondAddressNumber);
                    if (parsedNumber.getAddressNumberExists()) {
                        secondAddressNumber = Long.toString(parsedNumber.getAddressNumber());
                        break;
                    }
                    secondAddressNumber = null;
                }
            }
            if (secondAddressNumber != null) {
                parsedAddress.setAddressNumber(this.getFilteredDigitsFromAddressNumber(secondAddressNumber));
                super.scoreAddressNumber(parsedAddress);
                this.m_numAddrNumberFields = super.getInputNumber().getNumFields();
                this.m_numAddrNumberFieldsMatched = this.getCntAddressNumberFieldsMatched();
                if (this.getMatchedRangeNumber() >= 0 && this.getSegmentSide() >= 0) {
                    this.m_matchType = 2;
                    secondMatchedRange = this.getMatchedRangeNumber();
                    secondSegmentSide = this.getSegmentSide();
                    secondNumber = this.getInputNumber();
                    this.setCntAddressNumberFieldsMatched(0);
                }
                this.setInputNumber(null);
                this.setMatchedRangeNumber(-1);
                this.setSegmentSide(-1);
                this.setClosestRange(-1);
                super.setClosestSegmentSide(-1);
                this.setMatchingFlag(0);
            }
        }
        if (!StringUtilities.hasNumeric((String)firstAddressNumber) || !this.isAPCandidate()) {
            parsedAddress.setAddressNumber(this.getFilteredDigitsFromAddressNumber(firstAddressNumber));
        }
        super.scoreAddressNumber(parsedAddress);
        if (this.getInputNumber() != null && !this.isAPCandidate()) {
            this.m_numAddrNumberFields += this.getInputNumber().getNumFields();
            this.m_numAddrNumberFieldsMatched += this.getCntAddressNumberFieldsMatched();
            if (this.getMatchedRangeNumber() >= 0 && this.getSegmentSide() >= 0) {
                if (this.m_matchType == 2) {
                    if (secondMatchedRange == this.getMatchedRangeNumber() && secondSegmentSide == this.getSegmentSide()) {
                        this.m_matchType = 4;
                        this.m_addressNumber = firstAddressNumber;
                    } else {
                        this.m_matchType = 3;
                        this.m_addressNumber = firstAddressNumber;
                        ++this.m_numAddrNumberFields;
                    }
                } else {
                    this.m_matchType = 1;
                    this.m_addressNumber = firstAddressNumber;
                }
            }
            if (this.m_matchType == 2) {
                this.setInputNumber(secondNumber);
                this.setMatchedRangeNumber(secondMatchedRange);
                this.setSegmentSide(secondSegmentSide);
                this.m_addressNumber = secondAddressNumber;
            }
            parsedAddress.setAddressNumber(addressNumber);
        }
    }

    public String getAddressString(String unformattedStreetAddress, String originalAddress) {
        String result = null;
        if (unformattedStreetAddress != null) {
            unformattedStreetAddress = unformattedStreetAddress.replaceAll(",", "");
            unformattedStreetAddress = unformattedStreetAddress.replaceAll("/", " ");
            int unformattedStreetAddressLen = (unformattedStreetAddress = this.removeSpaces(unformattedStreetAddress)).indexOf(originalAddress);
            if (unformattedStreetAddressLen != -1) {
                unformattedStreetAddress = unformattedStreetAddress.replaceAll(originalAddress, " ");
            }
            result = unformattedStreetAddress;
        }
        return result;
    }

    public String removeSpaces(String str) {
        StringBuffer strbuf = new StringBuffer();
        String[] strarr = str.split(" ");
        for (int i = 0; i < strarr.length; ++i) {
            if (strarr[i].toString().equals("")) continue;
            strbuf.append(" " + strarr[i]);
        }
        return strbuf.toString().trim();
    }

    public void localscoreAddressNumber(ScoringAddress address) {
        int secondMatchedRange = -1;
        int secondSegmentSide = -1;
        ParsedNumber secondNumber = null;
        String addressNumber = address.getAddressNumber();
        if (addressNumber == null) {
            addressNumber = " ";
        }
        String firstAddressNumber = addressNumber;
        String secondAddressNumber = null;
        if (addressNumber != null) {
            StringTokenizer st = new StringTokenizer(addressNumber, " -/");
            if (st.countTokens() > 1) {
                firstAddressNumber = st.nextToken();
                ParsedNumber parsedNumber = new ParsedNumber(firstAddressNumber);
                if (parsedNumber.getAddressNumberExists()) {
                    firstAddressNumber = Long.toString(parsedNumber.getAddressNumber());
                }
                while (st.hasMoreTokens() && (secondAddressNumber = st.nextToken()) != null) {
                    parsedNumber = new ParsedNumber(secondAddressNumber);
                    if (parsedNumber.getAddressNumberExists()) {
                        secondAddressNumber = Long.toString(parsedNumber.getAddressNumber());
                        break;
                    }
                    secondAddressNumber = null;
                }
            }
            if (secondAddressNumber != null) {
                address.setAddressNumber(secondAddressNumber);
                super.scoreAddressNumber(address);
                this.m_numAddrNumberFields = super.getInputNumber().getNumFields();
                this.m_numAddrNumberFieldsMatched = this.getCntAddressNumberFieldsMatched();
                if (this.getMatchedRangeNumber() >= 0 && this.getSegmentSide() >= 0) {
                    this.m_matchType = 2;
                    secondMatchedRange = this.getMatchedRangeNumber();
                    secondSegmentSide = this.getSegmentSide();
                    secondNumber = this.getInputNumber();
                    this.setCntAddressNumberFieldsMatched(0);
                }
                this.setInputNumber(null);
                this.setMatchedRangeNumber(-1);
                this.setSegmentSide(-1);
                this.setClosestRange(-1);
                super.setClosestSegmentSide(-1);
                this.setMatchingFlag(0);
            }
        }
        address.setAddressNumber(firstAddressNumber);
        super.scoreAddressNumber(address);
        if (this.getInputNumber() != null) {
            this.m_numAddrNumberFields += super.getInputNumber().getNumFields();
            this.m_numAddrNumberFieldsMatched += this.getCntAddressNumberFieldsMatched();
            if (this.getMatchedRangeNumber() >= 0 && this.getSegmentSide() >= 0) {
                if (this.m_matchType == 2) {
                    if (secondMatchedRange == this.getMatchedRangeNumber() && secondSegmentSide == this.getSegmentSide()) {
                        this.m_matchType = 4;
                    } else {
                        this.m_matchType = 3;
                        ++this.m_numAddrNumberFields;
                    }
                } else {
                    this.m_matchType = 1;
                }
            }
            if (this.m_matchType == 2) {
                this.setInputNumber(secondNumber);
                this.setMatchedRangeNumber(secondMatchedRange);
                this.setSegmentSide(secondSegmentSide);
            }
            if (addressNumber.equals(" ")) {
                this.setInputNumber(null);
            } else {
                address.setAddressNumber(addressNumber);
            }
        }
    }

    public void setAreaName4(String areaName4) {
        this.m_CHEAreaName4 = areaName4;
    }

    @Override
    public String getAreaName4() {
        if (this.m_CHEAreaName4 != null) {
            return this.m_CHEAreaName4;
        }
        return super.getAreaName4();
    }

    @Override
    public String getAddressNumber() {
        if (this.m_addressNumber != null) {
            return this.m_addressNumber;
        }
        return super.getAddressNumber();
    }

    private String getFilteredDigitsFromAddressNumber(String addressNumber) {
        Pattern pattern;
        Matcher match;
        String houseNumber = null;
        if (addressNumber != null && (match = (pattern = Pattern.compile("[0-9]*")).matcher(addressNumber)).find()) {
            houseNumber = match.group().trim();
        }
        return houseNumber;
    }

    private void performCandidateFieldCleanUp(IResponseCandidate candidateAddress) {
        candidateAddress.setGenericField1(null);
        candidateAddress.setGenericField2(null);
        candidateAddress.setGenericField3(null);
        candidateAddress.setGenericField4(null);
        HashMap map = candidateAddress.getAdditionalFields();
        if (map != null) {
            map.remove(POST_STREET_TYPE_COMMON);
            map.remove(PRE_STREET_TYPE_COMMON);
            map.remove(PRE_ADDR_COMMON);
            map.remove(POST_ADDR_COMMON);
            map.remove(CAND_FULL_TOWN);
            map.remove(PRE_MAIN_COMMON_ADDRESS);
            map.remove(POST_STREET_COMMON_TYPE);
            map.remove(STREET_NUMBER);
            map.remove("input_house_number");
            map.remove("unparsed_input_street");
            map.remove(EXPANDED_PRE_MAIN_COMMON);
            map.remove(ORIGINAL_STREET_NAME);
        }
    }

    public ReverseGeocodeCandidateAddress toCandidateAddress(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) throws MapMarkerInternalException {
        if (this.isAPCandidate()) {
            Segment segment = this.getSegment();
            CHE_Range range = (CHE_Range)segment.getRangeAt(0, 0);
            segment.setSegmentId(Long.toString(range.getPointID()));
        }
        ReverseGeocodeCandidateAddress cand = super.toCandidateAddress(location, constraints);
        CHE_AddressUtils.converttoCamelCaseRG(cand);
        String streetStr = this.getFormatOutStreetforRG((IResponseCandidate)cand);
        cand.setFormattedStreetAddress(streetStr);
        this.performCandidateFieldCleanUp((IResponseCandidate)cand);
        if (StringUtilities.equalStringsIgnoreCase((String)cand.getAreaName1(), (String)"LIECHTENSTEIN") && StringUtilities.equalStringsIgnoreCase((String)cand.getCountry(), (String)"CHE")) {
            cand.setCountry("LIE");
        }
        return cand;
    }

    @Override
    public void setGeocodedPoint(CandidateAddress candidate, int debugLevel, IConstraints constraints, ResourceBundle errorBundle) {
        Segment segment = this.getSegment();
        int segmentPointCount = segment.getSegmentPointCount();
        if (segment.isHouseSegment()) {
            DirectPosition housePoint = this.getAddressNumberHousePoint();
            if (housePoint != null) {
                DirectPosition centerlineOffsetPoint;
                DirectPosition directPosition = centerlineOffsetPoint = constraints.getUseCenterlineOffset() ? this.getCenterlineOffsetLocation(housePoint, constraints.getHandler().getMatchResults(), constraints) : null;
                if (centerlineOffsetPoint != null) {
                    candidate.setLocation(centerlineOffsetPoint);
                    candidate.setLocationPrecision(18);
                } else {
                    candidate.setLocation(housePoint);
                    candidate.setLocationPrecision(16);
                }
            }
        } else if (this.isPointHouseCandidate(constraints)) {
            DirectPosition pointHouseLocation = segment.getSegmentPointAt(0);
            if (this.hasMatchingRange() || this.hasClosestRange()) {
                DirectPosition centerlineOffsetPoint;
                DirectPosition directPosition = centerlineOffsetPoint = constraints.getUseCenterlineOffset() ? this.getCenterlineOffsetLocation(pointHouseLocation, constraints.getHandler().getMatchResults(), constraints) : null;
                if (centerlineOffsetPoint != null) {
                    candidate.setLocation(centerlineOffsetPoint);
                    candidate.setLocationPrecision(18);
                } else {
                    candidate.setLocation(pointHouseLocation);
                    candidate.setLocationPrecision(16);
                }
            } else {
                candidate.setLocation(pointHouseLocation);
                candidate.setLocationPrecision(2);
            }
        } else if (segmentPointCount == 1) {
            candidate.setLocation(segment.getSegmentPointAt(0));
            candidate.setLocationPrecision(1);
        } else if (segmentPointCount != 0) {
            int rangeNumber;
            int segmentSide = this.getSegmentSide();
            if (segmentSide < 0) {
                segmentSide = this.getClosestSegmentSide();
            }
            if ((rangeNumber = this.getMatchedRangeNumber()) < 0) {
                rangeNumber = this.getClosestRangeNumber();
            }
            if (segmentSide < 0 || rangeNumber < 0) {
                candidate.setLocation(Interpolator.interpolateShapePath((List)segment.getSegmentPoints()));
                if (candidate.getLocationPoint() != null) {
                    candidate.setLocationPrecision(2);
                }
            } else {
                List pointHouseCandidates = this.findAllPointHouseCandidates(constraints);
                if (pointHouseCandidates == null) {
                    double percentage = this.getHouseNumberPercentage(segmentSide, rangeNumber, this.getParsedAddressNumber());
                    if (this.getSecondHNRangedAddress() != null) {
                        double percentage2 = this.getHouseNumberPercentage(segmentSide, rangeNumber, this.getSecondHNRangedAddress());
                        percentage = (percentage + percentage2) / 2.0;
                    }
                    candidate.setLocation(Interpolator.interpolate((List)segment.getSegmentPoints(), (segmentSide == 0 ? 1 : 0) != 0, (double)percentage, (Length)constraints.getCornerOffsetAsLength(), (Length)constraints.getStreetOffsetAsLength()));
                    if (candidate.getLocationPoint() != null) {
                        candidate.setLocationPrecision(1);
                    }
                } else {
                    DirectPosition exactPointHouse = this.findExactPointHouse(pointHouseCandidates);
                    if (exactPointHouse != null) {
                        candidate.setLocation(exactPointHouse);
                        candidate.setLocationPrecision(16);
                    } else {
                        this.filterPointCandidates(pointHouseCandidates, segmentSide);
                        this.interpolateUsingPointHouses(candidate, pointHouseCandidates, constraints, segmentSide, rangeNumber);
                    }
                }
            }
        } else {
            DirectPosition exactPointHouse;
            List pointCandidates = this.findAllPointHouseCandidates(constraints);
            if (pointCandidates != null && (exactPointHouse = this.findExactPointHouse(pointCandidates)) != null) {
                candidate.setLocation(exactPointHouse);
                candidate.setLocationPrecision(16);
            }
        }
        if (candidate.getLocationPrecision() != 0) {
            CoordSys clientCoordSys = constraints.getClientCoordinateSystemObject();
            candidate.setLocation(CoordConvertor.transformPointFromWGS84((CoordSys)clientCoordSys, (DirectPosition)candidate.getLocationPoint()));
            candidate.setCoordSysString(CoordSysUtilities.getSRSName((CoordSys)clientCoordSys));
        }
    }

    static {
        CHE_RANGE = 5;
        plainScorer = new StringScorer(false, new Locale("ch", "CH"));
        m_scoreCache = new ItemsCachedScore[20];
    }

    private class CHE_RangeComparator
    implements Comparator<Range> {
        private ParsedNumber m_InputNumber;

        public CHE_RangeComparator(ParsedNumber inputnumber) {
            this.m_InputNumber = inputnumber;
        }

        @Override
        public int compare(Range range1, Range range2) {
            long offsetDifferenceRange2;
            int value = 0;
            long offsetDifferenceRange1 = CHE_AddressUtils.computeOffsetDifference(this.m_InputNumber, range1);
            if (offsetDifferenceRange1 < (offsetDifferenceRange2 = CHE_AddressUtils.computeOffsetDifference(this.m_InputNumber, range2))) {
                value = -1;
            } else if (offsetDifferenceRange2 < offsetDifferenceRange1) {
                value = 1;
            } else if (offsetDifferenceRange1 == offsetDifferenceRange2) {
                long numberofFieldMatchedinRange2;
                long numberofFieldMatchedinRange1 = range1.getNumberFieldsMatched();
                if (numberofFieldMatchedinRange1 < (numberofFieldMatchedinRange2 = (long)range2.getNumberFieldsMatched())) {
                    value = 1;
                } else if (numberofFieldMatchedinRange2 < numberofFieldMatchedinRange1) {
                    value = -1;
                } else if (numberofFieldMatchedinRange1 == numberofFieldMatchedinRange2) {
                    String inputNumber = this.m_InputNumber.getCombinedAddressNumber();
                    String range1number = range1.getParsedFrom().getCombinedAddressNumber();
                    String range2number = range2.getParsedFrom().getCombinedAddressNumber();
                    if (inputNumber != null) {
                        if (inputNumber.compareTo(range1number) < inputNumber.compareTo(range2number)) {
                            value = 1;
                        } else if (inputNumber.compareTo(range1number) > inputNumber.compareTo(range2number)) {
                            value = -1;
                        }
                    }
                }
            }
            return value;
        }
    }

    class ItemsCachedScore {
        private double score;
        private String firstItem;
        private String secondItem;

        public ItemsCachedScore(String item1, String item2, double score) {
            this.firstItem = item1;
            this.secondItem = item2;
            this.score = score;
        }

        public double getScore() {
            return this.score;
        }

        public boolean equalItems(String item1, String item2) {
            return item1 != null && item1.equals(this.firstItem) && item2 != null && item2.equals(this.secondItem);
        }
    }
}

