/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE;

import com.mapinfo.coordsys.CoordSys;
import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoRecord;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.InternalIntersectionCandidateAddress;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.util.DoublePoint;
import java.util.HashMap;

public class CHE_InternalIntersectionCandidateAddress
extends InternalIntersectionCandidateAddress {
    public CHE_InternalIntersectionCandidateAddress(InternalCandidateAddress candidate1, InternalCandidateAddress candidate2) {
        super(candidate1, candidate2);
    }

    public CandidateAddress toCandidateAddress(Address input, IConstraints constraints) throws MapMarkerInternalException {
        CandidateAddress returnCandidate = this.superToCandidateAddress(input, constraints);
        return returnCandidate;
    }

    public CandidateAddress superToCandidateAddress(Address input, IConstraints constraints) throws MapMarkerInternalException {
        if (!this.isCloseMatch()) {
            return null;
        }
        InternalCandidateAddress candidate1 = this.getCandidate1();
        InternalCandidateAddress candidate2 = this.getCandidate2();
        CandidateAddress returnCandidate = new CandidateAddress((Address)candidate1);
        returnCandidate.setPostAddress(null);
        returnCandidate.setPreAddress(null);
        returnCandidate.setPostThoroughfareType(null);
        returnCandidate.setPreThoroughfareType(null);
        returnCandidate.setAddressNumber((String)null);
        returnCandidate.setPreDirectional(null);
        returnCandidate.setPostDirectional(null);
        if (input.getPostCode1() != null && input.getPostCode1().length() != 0 && input.getPostCode1().equals(candidate1.getPostCode1()) && input.getPostCode1().equals(candidate2.getPostCode1())) {
            returnCandidate.setPostalCode1Matched();
        }
        if (input.getPostCode2() != null && input.getPostCode2().length() != 0 && input.getPostCode2().equals(candidate1.getPostCode2()) && input.getPostCode2().equals(candidate2.getPostCode2())) {
            returnCandidate.setPostalCode2Matched();
        }
        if (input.getAreaName1() != null && input.getAreaName1().length() != 0 && input.getAreaName1().equals(candidate1.getAreaName1()) && input.getAreaName1().equals(candidate2.getAreaName1())) {
            returnCandidate.setAreaName1Matched();
        }
        if (input.getAreaName2() != null && input.getAreaName2().length() != 0 && input.getAreaName2().equals(candidate1.getAreaName2()) && input.getAreaName2().equals(candidate2.getAreaName2())) {
            returnCandidate.setAreaName2Matched();
        }
        String candidate1AreaName3Short = ((EMEA_GeoInfoRecord)candidate1.getSegment().getGeoInfoRecord()).getAreaName3Short();
        String candidate2AreaName3Short = ((EMEA_GeoInfoRecord)candidate2.getSegment().getGeoInfoRecord()).getAreaName3Short();
        if (input.getAreaName3() != null && input.getAreaName3().length() != 0) {
            if (input.getAreaName3().equals(candidate1.getAreaName3()) && input.getAreaName3().equals(candidate2.getAreaName3())) {
                returnCandidate.setAreaName3Matched();
            } else if (input.getAreaName3().equals(candidate1AreaName3Short) && input.getAreaName3().equals(candidate2AreaName3Short)) {
                returnCandidate.setAreaName3Matched();
            } else if (candidate1.getAreaName3Score() == 1.0) {
                returnCandidate.setAreaName3Matched();
            }
        }
        if (input.getAreaName4() != null && input.getAreaName4().length() != 0 && input.getAreaName4().equals(candidate1.getAreaName4()) && input.getAreaName4().equals(candidate2.getAreaName4())) {
            returnCandidate.setAreaName4Matched();
        }
        if (input.getCountry() != null && input.getCountry().length() != 0 && candidate1.getCountryScore() == 1.0 && candidate2.getCountryScore() == 1.0) {
            returnCandidate.setCountryMatched();
        }
        StringBuffer buff = new StringBuffer();
        String candidate1FormattedAddress = candidate1.getFormattedStreetAddress();
        String candidate1HouseNumber = candidate1.getAddressNumber();
        if (candidate1HouseNumber != null && candidate1HouseNumber.length() > 0) {
            int index = -1;
            index = candidate1FormattedAddress.indexOf(candidate1HouseNumber);
            if (index == 0) {
                buff.append(candidate1FormattedAddress.substring(candidate1HouseNumber.length()));
            } else {
                buff.append(candidate1FormattedAddress.substring(0, index));
            }
        } else {
            buff.append(candidate1FormattedAddress);
        }
        buff.append(" && ");
        String candidate2FormattedAddress = candidate2.getFormattedStreetAddress();
        String candidate2HouseNumber = candidate2.getAddressNumber();
        if (candidate2HouseNumber != null && candidate2HouseNumber.length() > 0) {
            int index = -1;
            index = candidate2FormattedAddress.indexOf(candidate2HouseNumber);
            if (index == 0) {
                buff.append(candidate2FormattedAddress.substring(candidate2HouseNumber.length()));
            } else {
                buff.append(candidate2FormattedAddress.substring(0, index));
            }
        } else {
            buff.append(candidate2FormattedAddress);
        }
        returnCandidate.setFormattedStreetAddress(buff.toString());
        returnCandidate.setFormattedLocationAddress(candidate1.getFormattedLocationAddress());
        returnCandidate.setMainAddress(returnCandidate.getFormattedStreetAddress());
        if (candidate1.getMainAddressScore() == 1.0 && candidate2.getMainAddressScore() == 1.0) {
            returnCandidate.setStreetNameMatched();
        }
        if (candidate1.getPostAddressScore() == 1.0 && candidate2.getPostAddressScore() == 1.0 && candidate1.getPreAddressScore() == 1.0 && candidate2.getPreAddressScore() == 1.0) {
            returnCandidate.setStreetPrefixAndSuffixMatched();
        }
        if (candidate1.getPreThoroughfareTypeScore() == 1.0 && candidate2.getPreThoroughfareTypeScore() == 1.0 && candidate1.getPostThoroughfareTypeScore() == 1.0 && candidate2.getPostThoroughfareTypeScore() == 1.0) {
            returnCandidate.setThoroughfareTypeMatched();
        }
        if (candidate1.getPreDirectionalScore() == 1.0 && candidate2.getPreDirectionalScore() == 1.0) {
            returnCandidate.setPreDirectionalMatched();
        }
        if (candidate1.getPostDirectionalScore() == 1.0 && candidate2.getPostDirectionalScore() == 1.0) {
            returnCandidate.setPostDirectionalMatched();
        }
        returnCandidate.setCloseMatch();
        returnCandidate.setLocation(this.getIntersectionPoint());
        returnCandidate.setLocation(CoordConvertor.transformPointFromWGS84((CoordSys)constraints.getClientCoordinateSystem(), (DoublePoint)returnCandidate.getLocation()));
        returnCandidate.setLocationPrecision(6);
        returnCandidate.setCoordSysString(candidate1.getSegment().getCoordSysInfo());
        String csys = returnCandidate.getCoordSysString();
        if (csys == null && constraints.getClientCoordinateSystem() != null) {
            csys = constraints.getClientCoordinateSystem().getSrsName();
            returnCandidate.setCoordSysString(csys);
        }
        if (candidate1.fromUserDictionary() || candidate2.fromUserDictionary()) {
            returnCandidate.setFromUserDictionary();
        }
        HashMap adFields = returnCandidate.getAdditionalFields();
        adFields.put(CandidateAddress.INTERSECTION_OUTPUT_STRING, returnCandidate.getFormattedStreetAddress());
        String geores = this.buildPrecisionCode(returnCandidate);
        returnCandidate.addKeyValueToAdditionalFields("RESULT_CODE", geores);
        returnCandidate.addKeyValueToAdditionalFields("StreetDataType", this.m_candidate1.getVendorCode());
        Address address = constraints.getHandler().getInputAddress();
        returnCandidate.setCountry(address.getCountry());
        returnCandidate.setGenericField4(null);
        HashMap addTable = returnCandidate.getAdditionalFields();
        if (addTable != null) {
            addTable.remove("post_st_type_common");
            addTable.remove("pre_street_type_common");
            addTable.remove("pre_addr_common");
            addTable.remove("post_addr_common");
            addTable.remove("post_st_type_common");
            addTable.remove("pre_street_type_common");
            addTable.remove("cand_full_town");
            addTable.remove("address.common.pre.main");
            addTable.remove("address.common.post.st_type");
            addTable.remove("STREET_NUMBER");
            addTable.remove("input_house_number");
            addTable.remove("unparsed_input_street");
            addTable.remove("original_street_name");
            addTable.remove("expanded_pre_main_common");
        }
        returnCandidate.setAdditionalFields(addTable);
        return returnCandidate;
    }
}

