/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE;

import com.mapinfo.mapmarker.CHE.CHE_AddressUtils;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Range;

public class CHE_Range
extends Range {
    private byte m_houseNumberPrecision;
    private long m_streetPointID;
    private boolean m_isAPRange;

    public CHE_Range() {
    }

    public CHE_Range(boolean isAPRange) {
        this.m_isAPRange = isAPRange;
    }

    public void sethouseNumberPrecision(byte precision) {
        this.m_houseNumberPrecision = precision;
    }

    public byte getHouseNumberPrecesion() {
        return this.m_houseNumberPrecision;
    }

    public void setpointID(long pointID) {
        this.m_streetPointID = pointID;
    }

    public long getPointID() {
        return this.m_streetPointID;
    }

    public CandidateRange toCandidateRange(ParsedNumber inputHouseNumber, int side, ParsedNumber inputUnitNumber, IConstraints constraints) {
        CandidateRange candRange = this.localToCandidateRange(inputHouseNumber, side, inputUnitNumber, constraints);
        if (this.m_isAPRange) {
            int numberOfFieldsMatched = 0;
            if (!this.isInputNumberRanged(inputHouseNumber)) {
                numberOfFieldsMatched = this.isNumberInRange(inputHouseNumber);
            }
            if (numberOfFieldsMatched > 0) {
                if (inputHouseNumber.hasAddressSuffix() && this.getParsedFrom().hasAddressSuffix() && numberOfFieldsMatched > 1) {
                    candRange.setOffset(-1L);
                } else if (numberOfFieldsMatched == 1 && !inputHouseNumber.hasAddressSuffix()) {
                    if (!this.getParsedFrom().hasTrailerSeparator() && !inputHouseNumber.hasTrailerSeparator()) {
                        candRange.setOffset(-1L);
                    } else {
                        candRange.setOffset(0L);
                    }
                } else {
                    candRange.setOffset(0L);
                }
            } else if (inputHouseNumber != null && inputHouseNumber.hasAddressSuffix() && this.getParsedFrom().hasAddressSuffix() && numberOfFieldsMatched == 0 && inputHouseNumber.getAddressNumber() == this.getParsedFrom().getAddressNumber()) {
                candRange.setOffset(0L);
            } else if (inputHouseNumber == null || inputHouseNumber.isEmpty()) {
                candRange.setOffset(Long.MIN_VALUE + this.getParsedRange().getLowEndpoint().getAddressNumber());
            } else {
                long offset = CHE_AddressUtils.computeOffsetDifference(inputHouseNumber, this);
                candRange.setOffset(offset);
            }
        }
        return candRange;
    }

    private boolean isInputNumberRanged(ParsedNumber inputnumber) {
        String hnr;
        boolean isnumberRanged = false;
        if (inputnumber != null && (hnr = inputnumber.getCombinedAddressNumber()) != null && (hnr.indexOf("-") > -1 || hnr.indexOf("/") > -1)) {
            isnumberRanged = true;
        }
        return isnumberRanged;
    }

    public CandidateRange localToCandidateRange(ParsedNumber inputHouseNumber, int side, ParsedNumber inputUnitNumber, IConstraints constraints) {
        int rangeUnitCount;
        CandidateRange candRange = new CandidateRange();
        this.computeLowHighNumber();
        candRange.setLowAddress(this.getLowNumber().getCombinedAddressNumber());
        candRange.setHighAddress(this.getHighNumber().getCombinedAddressNumber());
        candRange.setOddEvenIndicator(this.getOddEven());
        candRange.setLeftRightIndicator(side);
        candRange.setPlaceName(this.getPlaceName());
        if (!this.isInputNumberRanged(inputHouseNumber)) {
            if (this.isNumberInRange(inputHouseNumber) > 0) {
                candRange.setOffset(0L);
            } else if (inputHouseNumber == null || inputHouseNumber.isEmpty()) {
                candRange.setOffset(Long.MIN_VALUE + this.getParsedRange().getLowEndpoint().getAddressNumber());
            } else if (!this.m_isAPRange) {
                if (this.getOddEven() == 2 && (inputHouseNumber.getAddressNumber() & 1L) == 0L || this.getOddEven() == 1 && (inputHouseNumber.getAddressNumber() & 1L) == 1L) {
                    candRange.setOffset(0L);
                } else {
                    candRange.setOffset(1L);
                }
            } else {
                candRange.setOffset(this.computeOffsetFromRange(inputHouseNumber));
            }
        }
        candRange.setNumberOfAddresses(this.computeAddressesInRange());
        int maxRangeUnits = rangeUnitCount = this.getRangeUnitCount();
        if (constraints != null) {
            maxRangeUnits = constraints.getMaxRangeUnits();
        }
        candRange.setNumberOfReturnableRangeUnits(maxRangeUnits);
        if (maxRangeUnits != 0) {
            for (int i = 0; i < rangeUnitCount; ++i) {
                candRange.addRangeUnit(this.getRangeUnitAt(i).toCandidateRangeUnit(inputUnitNumber));
            }
        }
        return candRange;
    }

    public int getRangeDivisionFactor() {
        return super.getDivisionFactor();
    }
}

