/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE;

import com.mapinfo.mapmarker.CHE.CHESwissSoundex;
import com.mapinfo.mapmarker.CHE.CHE_AddressUtils;
import com.mapinfo.mapmarker.CHE.CHE_Handler;
import com.mapinfo.mapmarker.CHE.parser.CHE_ParseRuleHandler;
import com.mapinfo.mapmarker.EMEA.EMEA_StreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.CoreHandler;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;

public class CHE_StreetSingleAddressGeocoder
extends EMEA_StreetSingleAddressGeocoder {
    private int m_currentCase = 0;
    private String m_currentLanguage = "";
    private Vector languageVector;
    private CHESwissSoundex m_soundex;

    public CHE_StreetSingleAddressGeocoder(IHandler handler) {
        super(handler);
    }

    public boolean generateNewCase(IConstraints constraints) throws MapMarkerInternalException {
        boolean tryAgain = false;
        CHE_Handler che_handler = (CHE_Handler)constraints.getHandler();
        Address parsedAddress = che_handler.getPreParsedAddress();
        if (parsedAddress.getMainAddress() == null && parsedAddress.getAreaName3() == null && parsedAddress.getPostAddress() == null && parsedAddress.getPostCode1() == null) {
            return false;
        }
        this.fillVector(parsedAddress);
        Address addrress = che_handler.getParsedAddress();
        Address preparseAddress = che_handler.getPreParsedAddress();
        Address inputAddress = che_handler.getInputAddress();
        ScoredLanguage firstLangToBeUsed = null;
        this.m_soundex = CHESwissSoundex.getSoundexInstance();
        while (!tryAgain && this.m_currentCase < 3) {
            firstLangToBeUsed = (ScoredLanguage)this.languageVector.get(this.m_currentCase);
            HashMap map = preparseAddress.getAdditionalFields();
            map.put("highest_scoring_language", firstLangToBeUsed.getLanguage());
            preparseAddress.setAdditionalFields(map);
            if (!this.m_currentLanguage.equalsIgnoreCase(firstLangToBeUsed.getLanguage())) {
                CHE_ParseRuleHandler parse = null;
                this.setHandlerCountryCode(firstLangToBeUsed, che_handler, inputAddress);
                parse = new CHE_ParseRuleHandler(che_handler.getCountryCode());
                che_handler.setRuleHandler(parse);
                parse.addParsingRules(che_handler);
                this.m_currentLanguage = firstLangToBeUsed.getLanguage();
                addrress = ((CoreHandler)constraints.getHandler()).getParser().parse(inputAddress, constraints)[0];
            }
            this.setSearchParsedAddress(addrress);
            this.setParsedAddress(addrress);
            che_handler.setPreParsedAddress(preparseAddress);
            tryAgain = che_handler.getSingleAddressGeocoder(che_handler).generateNewCase(constraints);
            if (tryAgain) continue;
            ++this.m_currentCase;
        }
        return tryAgain;
    }

    private void fillVector(Address address) {
        double itaScore = Double.valueOf((String)address.getAdditionalFields().get("ITAScore"));
        double fraScore = Double.valueOf((String)address.getAdditionalFields().get("FRAScore"));
        double deuScore = Double.valueOf((String)address.getAdditionalFields().get("DEUScore"));
        this.languageVector = new Vector(3);
        this.languageVector.add(new ScoredLanguage(deuScore, "DEU"));
        this.languageVector.add(new ScoredLanguage(fraScore, "FRA"));
        this.languageVector.add(new ScoredLanguage(itaScore, "ITA"));
        Collections.sort(this.languageVector, new ScoredLanguage());
    }

    private void setHandlerCountryCode(ScoredLanguage firstLanguage, CHE_Handler handler, Address inputAddress) {
        if (firstLanguage.getLanguage().equalsIgnoreCase("DEU")) {
            handler.setCountryCode("DEU");
        } else if (firstLanguage.getLanguage().equalsIgnoreCase("FRA")) {
            handler.setCountryCode("FRA");
            inputAddress.setMainAddress(CHE_AddressUtils.getModifiedStreetAddress(inputAddress.getMainAddress()));
        } else if (firstLanguage.getLanguage().equalsIgnoreCase("ITA")) {
            handler.setCountryCode("ITA");
        }
    }

    private class ScoredLanguage
    implements Comparator {
        private double m_LanguageScore;
        private String m_language;

        public ScoredLanguage() {
            this(0.0, null);
        }

        public ScoredLanguage(double languageScore, String language) {
            this.m_LanguageScore = languageScore;
            this.m_language = language;
        }

        public String getLanguage() {
            return this.m_language;
        }

        public double getLanguageScore() {
            return this.m_LanguageScore;
        }

        public int compare(Object object1, Object object2) {
            double score2;
            int score = 0;
            double score1 = object1 == null ? 0.0 : ((ScoredLanguage)object1).getLanguageScore();
            double d = score2 = object2 == null ? 0.0 : ((ScoredLanguage)object2).getLanguageScore();
            if (score1 > score2) {
                score = -1;
            } else if (score2 > score1) {
                score = 1;
            } else {
                String language1 = object1 == null ? "" : ((ScoredLanguage)object1).getLanguage();
                String language2 = object2 == null ? "" : ((ScoredLanguage)object2).getLanguage();
                int langScore1 = 0;
                int langScore2 = 0;
                if (language1.equalsIgnoreCase("DEU")) {
                    langScore1 = 3;
                } else if (language1.equalsIgnoreCase("FRA")) {
                    langScore1 = 2;
                }
                if (language2.equalsIgnoreCase("DEU")) {
                    langScore2 = 3;
                } else if (language2.equalsIgnoreCase("FRA")) {
                    langScore2 = 2;
                }
                score = langScore2 - langScore1;
            }
            return score;
        }
    }
}

