/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.DEU;

import com.mapinfo.mapmarker.CHE.DEU.parser.DEU_Abbreviations;
import com.mapinfo.mapmarker.CHE.DEU.parser.DEU_AddressTerm;
import com.mapinfo.mapmarker.CHE.DEU.parser.DEU_ParseMainAddressRule;
import com.mapinfo.mapmarker.EMEA.EMEA_ScoringAddress;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.StringTokenizer;

public class DEU_ScoringAddress
extends EMEA_ScoringAddress {
    public DEU_ScoringAddress(Address addr) {
        super(addr);
    }

    public double scorePostAddress(StreetCandidateAddress parsedAddress) {
        String parsedPostAddr = this.getPostAddress();
        String candPostAddr = parsedAddress.getPostAddress();
        double score = 0.0;
        if (candPostAddr != null && parsedPostAddr == null && DEU_ParseMainAddressRule.isValidHouseNumber(candPostAddr.trim()) && this.getAddressNumber() != null) {
            String hnr;
            String oldHnr = this.getAddressNumber();
            StringTokenizer st = new StringTokenizer(oldHnr, "/- ");
            while (st.hasMoreTokens() && (score = this.scoreItems(candPostAddr, hnr = st.nextToken())) != 1.0) {
            }
        } else if (parsedPostAddr != null && this.getPostThoroughfareType() == null && parsedAddress.getPostThoroughfareType() != null) {
            score = this.scoreItems(parsedPostAddr, parsedAddress.getPostThoroughfareType());
            if (score > 0.75) {
                return score;
            }
        } else {
            if (DEU_AddressTerm.isIgnoreWord(parsedAddress.getPostAddress()) && this.getPostAddress() == null) {
                score = 0.75;
            }
            if (StringUtilities.isNumeric((String)parsedPostAddr) && candPostAddr == null) {
                parsedPostAddr = null;
                score = this.scoreItems(parsedPostAddr, candPostAddr);
            } else {
                score = this.scoreItems(parsedPostAddr, candPostAddr);
            }
        }
        return score;
    }

    public double scorePreAddress(String parsedAddress) {
        double score;
        String parsedPreAddr = this.getPreAddress();
        String candPreAddr = parsedAddress;
        double highScore = this.scoreItems(parsedAddress, this.getPreAddress());
        if (highScore != 1.0 && parsedPreAddr != null && candPreAddr != null) {
            String candAbbrPreAddr;
            String parsedAbbrPreAddr = DEU_Abbreviations.abbreviateWords(parsedPreAddr);
            score = this.scoreItems(parsedAbbrPreAddr, candAbbrPreAddr = DEU_Abbreviations.abbreviateWords(candPreAddr));
            if (score != 1.0) {
                String[] p = DEU_ScoringAddress.splitWordsIntoArray(parsedPreAddr);
                String[] c = DEU_ScoringAddress.splitWordsIntoArray(candPreAddr);
                if (p != null && c != null) {
                    int count = p.length < c.length ? p.length : c.length;
                    boolean abbrivated = false;
                    for (int i = 0; i < count; ++i) {
                        if (p[i].length() >= c[i].length()) continue;
                        if (c[i].startsWith(p[i])) {
                            abbrivated = true;
                            c[i] = p[i];
                            continue;
                        }
                        if (!p[i].startsWith(c[i])) continue;
                        abbrivated = true;
                        p[i] = c[i];
                    }
                    if (abbrivated) {
                        int i;
                        StringBuffer parsedBuf = new StringBuffer();
                        StringBuffer candBuf = new StringBuffer();
                        for (i = 0; i < p.length; ++i) {
                            parsedBuf.append(p[i]);
                            parsedBuf.append(' ');
                        }
                        for (i = 0; i < c.length; ++i) {
                            candBuf.append(c[i]);
                            candBuf.append(' ');
                        }
                        score = this.scoreItems(parsedBuf.toString().trim(), candBuf.toString().trim());
                        if (score > highScore) {
                            highScore = score;
                        }
                    }
                }
            } else if (score > highScore) {
                highScore = score;
            }
            parsedPreAddr = parsedAbbrPreAddr;
            candPreAddr = candAbbrPreAddr;
        }
        if (highScore != 1.0) {
            String str1 = parsedAddress;
            String str2 = this.getPreAddress();
            if (str1 != null && str1.trim().length() > 0 && str2 != null && str2.trim().length() > 0) {
                boolean romanTermExistInStr1 = false;
                boolean romanTermExistInStr2 = false;
                StringTokenizer st1 = new StringTokenizer(str1, this.getCharsToIgnore(), false);
                String temp = null;
                String inputNumber = null;
                String candidateNumber = null;
                while (!romanTermExistInStr1 && st1.hasMoreTokens()) {
                    temp = st1.nextToken();
                    if (StringUtilities.isNumeric((String)temp)) {
                        romanTermExistInStr1 = true;
                        inputNumber = temp.toString();
                        continue;
                    }
                    if (!DEU_AddressTerm.isRomanNumber(temp)) continue;
                    romanTermExistInStr1 = true;
                    inputNumber = String.valueOf(DEU_AddressTerm.convertRomanToLong(temp));
                }
                temp = null;
                StringTokenizer st2 = new StringTokenizer(str2, this.getCharsToIgnore(), false);
                while (!romanTermExistInStr2 && st2.hasMoreTokens()) {
                    temp = st2.nextToken();
                    if (StringUtilities.isNumeric((String)temp)) {
                        romanTermExistInStr2 = true;
                        candidateNumber = temp.toString();
                    }
                    if (!DEU_AddressTerm.isRomanNumber(temp)) continue;
                    romanTermExistInStr2 = true;
                    candidateNumber = String.valueOf(DEU_AddressTerm.convertRomanToLong(temp));
                }
                if (romanTermExistInStr2 && romanTermExistInStr1) {
                    score = this.scoreItems(inputNumber, candidateNumber);
                    if (score > highScore) {
                        highScore = score;
                    }
                    if (highScore > 1.0) {
                        highScore = 1.0;
                    }
                }
            }
        }
        if (highScore != 1.0) {
            String[] parsedRetValue = DEU_AddressTerm.removeCommonWords(parsedPreAddr);
            String[] candRetValue = DEU_AddressTerm.removeCommonWords(candPreAddr);
            if (parsedRetValue != null && candRetValue != null) {
                double otherWordsScore;
                if (!(parsedRetValue[0] == null && candRetValue[0] == null || parsedRetValue[1] == null && candRetValue[1] == null)) {
                    double otherWordsScore2 = this.scoreItems(parsedRetValue[0], candRetValue[0]);
                    double commonWordsScore = this.scoreItems(parsedRetValue[1], candRetValue[1]);
                    if (otherWordsScore2 != 0.0 && commonWordsScore != 0.0) {
                        highScore = otherWordsScore2 * 0.75 + commonWordsScore * 0.25;
                    }
                }
                if (parsedRetValue[0] != null && candRetValue[0] != null && highScore < (otherWordsScore = this.scoreItems(parsedRetValue[0], candRetValue[0]))) {
                    highScore = otherWordsScore;
                }
            } else if (parsedRetValue != null && parsedRetValue[0] == null) {
                highScore = 0.75;
            } else if (parsedRetValue != null) {
                highScore = 0.25;
            }
        }
        return highScore;
    }

    public double scorePostThoroughfareType(String str) {
        double highScore;
        double score = this.DEUScoreThoroughfareType(this.getPostThoroughfareType(), str);
        if (score != 1.0 && this.getPreThoroughfareType() != null && (highScore = this.DEUScoreThoroughfareType(this.getPreThoroughfareType(), str)) > score) {
            score = highScore;
        }
        return score;
    }

    public double scorePreThoroughfareType(String str) {
        double highScore;
        double score = this.DEUScoreThoroughfareType(this.getPreThoroughfareType(), str);
        if (score != 1.0 && (highScore = this.DEUScoreThoroughfareType(this.getPostThoroughfareType(), str)) > score) {
            score = highScore;
        }
        return score;
    }

    private double DEUScoreThoroughfareType(String s1, String s2) {
        double score = this.scoreStrings(s1, s2);
        if (score != 1.0 && score > 0.0 && s1.charAt(0) != s2.charAt(0)) {
            score = 0.75 * score;
        }
        return score;
    }

    private static String[] splitWordsIntoArray(String words) {
        if (words == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(words, " .-,");
        int n = st.countTokens();
        if (n > 0) {
            String[] strArray = new String[n];
            for (int i = 0; i < n; ++i) {
                strArray[i] = st.nextToken();
            }
            return strArray;
        }
        return null;
    }

    public double scoreMainAddress(String parsedAddress) {
        String parsedMainAddr = this.getMainAddress();
        String candMainAddr = parsedAddress;
        if (parsedMainAddr != null && parsedMainAddr.length() != 0) {
            parsedMainAddr = parsedMainAddr.toUpperCase();
        }
        if (candMainAddr != null && candMainAddr.length() != 0) {
            candMainAddr = candMainAddr.toUpperCase();
        }
        double highScore = this.scoreItems(parsedAddress, parsedMainAddr);
        return highScore;
    }
}

