/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.DEU;

import com.mapinfo.mapmarker.CHE.DEU.parser.DEU_ThoroughfareTypes;
import com.mapinfo.mapmarker.CHE.parser.CHE_AddressTerm;
import com.mapinfo.mapmarker.EMEA.EMEA_StreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.core.CoreHandler;
import com.mapinfo.mapmarker.core.ICoreParseHandler;
import com.mapinfo.mapmarker.core.address.ICoreStreetGeocoder;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.List;

public class DEU_StreetSingleAddressGeocoder
extends EMEA_StreetSingleAddressGeocoder {
    private int m_currentCase = 0;
    private Address m_savedParsedAddress;
    protected boolean m_resetConstraints;
    protected boolean m_resetParsedAddress;
    private boolean m_flag = false;
    private Address m_OrigScoringAddress;

    public DEU_StreetSingleAddressGeocoder(IHandler handler) {
        super(handler);
    }

    public boolean generateNewCase(IConstraints constraints) throws MapMarkerInternalException {
        int previousResultSize;
        boolean tryAgain = false;
        int debugLevel = DebugLevel.getDebugLevel((int)1);
        Address searchParsedAddress = ((ICoreStreetGeocoder)constraints.getHandler()).getSearchParsedAddress();
        if (!this.m_resetParsedAddress) {
            this.m_savedParsedAddress = new AddressImpl(constraints.getHandler().getParsedAddress());
        } else {
            this.setSearchParsedAddress((Address)new AddressImpl(this.m_savedParsedAddress));
            this.setParsedAddress((Address)new AddressImpl(this.m_savedParsedAddress));
            this.m_resetParsedAddress = false;
        }
        if (this.m_resetConstraints) {
            constraints.removeCustomObject((Object)"KEY_DEU_ALTERNATE_SOUNDEX_CODES");
            this.m_resetConstraints = false;
        }
        Address inputAddress = constraints.getHandler().getInputAddress();
        Address pa = constraints.getHandler().getParsedAddress();
        boolean exactStreet = false;
        CoreHandler handler = (CoreHandler)constraints.getHandler();
        List previousResultList = handler.getIntermediateMatchResults();
        int n = previousResultSize = previousResultList == null ? 0 : previousResultList.size();
        if (this.m_currentCase > 0 && previousResultSize > 0) {
            ArrayList<Long> previousStreetOffsets = (ArrayList<Long>)constraints.getCustomObject((Object)"KEY_STREETS_TO_REMOVE");
            if (previousStreetOffsets == null) {
                previousStreetOffsets = new ArrayList<Long>(previousResultSize);
            }
            for (int i = 0; i < previousResultSize; ++i) {
                InternalCandidateAddress candAddr = (InternalCandidateAddress)previousResultList.get(i);
                Long streetOffset = new Long(candAddr.getStreetOffset());
                if (previousStreetOffsets.contains(streetOffset)) continue;
                previousStreetOffsets.add(streetOffset);
            }
            constraints.setCustomObject((Object)"KEY_STREETS_TO_REMOVE", previousStreetOffsets);
        }
        if (this.m_currentCase == 0) {
            String mustMatchMainAddr = constraints.getCustomString("MustMatchMainAddr");
            constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
            if (mustMatchMainAddr != null && mustMatchMainAddr.equalsIgnoreCase("TRUE")) {
                exactStreet = true;
            }
        }
        switch (this.m_currentCase) {
            case 0: {
                ++this.m_currentCase;
                String sacMustMatchGeoAndPostal = constraints.getCustomString("KEY_SAC_MUSTMATCH_GEO_AND_POSTAL");
                if (sacMustMatchGeoAndPostal != null && sacMustMatchGeoAndPostal.equalsIgnoreCase("TRUE")) {
                    constraints.removeCustomObject((Object)"KEY_SAC_MUSTMATCH_GEO_AND_POSTAL");
                    constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    tryAgain = true;
                    break;
                }
            }
            case 1: {
                ++this.m_currentCase;
            }
            case 2: {
                ++this.m_currentCase;
                boolean bStringKey = new Boolean(constraints.getCustomString("KEY_GEOBASE_STRING_ONLY"));
                if (bStringKey) {
                    constraints.removeCustomObject((Object)"KEY_GEOBASE_STRING_ONLY");
                    constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    this.m_currentCase = 0;
                    tryAgain = true;
                    break;
                }
            }
            case 3: {
                ++this.m_currentCase;
                String sacPostTownOnly = constraints.getCustomString("KEY_GEOBASE_FOR_AREA3");
                if (sacPostTownOnly != null && sacPostTownOnly.equalsIgnoreCase("true")) {
                    constraints.setCustomObject((Object)"KEY_GEOBASE_FOR_AREA4", (Object)"true");
                    constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    if (pa.getAreaName3() != null || pa.getAreaName4() != null) {
                        tryAgain = true;
                        break;
                    }
                }
            }
            case 4: {
                String temp = null;
                ++this.m_currentCase;
                String postHnrFound = (String)searchParsedAddress.getAdditionalFields().get("POST_HNR_FOUND");
                if (postHnrFound != null && postHnrFound.equalsIgnoreCase("true")) {
                    AddressImpl ura = new AddressImpl(inputAddress);
                    ura.setMainAddress(ura.getMainAddress() + " 100");
                    Address newPa = null;
                    try {
                        newPa = ((ICoreParseHandler)constraints.getHandler()).getParser().parse((Address)ura, constraints)[0];
                    }
                    catch (ParserException e) {
                        newPa = null;
                    }
                    if (newPa != null && "100".equals(newPa.getAddressNumber())) {
                        newPa.setAddressNumber(temp);
                        searchParsedAddress = newPa;
                        this.setParsedAddress(newPa);
                        tryAgain = true;
                        this.m_resetParsedAddress = true;
                        constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                        break;
                    }
                }
            }
            case 5: {
                String newMainAddress;
                ++this.m_currentCase;
                String oldMainAddress = pa.getMainAddress();
                String oldStreettype = pa.getPreThoroughfareType();
                if (oldMainAddress != null && oldStreettype != null && StringUtilities.hasNumeric((String)oldMainAddress) && (newMainAddress = DEU_ThoroughfareTypes.lookupProperName(oldStreettype)) != null) {
                    searchParsedAddress.setMainAddress(newMainAddress);
                    searchParsedAddress.setPreThoroughfareType(null);
                    searchParsedAddress.setPostAddress(oldMainAddress);
                    constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    tryAgain = true;
                    this.m_resetParsedAddress = true;
                    break;
                }
            }
            case 6: {
                Address newPa;
                String preAddr;
                ++this.m_currentCase;
                String string = preAddr = searchParsedAddress.getPreAddress() == null ? "" : searchParsedAddress.getPreAddress().trim();
                if (preAddr.length() != 0 && (searchParsedAddress.getPostThoroughfareType() == null || searchParsedAddress.getPreThoroughfareType() == null)) {
                    AddressImpl ura = new AddressImpl(inputAddress);
                    ura.setMainAddress(preAddr);
                    newPa = null;
                    try {
                        newPa = ((ICoreParseHandler)constraints.getHandler()).getParser().parse((Address)ura, constraints)[0];
                    }
                    catch (ParserException e) {
                        newPa = null;
                    }
                    if (newPa != null && (newPa.getPostThoroughfareType() != null || newPa.getPreThoroughfareType() != null)) {
                        if (!CHE_AddressTerm.isCommonWord(searchParsedAddress.getMainAddress())) {
                            newPa.setPostAddress(searchParsedAddress.getMainAddress());
                        } else if (newPa.getPreAddress() == null) {
                            newPa.setPreAddress(searchParsedAddress.getMainAddress());
                        }
                        if (newPa.getPreThoroughfareType() == null && newPa.getPostThoroughfareType() != null) {
                            newPa.setPreThoroughfareType(newPa.getPostThoroughfareType());
                            newPa.setPostThoroughfareType(null);
                        }
                        searchParsedAddress = newPa;
                        this.setParsedAddress(newPa);
                        tryAgain = true;
                        this.m_resetParsedAddress = true;
                        constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                        break;
                    }
                }
            }
            case 7: {
                String newMainAddr;
                int spacePos;
                String preAddr;
                ++this.m_currentCase;
                String string = preAddr = searchParsedAddress.getPreAddress() == null ? "" : searchParsedAddress.getPreAddress().trim();
                if (preAddr.length() != 0) {
                    spacePos = preAddr.lastIndexOf(32);
                    newMainAddr = null;
                    if (spacePos != -1) {
                        newMainAddr = preAddr.substring(spacePos + 1) + searchParsedAddress.getMainAddress();
                        preAddr = preAddr.substring(0, spacePos);
                    } else {
                        spacePos = preAddr.lastIndexOf(45);
                        if (spacePos != -1) {
                            newMainAddr = preAddr.substring(spacePos + 1) + searchParsedAddress.getMainAddress();
                            preAddr = preAddr.substring(0, spacePos);
                        } else {
                            newMainAddr = preAddr + searchParsedAddress.getMainAddress();
                            preAddr = null;
                        }
                    }
                    searchParsedAddress.setMainAddress(newMainAddr);
                    searchParsedAddress.setPreAddress(preAddr);
                    this.setParsedAddress((Address)new AddressImpl(searchParsedAddress));
                    tryAgain = true;
                    this.m_resetParsedAddress = true;
                    constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    break;
                }
            }
            case 8: {
                Address newPa;
                ++this.m_currentCase;
                if (searchParsedAddress.getPostThoroughfareType() == null) {
                    AddressImpl ura = new AddressImpl(inputAddress);
                    StringBuffer newMainAddr = new StringBuffer();
                    if (searchParsedAddress.getPreAddress() != null) {
                        newMainAddr.append(searchParsedAddress.getPreAddress());
                        char lastch = newMainAddr.charAt(newMainAddr.length() - 1);
                        if (lastch != ' ' || lastch != '-') {
                            newMainAddr.append(' ');
                        }
                    }
                    newMainAddr.append(searchParsedAddress.getMainAddress());
                    if (searchParsedAddress.getPostAddress() != null) {
                        newMainAddr.append(searchParsedAddress.getPostAddress());
                    }
                    newMainAddr.append(". ");
                    if (searchParsedAddress.getAddressNumber() != null) {
                        newMainAddr.append(searchParsedAddress.getAddressNumber());
                    }
                    ura.setMainAddress(newMainAddr.toString());
                    newPa = null;
                    try {
                        newPa = ((ICoreParseHandler)constraints.getHandler()).getParser().parse((Address)ura, constraints)[0];
                    }
                    catch (ParserException e) {
                        newPa = null;
                    }
                    if (newPa != null && newPa.getPostThoroughfareType() != null) {
                        newPa.setPostAddress(searchParsedAddress.getMainAddress());
                        searchParsedAddress = newPa;
                        this.setParsedAddress(newPa);
                        tryAgain = true;
                        this.m_resetParsedAddress = true;
                        constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                        break;
                    }
                }
            }
            case 9: {
                ++this.m_currentCase;
                if (!exactStreet) {
                    this.m_resetConstraints = true;
                    int code = 8;
                    constraints.setCustomObject((Object)"KEY_DEU_ALTERNATE_SOUNDEX_CODES", (Object)new Integer(code |= 4));
                    tryAgain = true;
                    constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    break;
                }
            }
            case 10: {
                ++this.m_currentCase;
                if (!exactStreet) {
                    this.m_resetConstraints = true;
                    constraints.setCustomObject((Object)"KEY_DEU_ALTERNATE_SOUNDEX_CODES", (Object)new Integer(10));
                    tryAgain = true;
                    constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    break;
                }
            }
            case 11: {
                ++this.m_currentCase;
                if (!exactStreet) {
                    this.m_resetConstraints = true;
                    constraints.setCustomObject((Object)"KEY_DEU_ALTERNATE_SOUNDEX_CODES", (Object)new Integer(32));
                    tryAgain = true;
                    constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    break;
                }
            }
            case 12: {
                ++this.m_currentCase;
                if (!exactStreet) {
                    this.m_resetConstraints = true;
                    int code = 2;
                    constraints.setCustomObject((Object)"KEY_DEU_ALTERNATE_SOUNDEX_CODES", (Object)new Integer(code |= 0x10));
                    constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    tryAgain = true;
                    break;
                }
            }
            case 13: {
                String newMainAddr;
                int spacePos;
                String preAddr;
                ++this.m_currentCase;
                if (searchParsedAddress.getPreAddress() != null && searchParsedAddress.getPreAddress().trim().length() != 0) {
                    preAddr = searchParsedAddress.getPreAddress().trim();
                    spacePos = preAddr.lastIndexOf(32);
                    newMainAddr = null;
                    if (spacePos > -1) {
                        newMainAddr = preAddr.substring(spacePos + 1);
                        preAddr = preAddr.substring(0, spacePos + 1);
                    } else {
                        newMainAddr = preAddr;
                        preAddr = null;
                    }
                    if (newMainAddr != null || newMainAddr.trim().length() > 0) {
                        String newPostAddr = searchParsedAddress.getPostAddress();
                        newPostAddr = searchParsedAddress.getMainAddress() + ' ' + (newPostAddr == null ? "" : newPostAddr.trim());
                        searchParsedAddress.setPreAddress(preAddr);
                        searchParsedAddress.setMainAddress(newMainAddr);
                        searchParsedAddress.setPostAddress(newPostAddr);
                        this.setParsedAddress(searchParsedAddress);
                        tryAgain = true;
                        this.m_resetParsedAddress = true;
                        constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                        break;
                    }
                }
            }
            case 14: {
                boolean parsed;
                AddressImpl newInput;
                String newMainAddress;
                int originalOffset;
                String originalMainAddress;
                String lastWord;
                String postType;
                ++this.m_currentCase;
                String mainAddress = searchParsedAddress.getMainAddress();
                if (mainAddress != null && mainAddress.trim().length() != 0) {
                    int offset;
                    String preType = searchParsedAddress.getPreThoroughfareType();
                    postType = searchParsedAddress.getPostThoroughfareType();
                    if (!(preType != null && preType.trim().length() != 0 || postType != null && postType.trim().length() != 0 || (offset = mainAddress.lastIndexOf(" ")) <= 0)) {
                        lastWord = mainAddress.substring(offset + 1);
                        originalMainAddress = inputAddress.getMainAddress();
                        originalOffset = originalMainAddress.lastIndexOf(lastWord);
                        if (originalOffset > 0) {
                            newMainAddress = originalMainAddress.substring(0, originalOffset - 1);
                            if (originalMainAddress.length() > originalOffset + lastWord.length()) {
                                newMainAddress = newMainAddress + " " + originalMainAddress.substring(originalOffset + (lastWord.length() + 1));
                            }
                            newInput = new AddressImpl(inputAddress);
                            String possibleHNR = null;
                            if (StringUtilities.isNumeric((String)lastWord) && searchParsedAddress.getAddressNumber() == null) {
                                possibleHNR = lastWord;
                                newInput.setAddressNumber(possibleHNR);
                                this.m_flag = true;
                                this.m_OrigScoringAddress = new AddressImpl(constraints.getHandler().getParsedAddress());
                            }
                            newInput.setMainAddress(newMainAddress);
                            parsed = true;
                            try {
                                searchParsedAddress = ((ICoreParseHandler)constraints.getHandler()).getParser().parse((Address)newInput, constraints)[0];
                                if (this.m_flag) {
                                    constraints.getHandler().setParsedAddress(searchParsedAddress);
                                }
                            }
                            catch (ParserException PEx) {
                                throw new ParserException(PEx.getErrorCode());
                            }
                            if (parsed) {
                                tryAgain = true;
                                this.m_resetParsedAddress = true;
                                constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                                break;
                            }
                        }
                    }
                }
            }
            case 15: {
                boolean parsed;
                AddressImpl newInput;
                String newMainAddress;
                int originalOffset;
                String originalMainAddress;
                String lastWord;
                String postType;
                String mainAddress;
                ++this.m_currentCase;
                if (this.m_flag && this.m_OrigScoringAddress != null) {
                    constraints.getHandler().setParsedAddress(this.m_OrigScoringAddress);
                    this.m_flag = false;
                }
                if ((mainAddress = searchParsedAddress.getMainAddress()) != null && mainAddress.trim().length() != 0) {
                    int offset;
                    String preType = searchParsedAddress.getPreThoroughfareType();
                    postType = searchParsedAddress.getPostThoroughfareType();
                    if (!(preType != null && preType.trim().length() != 0 || postType != null && postType.trim().length() != 0 || (offset = mainAddress.lastIndexOf(" ")) <= 0)) {
                        lastWord = mainAddress.substring(offset + 1);
                        originalMainAddress = inputAddress.getMainAddress();
                        originalOffset = originalMainAddress.lastIndexOf(lastWord);
                        if (originalOffset > 0) {
                            String newPostType;
                            newMainAddress = originalMainAddress.substring(0, originalOffset - 1);
                            if (originalMainAddress.length() > originalOffset + lastWord.length()) {
                                newMainAddress = newMainAddress + " " + originalMainAddress.substring(originalOffset + (lastWord.length() + 1));
                            }
                            newInput = new AddressImpl(inputAddress);
                            newInput.setMainAddress(newMainAddress);
                            Address newParsed = null;
                            parsed = true;
                            try {
                                newParsed = ((ICoreParseHandler)constraints.getHandler()).getParser().parse((Address)newInput, constraints)[0];
                            }
                            catch (ParserException PEx) {
                                throw new ParserException(PEx.getErrorCode());
                            }
                            if (parsed && (newPostType = newParsed.getPostThoroughfareType()) != null && newPostType.trim().length() != 0) {
                                newMainAddress = newParsed.getMainAddress() + DEU_ThoroughfareTypes.lookupProperName(newPostType) + " " + lastWord;
                                searchParsedAddress.setMainAddress(newMainAddress);
                                tryAgain = true;
                                this.m_resetParsedAddress = true;
                                constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                                break;
                            }
                        }
                    }
                }
            }
            case 16: {
                ++this.m_currentCase;
                String sacMustMatchGeoAndPostal = constraints.getCustomString("KEY_SAC_MUSTMATCH_GEO_AND_POSTAL");
                if (sacMustMatchGeoAndPostal != null && sacMustMatchGeoAndPostal.equalsIgnoreCase("TRUE")) {
                    constraints.removeCustomObject((Object)"KEY_SAC_MUSTMATCH_GEO_AND_POSTAL");
                    constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    tryAgain = true;
                    break;
                }
            }
            case 17: {
                ++this.m_currentCase;
                if (!exactStreet) {
                    constraints.setCustomString("KEY_SAC_MUSTMATCH_GEO_AND_POSTAL", "true");
                    this.m_resetConstraints = true;
                    constraints.setCustomObject((Object)"KEY_DEU_ALTERNATE_SOUNDEX_CODES", (Object)new Integer(1));
                    tryAgain = true;
                    constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    break;
                }
            }
            case 18: {
                ++this.m_currentCase;
                constraints.setCustomObject((Object)"KEY_DEU_ALTERNATE_SOUNDEX_CODES", (Object)new Integer(1));
                constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                tryAgain = true;
                break;
            }
        }
        if (this.m_resetParsedAddress) {
            this.setSearchParsedAddress(searchParsedAddress);
        }
        if (this.m_resetParsedAddress && debugLevel >= 1) {
            MMJLog.getLog().debug("\nCurrent Case: " + (this.m_currentCase - 1));
            MMJLog.getLog().debug("New Parsed Address:");
            MMJLog.getLog().debug(searchParsedAddress.toString());
        } else if (tryAgain && debugLevel >= 1) {
            MMJLog.getLog().debug("\nCurrent Case: " + (this.m_currentCase - 1));
        }
        return tryAgain;
    }
}

