/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.DEU.parser;

import com.mapinfo.mapmarker.utils.FileUtilities;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class DEU_Abbreviations {
    private static Properties m_abbr = null;

    public static void load() throws Throwable {
        try {
            if (m_abbr == null) {
                Properties temp = null;
                m_abbr = new Properties();
                temp = FileUtilities.loadProperties((String)"com/mapinfo/mapmarker/CHE/DEU/parser/DEU_Abbreviations.properties");
                Enumeration<Object> em = temp.keys();
                while (em.hasMoreElements()) {
                    String key = (String)em.nextElement();
                    m_abbr.put(key.toUpperCase(), ((String)temp.get(key)).toUpperCase());
                }
            }
        }
        catch (Throwable T) {
            throw new RuntimeException("Unable to load required files for DEU_Parser.");
        }
    }

    public static boolean isAbbreviation(String abbr) {
        return m_abbr.containsValue(abbr.toUpperCase());
    }

    public static boolean hasAbbreviation(String term) {
        if (term == null || term.trim().length() == 0) {
            return false;
        }
        return m_abbr.containsKey(term.trim().toUpperCase());
    }

    public static String getAbbreviation(String word) {
        if (word == null || word.trim().length() == 0) {
            return null;
        }
        return (String)m_abbr.get(word.trim().toUpperCase());
    }

    public static boolean containAbbreviations(String words) {
        if (words == null || words.trim().length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(words, " ");
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            if (!DEU_Abbreviations.isAbbreviation(temp)) continue;
            return true;
        }
        return false;
    }

    public static boolean containWordThatCanBeAbbreviated(String words) {
        if (words == null || words.trim().length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(words, " ");
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            if (!DEU_Abbreviations.hasAbbreviation(temp)) continue;
            return true;
        }
        return false;
    }

    public static String abbreviateWords(String words) {
        if (words == null || words.trim().length() == 0) {
            return null;
        }
        StringBuffer output = new StringBuffer(words.length());
        StringTokenizer st = new StringTokenizer(words, " .-,");
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            String abbr = DEU_Abbreviations.getAbbreviation(temp);
            if (abbr != null) {
                output.append(abbr);
            } else {
                output.append(temp);
            }
            output.append(" ");
        }
        return output.toString().trim();
    }

    public static String getValuefromPropertybyValue(String value) {
        Enumeration<Object> enumeration = m_abbr.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String keyValue = m_abbr.getProperty(key.toUpperCase());
            if (keyValue == null || !keyValue.equalsIgnoreCase(value)) continue;
            return key;
        }
        return null;
    }

    static {
        try {
            DEU_Abbreviations.load();
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage());
        }
    }
}

