/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.FRA;

import com.mapinfo.mapmarker.CHE.CHE_InternalCandidateAddress;
import com.mapinfo.mapmarker.CHE.FRA.FRA_ScoringAddress;
import com.mapinfo.mapmarker.EMEA.EMEA_ScoringAddress;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;

public class FRA_StreetCandidateAddress
extends StreetCandidateAddress {
    public static final String ADDRESS_START = "address.start";
    public static final String ADDRESS_END = "address.end";
    public static final String PRE_MAIN_ADDRESS_COMMON = "address.common.pre.main";
    public static final String POST_STREET_TYPE_COMMON = "address.common.post.st_type";
    public static final String IS_MAJOR_ROAD = "is.major.road";
    public static final double THOROUGHFARE_TYPE_THRESHOLD = 0.99;
    private boolean m_APCandidate;

    public FRA_StreetCandidateAddress(boolean isAPCandidate) {
        this.m_APCandidate = isAPCandidate;
    }

    public FRA_StreetCandidateAddress(Address addr) {
        super(addr);
    }

    public boolean isAPCandidate() {
        return this.m_APCandidate;
    }

    public void score(ScoringAddress input) {
        FRA_ScoringAddress scoringAddress = (FRA_ScoringAddress)input;
        this.setCountryScore(scoringAddress.scoreCountry(this.getCountry()));
        this.setGenericField1Score(scoringAddress.scoreGenericField1(this.getGenericField1()));
        this.setGenericField2Score(scoringAddress.scoreGenericField2(this.getGenericField2()));
        this.setGenericField3Score(scoringAddress.scoreGenericField3(this.getGenericField3()));
        this.setGenericField4Score(scoringAddress.scoreGenericField4(this.getGenericField4()));
        this.setPreDirectionalScore(scoringAddress.scorePostDirectional(this.getPreDirectional()));
        this.setPostDirectionalScore(scoringAddress.scorePostDirectional(this.getPostDirectional()));
        this.scoreThoroughfareType(scoringAddress);
        this.setPreAddressScore(scoringAddress.scorePreAddress(this));
        this.setMainAddressScore(scoringAddress.scoreMainAddress(this.getMainAddress()));
        this.setPostAddressScore(scoringAddress.scorePostAddress(this.getPostAddress()));
        this.setIsScored(true);
    }

    public void scorePreAddress(EMEA_ScoringAddress input) {
        double preAddressScore = 0.0;
        String parsedPreAddress = input.getPreAddress();
        String candPreAddress = this.getPreAddress();
        if (parsedPreAddress != null && parsedPreAddress.length() == 0 || candPreAddress != null && candPreAddress.length() == 0) {
            preAddressScore = 0.8;
        } else {
            String candidatePreAddressFull;
            String parsedPreAddressFull;
            double score;
            preAddressScore = input.scorePreAddress(candPreAddress);
            if (preAddressScore != 1.0 && (score = input.scoreStrings(parsedPreAddressFull = CHE_InternalCandidateAddress.getFormattedPreAddress((Address)input), candidatePreAddressFull = CHE_InternalCandidateAddress.getFormattedPreAddress((Address)this))) > preAddressScore && score > 0.9) {
                preAddressScore = score;
            }
        }
        this.setPreAddressScore(preAddressScore);
    }

    public void scoreThoroughfareType(ScoringAddress parsedAddress) {
        boolean candHasType;
        FRA_ScoringAddress scorer = (FRA_ScoringAddress)parsedAddress;
        String parsedStreetType = parsedAddress.getPreThoroughfareType();
        String candStreetType = this.getPreThoroughfareType();
        boolean parsedHasType = parsedStreetType != null && parsedStreetType.length() > 0;
        boolean bl = candHasType = candStreetType != null && candStreetType.length() > 0;
        if (parsedHasType != candHasType) {
            boolean candHasPostType;
            String parsedPostStreetType = parsedAddress.getPostThoroughfareType();
            String candPostStreetType = this.getPostThoroughfareType();
            boolean parsedHasPostType = parsedPostStreetType != null && parsedPostStreetType.length() > 0;
            boolean bl2 = candHasPostType = candPostStreetType != null && candPostStreetType.length() > 0;
            if (!parsedHasPostType && candHasPostType) {
                double score = scorer.scoreItems(parsedStreetType, candPostStreetType);
                this.setPreThoroughfareTypeScore(score);
                this.setPostThoroughfareTypeScore(score);
            } else if (parsedHasPostType && !candHasPostType) {
                double score = scorer.scoreItems(parsedPostStreetType, candStreetType);
                this.setPreThoroughfareTypeScore(score);
                this.setPostThoroughfareTypeScore(score);
            } else {
                if (candHasType) {
                    this.setPreThoroughfareTypeScore(0.75);
                } else {
                    this.setPreThoroughfareTypeScore(0.5);
                }
                this.setPostThoroughfareTypeScore(scorer.scoreItems(parsedAddress.getPostThoroughfareType(), this.getPostThoroughfareType()));
            }
        } else {
            this.setPreThoroughfareTypeScore(scorer.getPreThoroughfareTypeScore(this.getPreThoroughfareType()));
            this.setPostThoroughfareTypeScore(scorer.getPostThoroughfareTypeScore(this.getPostThoroughfareType()));
        }
    }
}

