/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.FRA.parser;

import com.mapinfo.mapmarker.CHE.FRA.parser.FRA_MainAddressInfo;
import com.mapinfo.mapmarker.utils.MMJLog;

public class FRA_AddressComponent {
    private boolean debug = false;
    private int direction;
    private StringBuffer addressComponent;
    private int type;
    public static final int AT_HOUSE_NUMBER = 0;
    public static final int AT_HOUSE_NUMBER_RANGE_END = 1;
    public static final int AT_PRE_STREET_COMMON = 2;
    public static final int AT_STREET_TYPE = 3;
    public static final int AT_PRE_COMMON = 4;
    public static final int AT_MAIN_ADDRESS = 5;
    public static final int AT_POST_COMMON = 6;
    public static final int AT_POST_ADDRESS = 7;
    public static final int AT_PUNCTUATION = 8;
    public static final int AT_COMMON = 9;
    public static final int AT_HOUSE_NUMBER_RANGER_TERM = 10;
    public static final int AT_POST_STREET_COMMON = 11;
    public static final int AT_PRE_ADDRESS = 12;
    public static final int AT_NO_SPACE = 10;
    public static final int AT_SPACE = 11;
    public static final int AT_MAY_BE_POST_ADDRESS = 15;

    private FRA_AddressComponent() {
        this.addressComponent = new StringBuffer();
    }

    public FRA_AddressComponent(String token, int type, int direction) {
        this.setType(type);
        this.direction = direction;
        this.addressComponent = token != null ? new StringBuffer(token.length()) : new StringBuffer(10);
        if (token != null && !token.equals("")) {
            this.addToAddressComponent(token);
        }
    }

    public StringBuffer getAddressComponent() {
        return this.addressComponent;
    }

    public String getAddressComponentString() {
        return this.addressComponent == null ? null : this.addressComponent.toString();
    }

    public void addToAddressComponent(String newBit) {
        if (this.direction == FRA_MainAddressInfo.DIR_FORWARDS) {
            if (newBit.equals("'") || this.addressComponent.length() > 0 && this.addressComponent.charAt(this.addressComponent.length() - 1) == '\'' || newBit.equals("-") || this.addressComponent.length() > 0 && this.addressComponent.charAt(this.addressComponent.length() - 1) == '-') {
                this.addToAddressComponent(newBit, 10);
            } else {
                this.addToAddressComponent(newBit, 11);
            }
        } else if (this.direction == FRA_MainAddressInfo.DIR_BACKWARDS) {
            if (newBit.equals("'") || this.addressComponent.length() > 0 && this.addressComponent.charAt(0) == '\'' || newBit.equals("-") || this.addressComponent.length() > 0 && this.addressComponent.charAt(0) == '-') {
                this.addToAddressComponent(newBit, 10);
            } else {
                this.addToAddressComponent(newBit, 11);
            }
        }
    }

    public void addToAddressComponent(String newBit, int options) {
        if (newBit == null) {
            if (this.debug) {
                MMJLog.getLog().debug("Trying to add null to an address component");
            }
            return;
        }
        if (options != 10 && this.addressComponent.length() != 0) {
            if (this.direction == FRA_MainAddressInfo.DIR_FORWARDS) {
                this.addressComponent.append(" ");
            } else if (this.direction == FRA_MainAddressInfo.DIR_BACKWARDS) {
                this.addressComponent.insert(0, " ");
            }
        }
        if (this.direction == FRA_MainAddressInfo.DIR_FORWARDS) {
            this.addressComponent.append(newBit);
        } else if (this.direction == FRA_MainAddressInfo.DIR_BACKWARDS) {
            this.addressComponent.insert(0, newBit);
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (type > 12 || type < 0) {
            if (this.debug) {
                MMJLog.getLog().debug("Address component type out of range :" + type);
            }
            return;
        }
        this.type = type;
    }

    public void reset() {
        this.addressComponent = new StringBuffer();
    }
}

