/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.FRA.parser;

import com.mapinfo.mapmarker.CHE.parser.CHE_AddressTerm;
import com.mapinfo.mapmarker.utils.FileUtilities;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class FRA_AddressTerm {
    private static final String COMMON_TERMS_KEY = "common_words";
    private static final String PUNCTUATION_CHARACTERS_KEY = "punctuation_chars";
    private static final String COUNTRY_CODES_KEY = "country_codes";
    private static final String HNR_START = "hnr_start";
    private static final String HNR_CAN_CONTAIN = "hnr_can_contain";
    private static final String STREET_NOT_CONTAIN = "street_not_contain";
    private static final String EXTENDED_CHARS = "extended_chars";
    private static HashMap extendedCharMap = null;
    private static final String DIRECTIONALS = "directionals";
    private static final String PRE_NUM_STREET_WORD = "pre_num_street_word";
    private static final String POST_NUM_STREET_WORD = "post_num_street_word";
    private static final String MONTH_WORDS = "month_words";
    private static final String ORDINAL_CHARS = "ordinal_chars";
    private static final String ROMAN_NUMERAL_WORDS = "roman_numeral_words";
    private static final String POBOX_WORDS = "pobox_words";
    private static final String COMMON_NO_POSTCODE_TERMS = "common_no_postcode";
    private static final String COMMON_TERMS_WITH_POST_NUMBER = "common_terms_with_post_number";
    private static final String ORDINALS_WORDS = "ordinal_words";
    private static char[] romanNumberChars = new char[]{'X', 'x', 'V', 'v', 'I', 'i'};
    private static char[] validPunctuationChars = new char[]{'-', '\'', ',', ' ', '.'};
    private static StringBuffer punctuationList = null;
    private static StringBuffer ordinalCharList = null;
    private static ArrayList ordinalList = null;
    private static ArrayList cntryCodeList = null;
    private static ArrayList hnrStartList = null;
    private static ArrayList hnrContainList = null;
    private static ArrayList streetNotContainList = null;
    private static ArrayList directionalList = null;
    private static ArrayList preNumStreetWordList = null;
    private static ArrayList postNumStreetWordList = null;
    private static ArrayList monthWordList = null;
    private static ArrayList romanNumeralWordList = null;
    private static ArrayList commonNoPostCodeTermList = null;
    private static ArrayList commonTermsWithPostNumberList = null;
    private static ArrayList poboxWordList = null;
    public static String collatorRules = null;
    private static Properties properties = null;

    private static void loadPunctuations(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (punctuationList == null) {
                punctuationList = new StringBuffer(raw.length());
            }
            punctuationList.append(raw);
        }
    }

    private static void loadCountryCodes(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (cntryCodeList == null) {
                cntryCodeList = new ArrayList(5);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                String cntryCode = st.nextToken().trim();
                if (cntryCode.length() <= 0) continue;
                cntryCodeList.add(cntryCode.toUpperCase());
            }
        }
    }

    private static void loadHnrStartTerms(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (hnrStartList == null) {
                hnrStartList = new ArrayList(5);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                String start = st.nextToken().trim();
                if (start.length() <= 0) continue;
                hnrStartList.add(start.toUpperCase());
            }
        }
    }

    private static void loadHnrContainTerms(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (hnrContainList == null) {
                hnrContainList = new ArrayList(5);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                String contains = st.nextToken().trim();
                if (contains.length() <= 0) continue;
                hnrContainList.add(contains.toUpperCase());
            }
            hnrContainList.add(",");
        }
    }

    private static void loadStreetNotContainTerms(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (streetNotContainList == null) {
                streetNotContainList = new ArrayList(5);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                String contains = st.nextToken().trim();
                if (contains.length() <= 0) continue;
                streetNotContainList.add(contains.toUpperCase());
            }
        }
    }

    private static void loadMonths(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (monthWordList == null) {
                monthWordList = new ArrayList(5);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                String monthWord = st.nextToken().trim();
                if (monthWord.length() <= 0) continue;
                monthWordList.add(monthWord.toUpperCase());
            }
        }
    }

    private static void loadOrdinals(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (ordinalList == null) {
                ordinalList = new ArrayList(5);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                String contains = st.nextToken().trim();
                if (contains.length() <= 0) continue;
                ordinalList.add(contains.toUpperCase());
            }
        }
    }

    public static boolean isCountryCode(String code) {
        if (cntryCodeList == null) {
            return false;
        }
        return cntryCodeList.contains(code.toUpperCase());
    }

    public static boolean isPunctuation(String term) {
        if (punctuationList == null || term == null || term.length() == 0) {
            return false;
        }
        return punctuationList.toString().indexOf(term) > -1;
    }

    public static boolean isPunctuation(char ch) {
        if (punctuationList == null) {
            return false;
        }
        return punctuationList.toString().indexOf(ch) > -1;
    }

    public static boolean isOrdinalChar(char ch) {
        if (ordinalCharList == null) {
            return false;
        }
        return ordinalCharList.toString().indexOf(ch) > -1;
    }

    public static boolean isOrdinal(String term) {
        if (term != null && ordinalList != null) {
            return ordinalList.contains(term.toUpperCase());
        }
        return false;
    }

    public static boolean isOrdinalChar(String term) {
        if (ordinalCharList == null) {
            return false;
        }
        return ordinalCharList.toString().indexOf(term) > -1;
    }

    public static boolean isCommonTerm(String term) {
        if (term == null) {
            return false;
        }
        if (CHE_AddressTerm.m_commonTermList != null && CHE_AddressTerm.m_commonTermList.contains(term.toUpperCase())) {
            return true;
        }
        if (StringUtilities.hasNumeric((String)term)) {
            StringTokenizer st = new StringTokenizer(term, ". ");
            if (st.countTokens() > 2) {
                return false;
            }
            StringBuffer buf = new StringBuffer(20);
            while (st.hasMoreTokens()) {
                buf.append(st.nextToken());
            }
            String str = buf.toString().toLowerCase();
            if (str.endsWith("e") && StringUtilities.isNumeric((String)str.substring(0, str.length() - 1))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isHnrStartTerm(String term) {
        if (hnrStartList != null) {
            return hnrStartList.contains(term.toUpperCase());
        }
        return false;
    }

    public static boolean isHnrCanContainTerm(String term) {
        if (term != null && hnrContainList != null) {
            return hnrContainList.contains(term.toUpperCase());
        }
        return false;
    }

    public static boolean isStreetNotContainTerm(String term) {
        if (streetNotContainList != null) {
            return streetNotContainList.contains(term.toUpperCase());
        }
        return false;
    }

    public static boolean isRomanNumber(String term) {
        if (term == null || term.trim().length() == 0) {
            return false;
        }
        term = term.toUpperCase();
        char[] termChars = term.toCharArray();
        for (int i = 0; i < termChars.length; ++i) {
            int j;
            for (j = 0; j < romanNumberChars.length && termChars[i] != romanNumberChars[j]; ++j) {
            }
            if (j != romanNumberChars.length) continue;
            return false;
        }
        return true;
    }

    public static void loadExtendedChars(String key, String chars) {
        int pos = key.lastIndexOf(95);
        if (pos > -1 && pos + 2 >= key.length()) {
            String k = key.substring(pos + 1, pos + 2).toUpperCase();
            if (chars == null || chars.trim().length() == 0) {
                return;
            }
            if (extendedCharMap == null) {
                extendedCharMap = new HashMap(5);
            }
            StringTokenizer st = new StringTokenizer(chars, ",");
            char[] extendedChars = new char[st.countTokens()];
            for (int i = 0; i < extendedChars.length; ++i) {
                String exChar = st.nextToken().trim().toUpperCase();
                extendedChars[i] = exChar.charAt(0);
            }
            extendedCharMap.put(k, extendedChars);
        }
    }

    public static boolean isExtendedChar(String ch) {
        if (ch != null && ch.length() == 1) {
            return FRA_AddressTerm.isExtendedChar(ch.charAt(0));
        }
        return false;
    }

    public static boolean isExtendedChar(char ch) {
        ch = new Character(Character.toUpperCase(ch)).charValue();
        Iterator it = extendedCharMap.keySet().iterator();
        while (it.hasNext()) {
            char[] extendedChars = (char[])extendedCharMap.get(it.next());
            for (int i = 0; i < extendedChars.length; ++i) {
                if (extendedChars[i] != ch) continue;
                return true;
            }
        }
        return false;
    }

    public static String getValidTerm(String inTerm) {
        return FRA_AddressTerm.getValidTerm(inTerm, false);
    }

    public static String getValidTerm(String inTerm, boolean canHaveNumeric) {
        if (inTerm == null || inTerm.trim().length() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer(inTerm.length());
        char lastChar = '\u0000';
        for (int i = 0; i < inTerm.length(); ++i) {
            char ch = inTerm.charAt(i);
            if (ch == '_') {
                ch = '-';
            }
            if (ch == ',') {
                ch = ' ';
            }
            if (FRA_AddressTerm.isValidPunctuationCharacter(ch) && buf.length() > 0) {
                if (lastChar != ch) {
                    buf.append(ch);
                }
            } else if (ch == '\'') {
                buf.append(ch);
            } else if (Character.isLetter(ch)) {
                buf.append(ch);
            } else if (FRA_AddressTerm.isExtendedChar(ch)) {
                buf.append(ch);
            } else if (canHaveNumeric && FRA_AddressTerm.isDigit(ch)) {
                buf.append(ch);
            }
            lastChar = ch;
        }
        if (buf.length() > 0) {
            return buf.toString().trim();
        }
        return null;
    }

    public static boolean isValidPunctuationCharacter(char ch) {
        for (int i = 0; i < validPunctuationChars.length; ++i) {
            if (ch != validPunctuationChars[i]) continue;
            return true;
        }
        return false;
    }

    private static void loadDirectionals(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (directionalList == null) {
                directionalList = new ArrayList(10);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                String directional = st.nextToken().trim();
                if (directional.length() <= 0) continue;
                directionalList.add(directional.toUpperCase());
            }
        }
    }

    public static boolean isDirectional(String term) {
        if (term == null || directionalList == null) {
            return false;
        }
        return directionalList.contains(term.toUpperCase());
    }

    private static void loadPreNumStreetWord(String raw) {
        if (raw == null || raw.trim().length() == 0) {
            return;
        }
        if (preNumStreetWordList == null) {
            preNumStreetWordList = new ArrayList(5);
        }
        StringTokenizer st = new StringTokenizer(raw, ",");
        while (st.hasMoreTokens()) {
            String word = st.nextToken().trim();
            preNumStreetWordList.add(word.toUpperCase());
        }
    }

    private static void loadPostNumStreetWord(String raw) {
        if (raw == null || raw.trim().length() == 0) {
            return;
        }
        if (postNumStreetWordList == null) {
            postNumStreetWordList = new ArrayList(5);
        }
        StringTokenizer st = new StringTokenizer(raw, ",");
        while (st.hasMoreTokens()) {
            String word = st.nextToken().trim();
            postNumStreetWordList.add(word.toUpperCase());
        }
    }

    private static void loadRomanNumeralWords(String raw) {
        if (raw == null || raw.trim().length() == 0) {
            return;
        }
        if (romanNumeralWordList == null) {
            romanNumeralWordList = new ArrayList(10);
        }
        StringTokenizer st = new StringTokenizer(raw, ",");
        while (st.hasMoreTokens()) {
            String word = st.nextToken().trim();
            romanNumeralWordList.add(word.toUpperCase());
        }
    }

    public static boolean isPreNumStreetWord(String word) {
        if (word == null) {
            return false;
        }
        return preNumStreetWordList.contains(word.toUpperCase());
    }

    public static boolean isPostNumStreetWord(String word) {
        if (word == null) {
            return false;
        }
        return postNumStreetWordList.contains(word.toUpperCase());
    }

    public static boolean isMonth(String term) {
        if (monthWordList == null || term == null || term.trim().length() == 0) {
            return false;
        }
        return monthWordList.contains(term.toUpperCase());
    }

    public static String getPunctuationsAsString() {
        if (punctuationList == null) {
            return null;
        }
        return punctuationList.toString();
    }

    public static String getOrdinalsAsString() {
        if (ordinalCharList == null) {
            return null;
        }
        return ordinalCharList.toString();
    }

    public static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static int countWords(String str) {
        if (str == null) {
            return 0;
        }
        char[] chars = str.toCharArray();
        int words = chars.length > 0 ? 1 : 0;
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (Arrays.binarySearch(validPunctuationChars, ch) <= -1) continue;
            ++words;
        }
        return words;
    }

    public static int findFirstPunctuationIndex(String name) {
        int ndx = -1;
        for (int i = 0; i < validPunctuationChars.length; ++i) {
            int tempNdx = name.indexOf(validPunctuationChars[i]);
            if (tempNdx <= -1 || ndx >= 0 && tempNdx >= ndx) continue;
            ndx = tempNdx;
        }
        return ndx;
    }

    public static int findLastPunctuationIndex(String name) {
        int ndx = -1;
        for (int i = 0; i < validPunctuationChars.length; ++i) {
            int tempNdx = name.lastIndexOf(validPunctuationChars[i]);
            if (tempNdx <= -1 || tempNdx <= ndx) continue;
            ndx = tempNdx;
        }
        return ndx;
    }

    public static String getCollatorRules() {
        return collatorRules;
    }

    public static char[] getExtendedCharsForChar(char ch) {
        return extendedCharMap == null ? null : extendedCharMap.get("" + ch);
    }

    public static char[] getExtendedCharsMappedChars() {
        if (extendedCharMap != null) {
            Set s = extendedCharMap.keySet();
            char[] chars = new char[s.size()];
            Iterator it = s.iterator();
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = ((String)it.next()).charAt(0);
            }
            return chars;
        }
        return null;
    }

    public static boolean isCommonNoPostCodeTerm(String term) {
        if (term == null) {
            return false;
        }
        return commonNoPostCodeTermList != null && commonNoPostCodeTermList.contains(term.toUpperCase());
    }

    public static boolean isCommonTermWithPostNumber(String term) {
        if (term == null) {
            return false;
        }
        return commonTermsWithPostNumberList != null && commonTermsWithPostNumberList.contains(term.toUpperCase());
    }

    public static int isPOBox(ArrayList list) {
        if (list == null || list.size() == 0) {
            return 0;
        }
        StringBuffer buf = new StringBuffer(10);
        for (int i = 0; i < list.size(); ++i) {
            String term = (String)list.get(i);
            if (FRA_AddressTerm.isPunctuation(term)) continue;
            buf.append(term.toUpperCase());
        }
        if (buf.length() == 0) {
            return 0;
        }
        String str = buf.toString();
        boolean partialFound = false;
        for (int i = 0; i < poboxWordList.size(); ++i) {
            String poboxWord = (String)poboxWordList.get(i);
            if (poboxWord.equals(str)) {
                return 2;
            }
            if (!poboxWord.startsWith(str)) continue;
            partialFound = true;
        }
        if (partialFound) {
            return 1;
        }
        return 0;
    }

    public static int isPOBox(String str) {
        if (str == null || poboxWordList == null) {
            return 0;
        }
        StringTokenizer st = new StringTokenizer(str, " .-");
        ArrayList<String> list = new ArrayList<String>(5);
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return FRA_AddressTerm.isPOBox(list);
    }

    private static void loadCommonNoPostCodeTerms(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (commonNoPostCodeTermList == null) {
                commonNoPostCodeTermList = new ArrayList(5);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                String contains = st.nextToken().trim();
                if (contains.length() <= 0) continue;
                commonNoPostCodeTermList.add(contains.toUpperCase());
            }
        }
    }

    private static void loadCommonTermsWithPostNumber(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (commonTermsWithPostNumberList == null) {
                commonTermsWithPostNumberList = new ArrayList(5);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                String contains = st.nextToken().trim();
                if (contains.length() <= 0) continue;
                commonTermsWithPostNumberList.add(contains.toUpperCase());
            }
        }
    }

    private static void loadPOBoxWords(String raw) {
        String string = raw = raw == null ? "" : raw.trim();
        if (raw.length() > 0) {
            if (poboxWordList == null) {
                poboxWordList = new ArrayList(5);
            }
            StringTokenizer st = new StringTokenizer(raw.toUpperCase(), ",");
            while (st.hasMoreTokens()) {
                poboxWordList.add(st.nextToken().trim());
            }
        }
    }

    public static String replaceChars(String str, char[] charsToReplace, char replacement) {
        boolean replaced = false;
        char[] strChars = str.toCharArray();
        for (int i = 0; i < charsToReplace.length; ++i) {
            for (int j = 0; j < strChars.length; ++j) {
                if (strChars[j] != charsToReplace[i]) continue;
                strChars[j] = replacement;
                replaced = true;
            }
        }
        if (replaced) {
            return new String(strChars);
        }
        return str;
    }

    public static String replaceAll(String str, String strToReplace, String replacement) {
        int pos = -1;
        boolean replaced = false;
        StringBuffer buf = new StringBuffer();
        int lastPos = 0;
        while ((pos = str.indexOf(strToReplace, lastPos + 1)) > -1) {
            buf.append(str.substring(lastPos, pos));
            buf.append(replacement);
            lastPos = pos + strToReplace.length();
        }
        if (replaced) {
            return buf.toString();
        }
        return str;
    }

    static {
        try {
            properties = FileUtilities.loadProperties((String)"com/mapinfo/mapmarker/CHE/FRA/parser/FRA_AddressTerm.properties");
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key.startsWith(PUNCTUATION_CHARACTERS_KEY)) {
                    FRA_AddressTerm.loadPunctuations(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(COUNTRY_CODES_KEY)) {
                    FRA_AddressTerm.loadCountryCodes(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(HNR_START)) {
                    FRA_AddressTerm.loadHnrStartTerms(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(HNR_CAN_CONTAIN)) {
                    FRA_AddressTerm.loadHnrContainTerms(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(STREET_NOT_CONTAIN)) {
                    FRA_AddressTerm.loadStreetNotContainTerms(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(EXTENDED_CHARS)) {
                    FRA_AddressTerm.loadExtendedChars(key, properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(DIRECTIONALS)) {
                    FRA_AddressTerm.loadDirectionals(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(PRE_NUM_STREET_WORD)) {
                    FRA_AddressTerm.loadPreNumStreetWord(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(POST_NUM_STREET_WORD)) {
                    FRA_AddressTerm.loadPostNumStreetWord(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(MONTH_WORDS)) {
                    FRA_AddressTerm.loadMonths(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(ORDINAL_CHARS)) {
                    FRA_AddressTerm.loadOrdinals(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(ORDINALS_WORDS)) {
                    FRA_AddressTerm.loadOrdinals(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(ROMAN_NUMERAL_WORDS)) {
                    FRA_AddressTerm.loadRomanNumeralWords(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(POBOX_WORDS)) {
                    FRA_AddressTerm.loadPOBoxWords(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(COMMON_NO_POSTCODE_TERMS)) {
                    FRA_AddressTerm.loadCommonNoPostCodeTerms(properties.getProperty(key));
                    continue;
                }
                if (!key.startsWith(COMMON_TERMS_WITH_POST_NUMBER)) continue;
                FRA_AddressTerm.loadCommonTermsWithPostNumber(properties.getProperty(key));
            }
            StringBuffer buf = new StringBuffer();
            char[] chars = FRA_AddressTerm.getExtendedCharsMappedChars();
            int charSize = chars == null ? 0 : chars.length;
            for (int i = 0; i < charSize; ++i) {
                int exCharsSize;
                char ch = chars[i];
                char[] exChars = FRA_AddressTerm.getExtendedCharsForChar(ch);
                int n = exCharsSize = exChars == null ? 0 : exChars.length;
                if (exCharsSize <= 0) continue;
                buf.append("& ");
                buf.append(ch);
                buf.append(" ; ");
                for (int j = 0; j < exCharsSize; ++j) {
                    buf.append(exChars[j]);
                    buf.append(" , ");
                }
                buf.deleteCharAt(buf.length() - 1);
                buf.deleteCharAt(buf.length() - 1);
            }
            collatorRules = buf.toString();
        }
        catch (Throwable T) {
            throw new RuntimeException("Unable to load required files for FRA_Parser.");
        }
        Arrays.sort(validPunctuationChars);
    }
}

