/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.FRA.parser;

import com.mapinfo.mapmarker.utils.FileUtilities;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;

public class FRA_ThoroughfareTypes {
    private static Properties m_streetTypes = null;
    private static HashMap m_keys = new HashMap();
    private static HashMap m_prefferKeys = new HashMap();
    private String m_streetNamePart = null;
    private String m_streetTypePart = null;

    public static String lookupProperName(String key) {
        KeyInfo keyinfo = (KeyInfo)m_prefferKeys.get(key = key == null ? "" : key.trim().toUpperCase());
        if (keyinfo == null) {
            return null;
        }
        return keyinfo.getProperTypeName();
    }

    public static boolean isStreetType(String aTerm) {
        return m_keys.containsKey(aTerm.toUpperCase());
    }

    public String getStreetType() {
        return this.m_streetTypePart;
    }

    public String getStreetNamePart() {
        return this.m_streetNamePart;
    }

    public static String findStreetType(String str) {
        String string = str = str == null ? "" : str.trim().toUpperCase();
        if (str.length() == 0) {
            return null;
        }
        for (String type : m_keys.keySet()) {
            if (!str.endsWith(type)) continue;
            return type;
        }
        return null;
    }

    public static String getPrefferedName(String str) {
        KeyInfo keyinfo = (KeyInfo)m_keys.get(str = str == null ? "" : str.trim().toUpperCase());
        if (keyinfo != null) {
            return keyinfo.getPreferredTypeName();
        }
        return null;
    }

    public static String findStreetNamePart(String str) {
        String string = str = str == null ? "" : str.trim().toUpperCase();
        if (str.length() == 0) {
            return null;
        }
        String type = FRA_ThoroughfareTypes.findStreetType(str);
        if (type == null || type.length() == str.length()) {
            return str;
        }
        return str.substring(0, str.length() - type.length());
    }

    public static boolean containsStreetType(String str) {
        return FRA_ThoroughfareTypes.findStreetType(str) != null;
    }

    static {
        try {
            if (m_streetTypes == null) {
                m_streetTypes = FileUtilities.loadProperties((String)"com/mapinfo/mapmarker/CHE/FRA/parser/FRA_ThoroughfareTypes.properties");
                Enumeration<?> e = m_streetTypes.propertyNames();
                while (e.hasMoreElements()) {
                    KeyInfo key = new KeyInfo();
                    String type = (String)e.nextElement();
                    key.loadKey(m_streetTypes, type);
                    m_keys.put(type.toUpperCase(), key);
                    m_prefferKeys.put(key.getPreferredTypeName().toUpperCase(), key);
                }
            }
        }
        catch (Throwable T) {
            throw new RuntimeException("Unable to load required files for FRA_Parser.");
        }
    }

    static class KeyInfo {
        private String m_type = "";
        private String m_preferredType = "";
        private String m_properName = "";
        private boolean m_canStart = false;
        private boolean m_canEnd = false;

        KeyInfo() {
        }

        public String getTypeName() {
            return this.m_type;
        }

        public String getPreferredTypeName() {
            return this.m_preferredType;
        }

        public String getProperTypeName() {
            return this.m_properName;
        }

        public boolean canStart() {
            return this.m_canStart;
        }

        public boolean canEnd() {
            return this.m_canEnd;
        }

        public void loadKey(Properties p, String k) {
            String val = p.getProperty(k);
            StringTokenizer tokens = new StringTokenizer(val, ",");
            this.m_preferredType = tokens.nextToken();
            this.m_properName = tokens.nextToken();
            this.m_canStart = Boolean.valueOf(tokens.nextToken());
            this.m_canEnd = Boolean.valueOf(tokens.nextToken());
        }
    }
}

