/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.FRA.parser;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

public class Logger {
    private PrintWriter outputFile;
    private String mainAddress;
    private static Logger theInstance;

    private Logger() {
    }

    public Logger(String filename) {
        File f = new File(filename);
        try {
            this.outputFile = new PrintWriter(new BufferedWriter(new FileWriter(f.getAbsolutePath())));
        }
        catch (Exception e) {
            System.out.println("Exception within the logger class: " + e);
        }
    }

    public static void log(String msg) {
        if (theInstance == null) {
            theInstance = new Logger("D:\\maps\\MMJAVA\\FRA\\Output.txt");
        }
    }

    private void writeOut(String msg) {
        this.outputFile.println(msg);
    }

    public static void close() {
        if (theInstance != null) {
            theInstance.closePrivate();
        }
    }

    private void closePrivate() {
        if (this.outputFile != null) {
            this.outputFile.flush();
            this.outputFile.close();
        }
    }

    public static void saveMainAddressPart(String mainAddress) {
        if (theInstance != null) {
            theInstance.privateSaveMainAddressPart(mainAddress);
        }
    }

    private void privateSaveMainAddressPart(String mainAddress) {
        this.mainAddress = mainAddress;
    }

    public static boolean compareToSavedMainAddress(String parsed) {
        if (theInstance != null) {
            return theInstance.privateCompareToSavedMainAddress(parsed);
        }
        return false;
    }

    private boolean privateCompareToSavedMainAddress(String parsed) {
        if (parsed == null || this.mainAddress == null) {
            return false;
        }
        return parsed.trim().equals(this.mainAddress.trim());
    }

    public static String getSavedMainAddressPart() {
        if (theInstance != null) {
            return Logger.theInstance.mainAddress;
        }
        return null;
    }
}

