/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.ITA;

import com.mapinfo.mapmarker.utils.FileUtilities;
import java.util.Properties;

public class ITA_LocaliserProperties {
    private static final String ITA_LOCALISER_NUMBER_HNRS_CODES = "NUMBER_HNRS_CODES";
    private static final String ITA_LOCALISER_PROVINCE_ABBREVIATION = "PROVINCE_ABBREVIATION";
    private static final String ITA_LOCALISER_POSTCODE_LENGTH = "POSTCODE_LENGTH";
    private static final String ITA_LOCALISER_POSTCODE_COUNTRY_PREFIXES = "POSTCODE_COUNTRY_PREFIXES";
    private static final String ITA_LOCALISER_SAC_LENGTH = "SAC_LENGTH";
    private static Properties properties = null;

    public static int getNumberHNRSCodes() {
        String numberCodes = properties.getProperty(ITA_LOCALISER_NUMBER_HNRS_CODES);
        int result = 0;
        try {
            result = Integer.parseInt(numberCodes);
        }
        catch (NumberFormatException x) {
            System.err.println("ITA_LOCALISER_NUMBER_HNRS_CODES is not a valid number in ITA_LocaliserProperties.properties");
            System.exit(1);
        }
        return result;
    }

    public static boolean provinceAbbreviation() {
        String provinceAbb = properties.getProperty(ITA_LOCALISER_PROVINCE_ABBREVIATION);
        return !provinceAbb.equalsIgnoreCase("false");
    }

    public static int getPostCodeLength() {
        String postCodeLength = properties.getProperty(ITA_LOCALISER_POSTCODE_LENGTH);
        int result = 0;
        try {
            result = Integer.parseInt(postCodeLength);
        }
        catch (NumberFormatException x) {
            System.err.println("ITA_LOCALISER_POSTCODE_LENGTH is not a valid number in ITA_LocaliserProperties.properties");
            System.exit(1);
        }
        return result;
    }

    public static String getPostCodePrefixes() {
        String prefixString = properties.getProperty(ITA_LOCALISER_POSTCODE_COUNTRY_PREFIXES);
        if (prefixString == null) {
            return null;
        }
        return prefixString.trim();
    }

    public static int getSacLength() {
        String prefixString = properties.getProperty(ITA_LOCALISER_SAC_LENGTH);
        if (prefixString == null) {
            return 0;
        }
        try {
            return Integer.parseInt(prefixString.trim());
        }
        catch (Exception e) {
            return 0;
        }
    }

    static {
        try {
            properties = FileUtilities.loadProperties((String)"com/mapinfo/mapmarker/CHE/CHE_LocaliserProperties.properties");
        }
        catch (Throwable T) {
            throw new RuntimeException("Unable to load ITA_LocaliserProperties.properties");
        }
    }
}

