/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.ITA.parser;

import com.mapinfo.mapmarker.CHE.ITA.ITA_LocaliserProperties;
import com.mapinfo.mapmarker.CHE.parser.CHE_AddressTerm;
import com.mapinfo.mapmarker.utils.FileUtilities;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class ITA_AddressTerm {
    private static final String PUNCTUATION_CHARACTERS_KEY = "punctuation_chars";
    private static final String COUNTRY_CODES_KEY = "country_codes";
    private static final String HNR_START = "hnr_start";
    private static final String HNR_CAN_CONTAIN = "hnr_can_contain";
    private static final String STREET_NOT_CONTAIN = "street_not_contain";
    private static final String EXTENDED_CHARS = "extended_chars";
    private static final String DIRECTIONALS = "directionals";
    private static final String PRE_NUM_STREET_WORD = "pre_num_street_word";
    private static final String POST_NUM_STREET_WORD = "post_num_street_word";
    private static final String MONTH_WORDS = "month_words";
    private static final String ORDINAL_CHARS = "ordinal_chars";
    private static final String ROMAN_NUMERAL_WORDS = "roman_numeral_words";
    private static final String CONCAT_STREET_NAMES = "concat_street_names";
    private static char[] romanNumberChars = new char[]{'X', 'V', 'I', ' ', '1'};
    private static char[] validPunctuationChars = new char[]{'-', '\'', ',', ' ', '.'};
    private static StringBuffer punctuationList = null;
    private static StringBuffer ordinalCharList = null;
    private static ArrayList cntryCodeList = null;
    private static ArrayList hnrStartList = null;
    private static ArrayList hnrContainList = null;
    private static ArrayList streetNotContainList = null;
    private static ArrayList extendedCharsList = null;
    private static ArrayList directionalList = null;
    private static ArrayList preNumStreetWordList = null;
    private static ArrayList postNumStreetWordList = null;
    private static ArrayList monthWordList = null;
    private static ArrayList romanNumeralWordList = null;
    private static ArrayList concatWordsList = null;
    private static Properties properties;

    private static void loadPunctuations(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (punctuationList == null) {
                punctuationList = new StringBuffer(raw.length());
            }
            punctuationList.append(raw);
        }
    }

    private static void loadCountryCodes(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (cntryCodeList == null) {
                cntryCodeList = new ArrayList(5);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                String cntryCode = st.nextToken().trim();
                if (cntryCode.length() <= 0) continue;
                cntryCodeList.add(cntryCode.toUpperCase());
            }
        }
    }

    private static void loadHnrStartTerms(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (hnrStartList == null) {
                hnrStartList = new ArrayList(5);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                String start = st.nextToken().trim();
                if (start.length() <= 0) continue;
                hnrStartList.add(start.toUpperCase());
            }
        }
    }

    private static void loadHnrContainTerms(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (hnrContainList == null) {
                hnrContainList = new ArrayList(5);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                String contains = st.nextToken().trim();
                if (contains.length() <= 0) continue;
                hnrContainList.add(contains.toUpperCase());
            }
            hnrContainList.add(",");
        }
    }

    private static void loadStreetNotContainTerms(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (streetNotContainList == null) {
                streetNotContainList = new ArrayList(5);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                String contains = st.nextToken().trim();
                if (contains.length() <= 0) continue;
                streetNotContainList.add(contains.toUpperCase());
            }
        }
    }

    private static void loadMonths(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (monthWordList == null) {
                monthWordList = new ArrayList(5);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                String monthWord = st.nextToken().trim();
                if (monthWord.length() <= 0) continue;
                monthWordList.add(monthWord.toUpperCase());
            }
        }
    }

    private static void loadConcatStreetNamesList(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (concatWordsList == null) {
                concatWordsList = new ArrayList(5);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                String word = st.nextToken().trim();
                if (word.length() <= 0) continue;
                concatWordsList.add(word.toUpperCase());
            }
        }
    }

    private static void loadOrdinals(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (ordinalCharList == null) {
                ordinalCharList = new StringBuffer(raw.length());
            }
            ordinalCharList.append(raw.trim());
        }
    }

    public static boolean isCountryCode(String code) {
        if (cntryCodeList == null) {
            return false;
        }
        return cntryCodeList.contains(code.toUpperCase());
    }

    public static boolean isPunctuation(String term) {
        if (punctuationList == null || term == null || term.length() == 0) {
            return false;
        }
        return punctuationList.toString().indexOf(term) > -1;
    }

    public static boolean isPunctuation(char ch) {
        if (punctuationList == null) {
            return false;
        }
        return punctuationList.toString().indexOf(ch) > -1;
    }

    public static boolean isOrdinalChar(char ch) {
        if (ordinalCharList == null) {
            return false;
        }
        return ordinalCharList.toString().indexOf(ch) > -1;
    }

    public static boolean isOrdinalChar(String term) {
        if (ordinalCharList == null) {
            return false;
        }
        return ordinalCharList.toString().indexOf(term) > -1;
    }

    public static boolean isCommonTerm(String term) {
        if (CHE_AddressTerm.m_commonTermList == null) {
            return false;
        }
        return CHE_AddressTerm.m_commonTermList.contains(term.toUpperCase());
    }

    public static boolean isHnrStartTerm(String term) {
        if (hnrStartList == null) {
            return false;
        }
        return hnrStartList.contains(term.toUpperCase());
    }

    public static boolean isHnrCanContainTerm(String term) {
        if (term != null && hnrContainList != null) {
            return hnrContainList.contains(term.toUpperCase());
        }
        return false;
    }

    public static boolean isStreetNotContainTerm(String term) {
        if (streetNotContainList == null) {
            return false;
        }
        return streetNotContainList.contains(term.toUpperCase());
    }

    public static boolean isRomanNumber(String term) {
        if (term == null || term.trim().length() == 0) {
            return false;
        }
        if (romanNumeralWordList.contains(term = term.toUpperCase())) {
            return true;
        }
        char[] termChars = term.toCharArray();
        for (int i = 0; i < termChars.length; ++i) {
            int j;
            for (j = 0; j < romanNumberChars.length && termChars[i] != romanNumberChars[j]; ++j) {
            }
            if (j != romanNumberChars.length) continue;
            return false;
        }
        return true;
    }

    public static void loadExtendedChars(String chars) {
        if (chars == null || chars.trim().length() == 0) {
            return;
        }
        if (extendedCharsList == null) {
            extendedCharsList = new ArrayList(10);
        }
        StringTokenizer st = new StringTokenizer(chars, ",");
        while (st.hasMoreTokens()) {
            String exChar = st.nextToken().trim().toUpperCase();
            Character ch = new Character(exChar.charAt(0));
            extendedCharsList.add(ch);
        }
    }

    public static boolean isExtendedChar(String ch) {
        if (ch != null && ch.length() == 1) {
            return ITA_AddressTerm.isExtendedChar(ch.charAt(0));
        }
        return false;
    }

    public static boolean isExtendedChar(char ch) {
        Character exChar = new Character(Character.toUpperCase(ch));
        return extendedCharsList.contains(exChar);
    }

    public static String getValidTerm(String inTerm) {
        return ITA_AddressTerm.getValidTerm(inTerm, false);
    }

    public static String getValidTerm(String inTerm, boolean canHaveNumeric) {
        if (inTerm == null || inTerm.trim().length() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer(inTerm.length());
        for (int i = 0; i < inTerm.length(); ++i) {
            char ch = inTerm.charAt(i);
            if (ch == '_') {
                ch = '-';
            }
            if (ch == ',') {
                ch = ' ';
            }
            if (ITA_AddressTerm.isValidPunctuationCharacter(ch) && buf.length() > 0) {
                buf.append(ch);
                continue;
            }
            if (ch == '\'') {
                buf.append(ch);
                continue;
            }
            if (Character.isLetter(ch)) {
                buf.append(ch);
                continue;
            }
            if (ITA_AddressTerm.isExtendedChar(ch)) {
                buf.append(ch);
                continue;
            }
            if (!canHaveNumeric || !ITA_AddressTerm.isDigit(ch)) continue;
            buf.append(ch);
        }
        if (buf.length() > 0) {
            return buf.toString().trim();
        }
        return null;
    }

    public static boolean isValidPunctuationCharacter(char ch) {
        for (int i = 0; i < validPunctuationChars.length; ++i) {
            if (ch != validPunctuationChars[i]) continue;
            return true;
        }
        return false;
    }

    private static void loadDirectionals(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (directionalList == null) {
                directionalList = new ArrayList(10);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                String directional = st.nextToken().trim();
                if (directional.length() <= 0) continue;
                directionalList.add(directional.toUpperCase());
            }
        }
    }

    public static boolean isDirectional(String term) {
        if (term == null || directionalList == null) {
            return false;
        }
        return directionalList.contains(term.toUpperCase());
    }

    private static void loadPreNumStreetWord(String raw) {
        if (raw == null || raw.trim().length() == 0) {
            return;
        }
        if (preNumStreetWordList == null) {
            preNumStreetWordList = new ArrayList(5);
        }
        StringTokenizer st = new StringTokenizer(raw, ",");
        while (st.hasMoreTokens()) {
            String word = st.nextToken().trim();
            preNumStreetWordList.add(word.toUpperCase());
        }
    }

    private static void loadPostNumStreetWord(String raw) {
        if (raw == null || raw.trim().length() == 0) {
            return;
        }
        if (postNumStreetWordList == null) {
            postNumStreetWordList = new ArrayList(5);
        }
        StringTokenizer st = new StringTokenizer(raw, ",");
        while (st.hasMoreTokens()) {
            String word = st.nextToken().trim();
            postNumStreetWordList.add(word.toUpperCase());
        }
    }

    private static void loadRomanNumeralWords(String raw) {
        if (raw == null || raw.trim().length() == 0) {
            return;
        }
        if (romanNumeralWordList == null) {
            romanNumeralWordList = new ArrayList(10);
        }
        StringTokenizer st = new StringTokenizer(raw, ",");
        while (st.hasMoreTokens()) {
            String word = st.nextToken().trim();
            romanNumeralWordList.add(word.toUpperCase());
        }
    }

    public static boolean isPreNumStreetWord(String word) {
        if (word == null) {
            return false;
        }
        return preNumStreetWordList.contains(word.toUpperCase());
    }

    public static boolean isPostNumStreetWord(String word) {
        if (word == null) {
            return false;
        }
        return postNumStreetWordList.contains(word.toUpperCase());
    }

    public static boolean isMonth(String term) {
        if (monthWordList == null || term == null || term.trim().length() == 0) {
            return false;
        }
        return monthWordList.contains(term.toUpperCase());
    }

    public static boolean isConcatWord(String term) {
        if (concatWordsList == null || term == null || term.trim().length() == 0) {
            return false;
        }
        return concatWordsList.contains(term.toUpperCase());
    }

    public static String getPunctuationsAsString() {
        if (punctuationList == null) {
            return null;
        }
        return punctuationList.toString();
    }

    public static String getOrdinalsAsString() {
        if (ordinalCharList == null) {
            return null;
        }
        return ordinalCharList.toString();
    }

    public static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    static {
        try {
            properties = null;
            ITA_AddressTerm.loadCountryCodes(ITA_LocaliserProperties.getPostCodePrefixes());
            properties = FileUtilities.loadProperties((String)"com/mapinfo/mapmarker/CHE/ITA/parser/ITA_AddressTerm.properties");
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key.startsWith(PUNCTUATION_CHARACTERS_KEY)) {
                    ITA_AddressTerm.loadPunctuations(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(COUNTRY_CODES_KEY)) {
                    ITA_AddressTerm.loadCountryCodes(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(HNR_START)) {
                    ITA_AddressTerm.loadHnrStartTerms(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(HNR_CAN_CONTAIN)) {
                    ITA_AddressTerm.loadHnrContainTerms(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(STREET_NOT_CONTAIN)) {
                    ITA_AddressTerm.loadStreetNotContainTerms(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(EXTENDED_CHARS)) {
                    ITA_AddressTerm.loadExtendedChars(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(DIRECTIONALS)) {
                    ITA_AddressTerm.loadDirectionals(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(PRE_NUM_STREET_WORD)) {
                    ITA_AddressTerm.loadPreNumStreetWord(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(POST_NUM_STREET_WORD)) {
                    ITA_AddressTerm.loadPostNumStreetWord(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(MONTH_WORDS)) {
                    ITA_AddressTerm.loadMonths(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(ORDINAL_CHARS)) {
                    ITA_AddressTerm.loadOrdinals(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(ROMAN_NUMERAL_WORDS)) {
                    ITA_AddressTerm.loadRomanNumeralWords(properties.getProperty(key));
                    continue;
                }
                if (!key.startsWith(CONCAT_STREET_NAMES)) continue;
                ITA_AddressTerm.loadConcatStreetNamesList(properties.getProperty(key));
            }
        }
        catch (Throwable T) {
            throw new RuntimeException("Unable to load required files for ITA_Parser.");
        }
    }
}

