/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.ITA.parser;

import com.mapinfo.mapmarker.CHE.ITA.ITA_LocaliserProperties;
import com.mapinfo.mapmarker.CHE.ITA.parser.ITA_AddressTerm;
import com.mapinfo.mapmarker.CHE.ITA.parser.ITA_ProvinceAbbreviations;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class ITA_ParsePostAddressRule
implements IParseRule {
    public static final int POSTCODE_INVALID = 0;
    public static final int POSTCODE_PARTIAL = 1;
    public static final int POSTCODE_FULL = 2;
    private static String NO_MATCH_TOWN_ON_PROVINCE = "no_match_town_on_province";
    private static final int VALID_POSTCODE_LENGTH = ITA_LocaliserProperties.getPostCodeLength();

    public void parse(Address inputAddress, Address parsedAddress, IConstraints constraints) throws ParserException {
        int postcodeType;
        StringTokenizer tokens;
        String postcode = parsedAddress.getPostCode1();
        String town = ITA_AddressTerm.getValidTerm(parsedAddress.getAreaName3());
        String province = ITA_AddressTerm.getValidTerm(parsedAddress.getGenericField1());
        String fullProvince = ITA_AddressTerm.getValidTerm(parsedAddress.getAreaName2());
        LinkedList listOfTokens = null;
        String postAddress = parsedAddress.getPostAddress();
        if (postAddress != null && postAddress.trim().length() > 0) {
            postAddress = this.addSpaces(postAddress);
            tokens = new StringTokenizer(postAddress, " ()-/.,\\", true);
            listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
            this.removeCountry(listOfTokens);
            this.seperatePostcode(listOfTokens, parsedAddress);
        } else if (parsedAddress.getAreaName3() != null && parsedAddress.getAreaName3().trim().length() > 0) {
            tokens = new StringTokenizer(parsedAddress.getAreaName3(), " ()-/.,\\", true);
            listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
        }
        if (listOfTokens != null) {
            this.cleanTown(listOfTokens);
            this.seperateProvince(listOfTokens, parsedAddress);
            this.seperateTown(listOfTokens, parsedAddress);
            if (parsedAddress.getAreaName1() != null && parsedAddress.getAreaName1().length() > 0) {
                if (parsedAddress.getAreaName3() != null && parsedAddress.getAreaName3().length() > 0 && parsedAddress.getAreaName1().equalsIgnoreCase(parsedAddress.getAreaName3())) {
                    parsedAddress.setAreaName1(null);
                } else if (parsedAddress.getAreaName4() != null && parsedAddress.getAreaName4().length() > 0 && parsedAddress.getAreaName1().equalsIgnoreCase(parsedAddress.getAreaName4())) {
                    parsedAddress.setAreaName1(null);
                }
            }
        }
        if ((postcodeType = ITA_ParsePostAddressRule.checkPostcode(postcode)) == 2) {
            parsedAddress.setPostCode1(postcode);
        } else if (postcodeType == 1 && ITA_ParsePostAddressRule.checkPostcode(parsedAddress.getPostCode1()) != 2) {
            parsedAddress.setPostCode1(postcode);
        }
        if (town != null && town.trim().length() > 0) {
            String shortTown = ITA_ParsePostAddressRule.removeCommonWords(town);
            if (shortTown != null) {
                parsedAddress.setAreaName3(shortTown);
            } else {
                parsedAddress.setAreaName3(town);
            }
            HashMap<String, String> addFields = parsedAddress.getAdditionalFields();
            if (addFields == null) {
                addFields = new HashMap<String, String>(1);
            }
            addFields.put(NO_MATCH_TOWN_ON_PROVINCE, "true");
        }
        if (!(parsedAddress.getPostCode1() != null && parsedAddress.getPostCode1().trim().length() != 0 || parsedAddress.getAreaName3() != null && parsedAddress.getAreaName3().trim().length() != 0)) {
            throw new ParserException(2000);
        }
        if (province != null && province.trim().length() > 0) {
            if (province.length() > 2) {
                String abbrProvince = null;
                if (fullProvince != null) {
                    abbrProvince = ITA_ProvinceAbbreviations.getProvinceAbbreviation(fullProvince);
                }
                if (abbrProvince == null) {
                    abbrProvince = ITA_ProvinceAbbreviations.getProvinceAbbreviation(province);
                }
                if (abbrProvince != null) {
                    parsedAddress.setAreaName1(abbrProvince);
                } else if (fullProvince != null) {
                    parsedAddress.setAreaName2(fullProvince);
                } else {
                    parsedAddress.setAreaName2(province);
                }
            } else {
                parsedAddress.setAreaName1(province);
            }
        }
    }

    private void seperatePostcode(LinkedList listOfTokens, Address pa) {
        if (listOfTokens == null || listOfTokens.size() == 0) {
            return;
        }
        int len = listOfTokens.size();
        boolean partPostcode = false;
        StringBuffer postBuf = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            String temp = (String)listOfTokens.get(i);
            if (temp.equals(" ")) continue;
            if (StringUtilities.isNumeric((String)temp)) {
                if (postBuf.length() < VALID_POSTCODE_LENGTH && partPostcode) {
                    if (temp.length() > VALID_POSTCODE_LENGTH - postBuf.length()) {
                        listOfTokens.set(i, temp.substring(VALID_POSTCODE_LENGTH - postBuf.length()));
                        postBuf.append(temp.substring(0, VALID_POSTCODE_LENGTH - postBuf.length()));
                    } else {
                        postBuf.append(temp.substring(0));
                        listOfTokens.remove(i);
                        --len;
                    }
                    partPostcode = true;
                } else if (temp.length() > VALID_POSTCODE_LENGTH) {
                    postBuf.append(temp.substring(0, VALID_POSTCODE_LENGTH));
                    listOfTokens.set(i, temp.substring(VALID_POSTCODE_LENGTH));
                    partPostcode = false;
                } else {
                    postBuf.append(temp);
                    listOfTokens.remove(i);
                    --len;
                    partPostcode = true;
                }
                if (postBuf.length() != VALID_POSTCODE_LENGTH) continue;
                break;
            }
            partPostcode = false;
        }
        if (postBuf.toString().trim().length() > 0) {
            pa.setPostCode1(postBuf.toString());
        }
    }

    private void seperateProvince(LinkedList listOfTokens, Address pa) {
        String prov;
        if (listOfTokens == null || listOfTokens.size() == 0) {
            return;
        }
        StringBuffer province = new StringBuffer();
        boolean foundProvince = false;
        boolean foundEndParenthesis = false;
        while (listOfTokens.size() > 0) {
            String temp = (String)listOfTokens.getLast();
            if (temp.equals(" ")) {
                if (province.length() > 0) {
                    province.insert(0, ' ');
                }
                listOfTokens.removeLast();
                continue;
            }
            if (temp.length() == 2 && (ITA_ProvinceAbbreviations.getProvinceForAbbreviation(temp) != null || province.length() == 0)) {
                province.insert(0, temp);
                foundProvince = true;
                listOfTokens.removeLast();
                break;
            }
            if (foundEndParenthesis && temp.equals("(")) {
                listOfTokens.removeLast();
                foundProvince = true;
                break;
            }
            if (temp.equals(")") && !foundEndParenthesis) {
                foundEndParenthesis = true;
                listOfTokens.removeLast();
                continue;
            }
            if (temp.equals("-") && !foundEndParenthesis) {
                if (province.length() > 0) {
                    foundProvince = true;
                    listOfTokens.removeLast();
                    break;
                }
                listOfTokens.removeLast();
                break;
            }
            province.insert(0, temp);
            listOfTokens.removeLast();
        }
        if (foundProvince && province.length() > 0 && (prov = ITA_AddressTerm.getValidTerm(province.toString())) != null) {
            if (prov.length() != 2) {
                String abbrProvince = ITA_ProvinceAbbreviations.getProvinceAbbreviation(prov);
                if (abbrProvince != null) {
                    pa.setAreaName2(abbrProvince);
                } else {
                    pa.setAreaName2(prov);
                }
            } else {
                pa.setAreaName2(prov.toUpperCase());
            }
            return;
        }
        if (province.length() > 0) {
            StringTokenizer st = new StringTokenizer(province.toString(), " ()-/.,\\", true);
            while (st.hasMoreTokens()) {
                listOfTokens.add(st.nextToken());
            }
        }
    }

    private void seperateTown(LinkedList listOfTokens, Address pa) {
        String shortTown;
        if (listOfTokens == null || listOfTokens.size() == 0) {
            return;
        }
        StringBuffer townBuf = new StringBuffer();
        int len = listOfTokens.size();
        for (int i = 0; i < len; ++i) {
            townBuf.append((String)listOfTokens.get(i));
        }
        String town = ITA_AddressTerm.getValidTerm(townBuf.toString());
        if (town != null) {
            StringBuffer tempTown = new StringBuffer(town.length());
            LinkedList tempList = StringUtilities.tokensToList((StringTokenizer)new StringTokenizer(town, " "));
            if (tempList.size() > 1) {
                for (int i = tempList.size() - 1; i >= 0; --i) {
                    String term = (String)tempList.get(i);
                    String abbr = ITA_ProvinceAbbreviations.getProvinceAbbreviation(term);
                    if (abbr != null && pa.getAreaName2() == null && pa.getAreaName3() == null) {
                        pa.setAreaName2(abbr);
                        continue;
                    }
                    abbr = ITA_ProvinceAbbreviations.getProvinceAbbreviation(term + " " + tempTown.toString());
                    if (abbr != null && pa.getAreaName2() == null && pa.getAreaName3() == null) {
                        pa.setAreaName2(abbr);
                        tempTown = new StringBuffer(town.length());
                        continue;
                    }
                    tempTown.insert(0, " ");
                    tempTown.insert(0, term);
                }
                town = tempTown.toString().trim();
            }
        }
        if ((shortTown = ITA_ParsePostAddressRule.removeCommonWords(town)) != null && !town.equals(shortTown.trim())) {
            pa.setAreaName4(town);
        }
        if (shortTown == null || shortTown.trim().length() == 0) {
            pa.setAreaName3(town);
        } else {
            pa.setAreaName3(shortTown);
        }
    }

    private void cleanTown(LinkedList listOfTokens) {
        String temp;
        while (listOfTokens.size() > 0) {
            temp = (String)listOfTokens.getFirst();
            if (temp == null) continue;
            if (temp.length() == 0) {
                listOfTokens.removeFirst();
                continue;
            }
            if (!ITA_AddressTerm.isPunctuation(temp)) break;
            listOfTokens.removeFirst();
        }
        while (listOfTokens.size() > 0) {
            temp = (String)listOfTokens.getLast();
            if (temp == null) continue;
            if (temp.length() == 0) {
                listOfTokens.removeLast();
                continue;
            }
            if (!ITA_AddressTerm.isPunctuation(temp)) break;
            listOfTokens.removeLast();
        }
        String lastPunctuation = null;
        int i = 0;
        while (listOfTokens.size() > i) {
            String temp2 = (String)listOfTokens.get(i);
            if (ITA_AddressTerm.isPunctuation(temp2)) {
                if (lastPunctuation != null && lastPunctuation.equals(temp2)) {
                    listOfTokens.remove(i);
                    continue;
                }
            } else {
                lastPunctuation = temp2;
            }
            ++i;
        }
    }

    public static String removeCommonWords(String inTown) {
        if (inTown == null || inTown.trim().length() == 0) {
            return null;
        }
        StringBuffer outTown = new StringBuffer();
        StringTokenizer st = new StringTokenizer(inTown, " ()/.,\\", true);
        int lastPunctuation = 0;
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            if (temp.length() == 1 && temp.charAt(0) == ' ') {
                if (lastPunctuation == 32) continue;
                outTown.append(temp);
                lastPunctuation = 32;
                continue;
            }
            if (ITA_AddressTerm.isCommonTerm(temp)) continue;
            outTown.append(temp);
            lastPunctuation = 0;
        }
        if (outTown.toString().trim().length() > 0) {
            while (outTown.length() > 0 && ITA_AddressTerm.isPunctuation(outTown.substring(0, 1))) {
                outTown.deleteCharAt(0);
            }
        }
        if (outTown.toString().trim().length() == 0) {
            return inTown;
        }
        return outTown.toString().trim();
    }

    public static String cleanTown(String name) {
        if (name != null) {
            StringTokenizer st = new StringTokenizer(name, " -_/\\");
            StringBuffer buf = new StringBuffer(name.length() + 5);
            while (st.hasMoreTokens()) {
                String temp = st.nextToken();
                if ((temp.startsWith("D\ufffd") || temp.startsWith("d\ufffd") || temp.startsWith("Di") || temp.startsWith("di")) && temp.length() > 2) {
                    String temp1 = temp.substring(0, 2);
                    String temp2 = temp.substring(2);
                    buf.append(temp1);
                    buf.append(' ');
                    buf.append(temp2);
                    continue;
                }
                buf.append(temp);
                if (!st.hasMoreTokens()) continue;
                buf.append(' ');
            }
            return buf.toString();
        }
        return null;
    }

    private void removeCountry(LinkedList listOfTokens) {
        String temp;
        boolean cntryCodeFound = false;
        while (listOfTokens.size() > 0) {
            temp = (String)listOfTokens.getFirst();
            if (ITA_AddressTerm.isPunctuation(temp)) {
                listOfTokens.removeFirst();
                continue;
            }
            cntryCodeFound = false;
            if (ITA_AddressTerm.isCountryCode(temp)) {
                listOfTokens.removeFirst();
                cntryCodeFound = true;
            }
            if (cntryCodeFound) continue;
            break;
        }
        while (listOfTokens.size() > 0) {
            temp = (String)listOfTokens.getLast();
            if (ITA_AddressTerm.isPunctuation(temp)) {
                listOfTokens.removeLast();
                continue;
            }
            cntryCodeFound = false;
            if (ITA_AddressTerm.isCountryCode(temp)) {
                listOfTokens.removeLast();
                cntryCodeFound = true;
            }
            if (cntryCodeFound) continue;
            break;
        }
    }

    public static boolean isValidProvinceAbbreviation(String abbreviation) {
        return abbreviation != null && abbreviation.trim().length() == 2;
    }

    private String addSpaces(String input) {
        if (input == null || input.trim().length() < 1) {
            return input;
        }
        StringBuffer buf = new StringBuffer(input);
        boolean lastCharWasDigit = false;
        for (int i = 0; i < buf.length(); ++i) {
            if (this.isDigit(buf.charAt(i))) {
                if (!lastCharWasDigit && i > 0 && buf.charAt(i) != ' ') {
                    buf.insert(i, ' ');
                }
                lastCharWasDigit = true;
                continue;
            }
            if (lastCharWasDigit && buf.charAt(i) != ' ') {
                buf.insert(i, ' ');
            }
            lastCharWasDigit = false;
        }
        return buf.toString();
    }

    public static int checkPostcode(String postcode) {
        if (postcode == null || postcode.trim().length() == 0) {
            return 0;
        }
        try {
            Integer.parseInt(postcode);
        }
        catch (NumberFormatException ne) {
            return 0;
        }
        if (postcode.trim().length() == 5) {
            return 2;
        }
        return 1;
    }

    private boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }
}

