/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.dp.binary;

import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.IDataProvider;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataWriter;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJPostInfoItem;
import com.mapinfo.mapmarker.common.dp.binary.PostInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.PostInfoIndexValue;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.DataOutput;
import java.io.IOException;
import java.io.RandomAccessFile;

public class CHEDataWriter
extends MMJDataWriter {
    private IDataProvider m_provider;
    private RandomAccessFile m_postInfoDataFile;
    private RandomAccessFile m_postInfoIndexFile;

    public CHEDataWriter(IDataProvider provider) {
        super(provider);
        this.m_provider = provider;
    }

    public void processPostInfo(String postInfoFileBaseName) throws DataCreationException {
        this.m_provider.preProcessPostInfoDataSet();
        boolean bFirst = true;
        MMJPostInfoItem item = this.m_provider.getNextPostInfoItem();
        while (item != null) {
            if (bFirst) {
                bFirst = false;
                this.createPostInfoIndexFile(postInfoFileBaseName);
                this.createPostInfoDataFile(postInfoFileBaseName, this.m_provider.getPostInfoMetadata());
                try {
                    this.writePostInfoIndexEntry(item.getKey(), this.m_postInfoDataFile.getFilePointer());
                }
                catch (IOException e) {
                    throw new DataCreationException(500, (Throwable)e);
                }
            }
            try {
                this.writePostInfoIndexEntry(item.getKey(), this.m_postInfoDataFile.getFilePointer());
            }
            catch (IOException e) {
                throw new DataCreationException(500, (Throwable)e);
            }
            PostInfoDataItem record = item.getItem();
            if (record != null) {
                try {
                    record.write((DataOutput)this.m_postInfoDataFile, (MMJDataFileMetadata)this.m_provider.getPostInfoMetadata());
                }
                catch (IOException e) {
                    throw new DataCreationException(500, (Throwable)e);
                }
                catch (MMJEDataCorruptedException e) {
                    throw new DataCreationException(500, (Throwable)e);
                }
            }
            item = this.m_provider.getNextPostInfoItem();
        }
        try {
            if (this.m_postInfoIndexFile != null) {
                this.m_postInfoIndexFile.close();
            }
            if (this.m_postInfoDataFile != null) {
                this.m_postInfoDataFile.close();
            }
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logError("Error closing data files.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(500, (Throwable)e);
        }
    }

    private void createPostInfoDataFile(String postInfoFileBaseName, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        try {
            this.m_postInfoDataFile = new RandomAccessFile(StringUtilities.appendToPath((String)this.m_provider.getPostInfoFilePath(), (String)postInfoFileBaseName, (String)".jdr"), "rw");
            metadata.write((DataOutput)this.m_postInfoDataFile);
        }
        catch (IOException e) {
            throw new DataCreationException(500, (Throwable)e);
        }
    }

    private void createPostInfoIndexFile(String postInfoFileBaseName) throws DataCreationException {
        try {
            this.m_postInfoIndexFile = new RandomAccessFile(StringUtilities.appendToPath((String)this.m_provider.getPostInfoFilePath(), (String)postInfoFileBaseName, (String)".tdx"), "rw");
        }
        catch (IOException e) {
            throw new DataCreationException(600, (Throwable)e);
        }
    }

    private void writePostInfoIndexEntry(MapMarkerIndexKey key, long offset) throws DataCreationException {
        PostInfoIndexValue value = new PostInfoIndexValue(offset);
        try {
            key.write((DataOutput)this.m_postInfoIndexFile);
            value.write((DataOutput)this.m_postInfoIndexFile);
        }
        catch (IOException e) {
            throw new DataCreationException(600, (Throwable)e);
        }
    }
}

