/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.dp.binary;

import com.mapinfo.mapmarker.CHE.CHE_AddressUtils;
import com.mapinfo.mapmarker.CHE.CHE_InternalCandidateAddress;
import com.mapinfo.mapmarker.CHE.CHE_Range;
import com.mapinfo.mapmarker.CHE.CHE_StreetCandidateAddress;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_AddressFetcher;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.IDictionarySearchOrder;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.RangeUnit;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItemAccessor;
import com.mapinfo.mapmarker.common.dp.binary.GenericIINtermediateRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.GenericRange;
import com.mapinfo.mapmarker.common.dp.binary.GenericSegment;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreet;
import com.mapinfo.mapmarker.common.dp.binary.GenericUnit;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.ICompressedSegment;
import com.mapinfo.mapmarker.common.dp.binary.IDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.IGeoInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.TAIntermediateRangeRecord;
import com.mapinfo.mapmarker.utils.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class CHE_AddressFetcher
extends EMEA_AddressFetcher {
    static NumberFormat postalFormatter = NumberFormat.getInstance();
    private boolean m_APFetching;

    public CHE_AddressFetcher(Properties localSettings, Properties localStrings, boolean isAPFetching) {
        super(localSettings, localStrings);
        postalFormatter.setMinimumIntegerDigits(4);
        postalFormatter.setMaximumIntegerDigits(4);
        postalFormatter.setGroupingUsed(false);
        this.m_APFetching = isAPFetching;
    }

    @Override
    public NumberFormat getPostalFormatter() {
        return postalFormatter;
    }

    protected void populateCandidateFromData(StreetCandidateAddress cand, IDataFileDataItem street, long streetOffset, MMJDataFileMetadata metadata) throws LocalizationException, IOException {
        super.populateCandidateFromData(cand, street, streetOffset, metadata);
        this.privatePopulateCandidateFromData(cand, street, streetOffset, metadata);
    }

    private void privatePopulateCandidateFromData(StreetCandidateAddress cand, IDataFileDataItem street, long streetOffset, MMJDataFileMetadata metadata) throws LocalizationException, IOException {
        HashMap adFields = cand.getAdditionalFields();
        GenericStreet genericStreet = (GenericStreet)street;
        this.fillAdditionalFields(adFields, genericStreet, 34, "pre_main_address_common");
        this.fillAdditionalFields(adFields, genericStreet, 37, "pre_addr_common");
        this.fillAdditionalFields(adFields, genericStreet, 38, "post_addr_common");
        this.fillAdditionalFields(adFields, genericStreet, 42, "PRE_DIRECTIONAL_SEPARATOR");
        this.fillAdditionalFields(adFields, genericStreet, 40, "POST_TT_SEPARATOR");
        this.fillAdditionalFields(adFields, genericStreet, 41, "PRE_TT_SEPARATOR");
        this.fillAdditionalFields(adFields, genericStreet, 39, "POST_MAIN_SEPARATOR");
        this.fillAdditionalFields(adFields, genericStreet, 32, "address.start");
        this.fillAdditionalFields(adFields, genericStreet, 33, "address.end");
        this.fillAdditionalFields(adFields, genericStreet, 35, "post_st_type_common");
        this.fillAdditionalFields(adFields, genericStreet, 34, "pre_street_type_common");
        this.fillAdditionalFields(adFields, genericStreet, 35, "post_st_type_common");
        this.fillAdditionalFields(adFields, genericStreet, 50, "original_street_name");
    }

    private void fillAdditionalFields(HashMap fields, GenericStreet genericStreet, int intKey, String strKey) throws LocalizationException {
        if (genericStreet.hasString(intKey)) {
            String value = GenericDataItemAccessor.getDataString((int)intKey, (GenericDataItem)genericStreet);
            fields.put(strKey, value);
        }
    }

    public InternalCandidateAddress makeInternalCandidateAddress() {
        return new CHE_InternalCandidateAddress();
    }

    protected InternalCandidateAddress makeInternalCandidateAddress(StreetCandidateAddress street, IConstraints constraints) {
        return new CHE_InternalCandidateAddress((Address)street);
    }

    protected StreetCandidateAddress getStreetCandidateAddressObject() {
        return new CHE_StreetCandidateAddress(this.m_APFetching);
    }

    public List makeStreetCandidates(StreetCandidateAddress street, SeekableDataInput file, MMJDataFileMetadata metadata, IDataDictionary dict, IConstraints constraints) throws LocalizationException, IOException, MMJEDataCorruptedException {
        file.seek(street.getSegmentBlockOffset());
        int segmentCount = file.readUnsignedShort();
        ArrayList candidates = new ArrayList(segmentCount);
        IDictionarySearchOrder order = constraints.getDictionarySearchOrder();
        if (this.m_APFetching) {
            this.getAPCandiates(street, file, metadata, dict, constraints, segmentCount, candidates);
        } else {
            this.getSegmentedCandidates(street, file, metadata, dict, constraints, segmentCount, candidates);
        }
        return candidates;
    }

    private void getAPCandiates(StreetCandidateAddress street, SeekableDataInput file, MMJDataFileMetadata metadata, IDataDictionary dict, IConstraints constraints, int segmentCount, List candidates) throws IOException, MMJEDataCorruptedException, LocalizationException {
        for (int h = 0; h < segmentCount; ++h) {
            GenericSegment genericSegment = this.createSegmentObject();
            long segmentOffset = file.getFilePointer();
            genericSegment.read((DataInput)file, metadata);
            Segment lastSegment = null;
            Segment segment = this.makeSegment();
            this.populateSegmentFromData(segment, genericSegment, segmentOffset, metadata, dict, lastSegment);
            this.populateSegmentHousePoints(segment, genericSegment, metadata);
            lastSegment = segment;
            InternalCandidateAddress cand = this.makeInternalCandidateAddress(street, constraints);
            cand.setVendorCode(String.valueOf(metadata.getVendorCode()));
            cand.setStreetOffset(street.getStreetOffset());
            candidates.add(cand);
            cand.setSegment(segment);
            int rc = genericSegment.getRangeCount();
            if (rc == 0) continue;
            Range lastRange = null;
            for (int i = 0; i < rc; ++i) {
                GenericRange genericRange = genericSegment.getRange(i);
                Range range = this.makeRange();
                range.setRangeNumber(i);
                this.populateRangeFromData(range, genericRange, metadata, dict, lastRange);
                lastRange = range;
                this.addRangeToSegment(segment, range, genericRange);
                this.getRangeUnit(metadata, dict, genericRange, range);
            }
        }
    }

    private void getRangeUnit(MMJDataFileMetadata metadata, IDataDictionary dict, GenericRange genericRange, Range range) throws LocalizationException, IOException {
        int uc = genericRange.getRangeUnitCount();
        if (uc != 0) {
            RangeUnit lastRangeUnit = null;
            for (int j = 0; j < uc; ++j) {
                GenericUnit genericUnit = genericRange.getRangeUnit(j);
                RangeUnit unit = this.makeRangeUnit();
                this.populateRangeUnitFromData(unit, genericUnit, metadata, dict, lastRangeUnit);
                lastRangeUnit = unit;
                range.addRangeUnit(unit);
            }
        }
    }

    private void getSegmentedCandidates(StreetCandidateAddress street, SeekableDataInput file, MMJDataFileMetadata metadata, IDataDictionary dict, IConstraints constraints, int segmentCount, List candidates) throws IOException, MMJEDataCorruptedException, LocalizationException {
        Segment lastSegment = null;
        for (int h = 0; h < segmentCount; ++h) {
            InternalCandidateAddress cand = this.makeInternalCandidateAddress(street, constraints);
            cand.setVendorCode(String.valueOf(metadata.getVendorCode()));
            cand.setStreetOffset(street.getStreetOffset());
            candidates.add(cand);
            Segment segment = this.makeSegment();
            cand.setSegment(segment);
            GenericSegment genericSegment = this.createSegmentObject();
            long segmentOffset = file.getFilePointer();
            genericSegment.read((DataInput)file, metadata);
            this.populateSegmentFromData(segment, genericSegment, segmentOffset, metadata, dict, lastSegment);
            this.populateSegmentHousePoints(segment, genericSegment, metadata);
            lastSegment = segment;
            int rc = genericSegment.getRangeCount();
            if (rc != 0) {
                Range lastRange = null;
                for (int i = 0; i < rc; ++i) {
                    GenericRange genericRange = genericSegment.getRange(i);
                    Range range = this.makeRange();
                    range.setRangeNumber(i);
                    this.populateRangeFromData(range, genericRange, metadata, dict, lastRange);
                    lastRange = range;
                    this.addRangeToSegment(segment, range, genericRange);
                    int uc = genericRange.getRangeUnitCount();
                    if (uc == 0) continue;
                    RangeUnit lastRangeUnit = null;
                    for (int j = 0; j < uc; ++j) {
                        GenericUnit genericUnit = genericRange.getRangeUnit(j);
                        RangeUnit unit = this.makeRangeUnit();
                        this.populateRangeUnitFromData(unit, genericUnit, metadata, dict, lastRangeUnit);
                        lastRangeUnit = unit;
                        range.addRangeUnit(unit);
                    }
                }
            }
            if (cand.getSegment().getLeftPostCode1().equals(cand.getSegment().getRightPostCode1())) continue;
            CHE_InternalCandidateAddress tempCand = new CHE_InternalCandidateAddress((Address)cand);
            tempCand.getSegment().setLeftPostCode1(tempCand.getSegment().getRightPostCode1());
            tempCand.setClosestSegmentSide(-1);
            candidates.add(tempCand);
        }
    }

    protected void populateRangeFromData(Range range, GenericRange genericRange, MMJDataFileMetadata metadata, IDataDictionary dict, Range lastRange) throws LocalizationException, IOException {
        this.localPopulateRangeFromData(range, genericRange, metadata, dict, lastRange);
        if (genericRange.hasByte(3)) {
            ((CHE_Range)range).sethouseNumberPrecision(GenericDataItemAccessor.getDataByte((int)3, (GenericDataItem)genericRange));
        }
        if (genericRange.hasLong(4)) {
            ((CHE_Range)range).setpointID(GenericDataItemAccessor.getDataLong((int)4, (GenericDataItem)genericRange));
        }
    }

    protected void localPopulateRangeFromData(Range range, GenericRange genericRange, MMJDataFileMetadata metadata, IDataDictionary dict, Range lastRange) throws LocalizationException, IOException {
        ParsedNumber number;
        if (genericRange.hasByte(1)) {
            range.setRangeDirection((int)GenericDataItemAccessor.getDataByte((int)1, (GenericDataItem)genericRange));
        }
        if (genericRange.hasByte(0)) {
            range.setOddEven((int)GenericDataItemAccessor.getDataByte((int)0, (GenericDataItem)genericRange));
        }
        if (genericRange.hasString(2)) {
            range.setPlaceName(GenericDataItemAccessor.getDataString((int)2, (GenericDataItem)genericRange));
        }
        if (genericRange.hasUnsignedByte(1)) {
            range.setFrom(new ParsedNumber((long)GenericDataItemAccessor.getDataUnsignedByte((int)1, (GenericDataItem)genericRange)));
        } else if (genericRange.hasUnsignedShort(1)) {
            range.setFrom(new ParsedNumber((long)GenericDataItemAccessor.getDataUnsignedShort((int)1, (GenericDataItem)genericRange)));
        } else if (genericRange.hasInteger(0)) {
            range.setFrom(new ParsedNumber((long)GenericDataItemAccessor.getDataInt((int)0, (GenericDataItem)genericRange)));
        } else if (genericRange.hasLong(0)) {
            range.setFrom(new ParsedNumber(GenericDataItemAccessor.getDataLong((int)0, (GenericDataItem)genericRange)));
        } else if (genericRange.hasString(1)) {
            String fromHnr = GenericDataItemAccessor.getDataString((int)1, (GenericDataItem)genericRange);
            number = CHE_AddressUtils.prepareParsedHnrfromString(fromHnr);
            if (number != null) {
                range.setFrom(number);
            } else {
                range.setFrom(fromHnr);
            }
        }
        if (genericRange.hasBlob(0)) {
            range.setIntermediateRecordArray(new GenericIINtermediateRangeRecord().getRecord(GenericDataItemAccessor.getDataBlob((int)0, (GenericDataItem)genericRange)));
        } else if (genericRange.hasBlob(1)) {
            byte[] blob = GenericDataItemAccessor.getDataBlob((int)1, (GenericDataItem)genericRange);
            range.setIntermediateRecordArray(new TAIntermediateRangeRecord(blob).getIntermediateDataRecords());
        }
        if (genericRange.hasUnsignedByte(2)) {
            range.setTo(new ParsedNumber((long)GenericDataItemAccessor.getDataUnsignedByte((int)2, (GenericDataItem)genericRange)));
        } else if (genericRange.hasUnsignedShort(2)) {
            range.setTo(new ParsedNumber((long)GenericDataItemAccessor.getDataUnsignedShort((int)2, (GenericDataItem)genericRange)));
        } else if (genericRange.hasInteger(1)) {
            range.setTo(new ParsedNumber((long)GenericDataItemAccessor.getDataInt((int)1, (GenericDataItem)genericRange)));
        } else if (genericRange.hasLong(1)) {
            range.setTo(new ParsedNumber(GenericDataItemAccessor.getDataLong((int)1, (GenericDataItem)genericRange)));
        } else if (genericRange.hasString(0)) {
            String toHnr = GenericDataItemAccessor.getDataString((int)0, (GenericDataItem)genericRange);
            number = CHE_AddressUtils.prepareParsedHnrfromString(toHnr);
            if (number != null) {
                range.setTo(number);
            } else {
                range.setTo(toHnr);
            }
        }
    }

    protected Range makeRange() {
        return new CHE_Range(this.m_APFetching);
    }

    @Override
    protected void populateSegmentFromData(Segment segment, GenericSegment genericSegment, long segmentOffset, MMJDataFileMetadata metadata, IDataDictionary dict, Segment lastSegment) throws LocalizationException, IOException {
        this.localpopulateSegmentFromData(segment, genericSegment, segmentOffset, metadata, dict, lastSegment);
        if (genericSegment.hasString(19)) {
            segment.setSegmentId(GenericDataItemAccessor.getDataString((int)19, (GenericDataItem)genericSegment));
        }
        if (genericSegment.hasLong(3)) {
            segment.setSegmentId(String.valueOf(GenericDataItemAccessor.getDataLong((int)3, (GenericDataItem)genericSegment)));
        }
    }

    protected void localpopulateSegmentFromData(Segment segment, GenericSegment genericSegment, long segmentOffset, MMJDataFileMetadata metadata, IDataDictionary dict, Segment lastSegment) throws LocalizationException, IOException {
        int postVal;
        String leftPostalCode1 = null;
        String rightPostalCode1 = null;
        if (genericSegment.hasShort(32)) {
            postVal = GenericDataItemAccessor.getDataShort((int)32, (GenericDataItem)genericSegment);
            rightPostalCode1 = leftPostalCode1 = this.getPostalFormatter().format(postVal);
        } else if (genericSegment.hasInteger(32)) {
            postVal = GenericDataItemAccessor.getDataInt((int)32, (GenericDataItem)genericSegment);
            rightPostalCode1 = leftPostalCode1 = this.getPostalFormatter().format(postVal);
        } else if (genericSegment.hasString(12)) {
            rightPostalCode1 = leftPostalCode1 = GenericDataItemAccessor.getDataString((int)12, (GenericDataItem)genericSegment);
        } else {
            if (genericSegment.hasShort(33)) {
                postVal = GenericDataItemAccessor.getDataShort((int)33, (GenericDataItem)genericSegment);
                leftPostalCode1 = this.getPostalFormatter().format(postVal);
            } else if (genericSegment.hasInteger(33)) {
                postVal = GenericDataItemAccessor.getDataInt((int)33, (GenericDataItem)genericSegment);
                leftPostalCode1 = this.getPostalFormatter().format(postVal);
            } else if (genericSegment.hasString(0)) {
                leftPostalCode1 = GenericDataItemAccessor.getDataString((int)0, (GenericDataItem)genericSegment);
            }
            if (genericSegment.hasShort(34)) {
                postVal = GenericDataItemAccessor.getDataShort((int)34, (GenericDataItem)genericSegment);
                rightPostalCode1 = this.getPostalFormatter().format(postVal);
            } else if (genericSegment.hasInteger(34)) {
                postVal = GenericDataItemAccessor.getDataInt((int)34, (GenericDataItem)genericSegment);
                rightPostalCode1 = this.getPostalFormatter().format(postVal);
            } else if (genericSegment.hasString(1)) {
                rightPostalCode1 = GenericDataItemAccessor.getDataString((int)1, (GenericDataItem)genericSegment);
            }
        }
        segment.setLeftPostCode1(leftPostalCode1);
        segment.setRightPostCode1(rightPostalCode1);
        String leftAreaName3 = null;
        String rightAreaName3 = null;
        String leftAreaName2 = null;
        String rightAreaName2 = null;
        String leftAreaName1 = null;
        String rightAreaName1 = null;
        String leftAreaName4 = null;
        String rightAreaName4 = null;
        if (genericSegment.hasLong(0) && !dict.isUserDictionary()) {
            long geoOffset = GenericDataItemAccessor.getDataLong((int)0, (GenericDataItem)genericSegment);
            IGeoInfoFetcher geoFetcher = dict.getGeoInfoFetcher();
            GeoInfoRecord geoRecord = geoFetcher.getGeoInfoRecord(geoOffset);
            leftAreaName3 = geoRecord.getAreaName3();
            rightAreaName3 = geoRecord.getAreaName3();
            if (genericSegment.hasString(14)) {
                rightAreaName1 = leftAreaName1 = GenericDataItemAccessor.getDataString((int)14, (GenericDataItem)genericSegment);
            } else {
                leftAreaName1 = genericSegment.hasString(4) ? GenericDataItemAccessor.getDataString((int)4, (GenericDataItem)genericSegment) : geoRecord.getAreaName1();
                rightAreaName1 = genericSegment.hasString(5) ? GenericDataItemAccessor.getDataString((int)5, (GenericDataItem)genericSegment) : geoRecord.getAreaName1();
            }
            if (genericSegment.hasString(15)) {
                rightAreaName2 = leftAreaName2 = GenericDataItemAccessor.getDataString((int)15, (GenericDataItem)genericSegment);
            } else {
                leftAreaName2 = genericSegment.hasString(6) ? GenericDataItemAccessor.getDataString((int)6, (GenericDataItem)genericSegment) : geoRecord.getAreaName2();
                rightAreaName2 = genericSegment.hasString(7) ? GenericDataItemAccessor.getDataString((int)7, (GenericDataItem)genericSegment) : geoRecord.getAreaName2();
            }
            if (genericSegment.hasString(17)) {
                rightAreaName4 = leftAreaName4 = GenericDataItemAccessor.getDataString((int)17, (GenericDataItem)genericSegment);
            } else {
                leftAreaName4 = genericSegment.hasString(10) ? GenericDataItemAccessor.getDataString((int)10, (GenericDataItem)genericSegment) : geoRecord.getAreaName4();
                rightAreaName4 = genericSegment.hasString(11) ? GenericDataItemAccessor.getDataString((int)11, (GenericDataItem)genericSegment) : geoRecord.getAreaName4();
            }
            segment.setGeoInfoRecord(geoRecord);
        } else {
            if (genericSegment.hasString(14)) {
                rightAreaName1 = leftAreaName1 = GenericDataItemAccessor.getDataString((int)14, (GenericDataItem)genericSegment);
            } else {
                if (genericSegment.hasString(4)) {
                    leftAreaName1 = GenericDataItemAccessor.getDataString((int)4, (GenericDataItem)genericSegment);
                }
                if (genericSegment.hasString(5)) {
                    rightAreaName1 = GenericDataItemAccessor.getDataString((int)5, (GenericDataItem)genericSegment);
                }
            }
            if (genericSegment.hasString(15)) {
                rightAreaName2 = leftAreaName2 = GenericDataItemAccessor.getDataString((int)15, (GenericDataItem)genericSegment);
            } else {
                if (genericSegment.hasString(6)) {
                    leftAreaName2 = GenericDataItemAccessor.getDataString((int)6, (GenericDataItem)genericSegment);
                }
                if (genericSegment.hasString(7)) {
                    rightAreaName2 = GenericDataItemAccessor.getDataString((int)7, (GenericDataItem)genericSegment);
                }
            }
            if (genericSegment.hasString(16)) {
                rightAreaName3 = leftAreaName3 = GenericDataItemAccessor.getDataString((int)16, (GenericDataItem)genericSegment);
            } else {
                if (genericSegment.hasString(8)) {
                    leftAreaName3 = GenericDataItemAccessor.getDataString((int)8, (GenericDataItem)genericSegment);
                }
                if (genericSegment.hasString(9)) {
                    rightAreaName3 = GenericDataItemAccessor.getDataString((int)9, (GenericDataItem)genericSegment);
                }
            }
            if (genericSegment.hasString(17)) {
                rightAreaName4 = leftAreaName4 = GenericDataItemAccessor.getDataString((int)17, (GenericDataItem)genericSegment);
            } else {
                if (genericSegment.hasString(10)) {
                    leftAreaName4 = GenericDataItemAccessor.getDataString((int)10, (GenericDataItem)genericSegment);
                }
                if (genericSegment.hasString(11)) {
                    rightAreaName4 = GenericDataItemAccessor.getDataString((int)11, (GenericDataItem)genericSegment);
                }
            }
        }
        segment.setLeftAreaName3(leftAreaName3);
        segment.setRightAreaName3(rightAreaName3);
        segment.setLeftAreaName1(leftAreaName1);
        segment.setRightAreaName1(rightAreaName1);
        segment.setLeftAreaName2(leftAreaName2);
        segment.setRightAreaName2(rightAreaName2);
        segment.setLeftAreaName4(leftAreaName4);
        segment.setRightAreaName4(rightAreaName4);
        segment.setPointsAsCompressed((ICompressedSegment)genericSegment.getCompressedSegment());
        segment.setSegmentOffset(segmentOffset);
    }
}

