/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.dp.binary;

import com.mapinfo.mapmarker.CHE.CHE_Handler;
import com.mapinfo.mapmarker.CHE.CHE_StreetCandidateAddressFilter;
import com.mapinfo.mapmarker.CHE.dp.binary.CHE_DataDictionary;
import com.mapinfo.mapmarker.CHE.dp.binary.CHE_GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.DictionaryUsagePreference;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_DataManager;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoAliasKeyCreator;
import com.mapinfo.mapmarker.EngineThreadingModel;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CountryGeographyInfoImpl;
import com.mapinfo.mapmarker.common.ICountryGeographyInfo;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.StreetCandidateAddressFilter;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.DataManagerSettingsProvider;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataManagerInitializationException;
import com.mapinfo.mapmarker.core.CoreRetrievedCandidates;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.licensing.LicenseFilter;
import com.mapinfo.mapmarker.utils.MMJLog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.ResourceBundle;

public class CHE_DataManager
extends EMEA_DataManager {
    private static Throwable m_setupException;
    private static Properties m_dataResources;
    private static final String LSTRING_FILE = "com.mapinfo.mapmarker.common.dp.binary.DataManagerMessageStrings";
    private static final String ERROR_LOAD_DICT_MSG = "exception.error.reading.dictionaries";
    public static final String KEY_IGNORE_NO_SAC_ERROR = "KEY_IGNORE_NO_SAC_ERROR";
    public static final String KEY_SAC_ERROR_HAS_OCCURED = "KEY_SAC_ERROR_HAS_OCCURED";
    public static final String KEY_SUCCESS_HAS_OCCURED = "KEY_SUCCESS_HAS_OCCURED";
    public static final String KEY_SET_SAC_ERROR = "KEY_SET_SAC_ERROR";
    public static final String KEY_GEOBASE_STRING_ONLY = "KEY_GEOBASE_STRING_ONLY";
    public static final short GEOBASE_AREA1_FLAG = 1;
    public static final String KEY_STREETS_TO_REMOVE = "KEY_STREETS_TO_REMOVE";
    public static final String KEY_GEOBASE_FOR_AREA2 = "KEY_GEOBASE_FOR_AREA2";
    public static final String KEY_GEOBASE_FOR_AREA3 = "KEY_GEOBASE_FOR_AREA3";
    public static final String KEY_GEOBASE_FOR_AREA4 = "KEY_GEOBASE_FOR_AREA4";
    public static final String KEY_DEU_ALTERNATE_SOUNDEX_CODES = "KEY_DEU_ALTERNATE_SOUNDEX_CODES";
    private CHE_StreetCandidateAddressFilter m_CHEstreetFilter;
    static IDataDictionary[] m_dataDicts;
    static int m_numDicts;

    public CHE_DataManager() throws MMJEDataManagerInitializationException {
        if (m_setupException != null) {
            ResourceBundle rb = CHE_DataManager.loadBundleForLocale(null, (String)LSTRING_FILE);
            throw new MMJEDataManagerInitializationException(rb.getString(ERROR_LOAD_DICT_MSG));
        }
    }

    public int getDictionaryCount() {
        return m_numDicts;
    }

    public static ArrayList getGeoInfoAlias(String strGeoKey, String strPostCode, int dictNum) {
        if (strGeoKey == null && strPostCode == null) {
            return null;
        }
        if (m_dataDicts == null || m_dataDicts[dictNum] == null) {
            return null;
        }
        CHE_GeoInfoFetcherImpl geoFetcher = (CHE_GeoInfoFetcherImpl)((CHE_DataDictionary)m_dataDicts[dictNum]).getGeoInfoFetcher();
        if (geoFetcher == null) {
            return null;
        }
        return geoFetcher.getGeoInfoAlias(EMEA_GeoInfoAliasKeyCreator.createKey(strGeoKey, strPostCode));
    }

    @Override
    public IRetrievedCandidates retrieveCandidates(Address pa, ScoringAddress scoringAddress, IConstraints preferences) throws DataAccessException, FatalDataAccessException {
        IRetrievedCandidates retCandidates;
        try {
            retCandidates = super.retrieveCandidates(pa, scoringAddress, preferences);
        }
        catch (DataAccessException e) {
            if (e.getErrorCode() == 2104) {
                retCandidates = new CoreRetrievedCandidates(new ArrayList());
            }
            throw e;
        }
        return retCandidates;
    }

    public IRetrievedCandidates retrieveGeographicCentroids(Address pa, IConstraints preferences) throws FatalDataAccessException, DataAccessException {
        if (preferences.isFallbackToGeographic() && preferences.getGeocodeType() != 4) {
            HashMap<String, String> additionalFields = pa.getAdditionalFields();
            if (additionalFields == null) {
                additionalFields = new HashMap<String, String>();
            }
            String language = "DEU";
            additionalFields.put("highest_scoring_language", language);
            pa.setAdditionalFields(additionalFields);
            ((CHE_Handler)preferences.getHandler()).setPreParsedAddress(pa);
        }
        DictionaryUsagePreference originalSetting = preferences.getDictionaryUsage();
        preferences.setDictionaryUsage(DictionaryUsagePreference.AD_ONLY);
        IRetrievedCandidates candidates = super.retrieveGeographicCentroids(pa, preferences);
        preferences.setDictionaryUsage(originalSetting);
        return candidates;
    }

    public IDataDictionary getDictionary(int idx) {
        return m_dataDicts[idx];
    }

    protected LicenseFilter getLicenseFilter() {
        return null;
    }

    protected ICountryGeographyInfo getCountryGeographyInfoObject() {
        return new CountryGeographyInfoImpl("CHE");
    }

    public void reset() throws MMJEDataManagerInitializationException {
        if (!EngineThreadingModel.isThreadsafe()) {
            try {
                this.shutdown();
            }
            catch (DataAccessException DAEx) {
                throw new MMJEDataManagerInitializationException(DAEx.getMessage(), (Throwable)DAEx);
            }
            CHE_DataManager.start();
            if (m_setupException != null) {
                throw new MMJEDataManagerInitializationException(m_setupException.getMessage(), m_setupException);
            }
        }
    }

    private void shutdown() throws DataAccessException {
        for (int i = 0; i < m_numDicts; ++i) {
            IDataDictionary dict = m_dataDicts[i];
            dict.close();
            CHE_DataManager.m_dataDicts[i] = null;
        }
        m_dataDicts = null;
    }

    private static void start() {
        m_setupException = null;
        try {
            m_dataResources = DataManagerSettingsProvider.getInstance().getSettingsForCountry("CHE");
        }
        catch (IOException e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
            m_setupException = e;
        }
        try {
            m_numDicts = Integer.parseInt(m_dataResources.getProperty("DICTIONARY_COUNT"));
            if (m_numDicts < 1) {
                m_numDicts = 1;
            }
        }
        catch (Exception e) {
            m_numDicts = 1;
        }
        m_dataDicts = new CHE_DataDictionary[m_numDicts];
        try {
            for (int i = 0; i < m_numDicts; ++i) {
                try {
                    CHE_DataManager.m_dataDicts[i] = new CHE_DataDictionary(i, m_dataResources);
                    continue;
                }
                catch (DataDictionaryIntializationException DDIEx) {
                    MMJLog.getLog().error(DDIEx.getMessage(), (Throwable)DDIEx);
                    m_setupException = DDIEx;
                }
            }
        }
        catch (Exception e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
            m_setupException = e;
        }
    }

    protected StreetCandidateAddressFilter getStreetFilter() {
        if (this.m_CHEstreetFilter == null) {
            this.m_CHEstreetFilter = new CHE_StreetCandidateAddressFilter(null);
        }
        return this.m_CHEstreetFilter;
    }

    static {
        CHE_DataManager.start();
    }
}

