/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.dp.binary;

import com.mapinfo.mapmarker.CHE.dp.CHE_GeoinfoDependentHandler;
import com.mapinfo.mapmarker.CHE.dp.binary.index.CHE_GeoInfoIndexFile;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_StreetBuilder;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.GenericSegment;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreet;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MultiSegmentStreet;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexMultiValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class CHE_StreetBuilder
extends EMEA_StreetBuilder {
    private boolean m_isAPDictionary;
    private CHE_GeoinfoDependentHandler m_geoinfoHandler;

    public CHE_StreetBuilder() {
    }

    public CHE_StreetBuilder(Properties processingProperties, boolean m_bAPStreetData) {
        this.m_isAPDictionary = m_bAPStreetData;
        this.m_geoinfoHandler = new CHE_GeoinfoDependentHandler(processingProperties);
    }

    public IDataFileDataItem buildStreetFromRecord(MultiSegmentStreet record, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        GenericStreet street = (GenericStreet)super.buildStreetFromRecord(record, metadata);
        Address address = record.getAddress();
        try {
            String town = address.getAreaName4();
            if (town != null && town.length() != 0) {
                street.putString(17, town);
            }
            if (address.hasAdditionalFields()) {
                String preAddrCommon;
                String postStTypeCommon;
                String preCommon = (String)address.getAdditionalFields().get("pre_main_address_common");
                if (preCommon != null && preCommon.length() > 0) {
                    street.putString(34, preCommon);
                }
                if ((postStTypeCommon = (String)address.getAdditionalFields().get("post_st_type_common")) != null && postStTypeCommon.length() > 0) {
                    street.putString(35, postStTypeCommon);
                }
                String unparsedHnr = (String)address.getAdditionalFields().get("unparsed_hnr");
                StringBuffer buf = new StringBuffer();
                if (unparsedHnr != null && unparsedHnr.length() > 0) {
                    if (address.getPostAddress() != null) {
                        buf.append(address.getPostAddress());
                        buf.append(" ");
                    }
                    buf.append(unparsedHnr);
                    street.putString(10, buf.toString());
                }
                if ((preAddrCommon = (String)address.getAdditionalFields().get("pre_addr_common")) != null && preAddrCommon.length() > 0) {
                    street.putString(37, preAddrCommon);
                }
            }
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            System.err.println("Unable to add to the street.");
            System.err.println("Attempting to add: " + address.toString());
            System.err.println(MMJETASEEx.getMessage());
            MMJETASEEx.printStackTrace(System.err);
            System.exit(1);
        }
        return street;
    }

    protected void populateStreetInfo(MultiSegmentStreet record, IDataFileDataItem item, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        Address address = record.getAddress();
        GenericStreet street = (GenericStreet)item;
        String temp = "";
        try {
            super.populateStreetInfo(record, item, metadata);
            HashMap adFields = address.getAdditionalFields();
            if (adFields.containsKey("pre_addr_common")) {
                temp = adFields.get("pre_addr_common").toString();
                street.putString(37, temp);
            }
            if (adFields.containsKey("post_addr_common")) {
                temp = adFields.get("post_addr_common").toString();
                street.putString(38, temp);
            }
            if (adFields.containsKey("pre_street_type_common")) {
                temp = adFields.get("pre_street_type_common").toString();
                street.putString(34, temp);
            }
            if (adFields.containsKey("post_st_type_common")) {
                temp = adFields.get("post_st_type_common").toString();
                street.putString(35, temp);
            }
            if (adFields.containsKey("pre_main_address_common")) {
                temp = adFields.get("pre_main_address_common").toString();
                street.putString(34, temp);
            }
            if (adFields.containsKey("original_street_name")) {
                temp = adFields.get("original_street_name").toString();
                street.putString(50, temp);
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate street data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(101, (Throwable)e);
        }
    }

    @Override
    protected IDataFileDataItem buildSegmentFromRecord(MMJSegmentRecord segmentRecord, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        GenericSegment segment = (GenericSegment)this.getSegmentDataObject();
        try {
            int postVal;
            String segmentId = segmentRecord.getId();
            if (segmentId != null) {
                boolean storeSegmentIdAsLong = false;
                try {
                    segment.putLong(3, Long.parseLong(segmentId));
                    storeSegmentIdAsLong = true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (!storeSegmentIdAsLong) {
                    segment.putString(19, segmentId);
                }
            }
            String leftPostalCode1 = segmentRecord.getLeftPostalCode1();
            String rightPostalCode1 = segmentRecord.getRightPostalCode1();
            if (leftPostalCode1 != null && rightPostalCode1 != null && leftPostalCode1.equals(rightPostalCode1)) {
                if (StringUtilities.isNumeric((String)leftPostalCode1)) {
                    postVal = Integer.parseInt(leftPostalCode1);
                    if (postVal < Short.MAX_VALUE && postVal > Short.MIN_VALUE) {
                        segment.putShort(32, (short)postVal);
                    } else {
                        segment.putInt(32, postVal);
                    }
                } else {
                    segment.putString(12, leftPostalCode1);
                }
            } else {
                if (leftPostalCode1 != null) {
                    if (StringUtilities.isNumeric((String)leftPostalCode1)) {
                        postVal = Integer.parseInt(leftPostalCode1);
                        if (postVal < Short.MAX_VALUE && postVal > Short.MIN_VALUE) {
                            segment.putShort(33, (short)postVal);
                        } else {
                            segment.putInt(33, postVal);
                        }
                    } else {
                        segment.putString(0, leftPostalCode1);
                    }
                }
                if (rightPostalCode1 != null) {
                    if (StringUtilities.isNumeric((String)rightPostalCode1)) {
                        postVal = Integer.parseInt(rightPostalCode1);
                        if (postVal < Short.MAX_VALUE && postVal > Short.MIN_VALUE) {
                            segment.putShort(34, (short)postVal);
                        } else {
                            segment.putInt(34, postVal);
                        }
                    } else {
                        segment.putString(1, rightPostalCode1);
                    }
                }
            }
            String leftAreaName1 = segmentRecord.getLeftAreaName1();
            String rightAreaName1 = segmentRecord.getRightAreaName1();
            if (leftAreaName1 != null && rightAreaName1 != null && leftAreaName1.equals(rightAreaName1)) {
                segment.putString(14, leftAreaName1);
            } else {
                if (leftAreaName1 != null) {
                    segment.putString(4, leftAreaName1);
                }
                if (rightAreaName1 != null) {
                    segment.putString(5, rightAreaName1);
                }
            }
            String leftAreaName2 = segmentRecord.getLeftAreaName2();
            String rightAreaName2 = segmentRecord.getRightAreaName2();
            if (leftAreaName2 != null && rightAreaName2 != null && leftAreaName2.equals(rightAreaName2)) {
                segment.putString(15, leftAreaName2);
            } else {
                if (leftAreaName2 != null) {
                    segment.putString(6, leftAreaName2);
                }
                if (rightAreaName2 != null) {
                    segment.putString(7, rightAreaName2);
                }
            }
            String leftAreaName4 = segmentRecord.getLeftAreaName4();
            String rightAreaName4 = segmentRecord.getRightAreaName4();
            if (leftAreaName4 != null && rightAreaName4 != null && leftAreaName4.equals(rightAreaName4)) {
                segment.putString(17, leftAreaName4);
            } else {
                if (leftAreaName4 != null) {
                    segment.putString(10, leftAreaName4);
                }
                if (rightAreaName4 != null) {
                    segment.putString(11, rightAreaName4);
                }
            }
            String leftAreaName3 = segmentRecord.getLeftAreaName3();
            String rightAreaName3 = segmentRecord.getRightAreaName3();
            if (leftAreaName3 != null && rightAreaName3 != null) {
                if (leftAreaName3.equals(rightAreaName3)) {
                    if (!this.setGeoInfoRecordToData(segmentRecord, segment)) {
                        segment.putString(16, leftAreaName3);
                    }
                } else {
                    segment.putString(8, leftAreaName3);
                    segment.putString(9, rightAreaName3);
                }
            } else {
                if (leftAreaName3 != null) {
                    segment.putString(8, leftAreaName3);
                }
                if (rightAreaName3 != null) {
                    segment.putString(9, rightAreaName3);
                }
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(106, (Throwable)e);
        }
        catch (IOException IOEx) {
            System.err.println("Problem building generic segment.  Unable to lookup areaName in geoinfo.");
            System.err.println(IOEx.getMessage());
            IOEx.printStackTrace(System.err);
            System.exit(1);
        }
        this.storeSegmentPoints(segmentRecord, (IDataFileDataItem)segment, (MMJDataFileMetadata)metadata);
        this.storeHousePoints(segmentRecord, (IDataFileDataItem)segment, (MMJDataFileMetadata)metadata);
        MMJRangeRecord lastRange = null;
        List addressRanges = segmentRecord.getRanges();
        if (addressRanges != null) {
            for (MMJRangeRecord range : addressRanges) {
                this.compressRange(range, lastRange);
                lastRange = range;
                this.addRangeToSegment((IDataFileDataItem)segment, this.buildRangeFromRangeRecord(range, metadata));
                ++this.totalRanges;
            }
        }
        return segment;
    }

    private boolean setGeoInfoRecordToData(MMJSegmentRecord segmentRecord, GenericSegment segment) throws IOException, MMJETypeArraySizeExceededException {
        long geoOffset;
        if (this.m_geoIndex == null) {
            return false;
        }
        String combinedKey = "";
        combinedKey = segmentRecord.getLeftAreaName4() == null ? "" : segmentRecord.getLeftAreaName4();
        combinedKey = combinedKey + (segmentRecord.getLeftAreaName3() == null ? "" : segmentRecord.getLeftAreaName3());
        combinedKey = combinedKey + (segmentRecord.getLeftAreaName2() == null ? "" : segmentRecord.getLeftAreaName2());
        combinedKey = combinedKey + (segmentRecord.getLeftAreaName1() == null ? "" : segmentRecord.getLeftAreaName1());
        MiStringIndexKey key = new MiStringIndexKey(combinedKey);
        MapMarkerIndexMultiValue val = (MapMarkerIndexMultiValue)this.m_geoIndex.search((MapMarkerIndexKey)key);
        if (val == null && (val = (MapMarkerIndexMultiValue)this.m_geoIndex.search((MapMarkerIndexKey)(key = new MiStringIndexKey(segmentRecord.getLeftAreaName3())))) == null) {
            DataCreationLogger.getLogger().logInternalError("\n\nUnable to locate a geoinfo record for: " + segmentRecord.getLeftAreaName3() + " or combined key: " + combinedKey);
            DataCreationLogger.getLogger().logInternalError("Address Info: " + segmentRecord.toString());
            DataCreationLogger.getLogger().logInternalError("In zipcode: " + segmentRecord.getLeftPostalCode1());
        }
        if (val != null && (geoOffset = val.getOffsetAt((short)0)) > 0L) {
            segment.putLong(0, geoOffset);
            return true;
        }
        return false;
    }

    @Override
    public void setGeoInfoBaseName(String geoInfoFileBaseName) {
        try {
            this.m_geoinfoHandler.loadGeoinfoFetcher(this.m_isAPDictionary);
            if (this.m_geoinfoHandler.isGeoinfoFetcherInitialized()) {
                this.m_geoIndex = this.m_geoinfoHandler.getGeoinfoIndexFileHandle();
            }
        }
        catch (DataDictionaryIntializationException e) {
            DataCreationLogger.getLogger().logInternalError(e.getCause().getMessage());
            System.exit(1);
        }
    }

    protected void assignGeoInfoIndex(CHE_GeoInfoIndexFile index) {
        this.m_geoIndex = index;
    }
}

