/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.dp.binary.index;

import com.mapinfo.mapmarker.CHE.parser.CHE_AddressTerm;
import com.mapinfo.mapmarker.CHE.parser.CHE_PreParseHandler;
import com.mapinfo.mapmarker.EMEA.dp.binary.index.EMEA_GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.generic.soundex.GenericSoundex;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class CHE_GeoInfoSoundexIndexer
extends EMEA_GeoInfoSoundexIndexer {
    private Map m_soundexMap;

    public CHE_GeoInfoSoundexIndexer() {
    }

    public CHE_GeoInfoSoundexIndexer(Map soundexMap) {
        this.m_soundexMap = soundexMap;
    }

    protected ArrayList makeKeys(GeoInfoDataItem item, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        return this.makeKeys(item);
    }

    protected ArrayList makeKeys(GeoInfoDataItem item) {
        Vector<ISoundexKey> list = new Vector<ISoundexKey>(5);
        if (item != null) {
            String areaName3 = this.getShortAreaName3(item);
            String altAreaName4 = CHE_AddressTerm.cleanExtendedCharsInString(this.getAltAreaName4(item));
            if (areaName3 == null) {
                areaName3 = this.getAreaName3(item);
            }
            areaName3 = CHE_AddressTerm.cleanExtendedCharsInString(areaName3);
            String altLanguageNames = CHE_AddressTerm.cleanExtendedCharsInString(this.getAltLanguageNames(item));
            String altAreaName3 = CHE_AddressTerm.cleanExtendedCharsInString(this.getAltAreaName3(item));
            if (areaName3 != null && areaName3.length() > 0) {
                ISoundexKey area3Key;
                if (this.sndx == null) {
                    this.setLanguageSoundex(areaName3);
                }
                if (!list.contains(area3Key = this.sndx.getSoundex(areaName3))) {
                    String firstWord;
                    list.add(area3Key);
                    StringTokenizer tokens = new StringTokenizer(areaName3, CHE_AddressTerm.getPunctuationsAsString(), true);
                    LinkedList listofTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
                    if (listofTokens != null && listofTokens.size() > 0 && (firstWord = CHE_AddressTerm.cleanExtendedCharsInString((String)listofTokens.get(0))) != null && !list.contains(area3Key = this.sndx.getSoundex(firstWord))) {
                        list.add(area3Key);
                    }
                }
            }
            if (altAreaName3 != null && altAreaName3.length() > 0) {
                ISoundexKey altArea3Key;
                if (this.sndx == null) {
                    this.setLanguageSoundex(areaName3);
                }
                if (!list.contains(altArea3Key = this.sndx.getSoundex(altAreaName3))) {
                    list.add(altArea3Key);
                }
            }
            if (altLanguageNames != null && altLanguageNames.length() > 0) {
                StringTokenizer tokens = new StringTokenizer(altLanguageNames, "/", false);
                while (tokens.hasMoreTokens()) {
                    String s = tokens.nextToken();
                    ISoundexKey altLangKey = this.sndx.getSoundex(s = CHE_AddressTerm.removeCommonWords(s, false));
                    if (list.contains(altLangKey)) continue;
                    list.add(altLangKey);
                }
            }
            if (altAreaName4 != null && altAreaName4.length() > 0) {
                ISoundexKey altAreaName4Key = this.sndx.getSoundex(altAreaName4);
                list.add(altAreaName4Key);
            }
            if (list == null || list.size() == 0) {
                System.out.println("No Key");
            }
        }
        if (list.size() > 0) {
            return new ArrayList(list);
        }
        return null;
    }

    private String getAltAreaName4(GeoInfoDataItem item) {
        String ret = null;
        if (item != null && item.hasString(7)) {
            try {
                ret = item.getString(7);
            }
            catch (MMJETypeArraySizeExceededException MMJETASEEx) {
                System.err.println("ERROR: unable to get areaName4 from geoInfo item.");
                System.err.println(MMJETASEEx.getMessage());
                MMJETASEEx.printStackTrace(System.err);
                System.exit(1);
            }
        }
        return ret;
    }

    public static final void main(String[] args) throws DataCreationException {
        if (args == null || args.length < 1) {
            System.err.println("ITA_GeoInfoSoundexIndexer <geoinfo data file>");
            System.exit(1);
        }
        CHE_GeoInfoSoundexIndexer indexer = new CHE_GeoInfoSoundexIndexer();
        String geoInfoFileName = args[0];
        int extensionStart = geoInfoFileName.indexOf(".");
        if (extensionStart > 0) {
            geoInfoFileName = geoInfoFileName.substring(0, extensionStart);
            System.out.println("GeoInfo base name: " + geoInfoFileName);
        }
        indexer.processGeoInfoFile(geoInfoFileName);
        System.out.println("Finished processing.");
    }

    private void setLanguageSoundex(String keyString) {
        String language = new CHE_PreParseHandler().preParse(keyString, null);
        this.sndx = (GenericSoundex)this.m_soundexMap.get(language);
    }
}

