/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.dp.intermediate;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateStreetDataItem;
import java.util.HashMap;

public class CHE_IntermediateStreetDataFileFormatHandler
extends IntermediateStreetDataFileFormatHandler {
    public CHE_IntermediateStreetDataFileFormatHandler(String fileName) {
        super(fileName);
    }

    protected void convertStreetRecord2DataItem(MMJStreetRecord record, IntermediateStreetDataItem item) throws DataSourceException {
        super.convertStreetRecord2DataItem(record, item);
        Address address = record.getAddress();
        if (address.hasAdditionalFields()) {
            try {
                this.putField2DataItem(item, address, "address.start", 11);
                this.putField2DataItem(item, address, "address.end", 12);
                this.putField2DataItem(item, address, "pre_main_address_common", 13);
                this.putField2DataItem(item, address, "post_st_type_common", 14);
                this.putField2DataItem(item, address, "pre_street_type_common", 22);
                this.putField2DataItem(item, address, "pre_addr_common", 16);
                this.putField2DataItem(item, address, "post_addr_common", 17);
                this.putField2DataItem(item, address, "POST_MAIN_SEPARATOR", 18);
                this.putField2DataItem(item, address, "POST_TT_SEPARATOR", 19);
                this.putField2DataItem(item, address, "PRE_TT_SEPARATOR", 20);
                this.putField2DataItem(item, address, "PRE_DIRECTIONAL_SEPARATOR", 21);
                this.putField2DataItem(item, address, "original_street_name", 50);
            }
            catch (MMJETypeArraySizeExceededException e) {
                DataCreationLogger.getLogger().logInternalError("Unable to populate street data.");
                DataCreationLogger.getLogger().logInternalError(e.getMessage());
                DataCreationLogger.getLogger().logStackTrace((Throwable)e);
                throw new DataSourceException(14, (Throwable)e);
            }
        }
    }

    private void putField2DataItem(IntermediateStreetDataItem item, Address address, Object hash, int index) throws MMJETypeArraySizeExceededException {
        String value = (String)address.getAdditionalFields().get(hash);
        if (value != null && value.length() > 0) {
            item.putString(index, value);
        }
    }

    protected void convertStreetDataItem2Record(MMJStreetRecord record, IntermediateStreetDataItem item) throws DataSourceException {
        super.convertStreetDataItem2Record(record, item);
        try {
            HashMap adFields = new HashMap();
            this.putDataItem2Field(item, adFields, "address.start", 11);
            this.putDataItem2Field(item, adFields, "address.end", 12);
            this.putDataItem2Field(item, adFields, "pre_main_address_common", 13);
            this.putDataItem2Field(item, adFields, "post_st_type_common", 14);
            this.putDataItem2Field(item, adFields, "pre_street_type_common", 22);
            this.putDataItem2Field(item, adFields, "pre_addr_common", 16);
            this.putDataItem2Field(item, adFields, "post_addr_common", 17);
            this.putDataItem2Field(item, adFields, "POST_MAIN_SEPARATOR", 18);
            this.putDataItem2Field(item, adFields, "POST_TT_SEPARATOR", 19);
            this.putDataItem2Field(item, adFields, "PRE_TT_SEPARATOR", 20);
            this.putDataItem2Field(item, adFields, "PRE_DIRECTIONAL_SEPARATOR", 21);
            this.putDataItem2Field(item, adFields, "original_street_name", 50);
            if (!adFields.isEmpty()) {
                Address address = record.getAddress();
                address.setAdditionalFields(adFields);
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate street data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }

    private void putDataItem2Field(IntermediateStreetDataItem item, HashMap fields, Object hash, int index) throws MMJETypeArraySizeExceededException {
        if (item.hasString(index)) {
            fields.put(hash, item.getString(index));
        }
    }
}

