/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.dp.intermediate.ap;

import com.mapinfo.mapmarker.CHE.dp.binary.ap.CHE_MMJAPRangeRecord;
import com.mapinfo.mapmarker.CHE.dp.intermediate.CHE_IntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateRangeDataItem;

public class CHE_APIntermediateStreetDataFileFormatHandler
extends CHE_IntermediateStreetDataFileFormatHandler {
    public CHE_APIntermediateStreetDataFileFormatHandler(String fileName) {
        super(fileName);
    }

    protected void convertRangeRecord2DataItem(MMJRangeRecord record, IntermediateRangeDataItem item) throws DataSourceException {
        try {
            super.convertRangeRecord2DataItem(record, item);
            item.putByte(3, ((CHE_MMJAPRangeRecord)record).getPositionAccuracy());
            item.putLong(4, ((CHE_MMJAPRangeRecord)record).getPoinID());
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }

    protected void convertRangeDataItem2Record(MMJRangeRecord record, IntermediateRangeDataItem item) throws DataSourceException {
        try {
            super.convertRangeDataItem2Record(record, item);
            CHE_MMJAPRangeRecord rangeRecord = (CHE_MMJAPRangeRecord)record;
            if (item.hasByte(3)) {
                rangeRecord.setPositionAccuracy(item.getByte(3));
            }
            if (item.hasLong(4)) {
                rangeRecord.setPoinID(item.getLong(4));
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }

    protected MMJRangeRecord getRangeRecordType() {
        return new CHE_MMJAPRangeRecord();
    }
}

