/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.dp.ud;

import com.mapinfo.mapmarker.CHE.CHESwissSoundex;
import com.mapinfo.mapmarker.CHE.CHE_AddressUtils;
import com.mapinfo.mapmarker.CHE.CHE_InternalCandidateAddress;
import com.mapinfo.mapmarker.CHE.CHE_InternalGeographicCandidate;
import com.mapinfo.mapmarker.CHE.CHE_ScoringHelper;
import com.mapinfo.mapmarker.CHE.dp.IAPRangeAttributeDataSourceRecord;
import com.mapinfo.mapmarker.CHE.dp.binary.CHE_GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.CHE.dp.binary.ap.CHE_MMJAPRangeRecord;
import com.mapinfo.mapmarker.CHE.parser.CHE_ParsePostAddressRule;
import com.mapinfo.mapmarker.CHE.parser.CHE_PreParseHandler;
import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoBase;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoAliasKeyCreator;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoRecord;
import com.mapinfo.mapmarker.EMEA.dp.ud.EMEA_UDStreetDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IUDNonStreetDataHandler;
import com.mapinfo.mapmarker.common.dp.UDGeo2SacDataHandler;
import com.mapinfo.mapmarker.common.dp.UDPost2SacDataHandler;
import com.mapinfo.mapmarker.common.dp.binary.AlternateDataItem;
import com.mapinfo.mapmarker.common.dp.binary.AlternateDataRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.IPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.SacData;
import com.mapinfo.mapmarker.common.dp.binary.StandardPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.UserDictSacData;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiSoundexStreetDataIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.core.parser.IParser;
import com.mapinfo.mapmarker.generic.soundex.GenericSoundex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class CHE_UDStreetDataSourceRecordConvertor
extends EMEA_UDStreetDataSourceRecordConvertor {
    private CHE_GeoInfoFetcherImpl m_geoInfoFetcher;
    private IUDNonStreetDataHandler m_geoInfoHandler;
    private Map m_soundexMap;
    private boolean isAPData = false;
    String m_soundexLanguage = null;

    public CHE_UDStreetDataSourceRecordConvertor(Properties dataProperties, UDPost2SacDataHandler post2SacHandler, UDGeo2SacDataHandler geo2SacHandler, Soundex soundex, CollationKeyGenerator generator, IParser parser, Constraints parserConstraints, IUDNonStreetDataHandler geoInfoHandler, boolean isAPDataRecord) throws DataCreationException {
        super(soundex, dataProperties, generator, parser, parserConstraints, post2SacHandler, geo2SacHandler);
        this.m_geoInfoHandler = geoInfoHandler;
        this.isAPData = isAPDataRecord;
        String dataSetPath = dataProperties.getProperty("dataSetPath");
        if (dataSetPath != null) {
            try {
                this.m_geoInfoFetcher = new CHE_GeoInfoFetcherImpl(dataSetPath, null, null, isAPDataRecord);
            }
            catch (Throwable t) {
                throw new DataCreationException(t);
            }
        }
    }

    public CHE_UDStreetDataSourceRecordConvertor(Properties dataProperties, UDPost2SacDataHandler post2SacHandler, UDGeo2SacDataHandler geo2SacHandler, Map soundexMap, CollationKeyGenerator generator, IParser parser, Constraints parserConstraints, IUDNonStreetDataHandler geoInfoHandler, boolean isAPDataRecord) throws DataCreationException {
        super(null, dataProperties, generator, parser, parserConstraints, post2SacHandler, geo2SacHandler);
        this.m_soundexMap = soundexMap;
        this.m_geoInfoHandler = geoInfoHandler;
        this.isAPData = isAPDataRecord;
        String dataSetPath = dataProperties.getProperty("dataSetPath");
        if (dataSetPath != null) {
            try {
                this.m_geoInfoFetcher = new CHE_GeoInfoFetcherImpl(dataSetPath, null, null, isAPDataRecord);
            }
            catch (Throwable t) {
                throw new DataCreationException(t);
            }
        }
    }

    public void close() {
        try {
            if (this.m_geoInfoFetcher != null) {
                this.m_geoInfoFetcher.close();
                this.m_geoInfoFetcher = null;
            }
        }
        catch (DataAccessException dataAccessException) {
            // empty catch block
        }
    }

    protected MMJRangeRecord makeRangeRecordType() {
        if (this.isAPData) {
            return new CHE_MMJAPRangeRecord();
        }
        return super.makeRangeRecordType();
    }

    protected MMJRangeRecord convertRangeRecord(IRangeDataSourceRecord input, int sac) throws DataSourceException {
        if (!this.isAPData) {
            return super.convertRangeRecord(input, sac);
        }
        CHE_MMJAPRangeRecord rangeRecord = (CHE_MMJAPRangeRecord)super.convertRangeRecord(input, sac);
        IAPRangeAttributeDataSourceRecord rangeSource = (IAPRangeAttributeDataSourceRecord)input;
        if (rangeRecord != null) {
            if (rangeSource.hasPositionAccuracy()) {
                rangeRecord.setPositionAccuracy(rangeSource.getPositionAccuracy());
            }
            if (rangeSource.hasPointID()) {
                rangeRecord.setPoinID(rangeSource.getPointID());
            }
            this.modifyRangeFromnTo(rangeRecord);
        }
        return rangeRecord;
    }

    private void modifyRangeFromnTo(CHE_MMJAPRangeRecord rangeRecord) {
        ParsedNumber toNum;
        ParsedNumber fromNum = rangeRecord.getFromHouse();
        if (fromNum.hasNumberSeparator() && fromNum.hasAddressSuffix() && " ".equals(fromNum.getNumberSeparator())) {
            fromNum.setNumberSeparator(null);
        }
        if ((toNum = rangeRecord.getToHouse()).hasNumberSeparator() && toNum.hasAddressSuffix() && " ".equals(toNum.getNumberSeparator())) {
            toNum.setNumberSeparator(null);
        }
    }

    @Override
    protected MMJSegmentRecord convertSegmentRecord(ISegmentDataSourceRecord input, int sac, boolean convertLeft, boolean convertRight) throws DataSourceException {
        MMJSegmentRecord record = super.convertSegmentRecord(input, sac, convertLeft, convertRight);
        if (convertLeft && convertRight && this.isLeftRightSameForAddingGeoInfoRecord(input)) {
            this.addGeoInfoRecordIntoHandler(input, true);
            return record;
        }
        if (convertLeft) {
            this.addGeoInfoRecordIntoHandler(input, true);
        }
        if (convertRight) {
            this.addGeoInfoRecordIntoHandler(input, false);
        }
        return record;
    }

    private boolean isLeftRightSameForAddingGeoInfoRecord(ISegmentDataSourceRecord input) throws DataSourceException {
        if (input.hasLeftAreaName1() ? (input.hasRightAreaName1() ? !this.compareString(input.getLeftAreaName1(), input.getRightAreaName1()) : !CHE_AddressUtils.isEmpty(input.getLeftAreaName1())) : input.hasRightAreaName1() && !CHE_AddressUtils.isEmpty(input.getRightAreaName1())) {
            return false;
        }
        if (input.hasLeftAreaName2() ? (input.hasRightAreaName2() ? !this.compareString(input.getLeftAreaName2(), input.getRightAreaName2()) : !CHE_AddressUtils.isEmpty(input.getLeftAreaName2())) : input.hasRightAreaName2() && !CHE_AddressUtils.isEmpty(input.getRightAreaName2())) {
            return false;
        }
        if (input.hasLeftAreaName3() ? (input.hasRightAreaName3() ? !this.compareString(input.getLeftAreaName3(), input.getRightAreaName3()) : !CHE_AddressUtils.isEmpty(input.getLeftAreaName3())) : input.hasRightAreaName3() && !CHE_AddressUtils.isEmpty(input.getRightAreaName3())) {
            return false;
        }
        if (input.hasLeftAreaName4() ? (input.hasRightAreaName4() ? !this.compareString(input.getLeftAreaName4(), input.getRightAreaName4()) : !CHE_AddressUtils.isEmpty(input.getLeftAreaName4())) : input.hasRightAreaName4() && !CHE_AddressUtils.isEmpty(input.getRightAreaName4())) {
            return false;
        }
        return !(input.hasLeftPostCode1() ? (input.hasRightPostCode1() ? !this.compareString(input.getLeftPostCode1(), input.getRightPostCode1()) : !CHE_AddressUtils.isEmpty(input.getLeftPostCode1())) : input.hasRightPostCode1() && !CHE_AddressUtils.isEmpty(input.getRightPostCode1()));
    }

    private EMEA_GeoInfoRecord lookupGeoInfoRecord(Address addr) throws DataSourceException {
        List possibles;
        if (addr == null) {
            return null;
        }
        if (CHE_AddressUtils.isEmpty(addr.getAreaName3())) {
            return null;
        }
        try {
            String combinedKey = addr.getAreaName4() == null ? "" : addr.getAreaName4();
            combinedKey = combinedKey + (addr.getAreaName3() == null ? "" : addr.getAreaName3());
            combinedKey = combinedKey + (addr.getAreaName2() == null ? "" : addr.getAreaName2());
            combinedKey = combinedKey + (addr.getAreaName1() == null ? "" : addr.getAreaName1());
            possibles = this.m_geoInfoFetcher.getGeoInfoAlias(combinedKey);
            int listSize = possibles.size();
            if (listSize < 1) {
                possibles = this.m_geoInfoFetcher.getGeoInfoAlias(addr.getAreaName3());
            }
            if ((listSize = possibles.size()) < 1) {
                possibles = this.m_geoInfoFetcher.getGeoInfoAlias(EMEA_GeoInfoAliasKeyCreator.createKey(addr.getAreaName3(), addr.getPostCode1()));
                listSize = possibles.size();
            }
            possibles = this.makeGeoInfoCandidate(addr, possibles);
        }
        catch (Throwable t) {
            throw new DataSourceException("error reading geoinfo" + addr);
        }
        if (possibles == null) {
            return null;
        }
        EMEA_GeoInfoRecord exactMatchedRecord = null;
        EMEA_GeoInfoRecord firstLevelMatchedRecord = null;
        EMEA_GeoInfoRecord secondLevelMatchedRecord = null;
        EMEA_GeoInfoRecord thridLevelMatchedRecord = null;
        for (int index = 0; index < possibles.size(); ++index) {
            InternalGeographicCandidate cand = (InternalGeographicCandidate)possibles.get(index);
            EMEA_GeoInfoRecord record = (EMEA_GeoInfoRecord)cand.getGeoInfoRecord();
            if (!this.isTownValidAndMatched(record, addr)) continue;
            if (this.compareProvince(record.getAreaName1(), addr.getAreaName1())) {
                if (CHE_AddressUtils.isEmpty(addr.getAreaName4()) || this.compareString(record.getAreaName4(), addr.getAreaName4())) {
                    if (this.compareString(record.getAreaName2(), addr.getAreaName2())) {
                        exactMatchedRecord = record;
                        break;
                    }
                    firstLevelMatchedRecord = record;
                    continue;
                }
                secondLevelMatchedRecord = record;
                continue;
            }
            thridLevelMatchedRecord = record;
        }
        if (exactMatchedRecord != null) {
            return exactMatchedRecord;
        }
        if (firstLevelMatchedRecord != null) {
            return firstLevelMatchedRecord;
        }
        if (secondLevelMatchedRecord != null) {
            return secondLevelMatchedRecord;
        }
        return thridLevelMatchedRecord;
    }

    private boolean compareProvince(String province1, String province2) {
        return this.compareString(province1, province2);
    }

    private Address constructGeoInfoSearchingAddress(ISegmentDataSourceRecord input, boolean bLeft) throws DataSourceException {
        AddressImpl addr = new AddressImpl();
        if (bLeft) {
            if (input.hasLeftPostCode1()) {
                addr.setPostCode1(input.getLeftPostCode1());
            }
            if (input.hasLeftAreaName4()) {
                addr.setAreaName4(input.getLeftAreaName4());
            }
            if (input.hasLeftAreaName3()) {
                addr.setAreaName3(input.getLeftAreaName3());
            }
            if (input.hasLeftAreaName2()) {
                addr.setAreaName2(input.getLeftAreaName2());
            }
            if (input.hasLeftAreaName1()) {
                addr.setAreaName1(input.getLeftAreaName1());
            }
        } else {
            if (input.hasRightPostCode1()) {
                addr.setPostCode1(input.getRightPostCode1());
            }
            if (input.hasRightAreaName4()) {
                addr.setAreaName4(input.getRightAreaName4());
            }
            if (input.hasRightAreaName3()) {
                addr.setAreaName3(input.getRightAreaName3());
            }
            if (input.hasRightAreaName2()) {
                addr.setAreaName2(input.getRightAreaName2());
            }
            if (input.hasRightAreaName1()) {
                addr.setAreaName1(input.getRightAreaName1());
            }
        }
        return addr;
    }

    private void addGeoInfoRecordIntoHandler(ISegmentDataSourceRecord input, boolean bLeft) throws DataSourceException {
        Address addr = this.constructGeoInfoSearchingAddress(input, bLeft);
        EMEA_GeoInfoRecord matchedRecord = this.lookupGeoInfoRecord(addr);
        if (matchedRecord == null) {
            return;
        }
        StringBuffer buf = new StringBuffer(20);
        buf.append(addr.getAreaName4() == null ? "" : addr.getAreaName4());
        buf.append(addr.getAreaName3() == null ? "" : addr.getAreaName3());
        buf.append(addr.getAreaName2() == null ? "" : addr.getAreaName2());
        buf.append(addr.getAreaName1() == null ? "" : addr.getAreaName1());
        MapMarkerIndexKey key = this.makeExactGeoInfoKey(buf.toString().toUpperCase(), 0);
        MMJGeoInfoRecord mmjRecord = new MMJGeoInfoRecord((GeoInfoRecord)matchedRecord, key);
        this.m_geoInfoHandler.addRecord(mmjRecord);
        key = this.makeExactGeoInfoKey(addr.getAreaName3(), 0);
        mmjRecord = new MMJGeoInfoRecord((GeoInfoRecord)matchedRecord, key);
        this.m_geoInfoHandler.addRecord(mmjRecord);
        String postalCode1ForSearching = CHE_AddressUtils.isEmpty(matchedRecord.getPostCode()) ? addr.getPostCode1() : matchedRecord.getPostCode();
        if (CHE_AddressUtils.isEmpty(postalCode1ForSearching)) {
            return;
        }
        String searchKey = EMEA_GeoInfoAliasKeyCreator.createKey(addr.getAreaName3(), postalCode1ForSearching);
        ArrayList localityRecordList = this.m_geoInfoFetcher.getGeoInfoAlias(searchKey);
        if (localityRecordList == null) {
            return;
        }
        for (int index = 0; index < localityRecordList.size(); ++index) {
            EMEA_GeoInfoRecord record = (EMEA_GeoInfoRecord)((Object)localityRecordList.get(index));
            key = this.makeExactGeoInfoKey(searchKey, index);
            mmjRecord = new MMJGeoInfoRecord((GeoInfoRecord)record, key);
            this.m_geoInfoHandler.addRecord(mmjRecord);
        }
    }

    private boolean isTownValidAndMatched(EMEA_GeoInfoRecord record, Address addr) {
        String recordTown = record.getAreaName3();
        if (CHE_AddressUtils.isEmpty(recordTown)) {
            return false;
        }
        String addrTown = addr.getAreaName3();
        if (CHE_AddressUtils.isEmpty(addrTown)) {
            return false;
        }
        return recordTown.equalsIgnoreCase(addrTown);
    }

    private MapMarkerIndexKey makeExactGeoInfoKey(String strKey, int index) {
        return new MiStringIndexKey(strKey);
    }

    @Override
    protected IPostalBase makePostalBase(ISegmentDataSourceRecord input, boolean left) throws DataSourceException {
        String postcode = null;
        if (left && input.hasLeftPostCode1() && this.stringExists(input.getLeftPostCode1())) {
            postcode = input.getLeftPostCode1().trim();
        }
        if (!left && input.hasRightPostCode1() && this.stringExists(input.getRightPostCode1())) {
            postcode = input.getRightPostCode1().trim();
        }
        StandardPostalBase base = null;
        if (!CHE_AddressUtils.isEmpty(postcode)) {
            if (postcode.length() > 4) {
                postcode = postcode.substring(0, 4);
            }
            base = new StandardPostalBase(postcode);
        }
        return base;
    }

    private IGeoBase[] makeGeoBases(ISegmentDataSourceRecord input, boolean left) throws DataSourceException {
        String areaName3 = this.getAreaName3(input, left);
        return this.makeGeoBases(areaName3, (short)3);
    }

    private IGeoBase[] makeGeoBases(String geoBaseStr, short flag) {
        IGeoBase[] bases = null;
        if (!CHE_AddressUtils.isEmpty(geoBaseStr) && !CHE_AddressUtils.isEmpty(geoBaseStr = geoBaseStr.trim())) {
            bases = new IGeoBase[2];
            String shortGeoBaseStr = CHE_ParsePostAddressRule.removeCommonWords(geoBaseStr);
            if (shortGeoBaseStr == null) {
                shortGeoBaseStr = geoBaseStr;
            }
            ISoundexKey sndxKey = this.makeSoundexKey(shortGeoBaseStr);
            bases[0] = new EMEA_GeoBase((MiSoundexKey)sndxKey, flag);
            sndxKey = CHESwissSoundex.getSoundexInstance().getSoundex(shortGeoBaseStr);
            bases[1] = new EMEA_GeoBase((MiSoundexKey)sndxKey, flag);
        }
        return bases;
    }

    protected IGeoBase makeGeoBase(ISegmentDataSourceRecord input, boolean left) {
        throw new UnsupportedOperationException();
    }

    private String getAreaName3(ISegmentDataSourceRecord input, boolean left) throws DataSourceException {
        String areaName3 = null;
        if (left && input.hasLeftAreaName3() && this.stringExists(input.getLeftAreaName3())) {
            areaName3 = input.getLeftAreaName3();
        } else if (!left && input.hasRightAreaName3() && this.stringExists(input.getRightAreaName3())) {
            areaName3 = input.getRightAreaName3();
        }
        return areaName3;
    }

    private boolean compareString(String src, String target) {
        if (CHE_AddressUtils.isEmpty(src) && CHE_AddressUtils.isEmpty(target)) {
            return true;
        }
        if (CHE_AddressUtils.isEmpty(src) || CHE_AddressUtils.isEmpty(target)) {
            return false;
        }
        return src.equalsIgnoreCase(target);
    }

    protected int[] getSacsFromGeo2Sac(IStreetDataSourceRecord input, boolean left) throws DataSourceException {
        IGeoBase[] bases = this.makeGeoBases(input.getSegment(), left);
        if (bases == null) {
            return new int[]{this.NO_SAC};
        }
        int[] sacs = this.getGeo2Sac(bases[0]);
        this.addGeo2SacRecords(bases[1], sacs);
        this.addAdditionalGeo2SacRecords(input, left, sacs);
        return sacs;
    }

    private void addAdditionalGeo2SacRecords(IStreetDataSourceRecord input, boolean left, int[] sacs) throws DataSourceException {
        String postcode;
        ISegmentDataSourceRecord segment = input.getSegment();
        String areaName3 = this.getAreaName3(segment, left);
        if (areaName3 == null) {
            return;
        }
        Address addr = this.constructGeoInfoSearchingAddress(segment, left);
        EMEA_GeoInfoRecord matchedRecord = this.lookupGeoInfoRecord(addr);
        if (matchedRecord == null) {
            return;
        }
        CHE_GeoInfoFetcherImpl CHEGeoInfoFetcher = this.m_geoInfoFetcher;
        String town = matchedRecord.getAreaName3();
        if (CHE_AddressUtils.isEmpty(town)) {
            return;
        }
        ArrayList list = (ArrayList)CHEGeoInfoFetcher.getAltLangNames(town = town.trim());
        if (list != null) {
            for (int index = 0; index < list.size(); ++index) {
                IGeoBase[] bases = this.makeGeoBases((String)list.get(index), (short)3);
                if (bases == null) continue;
                for (int j = 0; j < bases.length; ++j) {
                    this.addGeo2SacRecords(bases[j], sacs);
                }
            }
        }
        String string = postcode = left ? segment.getLeftPostCode1() : segment.getRightPostCode1();
        if (CHE_AddressUtils.isEmpty(postcode)) {
            return;
        }
        int sacFromPost2Sac = this.getSacFromPost2Sac(input, left);
        ArrayList localityList = CHEGeoInfoFetcher.getGeoInfoAlias(EMEA_GeoInfoAliasKeyCreator.createKey(town, postcode));
        for (int index = 0; index < localityList.size(); ++index) {
            IGeoBase[] geoBases;
            EMEA_GeoInfoRecord tempRecord = (EMEA_GeoInfoRecord)((Object)localityList.get(index));
            String localityAlias = tempRecord.getAliasedLocality();
            if (localityAlias == null || (geoBases = this.makeGeoBases(localityAlias, (short)4)) == null) continue;
            for (int j = 0; j < geoBases.length; ++j) {
                if (sacFromPost2Sac != this.NO_SAC) {
                    this.addGeo2SacRecord(geoBases[j], sacFromPost2Sac);
                    continue;
                }
                SacData o = this.m_geo2sac.getSacForGeoBase(geoBases[j]);
                if (o == null) continue;
                UserDictSacData userSacData = new UserDictSacData((Object)o);
                this.addGeo2SacRecords(geoBases[j], userSacData.getSacs());
            }
        }
    }

    private void addGeo2SacRecord(IGeoBase base, int sac) {
        this.addRecordToSet(this.makeGeo2SacDataRecordType(sac, base));
    }

    private void addGeo2SacRecords(IGeoBase base, int[] sacs) {
        for (int i = 0; i < sacs.length; ++i) {
            this.addGeo2SacRecord(base, sacs[i]);
        }
    }

    protected void populateAlternateDataItems(MMJRangeRecord range, IRangeDataSourceRecord input, int sac) throws DataSourceException {
        String placeName = range.getPlaceName();
        if (placeName != null) {
            MiSoundexStreetDataIndexKey searchKey = new MiSoundexStreetDataIndexKey(sac, this.makeSoundexKey(placeName));
            MapMarkerBrowseMultiLevelIndexKey browseKey = this.makePlaceBrowseKey(sac, placeName);
            if (searchKey != null || browseKey != null) {
                AlternateDataRecord placeRecord = new AlternateDataRecord();
                placeRecord.setAlternateDataID(placeName);
                AlternateDataItem placeItem = new AlternateDataItem(0, placeRecord, (MapMarkerIndexKey)searchKey, (MapMarkerIndexKey)browseKey);
                range.addAlternateDataItem(placeItem);
            }
        }
    }

    private MapMarkerBrowseMultiLevelIndexKey makePlaceBrowseKey(int sac, String browseString) {
        MapMarkerBrowseMultiLevelIndexKey key = null;
        char c = CHE_ScoringHelper.getFirstNormChar(browseString);
        int[] collationKey = this.m_generator.getCollationKey(browseString);
        key = new MapMarkerBrowseMultiLevelIndexKey(sac, c, collationKey);
        return key;
    }

    protected MapMarkerIndexKey makeAlternateTypeBrowseKey(String alternateBrowseString, int sac) {
        String keyBase = alternateBrowseString;
        int[] mainCollationKey = this.m_generator.getCollationKey(keyBase);
        char c = CHE_ScoringHelper.getFirstNormChar(keyBase);
        return new MapMarkerBrowseMultiLevelIndexKey(sac, c, mainCollationKey);
    }

    protected MapMarkerIndexKey[] makeStreetBrowseKeys(Address address, int sac) {
        ArrayList keyBases = this.getKeyBases(address);
        if (keyBases == null) {
            return null;
        }
        ArrayList<MapMarkerBrowseMultiLevelIndexKey> keys = new ArrayList<MapMarkerBrowseMultiLevelIndexKey>(keyBases.size());
        for (String keyBase : keyBases) {
            int[] mainCollationKey = this.m_generator.getCollationKey(keyBase);
            char c = CHE_ScoringHelper.getFirstNormChar(keyBase);
            keys.add(new MapMarkerBrowseMultiLevelIndexKey(sac, c, mainCollationKey));
        }
        MapMarkerIndexKey[] keyArray = new MapMarkerIndexKey[keys.size()];
        return keys.toArray(keyArray);
    }

    private ArrayList getKeyBases(Address address) {
        String postKey;
        if (CHE_AddressUtils.isEmpty(address.getMainAddress())) {
            return null;
        }
        String mainKey = address.getMainAddress().toUpperCase();
        ArrayList<String> keys = new ArrayList<String>(1);
        keys.add(mainKey);
        String preKey = address.getPreAddress();
        if (!CHE_AddressUtils.isEmpty(preKey)) {
            keys.add(preKey.toUpperCase());
        }
        if (!CHE_AddressUtils.isEmpty(postKey = address.getPostAddress())) {
            keys.add(postKey.toUpperCase());
        }
        keys.add(CHE_AddressUtils.getFormattedStreetAddress(address, false).toUpperCase());
        return keys;
    }

    public boolean canReassembleAddress(String original_street, Address parsed) {
        String parsed_street = CHE_InternalCandidateAddress.reconstructAddress(new InternalCandidateAddress(parsed));
        HashMap<String, String> additionalFMap = parsed.getAdditionalFields();
        if (additionalFMap == null) {
            additionalFMap = new HashMap<String, String>();
        }
        additionalFMap.put("original_street_name", original_street);
        parsed.setAdditionalFields(additionalFMap);
        boolean result = parsed_street.equalsIgnoreCase(original_street);
        return result;
    }

    @Override
    public Object convert(IDataSourceRecord inputData) throws DataCreationException {
        int i;
        boolean useAlternate;
        if (inputData == null) {
            if (this.hasNextDataRecord()) {
                return this.getNextDataRecord();
            }
            return null;
        }
        IStreetDataSourceRecord input = (IStreetDataSourceRecord)inputData;
        List addressList = null;
        try {
            if (!input.hasMainAddress() || !this.stringExists(input.getMainAddress())) {
                DataCreationLogger.getLogger().logInternalError("CHE_UDStreetDataSourceRecordConvertorImpl:: All streets should have main addresses.");
                return null;
            }
            addressList = this.getAllPossibleMainAddresses(input);
            if (addressList == null || addressList.size() == 0) {
                DataCreationLogger.getLogger().logInternalError("CHE_UDStreetDataSourceRecordConvertorImpl:: No main adddress found.");
                return null;
            }
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(101, (Throwable)DSEx);
        }
        int[] leftSacs = this.getLeftSacs(input);
        int[] rightSacs = this.getRightSacs(input);
        int[] commonSacs = this.getCommonSacs(leftSacs, rightSacs);
        int uniqueLeftSacs = this.getNumberOfNonNoSacs(leftSacs);
        int uniqueRightSacs = this.getNumberOfNonNoSacs(rightSacs);
        int uniqueCommonSacs = this.getNumberOfNonNoSacs(commonSacs);
        int uniqueSacs = uniqueLeftSacs + uniqueRightSacs + uniqueCommonSacs;
        if (uniqueSacs == 0) {
            DataCreationLogger.getLogger().logInternalError("StreetDataSourceRecordConvertorImpl:: No unique sacs on either side of the street.");
            return null;
        }
        boolean bl = useAlternate = addressList.size() > 1;
        if (uniqueSacs == 1 && !useAlternate) {
            this.m_dataRecords = null;
            this.m_nextDataRecordIndex = -1;
        } else {
            this.m_dataRecords = new Object[uniqueSacs * addressList.size() - 1];
        }
        MMJStreetRecord record = null;
        this.m_nextDataRecordIndex = 0;
        int dataRecordsIndex = 0;
        if (commonSacs != null) {
            for (i = 0; i < commonSacs.length; ++i) {
                if (record == null) {
                    try {
                        record = this.createStreetRecord(input, commonSacs[i], commonSacs[i]);
                        continue;
                    }
                    catch (DataSourceException DSEx) {
                        throw new DataCreationException(101, (Throwable)DSEx);
                    }
                }
                try {
                    this.m_dataRecords[dataRecordsIndex] = this.createStreetRecord(input, commonSacs[i], commonSacs[i]);
                    ++dataRecordsIndex;
                    continue;
                }
                catch (DataSourceException DSEx) {
                    throw new DataCreationException(101, (Throwable)DSEx);
                }
            }
        }
        if (uniqueLeftSacs > 0) {
            for (i = 0; i < leftSacs.length; ++i) {
                if (leftSacs[i] == this.NO_SAC) continue;
                if (record == null) {
                    try {
                        record = this.createStreetRecord(input, leftSacs[i], this.NO_SAC);
                        continue;
                    }
                    catch (DataSourceException DSEx) {
                        throw new DataCreationException(101, (Throwable)DSEx);
                    }
                }
                try {
                    this.m_dataRecords[dataRecordsIndex] = this.createStreetRecord(input, leftSacs[i], this.NO_SAC);
                    ++dataRecordsIndex;
                    continue;
                }
                catch (DataSourceException DSEx) {
                    throw new DataCreationException(101, (Throwable)DSEx);
                }
            }
        }
        if (uniqueRightSacs > 0) {
            for (i = 0; i < rightSacs.length; ++i) {
                if (rightSacs[i] == this.NO_SAC) continue;
                if (record == null) {
                    try {
                        record = this.createStreetRecord(input, this.NO_SAC, rightSacs[i]);
                        continue;
                    }
                    catch (DataSourceException DSEx) {
                        throw new DataCreationException(101, (Throwable)DSEx);
                    }
                }
                try {
                    this.m_dataRecords[dataRecordsIndex] = this.createStreetRecord(input, this.NO_SAC, rightSacs[i]);
                    ++dataRecordsIndex;
                    continue;
                }
                catch (DataSourceException DSEx) {
                    throw new DataCreationException(101, (Throwable)DSEx);
                }
            }
        }
        if (useAlternate) {
            try {
                for (int altNum = 0; altNum < addressList.size() - 1; ++altNum) {
                    this.m_dataRecords[uniqueSacs + altNum - 1] = this.createAlternateStreetRecord(record, input, (Address)addressList.get(altNum + 1));
                }
            }
            catch (DataSourceException DSEx) {
                throw new DataCreationException(101, (Throwable)DSEx);
            }
            for (i = 1; i < uniqueSacs; ++i) {
                try {
                    for (int altNum = 0; altNum < addressList.size() - 1; ++altNum) {
                        this.m_dataRecords[uniqueSacs + i + altNum - 1] = this.createAlternateStreetRecord((MMJStreetRecord)this.m_dataRecords[i + altNum - 1], input, (Address)addressList.get(altNum + 1));
                    }
                    continue;
                }
                catch (DataSourceException DSEx) {
                    throw new DataCreationException(101, (Throwable)DSEx);
                }
            }
        }
        return record;
    }

    private int getNumberOfNonNoSacs(int[] sacs) {
        if (sacs == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < sacs.length; ++i) {
            if (sacs[i] == this.NO_SAC) continue;
            ++count;
        }
        return count;
    }

    private int[] getCommonSacs(int[] leftSacs, int[] rightSacs) {
        int[] finalCommonSacs;
        int[] tempCommonSacs = leftSacs.length < rightSacs.length ? new int[leftSacs.length] : new int[rightSacs.length];
        for (int i = 0; i < tempCommonSacs.length; ++i) {
            tempCommonSacs[i] = this.NO_SAC;
        }
        int commonIndex = 0;
        boolean foundCommon = false;
        for (int l = 0; l < leftSacs.length; ++l) {
            for (int r = 0; r < rightSacs.length; ++r) {
                if (leftSacs[l] != rightSacs[r] || leftSacs[l] == this.NO_SAC) continue;
                foundCommon = true;
                tempCommonSacs[commonIndex] = leftSacs[l];
                ++commonIndex;
                leftSacs[l] = rightSacs[r] = this.NO_SAC;
            }
        }
        if (foundCommon) {
            int commonCount = 0;
            int totalCommonSacs = this.getNumberOfNonNoSacs(tempCommonSacs);
            finalCommonSacs = new int[totalCommonSacs];
            for (int i = 0; i < tempCommonSacs.length; ++i) {
                if (tempCommonSacs[i] == this.NO_SAC) continue;
                finalCommonSacs[commonCount] = tempCommonSacs[i];
                ++commonCount;
            }
        } else {
            return null;
        }
        return finalCommonSacs;
    }

    private List makeGeoInfoCandidate(Address addr, List list) {
        ArrayList<CHE_InternalGeographicCandidate> candidateList = new ArrayList<CHE_InternalGeographicCandidate>();
        CHE_InternalGeographicCandidate candidate = null;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            candidate = new CHE_InternalGeographicCandidate();
            candidate.setCountry(addr.getCountry());
            candidate.setGeoInfoRecord((GeoInfoRecord)iter.next());
            candidateList.add(candidate);
        }
        return candidateList;
    }

    @Override
    protected String makeMainAddressString(String street, String houseNumber) {
        return street;
    }

    private String getLanguage(String string) {
        String langugage = null;
        if (this.m_soundexLanguage == null) {
            this.m_soundexLanguage = langugage = new CHE_PreParseHandler().preParse(string, null);
        } else {
            langugage = this.m_soundexLanguage;
        }
        return langugage;
    }

    public void setSoundexMap(HashMap map) {
        this.m_soundexMap = new HashMap(map);
    }

    public GenericSoundex getProperSoundex(String language) {
        return (GenericSoundex)this.m_soundexMap.get(language);
    }

    protected ISoundexKey makeSoundexKey(String soundexSource) {
        return CHESwissSoundex.getSoundexInstance().getSoundex(soundexSource);
    }

    @Override
    protected int[] getLeftSacs(IStreetDataSourceRecord input) throws DataCreationException {
        int[] sacsFromGeo2Sac;
        int sacFromPost2Sac;
        try {
            if (input.hasLeftSAC()) {
                String leftSac = String.valueOf(input.getLeftSAC());
                int value = -1;
                if (Integer.valueOf(leftSac) != 0) {
                    value = Integer.valueOf(leftSac.substring(0, 3));
                }
                return new int[]{value};
            }
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(101, (Throwable)DSEx);
        }
        try {
            sacFromPost2Sac = this.getSacFromPost2Sac(input, true);
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(106, (Throwable)DSEx);
        }
        try {
            sacsFromGeo2Sac = this.getSacsFromGeo2Sac(input, true);
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(106, (Throwable)DSEx);
        }
        return this.getFinalSacs(sacFromPost2Sac, sacsFromGeo2Sac);
    }

    private int[] getFinalSacs(int sacFromPost2Sac, int[] sacsFromGeo2Sac) {
        if (sacFromPost2Sac != this.NO_SAC) {
            for (int i = 0; i < sacsFromGeo2Sac.length; ++i) {
                if (sacFromPost2Sac != sacsFromGeo2Sac[i]) continue;
                return new int[]{sacFromPost2Sac};
            }
            if (sacsFromGeo2Sac[0] != this.NO_SAC) {
                return new int[]{sacFromPost2Sac, sacsFromGeo2Sac[0]};
            }
            return new int[]{sacFromPost2Sac};
        }
        if (sacsFromGeo2Sac[0] != this.NO_SAC) {
            return new int[]{sacsFromGeo2Sac[0]};
        }
        return new int[]{this.NO_SAC};
    }

    protected int[] getRightSacs(IStreetDataSourceRecord input) throws DataCreationException {
        int[] sacsFromGeo2Sac;
        int sacFromPost2Sac;
        try {
            if (input.hasRightSAC()) {
                String rightSac = String.valueOf(input.getRightSAC());
                int value = -1;
                if (Integer.valueOf(rightSac) != 0) {
                    value = Integer.valueOf(rightSac.substring(0, 3));
                }
                return new int[]{value};
            }
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(101, (Throwable)DSEx);
        }
        try {
            sacFromPost2Sac = this.getSacFromPost2Sac(input, false);
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(106, (Throwable)DSEx);
        }
        try {
            sacsFromGeo2Sac = this.getSacsFromGeo2Sac(input, false);
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(106, (Throwable)DSEx);
        }
        return this.getFinalSacs(sacFromPost2Sac, sacsFromGeo2Sac);
    }

    @Override
    protected MMJStreetRecord createStreetRecord(IStreetDataSourceRecord input, int leftSac, int rightSac) throws DataSourceException, DataCreationException {
        int inputSAC = leftSac != this.NO_SAC ? leftSac : rightSac;
        Address preParsed = this.makePreParsedAddress(input);
        preParsed.setMainAddress(this.makeMainAddressString(preParsed.getMainAddress(), "100"));
        Address parsed = this.getParsedStreet(input, preParsed);
        if (parsed == null) {
            return null;
        }
        String original_street = input.getMainAddress();
        if (!this.canReassembleAddress(original_street, parsed)) {
            parsed.setGenericField4(original_street);
        }
        MMJStreetRecord record = this.makeStreetRecordType();
        record.setAddress(parsed);
        record.setSac(inputSAC);
        record.setKey(this.makeStreetSearchKey(parsed, inputSAC));
        if (record.getKey() == null) {
            DataCreationLogger.getLogger().logError("Could not generate a search key for address '" + input.getMainAddress() + "'");
            return null;
        }
        this.assignBrowseKeys(record);
        ISegmentDataSourceRecord inputSegment = input.getSegment();
        MMJSegmentRecord segment = this.convertSegmentRecord(inputSegment, inputSAC, leftSac != this.NO_SAC, rightSac != this.NO_SAC);
        if (segment == null) {
            return null;
        }
        record.setSegment(segment);
        this.addRangesToSegment(segment, inputSegment, inputSAC, true, true);
        this.populateAlternateDataItems(record, input, inputSAC);
        return record;
    }
}

