/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.filters;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;

public class CloserHouseFilterRule
implements ICloseMatchFilterRule {
    public boolean demoteOther(Address[] inputAddresses, ICandidate bestCandidate, ICandidate otherCandidate) {
        InternalCandidateAddress best = (InternalCandidateAddress)bestCandidate;
        InternalCandidateAddress other = (InternalCandidateAddress)otherCandidate;
        String num = inputAddresses[0].getAddressNumber();
        if (num == null) {
            return false;
        }
        if (best.getMainAddressScore() >= other.getMainAddressScore() && best.getAreaName1Score() == other.getAreaName1Score() && best.getAreaName2Score() == other.getAreaName2Score() && best.getAreaName3Score() == other.getAreaName3Score() && best.getPostCode1Score() >= other.getPostCode1Score() && best.getPlaceNameScore() >= other.getPlaceNameScore() && best.getCombinedAddressScore() >= other.getCombinedAddressScore()) {
            if (best.hasMatchingRange() && other.hasMatchingRange()) {
                Range bestRange = best.getSegment().getRangeAt(best.getMatchedRangeNumber(), best.getSegmentSide());
                Range otherRange = other.getSegment().getRangeAt(other.getMatchedRangeNumber(), other.getSegmentSide());
                if (bestRange.computeAddressesInRange() < otherRange.computeAddressesInRange()) {
                    return true;
                }
            }
            if (best.hasClosestRange() && other.hasClosestRange()) {
                ParsedNumber inputNumber = new ParsedNumber(num);
                Range bestRange = best.getSegment().getRangeAt(best.getClosestRangeNumber(), best.getClosestSegmentSide());
                Range otherRange = other.getSegment().getRangeAt(other.getClosestRangeNumber(), other.getClosestSegmentSide());
                if (bestRange.computeOffsetFromRange(inputNumber) < otherRange.computeOffsetFromRange(inputNumber)) {
                    return true;
                }
            }
        }
        return false;
    }
}

