/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.parser;

import com.mapinfo.mapmarker.utils.FileUtilities;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class CHE_PostCodeRange {
    public static final String POSTCODE_LANGUAGE_DEU = "DEU";
    public static final String POSTCODE_LANGUAGE_FRA = "FRA";
    public static final String POSTCODE_LANGUAGE_ITA = "ITA";
    public static final String POSTCODE_LANGUAGE_DEU_AND_FRA = "DEU&FRA";
    private static List germanPostCodes = null;
    private static List frenchPostCodes = null;
    private static List italianPostCodes = null;
    private static List germanAndFrenchPostCodes = null;
    private static Properties ranges;
    private int fromRange;
    private int toRange;

    public CHE_PostCodeRange(String rawRangeText) {
        StringTokenizer st = new StringTokenizer(rawRangeText, "-");
        if (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            this.fromRange = token.length() != 4 ? -1 : Integer.parseInt(token);
            this.toRange = st.hasMoreTokens() ? ((token = st.nextToken().trim()).length() != 4 ? this.fromRange : Integer.parseInt(token)) : this.fromRange;
        }
    }

    private static void loadPostCodeRanges(String raw, String language) {
        if (language.equalsIgnoreCase(POSTCODE_LANGUAGE_DEU)) {
            if (raw != null && raw.trim().length() > 0) {
                if (germanPostCodes == null) {
                    germanPostCodes = new ArrayList();
                }
                StringTokenizer st = new StringTokenizer(raw, ",");
                String token = null;
                while (st.hasMoreTokens()) {
                    token = st.nextToken().trim();
                    if (token.length() <= 0) continue;
                    germanPostCodes.add(new CHE_PostCodeRange(token.toUpperCase()));
                }
            }
        } else if (language.equalsIgnoreCase(POSTCODE_LANGUAGE_FRA)) {
            if (raw != null && raw.trim().length() > 0) {
                if (frenchPostCodes == null) {
                    frenchPostCodes = new ArrayList();
                }
                StringTokenizer st = new StringTokenizer(raw, ",");
                String token = null;
                while (st.hasMoreTokens()) {
                    token = st.nextToken().trim();
                    if (token.length() <= 0) continue;
                    frenchPostCodes.add(new CHE_PostCodeRange(token.toUpperCase()));
                }
            }
        } else if (language.equalsIgnoreCase(POSTCODE_LANGUAGE_ITA)) {
            if (raw != null && raw.trim().length() > 0) {
                if (italianPostCodes == null) {
                    italianPostCodes = new ArrayList();
                }
                StringTokenizer st = new StringTokenizer(raw, ",");
                String token = null;
                while (st.hasMoreTokens()) {
                    token = st.nextToken().trim();
                    if (token.length() <= 0) continue;
                    italianPostCodes.add(new CHE_PostCodeRange(token.toUpperCase()));
                }
            }
        } else if (language.equalsIgnoreCase(POSTCODE_LANGUAGE_DEU_AND_FRA)) {
            if (raw != null && raw.trim().length() > 0) {
                if (germanAndFrenchPostCodes == null) {
                    germanAndFrenchPostCodes = new ArrayList();
                }
                StringTokenizer st = new StringTokenizer(raw, ",");
                String token = null;
                while (st.hasMoreTokens()) {
                    token = st.nextToken().trim();
                    if (token.length() <= 0) continue;
                    germanAndFrenchPostCodes.add(new CHE_PostCodeRange(token.toUpperCase()));
                }
            }
        } else {
            System.err.println("Could not load : " + raw);
        }
    }

    public static boolean isPostCodeInRange(String postcode, CHE_PostCodeRange range) {
        boolean result = false;
        if (postcode == null && postcode.length() != 4 || range == null || range.fromRange == -1) {
            result = false;
        } else {
            int pcode = Integer.parseInt(postcode);
            if (pcode >= range.fromRange && pcode <= range.toRange) {
                result = true;
            }
        }
        return result;
    }

    public static boolean isGermanPostCode(String postcode) {
        boolean result = false;
        if (germanPostCodes != null) {
            for (int i = 0; i < germanPostCodes.size(); ++i) {
                CHE_PostCodeRange range = (CHE_PostCodeRange)germanPostCodes.get(i);
                if (!CHE_PostCodeRange.isPostCodeInRange(postcode, range)) continue;
                result = true;
            }
        }
        return result;
    }

    public static boolean isFrenchPostCode(String postcode) {
        boolean result = false;
        if (frenchPostCodes == null) {
            CHE_PostCodeRange range = null;
            for (int i = 0; i < frenchPostCodes.size(); ++i) {
                range = (CHE_PostCodeRange)frenchPostCodes.get(i);
                if (!CHE_PostCodeRange.isPostCodeInRange(postcode, range)) continue;
                result = true;
            }
        }
        return result;
    }

    public static boolean isItalianPostCode(String postcode) {
        boolean result = false;
        if (italianPostCodes != null) {
            CHE_PostCodeRange range = null;
            for (int i = 0; i < italianPostCodes.size(); ++i) {
                range = (CHE_PostCodeRange)italianPostCodes.get(i);
                if (!CHE_PostCodeRange.isPostCodeInRange(postcode, range)) continue;
                result = true;
            }
        }
        return result;
    }

    public static boolean isGermanAndFrenchPostCode(String postcode) {
        boolean result = false;
        if (germanAndFrenchPostCodes != null) {
            CHE_PostCodeRange range = null;
            for (int i = 0; i < germanAndFrenchPostCodes.size(); ++i) {
                range = (CHE_PostCodeRange)germanAndFrenchPostCodes.get(i);
                if (!CHE_PostCodeRange.isPostCodeInRange(postcode, range)) continue;
                result = true;
            }
        }
        return result;
    }

    public static String getPostCodeLanguage(String postcode) {
        String postCodeLanguage = null;
        if (postcode == null) {
            return null;
        }
        if (CHE_PostCodeRange.isGermanPostCode(postcode)) {
            postCodeLanguage = POSTCODE_LANGUAGE_DEU;
        }
        if (CHE_PostCodeRange.isFrenchPostCode(postcode)) {
            postCodeLanguage = POSTCODE_LANGUAGE_FRA;
        }
        if (CHE_PostCodeRange.isItalianPostCode(postcode)) {
            postCodeLanguage = POSTCODE_LANGUAGE_ITA;
        }
        if (CHE_PostCodeRange.isGermanAndFrenchPostCode(postcode)) {
            postCodeLanguage = POSTCODE_LANGUAGE_DEU_AND_FRA;
        }
        return postCodeLanguage;
    }

    static {
        try {
            ranges = FileUtilities.loadProperties((String)"com/mapinfo/mapmarker/CHE/parser/CHE_PostCodeLanguageRanges.properties");
            String key = null;
            Enumeration<?> e = ranges.propertyNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                CHE_PostCodeRange.loadPostCodeRanges(ranges.getProperty(key), key);
            }
        }
        catch (Throwable T) {
            throw new RuntimeException("Unable to load com/mapinfo/mapmarker/CHE/parser/CHE_PostCodeLanguageRanges.properties");
        }
    }
}

