/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.parser;

import com.mapinfo.mapmarker.CHE.CHE_AddressUtils;
import com.mapinfo.mapmarker.CHE.CHE_Handler;
import com.mapinfo.mapmarker.CHE.parser.CHE_AddressTerm;
import com.mapinfo.mapmarker.CHE.parser.CHE_PostCodeRange;
import com.mapinfo.mapmarker.CHE.parser.CHE_ThoroughFareTypes;
import com.mapinfo.mapmarker.EMEA.parser.EMEA_PreParseHandler;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class CHE_PreParseHandler
extends EMEA_PreParseHandler {
    public static final String UNPARSED_HNR = "unparsed_hnr";
    public static final String UNPARSED_INPUT_STREET = "unparsed_input_street";
    public static final String DEU_SCORE = "DEUScore";
    public static final String FRA_SCORE = "FRAScore";
    public static final String ITA_SCORE = "ITAScore";
    public static final String LANGUAGES_ATTEMPTED = "countries_attempted";
    public static final String SUGGESTED_LANGUAGE_TO_ATTEMPT = "suggested_language";
    public static final String HIGHEST_SCORING_LANGUAGE = "highest_scoring_language";
    public static final String INPUT_HOUSE_NUMBER = "input_house_number";
    private static boolean debug = false;
    private double DEUScore = 0.0;
    private double FRAScore = 0.0;
    private double ITAScore = 0.0;
    private static final String punctuations = " ()-/.,\\'";
    private static final Pattern CHE_POBOX_HANDLING = Pattern.compile("POST\\s*FATCH\\s*\\p{Punct}*\\d*\\s*\\p{Punct}*|POST\\s*FACH\\s*\\p{Punct}*\\d*\\s*\\p{Punct}*|CASE\\s*POSTALE\\s*\\p{Punct}*\\d*\\s*\\p{Punct}*|CASELLA\\s*POSTALE\\s*\\p{Punct}*\\d*\\s*\\p{Punct}*|PF[^[\\s*]]\\p{Punct}*\\d*\\s*\\p{Punct}*|CP[^[\\s*]]\\p{Punct}*\\d*\\s*\\p{Punct}*");
    public static final Pattern POBOX_KEYWORDS = Pattern.compile("(PO\\s*BOX\\s*)NO.\\s*\\d*|(PO\\s*BOX\\s*)NO\\s*\\d*|(P.O.\\s*BOX\\s*)NO.\\s*\\d*|(P.O.\\s*BOX\\s*)NO\\s*\\d*|(P.O.\\s*BOX)\\s*\\d*|(PO\\s*BOX)\\s*\\d*|(Post\\s*Office\\s*Box)\\s*\\d*");

    public static String removePostBoxKeywords(String streetAddress) {
        String result = null;
        if (streetAddress != null) {
            result = CHE_POBOX_HANDLING.matcher(streetAddress.toUpperCase()).replaceAll("").trim();
            result = POBOX_KEYWORDS.matcher(result).replaceAll("").trim();
        }
        return result;
    }

    @Override
    public Address preParse(Address unrefinedAddress, IHandler handler) {
        HashMap<String, String> addFields = new HashMap<String, String>();
        String street = unrefinedAddress.getMainAddress();
        String areanmae3 = unrefinedAddress.getAreaName3();
        String postcode = unrefinedAddress.getPostCode1();
        String highestScoringLanguage = null;
        CHE_Handler localHandler = (CHE_Handler)handler;
        highestScoringLanguage = localHandler.getGeocodeTypeForParsing() == 4 ? "DEU" : (street != null && street.length() != 0 ? this.preParse(street, unrefinedAddress) : (areanmae3 != null ? this.preParse(areanmae3, unrefinedAddress) : (postcode != null ? this.preParse(postcode, unrefinedAddress) : "DEU")));
        addFields.put(DEU_SCORE, String.valueOf(this.DEUScore));
        addFields.put(FRA_SCORE, String.valueOf(this.FRAScore));
        addFields.put(ITA_SCORE, String.valueOf(this.ITAScore));
        addFields.put(HIGHEST_SCORING_LANGUAGE, highestScoringLanguage);
        addFields.put(UNPARSED_INPUT_STREET, street);
        addFields.put(INPUT_HOUSE_NUMBER, unrefinedAddress.getAddressNumber());
        unrefinedAddress.setAdditionalFields(addFields);
        LinkedList listOfTokens = null;
        if (street != null && street.length() != 0) {
            street = CHE_PreParseHandler.removePostBoxKeywords(street);
            StringTokenizer tokens = new StringTokenizer(street, punctuations, true);
            listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < listOfTokens.size(); ++i) {
                buf.append(listOfTokens.get(i));
            }
            unrefinedAddress.setMainAddress(buf.toString().trim());
        }
        if (highestScoringLanguage != null) {
            if (unrefinedAddress.getAreaName4() != null) {
                unrefinedAddress.setAreaName4(null);
            }
            if (unrefinedAddress.getAreaName2() != null) {
                unrefinedAddress.setAreaName2(null);
            }
            localHandler.setPreParsedAddress(unrefinedAddress);
            if (highestScoringLanguage.equalsIgnoreCase("DEU")) {
                localHandler.setCountryCode("DEU");
            } else if (highestScoringLanguage.equalsIgnoreCase("FRA")) {
                localHandler.setCountryCode("FRA");
                unrefinedAddress.setMainAddress(CHE_AddressUtils.getModifiedStreetAddress(unrefinedAddress.getMainAddress()));
            } else if (highestScoringLanguage.equalsIgnoreCase("ITA")) {
                localHandler.setCountryCode("ITA");
            }
        }
        return unrefinedAddress;
    }

    @Override
    public void setPostCode1(Address pa, Address ura) {
        this.removeCharsFromPostcode(pa, ura);
    }

    private boolean germanPresentInArray(String[] array) {
        boolean isGermanPresent = false;
        if (array != null || array.length != 0) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null || !array[i].equalsIgnoreCase("DEU")) continue;
                isGermanPresent = true;
            }
        }
        return isGermanPresent;
    }

    private String getStreetTypeEnding(String mayBeStreetType) {
        boolean hasStreetTypeEnd = false;
        String endSection = null;
        if (mayBeStreetType != null) {
            int lastLetterIndex = mayBeStreetType.length();
            for (int i = 0; i < lastLetterIndex - 1; ++i) {
                endSection = mayBeStreetType.substring(i, lastLetterIndex);
                if (CHE_ThoroughFareTypes.isThoroughfareType(endSection)) {
                    hasStreetTypeEnd = true;
                }
                if (hasStreetTypeEnd) break;
            }
        }
        return endSection;
    }

    private boolean hasStreetTypeEnding(String mayBeStreetType) {
        boolean hasStreetTypeEnd = false;
        String endSection = null;
        if (mayBeStreetType != null) {
            int lastLetterIndex = mayBeStreetType.length();
            for (int i = 0; i < lastLetterIndex - 1; ++i) {
                endSection = mayBeStreetType.substring(i, lastLetterIndex);
                if (CHE_ThoroughFareTypes.isThoroughfareType(endSection)) {
                    hasStreetTypeEnd = true;
                }
                if (hasStreetTypeEnd) break;
            }
        }
        return hasStreetTypeEnd;
    }

    private boolean isConcatanatedStreetType(String mayBeStreetType) {
        boolean isConcatenated = false;
        if (mayBeStreetType != null && CHE_ThoroughFareTypes.isThoroughfareType(mayBeStreetType.trim())) {
            isConcatenated = true;
        }
        return isConcatenated;
    }

    private void debug(String message) {
        if (debug) {
            System.out.println("DEBUG: " + message);
        }
    }

    private String getDelimiters() {
        String delimiters = null;
        StringBuffer buf = new StringBuffer(20);
        if (CHE_AddressTerm.getPunctuationsAsString() != null) {
            buf.append(CHE_AddressTerm.getPunctuationsAsString());
        }
        if (CHE_AddressTerm.getOrdinalsAsString() != null) {
            buf.append(CHE_AddressTerm.getOrdinalsAsString());
        }
        if (buf.length() > 0) {
            delimiters = buf.toString();
        }
        return delimiters;
    }

    public String preParse(String preParseString, Address unrefinedAddress) {
        String highestScoringLanguage = null;
        this.DEUScore = 0.0;
        this.FRAScore = 0.0;
        this.ITAScore = 0.0;
        boolean highlyLikelyLanguageFound = false;
        preParseString = CHE_PreParseHandler.removePostBoxKeywords(preParseString);
        StringTokenizer tokens = new StringTokenizer(preParseString, this.getDelimiters(), true);
        LinkedList listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
        if (!highlyLikelyLanguageFound) {
            int n;
            int count;
            String[] streetTypeLanguages = null;
            String[] commonWordLanguages = null;
            boolean firstTime = true;
            String term = null;
            for (int i = 0; i < listOfTokens.size(); ++i) {
                term = (String)listOfTokens.get(i);
                if (CHE_AddressTerm.isPunctuation(term)) continue;
                if (firstTime) {
                    if (StringUtilities.isNumeric((String)term)) {
                        this.FRAScore = 0.99;
                    } else if (CHE_ThoroughFareTypes.isFrenchThoroughFareType(term)) {
                        this.FRAScore = 0.99;
                    } else if (CHE_ThoroughFareTypes.isItalianThoroughFareType(term)) {
                        this.ITAScore = 0.99;
                    }
                    firstTime = false;
                }
                if (this.hasStreetTypeEnding(term)) {
                    this.debug(term + " has street type ending");
                    streetTypeLanguages = CHE_ThoroughFareTypes.getLanguagesOfThoroughfareType(this.getStreetTypeEnding(term));
                    if (!this.isConcatanatedStreetType(term) || !this.germanPresentInArray(streetTypeLanguages)) continue;
                    this.DEUScore = 1.0;
                    continue;
                }
                if (!CHE_AddressTerm.isCommonWord(term)) continue;
                commonWordLanguages = CHE_AddressTerm.getLanguagesOfCommonWords(term);
            }
            if (streetTypeLanguages != null) {
                double scoreWeight = 0.0;
                count = 0;
                for (n = 0; n < streetTypeLanguages.length; ++n) {
                    if (streetTypeLanguages[n] == null || streetTypeLanguages.length == 0) continue;
                    ++count;
                }
                switch (count) {
                    case 1: {
                        scoreWeight = 1.0;
                        break;
                    }
                    case 2: {
                        scoreWeight = 0.5;
                        break;
                    }
                    case 3: {
                        scoreWeight = 0.33;
                        break;
                    }
                    default: {
                        this.debug("There are no languages in the array");
                    }
                }
                for (int p = 0; p < streetTypeLanguages.length; ++p) {
                    if (streetTypeLanguages[p] == null || streetTypeLanguages.length == 0) continue;
                    String tmp = streetTypeLanguages[p];
                    if (tmp.equalsIgnoreCase("DEU")) {
                        this.DEUScore += scoreWeight;
                        if (!(this.DEUScore > 1.0)) continue;
                        this.DEUScore = 1.0;
                        continue;
                    }
                    if (tmp.equalsIgnoreCase("FRA")) {
                        this.FRAScore += scoreWeight;
                        if (!(this.FRAScore > 1.0)) continue;
                        this.FRAScore = 1.0;
                        continue;
                    }
                    if (!tmp.equalsIgnoreCase("ITA")) continue;
                    this.ITAScore += scoreWeight;
                    if (!(this.ITAScore > 1.0)) continue;
                    this.ITAScore = 1.0;
                }
            }
            if (commonWordLanguages != null) {
                double scoreWeight = 0.0;
                count = 0;
                for (n = 0; n < commonWordLanguages.length; ++n) {
                    if (commonWordLanguages[n] == null || commonWordLanguages.length == 0) continue;
                    ++count;
                }
                switch (count) {
                    case 1: {
                        scoreWeight = 0.6;
                        break;
                    }
                    case 2: {
                        scoreWeight = 0.3;
                        break;
                    }
                    case 3: {
                        scoreWeight = 0.15;
                        break;
                    }
                    default: {
                        this.debug("There are no languages in the array");
                    }
                }
                String temp = null;
                for (int p = 0; p < commonWordLanguages.length; ++p) {
                    if (commonWordLanguages[p] == null || commonWordLanguages.length == 0) continue;
                    temp = commonWordLanguages[p];
                    if (temp.equalsIgnoreCase("DEU")) {
                        this.DEUScore += scoreWeight;
                        if (!(this.DEUScore > 1.0)) continue;
                        this.DEUScore = 1.0;
                        continue;
                    }
                    if (temp.equalsIgnoreCase("FRA")) {
                        this.FRAScore += scoreWeight;
                        if (!(this.FRAScore > 1.0)) continue;
                        this.FRAScore = 1.0;
                        continue;
                    }
                    if (!temp.equalsIgnoreCase("ITA")) continue;
                    this.ITAScore += scoreWeight;
                    if (!(this.ITAScore > 1.0)) continue;
                    this.ITAScore = 1.0;
                }
            }
        }
        if (!highlyLikelyLanguageFound) {
            if (CHE_AddressTerm.containsGermanExtendedCharacter(preParseString)) {
                this.DEUScore = 0.9;
                highlyLikelyLanguageFound = true;
            } else if (CHE_AddressTerm.containsFrenchExtendedCharacter(preParseString)) {
                if (CHE_AddressTerm.containsItalianExtendedCharacter(preParseString)) {
                    this.ITAScore = 0.5;
                    this.FRAScore = 0.5;
                } else {
                    this.FRAScore = 0.9;
                    highlyLikelyLanguageFound = true;
                }
            } else if (CHE_AddressTerm.containsItalianExtendedCharacter(preParseString)) {
                this.ITAScore = 0.9;
                highlyLikelyLanguageFound = true;
            }
        }
        if (!highlyLikelyLanguageFound) {
            String mostLikelyLanguage = null;
            String postcode = preParseString;
            if (postcode != null && StringUtilities.isNumeric((String)preParseString)) {
                mostLikelyLanguage = CHE_PostCodeRange.getPostCodeLanguage(postcode);
            }
            if (mostLikelyLanguage != null && mostLikelyLanguage.length() != 0) {
                if (mostLikelyLanguage.equals("DEU")) {
                    this.DEUScore = 1.0;
                    highlyLikelyLanguageFound = true;
                } else if (mostLikelyLanguage.equals("FRA")) {
                    this.FRAScore = 1.0;
                    highlyLikelyLanguageFound = true;
                } else if (mostLikelyLanguage.equals("ITA")) {
                    this.ITAScore = 1.0;
                    highlyLikelyLanguageFound = true;
                }
            }
        }
        highestScoringLanguage = this.DEUScore >= this.FRAScore ? (this.DEUScore >= this.ITAScore ? "DEU" : "ITA") : (this.FRAScore >= this.ITAScore ? "FRA" : "ITA");
        return highestScoringLanguage;
    }
}

