/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.singleline;

import com.mapinfo.mapmarker.CHE.singleline.CHESpecialCaseUtils;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import java.util.Comparator;

public class CHEAvoidSplittingArticleRule
implements Comparator<IAddressParsing> {
    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        boolean splitsArticle1 = this.hasSplitArticle(o1);
        boolean splitsArticle2 = this.hasSplitArticle(o2);
        if (splitsArticle1 && !splitsArticle2) {
            return 1;
        }
        if (!splitsArticle1 && splitsArticle2) {
            return -1;
        }
        return 0;
    }

    private boolean hasSplitArticle(IAddressParsing parsing) {
        String main = parsing.getSplit().getAddress().getMainAddress();
        if (main != null && main.length() > 0 && (parsing.getSplit().isFromReverseSplit() ? CHESpecialCaseUtils.isArticle(CHESpecialCaseUtils.getFirstWord(main)) : CHESpecialCaseUtils.isArticle(CHESpecialCaseUtils.getLastWord(main)))) {
            return true;
        }
        String post = parsing.getSplit().getAddress().getPostAddress();
        if (post != null && post.length() > 0) {
            String lastWord;
            String firstWord;
            if ((post = post.toUpperCase()).startsWith("D'") || post.startsWith("L'")) {
                return true;
            }
            if (!parsing.getSplit().isFromReverseSplit() ? CHESpecialCaseUtils.isArticle(firstWord = CHESpecialCaseUtils.getFirstWord(post)) && (firstWord.length() == post.length() || !CHESpecialCaseUtils.isLeadingArticle(firstWord)) : CHESpecialCaseUtils.isArticle(lastWord = CHESpecialCaseUtils.getLastWord(post)) && (lastWord.length() == post.length() || !CHESpecialCaseUtils.isLeadingArticle(lastWord))) {
                return true;
            }
        }
        return false;
    }
}

