/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHE.singleline;

import com.mapinfo.mapmarker.CHE.singleline.CHESpecialCaseUtils;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Comparator;
import java.util.StringTokenizer;

public class CHEPreferGermanTownEndingInPostRule
implements Comparator<IAddressParsing> {
    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        boolean prefer1 = this.hasTownTypeInPost(o1);
        boolean prefer2 = this.hasTownTypeInPost(o2);
        if (prefer1 && !prefer2) {
            return -1;
        }
        if (!prefer1 && prefer2) {
            return 1;
        }
        if (prefer1 && prefer2) {
            prefer1 = !StringUtilities.isEmpty((String)o1.getSplit().getAddress().getMainAddress());
            boolean bl = prefer2 = !StringUtilities.isEmpty((String)o2.getSplit().getAddress().getMainAddress());
            if (prefer1 && !prefer2) {
                return -1;
            }
            if (!prefer1 && prefer2) {
                return 1;
            }
        }
        return 0;
    }

    private boolean hasTownTypeInPost(IAddressParsing ap) {
        String post = ap.getSplit().getAddress().getPostAddress();
        if (StringUtilities.isEmpty((String)post)) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(post, "., ;-\t'");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (!CHESpecialCaseUtils.endsInTownSuffix(tok)) continue;
            return true;
        }
        return false;
    }
}

