/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU;

import com.mapinfo.mapmarker.DEU.DEU_Geocoder;
import com.mapinfo.mapmarker.DEU.DEU_SpecificHandler;
import com.mapinfo.mapmarker.DEU.dp.binary.DEU_DataManager;
import com.mapinfo.mapmarker.DEU.licensing.DEULicenseFilter;
import com.mapinfo.mapmarker.DEU.singleline.DEUSingleLineParser;
import com.mapinfo.mapmarker.GeocodableAddressCreationException;
import com.mapinfo.mapmarker.GeocodableAddressFactory;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataManagerInitializationException;
import com.mapinfo.mapmarker.core.IGeocoder;
import com.mapinfo.mapmarker.core.singleline.IGeocoderFactory;
import com.mapinfo.mapmarker.core.singleline.ISingleLineParser;
import com.mapinfo.mapmarker.core.singleline.SingleLineGeocoder;
import com.mapinfo.mapmarker.utils.MMJLog;

public class DEUGeocodableAddressFactory
extends GeocodableAddressFactory {
    public IGeocoder createSpecificGeocodableAddress(Address address, IGeocodeConstraints constraints) throws GeocodableAddressCreationException {
        DEUGeocodingFactory geocodingFactory = new DEUGeocodingFactory();
        return SingleLineGeocoder.getGeocoder((IGeocoderFactory)geocodingFactory, (ISingleLineParser)new DEUSingleLineParser(), (Address)address, (IGeocodeConstraints)constraints);
    }

    protected void resetSpecificDataManager() throws MMInternalFatalException {
        try {
            DEU_DataManager data = new DEU_DataManager();
            data.reset();
        }
        catch (MMJEDataManagerInitializationException MMJEDMIEx) {
            throw new FatalDataAccessException(2306, (Throwable)MMJEDMIEx);
        }
    }

    protected String[] getLicenseInformation() {
        try {
            DEULicenseFilter licenseFilter = new DEULicenseFilter();
            return licenseFilter.getLicenseInformation();
        }
        catch (MapMarkerInternalException e) {
            MMJLog.getLog().debug("Error building license information list.", (Throwable)e);
            return new String[0];
        }
    }

    private static class DEUGeocodingFactory
    implements IGeocoderFactory {
        private DEUGeocodingFactory() {
        }

        public IGeocoder createGeocoder(Address address, IGeocodeConstraints constraints) throws GeocodableAddressCreationException {
            address.setGenericField4(String.valueOf(constraints.getGeocodeType()));
            return new DEU_Geocoder(DEU_SpecificHandler.buildHandler(address));
        }
    }
}

