/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU;

import com.mapinfo.mapmarker.DEU.DEUMIStringSoundexKey;
import com.mapinfo.mapmarker.DEU.parser.DEU_Abbreviations;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class DEUGermanSoundex
extends Soundex {
    protected static char[] letters = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c4', '\u00d6', '\u00dc', '\u00df'};
    protected static int[] sounds = new int[]{0, 1, 2, 3, 0, 8, 2, 0, 0, 0, 2, 4, 5, 5, 0, 1, 2, 6, 7, 3, 0, 8, 8, 2, 0, 7, 0, 0, 0, 7};
    protected static String CONSONANTS = "BCDFGHJKLMNPQRSTVWXYZ\u00df";
    protected static String SPECIALCASES = "PQTX";
    protected static String DIGITS = "0123456789";
    protected static String soundStr = "000000000001122222334556777888";
    protected static String charStr = "AEHIOUY\u00c4\u00c1\u00d6\u00dcBPCGKQXDTLMNRSZ\u00dfFVW";
    protected static String VALID_CODES = "12345678";
    protected static int SPECIAL_CASE_INITIALDIGIT = 1;
    protected static int SPECIAL_CASE_INITIALDIPTHONG = 2;
    public static final int LAST_CHAR_DROPPED = 64;
    protected Hashtable soundHash = new Hashtable(sounds.length);
    protected int MAX_SOUNDEX_KEY_LENGTH;
    protected static char[] exChars = new char[]{'\u00c4', '\u00d6', '\u00dc', '\u00df'};
    protected static char[] nrChars = new char[]{'A', 'O', 'U', 'S'};
    protected static String[] ignoredWordList = new String[]{"AN", "AM", "AUF", "IN", "IM", "A.", "A", "DER", "DIE", "DAS", "DEN", "DEM", "DES", "D.", "D", "EIN", "EINE", "EINES", "EINEM", "EINEN", "EINER", "BIS", "FUER", "FUR", "F\u00dcR", "VON", "V.", "V", "ZU", "ZUR", "ZUM", "NACH", "BEI", "BEIM", "AUF", "UBER", "\u00dcBER", "\u00dcBERM", "UEBER", "UNTER", "UNTERM", "NEU", "NEUE", "NEUEN", "HINTER", "NEBEN", "SWISCHEN", "VOR", "ALT", "ALTE", "ALTEN"};

    public DEUGermanSoundex() {
        for (int i = 0; i < sounds.length; ++i) {
            this.soundHash.put(new Character(letters[i]), new Integer(sounds[i]));
        }
        this.MAX_SOUNDEX_KEY_LENGTH = 8;
    }

    public ISoundexKey getSoundex(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        if (this.isSpecialCase(str = str.toUpperCase()) != 0) {
            return this.handleSpecialCases(str);
        }
        char[] inputStringArray = (str = this.removeUnwantedCharsAndWords(str)).toCharArray();
        if (inputStringArray.length == 0) {
            return null;
        }
        MiSoundexKey key = new MiSoundexKey();
        char firstChar = inputStringArray[0];
        for (int i = 0; i < exChars.length; ++i) {
            if (exChars[i] != firstChar) continue;
            firstChar = nrChars[i];
            break;
        }
        key.setFirstChar(firstChar);
        int inputStringLength = inputStringArray.length;
        int returnCode = 0;
        int base = 1;
        int lastcode = 0;
        int sdx = 0;
        int i = 1;
        int soundexKeysAdded = 0;
        while (i < inputStringLength && soundexKeysAdded < this.MAX_SOUNDEX_KEY_LENGTH) {
            char c = inputStringArray[i];
            boolean bIncrement = true;
            Integer intKey = (Integer)this.soundHash.get(new Character(c));
            sdx = intKey == null ? 0 : intKey;
            boolean bVowel = false;
            if (sdx == 0) {
                bVowel = true;
                while (i < inputStringLength) {
                    if (Character.isDigit(c = inputStringArray[i++]) || (sdx = (intKey = (Integer)this.soundHash.get(new Character(c))) == null ? 0 : intKey) == 0) continue;
                    bIncrement = false;
                    break;
                }
            }
            boolean tryTwoCharCases = true;
            if (bIncrement) {
                if (i + 1 >= inputStringLength) {
                    tryTwoCharCases = false;
                }
            } else if (i >= inputStringLength) {
                tryTwoCharCases = false;
            }
            if (tryTwoCharCases && soundexKeysAdded + 1 < this.MAX_SOUNDEX_KEY_LENGTH) {
                switch (c) {
                    case 'T': {
                        char c2 = bIncrement ? inputStringArray[i + 1] : inputStringArray[i];
                        if (c2 != 'S' && c2 != 'Z') break;
                        sdx = 7;
                        break;
                    }
                    case 'P': {
                        char c2 = bIncrement ? inputStringArray[i + 1] : inputStringArray[i];
                        if (c2 != 'H' && c2 != 'F') break;
                        sdx = 8;
                        break;
                    }
                    case 'X': {
                        returnCode += base * sdx;
                        base *= 10;
                        ++soundexKeysAdded;
                        sdx = 7;
                        break;
                    }
                    case 'Q': {
                        returnCode += base * sdx;
                        base *= 10;
                        ++soundexKeysAdded;
                        sdx = 8;
                        break;
                    }
                }
            }
            if (sdx != lastcode || bVowel) {
                returnCode += base * sdx;
                base *= 10;
                lastcode = sdx;
                ++soundexKeysAdded;
            }
            if (!bIncrement) continue;
            ++i;
        }
        key.setNumericValue(returnCode);
        return key;
    }

    protected int isSpecialCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar == 'T') {
            if (str.length() < 2) {
                return 0;
            }
            char secondChar = str.charAt(1);
            if (secondChar == 'Z' || secondChar == 'S') {
                return SPECIAL_CASE_INITIALDIPTHONG;
            }
        } else if (firstChar == 'P') {
            if (str.length() < 2) {
                return 0;
            }
            char secondChar = str.charAt(1);
            if (secondChar == 'F' || secondChar == 'H') {
                return SPECIAL_CASE_INITIALDIPTHONG;
            }
        } else if (Character.isDigit(firstChar)) {
            return SPECIAL_CASE_INITIALDIGIT;
        }
        return 0;
    }

    protected ISoundexKey handleSpecialCases(String str) {
        char firstChar = str.charAt(0);
        if (firstChar == 'T') {
            char secondChar = str.charAt(1);
            if (secondChar == 'Z' || secondChar == 'S') {
                return this.getSoundex(str.substring(1));
            }
        } else if (firstChar == 'P') {
            char secondChar = str.charAt(1);
            if (secondChar == 'F' || secondChar == 'H') {
                return this.getSoundex("F" + str.substring(2));
            }
        } else if (Character.isDigit(firstChar)) {
            int code;
            try {
                Integer tmp = new Integer(StringUtilities.trimToChars((String)str, (String)DIGITS));
                code = tmp;
            }
            catch (NumberFormatException e) {
                code = 0;
            }
            MiSoundexKey key = new MiSoundexKey();
            key.setFirstChar('0');
            key.setNumericValue(code);
            return key;
        }
        return null;
    }

    protected RemoveWordResult removeWord(String str, String word) {
        RemoveWordResult ret = new RemoveWordResult();
        ret.retStr = str;
        ret.found = 0;
        if (str.indexOf(" ") == -1) {
            ret.found = -1;
            return ret;
        }
        if (str.indexOf(word) == -1) {
            return ret;
        }
        int wordLength = word.length();
        while (str.startsWith(word + ' ')) {
            ret.retStr = str = str.substring(wordLength + 1);
            ret.found = 1;
        }
        while (str.endsWith(' ' + word)) {
            ret.retStr = str = str.substring(0, str.length() - wordLength - 1);
            ret.found = 1;
        }
        int pos = str.indexOf(' ' + word + ' ');
        while (pos > -1) {
            str = str.substring(0, pos) + str.substring(pos + wordLength + 1);
            pos = str.indexOf(' ' + word + ' ');
            ret.retStr = str;
            ret.found = 1;
        }
        if (str.indexOf(" ") == -1) {
            ret.found = -1;
            return ret;
        }
        return ret;
    }

    protected String removeUnwantedCharsAndWords(String str) {
        int i;
        str.trim();
        if (str.indexOf(" ") != -1) {
            int len = ignoredWordList.length;
            for (i = 0; i < len; ++i) {
                RemoveWordResult ret = this.removeWord(str, ignoredWordList[i]);
                str = ret.retStr;
                if (ret.found < 0) break;
            }
        }
        char[] tempArray = str.toCharArray();
        StringBuffer returnBuffer = new StringBuffer(str.length());
        for (i = 0; i < tempArray.length; ++i) {
            char c = tempArray[i];
            if (!Character.isLetterOrDigit(c)) continue;
            returnBuffer.append(c);
        }
        return returnBuffer.toString();
    }

    public List calculateAlternateSoundexKeys(String origString, ISoundexKey origKey, int possibleErrors, List keys) {
        int len;
        int val;
        int j;
        String code;
        MiSoundexKey key;
        int i;
        int end;
        char sound;
        char c;
        int idx;
        if (possibleErrors == 0) {
            return keys;
        }
        if (origString == null || origString.length() == 0) {
            return keys;
        }
        if (origKey == null) {
            return keys;
        }
        int type = this.isSpecialCase(origString = origString.toUpperCase());
        if (type == SPECIAL_CASE_INITIALDIGIT) {
            return keys;
        }
        origString = this.removeUnwantedCharsAndWords(origString);
        String origUpper = origString.toUpperCase();
        char firstChar = ((MiSoundexKey)origKey).getFirstChar();
        int origNumericVal = ((MiSoundexKey)origKey).getNumericValue();
        if ((possibleErrors & 0x20) > 0) {
            StringBuffer sb = new StringBuffer(origUpper);
            if (sb.length() == 1 && DEU_Abbreviations.isAbbreviation(origUpper)) {
                ArrayList wordsForAbbreviation = DEU_Abbreviations.getWordsForAbbreviation(origUpper);
                for (int words = 0; words < wordsForAbbreviation.size(); ++words) {
                    keys.add(this.getSoundex((String)wordsForAbbreviation.get(words)));
                }
            }
            boolean bFoundMulti = false;
            idx = origUpper.indexOf(66, 1);
            while (idx > 0) {
                c = sb.charAt(idx);
                sb.setCharAt(idx, '\u00df');
                keys.add(this.getSoundex(sb.toString()));
                sb.setCharAt(idx, c);
                if ((idx = origUpper.indexOf(66, idx + 1)) <= 0) continue;
                bFoundMulti = true;
            }
            if (bFoundMulti) {
                keys.add(this.getSoundex(origUpper.replace('B', '\u00df')));
            }
            bFoundMulti = false;
            idx = origUpper.indexOf("SCHT");
            while (idx >= 0) {
                sb.delete(idx + 1, idx + 3);
                keys.add(this.getSoundex(sb.toString()));
                sb.insert(idx + 1, "CH");
                if ((idx = origUpper.indexOf("SCHT", idx + 4)) < 0) continue;
                bFoundMulti = true;
            }
            if (bFoundMulti) {
                String tmpStr = sb.toString();
                idx = tmpStr.indexOf("SCHT");
                while (idx >= 0) {
                    sb.delete(idx + 1, idx + 3);
                    tmpStr = sb.toString();
                    idx = tmpStr.indexOf("SCHT");
                }
                keys.add(this.getSoundex(sb.toString()));
            }
            sb.delete(0, sb.length());
            sb.append(origUpper);
            int len2 = origUpper.length();
            if (origUpper.endsWith("SCHE")) {
                sb.delete(len2 - 4, len2);
                keys.add(this.getSoundex(sb.toString()));
                sb.append("ER");
                keys.add(this.getSoundex(sb.toString()));
            } else if (origUpper.endsWith("ER") && !origUpper.equals("ER")) {
                sb.delete(len2 - 2, len2);
                keys.add(this.getSoundex(sb.toString()));
                sb.append("SCHE");
                keys.add(this.getSoundex(sb.toString()));
            } else {
                sb.append("SCHE");
                keys.add(this.getSoundex(sb.toString()));
                sb.delete(len2, len2 + 4);
                sb.append("ER");
                keys.add(this.getSoundex(sb.toString()));
            }
        }
        if ((possibleErrors & 1) > 0 && (idx = charStr.indexOf(firstChar)) >= 0) {
            sound = soundStr.charAt(idx);
            end = soundStr.lastIndexOf(sound) + 1;
            for (i = soundStr.indexOf(sound); i < end; ++i) {
                c = charStr.charAt(i);
                if (c == firstChar) continue;
                key = new MiSoundexKey();
                key.setNumericValue(origNumericVal);
                key.setFirstChar(c);
                if (key == null || keys.contains(key)) continue;
                keys.add(key);
            }
        }
        if ((possibleErrors & 2) > 0) {
            int len3 = origUpper.length();
            StringBuffer nameBuf = new StringBuffer(origUpper);
            for (i = 1; i < len3; ++i) {
                c = nameBuf.charAt(i);
                idx = charStr.indexOf(c);
                if (idx < 0 || (sound = soundStr.charAt(charStr.indexOf(c))) == '0') continue;
                nameBuf.setCharAt(i, 'A');
                key = (MiSoundexKey)this.getSoundex(nameBuf.toString());
                if (key != null && !keys.contains(key)) {
                    keys.add(key);
                }
                nameBuf.setCharAt(i, c);
            }
        }
        if ((possibleErrors & 4) > 0) {
            code = String.valueOf(origNumericVal);
            int len4 = code.length();
            end = VALID_CODES.length();
            StringBuffer sb = new StringBuffer(len4);
            for (i = 0; i < len4; ++i) {
                for (j = 0; j < end; ++j) {
                    if (code.charAt(i) == VALID_CODES.charAt(j)) continue;
                    sb.delete(0, len4);
                    sb.append(code);
                    sb.replace(i, i + 1, new String("" + VALID_CODES.charAt(j)));
                    key = new MiSoundexKey();
                    key.setFirstChar(firstChar);
                    val = Integer.parseInt(sb.toString());
                    key.setNumericValue(val);
                    if (keys.contains(key)) continue;
                    keys.add(key);
                }
            }
        }
        if ((possibleErrors & 8) > 0) {
            code = String.valueOf(origNumericVal);
            int len5 = code.length();
            if (len5 == this.MAX_SOUNDEX_KEY_LENGTH) {
                code = code.substring(1);
                --len5;
            }
            end = VALID_CODES.length();
            StringBuffer sb = new StringBuffer(len5 + 1);
            for (i = 0; i < len5 + 1; ++i) {
                for (j = 0; j < end; ++j) {
                    sb.delete(0, len5 + 1);
                    sb.append(code);
                    if (i + 1 <= len5 && code.charAt(i) == '3' && VALID_CODES.charAt(j) == '7') {
                        sb.replace(i, i + 1, "7");
                        key = new MiSoundexKey();
                        val = Integer.parseInt(sb.toString());
                        key.setNumericValue(val);
                        key.setFirstChar(firstChar);
                        if (!keys.contains(key)) {
                            keys.add(key);
                        }
                        sb.replace(i, i + 1, "3");
                        sb.insert(i, '7');
                        key = new MiSoundexKey();
                        val = Integer.parseInt(sb.toString());
                        key.setNumericValue(val);
                        key.setFirstChar(firstChar);
                        if (keys.contains(key)) continue;
                        keys.add(key);
                        continue;
                    }
                    if (i + 1 < len5 && code.charAt(i) == '1' && VALID_CODES.charAt(j) == '8') {
                        sb.replace(i, i + 1, "8");
                        key = new MiSoundexKey();
                        val = Integer.parseInt(sb.toString());
                        key.setNumericValue(val);
                        key.setFirstChar(firstChar);
                        if (!keys.contains(key)) {
                            keys.add(key);
                        }
                        sb.replace(i, i + 1, "1");
                        sb.insert(i, '8');
                        key = new MiSoundexKey();
                        val = Integer.parseInt(sb.toString());
                        key.setNumericValue(val);
                        key.setFirstChar(firstChar);
                        if (keys.contains(key)) continue;
                        keys.add(key);
                        continue;
                    }
                    sb.insert(i, VALID_CODES.charAt(j));
                    key = new MiSoundexKey();
                    val = Integer.parseInt(sb.toString());
                    key.setNumericValue(val);
                    key.setFirstChar(firstChar);
                    if (keys.contains(key)) continue;
                    keys.add(key);
                }
            }
        }
        if ((possibleErrors & 0x10) > 0) {
            code = String.valueOf(origNumericVal);
            int len6 = code.length() - 1;
            StringBuffer sb = new StringBuffer(len6 + 1);
            sb.append(code);
            for (i = 0; i < len6; ++i) {
                char c1 = sb.charAt(i);
                char c2 = sb.charAt(i + 1);
                sb.setCharAt(i, c2);
                sb.setCharAt(i + 1, c1);
                key = new MiSoundexKey();
                val = Integer.parseInt(sb.toString());
                key.setNumericValue(val);
                key.setFirstChar(firstChar);
                if (!keys.contains(key)) {
                    keys.add(key);
                }
                sb.setCharAt(i, c1);
                sb.setCharAt(i + 1, c2);
            }
        }
        if ((possibleErrors & 0x40) > 0 && (len = (code = String.valueOf(origNumericVal)).length()) < this.MAX_SOUNDEX_KEY_LENGTH) {
            for (i = 0; i < DIGITS.length(); ++i) {
                if (DIGITS.charAt(i) == '0') continue;
                key = new MiSoundexKey();
                key.setFirstChar(firstChar);
                key.setNumericValue(origNumericVal + DIGITS.charAt(i));
                if (keys.contains(key)) continue;
                keys.add(key);
            }
        }
        return keys;
    }

    public static ISoundexKey getStringKey(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        str = str.toUpperCase();
        char ch = str.charAt(0);
        int key = 1;
        for (int i = 1; i < str.length(); ++i) {
            key |= i << str.charAt(i);
        }
        MiSoundexKey mikey = new MiSoundexKey();
        mikey.setFirstChar(ch);
        mikey.setNumericValue(key);
        return mikey;
    }

    public static void turnOffErrorHandling(IConstraints constraints) {
        constraints.removeCustomObject((Object)"input_correction_error");
        constraints.setCustomObject((Object)"input_correction_active", (Object)new Boolean(false));
    }

    public static void turnOnErrorHandling(IConstraints constraints) {
        constraints.setCustomObject((Object)"input_correction_active", (Object)new Boolean(true));
        constraints.setCustomObject((Object)"input_correction_checked", new ArrayList());
    }

    public static boolean checkingErrorHandling(IConstraints constraints) {
        return (Boolean)constraints.getCustomObject((Object)"input_correction_active");
    }

    public static void setPossibleError(IConstraints constraints, int possibleError) {
        constraints.removeCustomObject((Object)"input_correction_error");
        constraints.setCustomObject((Object)"input_correction_error", (Object)new Integer(possibleError));
    }

    public static int getPossibleError(IConstraints constraints) {
        return (Integer)constraints.getCustomObject((Object)"input_correction_error");
    }

    public static ArrayList getAlreadyChecked(IConstraints constraints) {
        return (ArrayList)constraints.getCustomObject((Object)"input_correction_checked");
    }

    public static void addChecked(IConstraints constraints, ArrayList unchecked) {
        ArrayList checked = DEUGermanSoundex.getAlreadyChecked(constraints);
        constraints.removeCustomObject((Object)"input_correction_checked");
        constraints.setCustomObject((Object)"input_correction_checked", (Object)checked);
    }

    public static ISoundexKey getStringKeyForDataChecck(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        str = str.toUpperCase();
        char ch = str.charAt(0);
        int key = 1;
        for (int i = 1; i < str.length(); ++i) {
            key |= i << str.charAt(i);
        }
        DEUMIStringSoundexKey mikey = new DEUMIStringSoundexKey();
        mikey.setFirstChar(ch);
        mikey.setNumericValue(key);
        return mikey;
    }

    protected class RemoveWordResult {
        String retStr;
        int found;

        protected RemoveWordResult() {
        }
    }
}

